package com.amity.socialcloud.sdk.social.data.poll

import com.amity.socialcloud.sdk.common.EntityMapper
import com.ekoapp.ekosdk.internal.api.dto.EkoPollDto
import com.ekoapp.ekosdk.internal.api.mapper.EkoPollMapper
import com.ekoapp.ekosdk.internal.entity.PollEntity

internal class PollEntityMapper : EntityMapper<EkoPollDto, PollEntity>() {

    override fun map(list: List<EkoPollDto>): List<PollEntity> {
        return list.map { map(it) }
    }

    private fun map(dto: EkoPollDto) : PollEntity {
        return PollEntity().apply {
            dto.pollId?.let { pollId = it }
            dto.userId?.let { userId = it }
            dto.question?.let { question = it }
            dto.answers?.let { answers = it }
            dto.answerType?.let { answerType = it }
            dto.status?.let { status = it }
            dto.closedAt?.let { closedAt = it }
            dto.isDeleted?.let { isDeleted = it }
            dto.isVoted?.let { isVoted = it }
            createdAt = dto.createdAt
            updatedAt = dto.updatedAt
        }
    }

}