package com.amity.socialcloud.sdk.core.data.notification.channel;

import com.amity.socialcloud.sdk.model.chat.notification.AmityChannelNotificationSettings
import com.ekoapp.ekosdk.internal.api.socket.request.NotificationSaveSettingsRequest
import com.ekoapp.ekosdk.internal.mapper.EkoPushNotificationMapper
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Single

internal class ChannelNotificationRepository {

    fun saveNotificationSettings(channelId: String, allowed: Boolean): Completable {
        return ChannelNotificationRemoteDataStore().saveSetting(channelId, allowed).ignoreElement()
    }

    fun getNotificationSettings(channelId: String): Single<AmityChannelNotificationSettings> {
        return ChannelNotificationRemoteDataStore().getSetting(channelId)
            .map { pushNotificationDto ->
                EkoPushNotificationMapper().mapToChannelNotificationSettings(pushNotificationDto)
            }
    }
}