/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import android.database.Cursor;
import androidx.room.EntityDeletionOrUpdateAdapter;
import androidx.room.EntityInsertionAdapter;
import androidx.room.RoomDatabase;
import androidx.room.RoomSQLiteQuery;
import androidx.room.SharedSQLiteStatement;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.CursorUtil;
import androidx.room.util.DBUtil;
import androidx.sqlite.db.SupportSQLiteQuery;
import androidx.sqlite.db.SupportSQLiteStatement;
import com.amity.socialcloud.sdk.model.social.poll.AmityPollAnswer;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.PollAnswersConverter;
import com.ekoapp.ekosdk.internal.data.dao.PollDao;
import com.ekoapp.ekosdk.internal.entity.PollEntity;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Callable;
import org.joda.time.DateTime;

public final class PollDao_Impl
extends PollDao {
    private final RoomDatabase __db;
    private final EntityInsertionAdapter<PollEntity> __insertionAdapterOfPollEntity;
    private final PollAnswersConverter __pollAnswersConverter = new PollAnswersConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeletionOrUpdateAdapter<PollEntity> __deletionAdapterOfPollEntity;
    private final EntityDeletionOrUpdateAdapter<PollEntity> __updateAdapterOfPollEntity;
    private final SharedSQLiteStatement __preparedStmtOfDeleteAll;
    private final SharedSQLiteStatement __preparedStmtOfDeletePoll;

    public PollDao_Impl(RoomDatabase __db) {
        this.__db = __db;
        this.__insertionAdapterOfPollEntity = new EntityInsertionAdapter<PollEntity>(__db){

            public String createQuery() {
                return "INSERT OR REPLACE INTO `poll` (`pollId`,`userId`,`question`,`answers`,`answerType`,`status`,`closedAt`,`isDeleted`,`isVoted`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            public void bind(SupportSQLiteStatement stmt, PollEntity value) {
                if (value.getPollId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getPollId());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getUserId());
                }
                if (value.getQuestion() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getQuestion());
                }
                String _tmp = PollDao_Impl.this.__pollAnswersConverter.answersToJson(value.getAnswers());
                if (_tmp == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp);
                }
                if (value.getAnswerType() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getAnswerType());
                }
                if (value.getStatus() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getStatus());
                }
                String _tmp_1 = PollDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getClosedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_1);
                }
                int _tmp_2 = value.isDeleted() ? 1 : 0;
                stmt.bindLong(8, (long)_tmp_2);
                int _tmp_3 = value.isVoted() ? 1 : 0;
                stmt.bindLong(9, (long)_tmp_3);
                String _tmp_4 = PollDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_4 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, _tmp_4);
                }
                String _tmp_5 = PollDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_5 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, _tmp_5);
                }
                String _tmp_6 = PollDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_6 == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, _tmp_6);
                }
            }
        };
        this.__deletionAdapterOfPollEntity = new EntityDeletionOrUpdateAdapter<PollEntity>(__db){

            public String createQuery() {
                return "DELETE FROM `poll` WHERE `pollId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, PollEntity value) {
                if (value.getPollId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getPollId());
                }
            }
        };
        this.__updateAdapterOfPollEntity = new EntityDeletionOrUpdateAdapter<PollEntity>(__db){

            public String createQuery() {
                return "UPDATE OR ABORT `poll` SET `pollId` = ?,`userId` = ?,`question` = ?,`answers` = ?,`answerType` = ?,`status` = ?,`closedAt` = ?,`isDeleted` = ?,`isVoted` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `pollId` = ?";
            }

            public void bind(SupportSQLiteStatement stmt, PollEntity value) {
                if (value.getPollId() == null) {
                    stmt.bindNull(1);
                } else {
                    stmt.bindString(1, value.getPollId());
                }
                if (value.getUserId() == null) {
                    stmt.bindNull(2);
                } else {
                    stmt.bindString(2, value.getUserId());
                }
                if (value.getQuestion() == null) {
                    stmt.bindNull(3);
                } else {
                    stmt.bindString(3, value.getQuestion());
                }
                String _tmp = PollDao_Impl.this.__pollAnswersConverter.answersToJson(value.getAnswers());
                if (_tmp == null) {
                    stmt.bindNull(4);
                } else {
                    stmt.bindString(4, _tmp);
                }
                if (value.getAnswerType() == null) {
                    stmt.bindNull(5);
                } else {
                    stmt.bindString(5, value.getAnswerType());
                }
                if (value.getStatus() == null) {
                    stmt.bindNull(6);
                } else {
                    stmt.bindString(6, value.getStatus());
                }
                String _tmp_1 = PollDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getClosedAt());
                if (_tmp_1 == null) {
                    stmt.bindNull(7);
                } else {
                    stmt.bindString(7, _tmp_1);
                }
                int _tmp_2 = value.isDeleted() ? 1 : 0;
                stmt.bindLong(8, (long)_tmp_2);
                int _tmp_3 = value.isVoted() ? 1 : 0;
                stmt.bindLong(9, (long)_tmp_3);
                String _tmp_4 = PollDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getCreatedAt());
                if (_tmp_4 == null) {
                    stmt.bindNull(10);
                } else {
                    stmt.bindString(10, _tmp_4);
                }
                String _tmp_5 = PollDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getUpdatedAt());
                if (_tmp_5 == null) {
                    stmt.bindNull(11);
                } else {
                    stmt.bindString(11, _tmp_5);
                }
                String _tmp_6 = PollDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(value.getExpiresAt());
                if (_tmp_6 == null) {
                    stmt.bindNull(12);
                } else {
                    stmt.bindString(12, _tmp_6);
                }
                if (value.getPollId() == null) {
                    stmt.bindNull(13);
                } else {
                    stmt.bindString(13, value.getPollId());
                }
            }
        };
        this.__preparedStmtOfDeleteAll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "delete from poll";
                return "delete from poll";
            }
        };
        this.__preparedStmtOfDeletePoll = new SharedSQLiteStatement(__db){

            public String createQuery() {
                String _query = "update poll set isDeleted = 1 where pollId = ?";
                return "update poll set isDeleted = 1 where pollId = ?";
            }
        };
    }

    @Override
    public void insertImpl(PollEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfPollEntity.insert((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insertImpl(List<? extends PollEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__insertionAdapterOfPollEntity.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(PollEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfPollEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void delete(List<? extends PollEntity> objects) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__deletionAdapterOfPollEntity.handleMultiple(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void updateImpl(PollEntity object) {
        this.__db.assertNotSuspendingTransaction();
        this.__db.beginTransaction();
        try {
            this.__updateAdapterOfPollEntity.handle((Object)object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(PollEntity object) {
        this.__db.beginTransaction();
        try {
            PollDao_Impl.super.insert(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void insert(List<? extends PollEntity> objects) {
        this.__db.beginTransaction();
        try {
            PollDao_Impl.super.insert(objects);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void update(PollEntity object) {
        this.__db.beginTransaction();
        try {
            PollDao_Impl.super.update(object);
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
        }
    }

    @Override
    public void deleteAll() {
        this.__db.assertNotSuspendingTransaction();
        SupportSQLiteStatement _stmt = this.__preparedStmtOfDeleteAll.acquire();
        this.__db.beginTransaction();
        try {
            _stmt.executeUpdateDelete();
            this.__db.setTransactionSuccessful();
        }
        finally {
            this.__db.endTransaction();
            this.__preparedStmtOfDeleteAll.release(_stmt);
        }
    }

    @Override
    public Completable deletePoll(final String pollId) {
        return Completable.fromCallable((Callable)new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                SupportSQLiteStatement _stmt = PollDao_Impl.this.__preparedStmtOfDeletePoll.acquire();
                int _argIndex = 1;
                if (pollId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindString(_argIndex, pollId);
                }
                PollDao_Impl.this.__db.beginTransaction();
                try {
                    _stmt.executeUpdateDelete();
                    PollDao_Impl.this.__db.setTransactionSuccessful();
                    Void void_ = null;
                    return void_;
                }
                finally {
                    PollDao_Impl.this.__db.endTransaction();
                    PollDao_Impl.this.__preparedStmtOfDeletePoll.release(_stmt);
                }
            }
        });
    }

    @Override
    public Flowable<PollEntity> getPoll(String pollId) {
        String _sql = "select * from poll where pollId = ?";
        final RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select * from poll where pollId = ?", (int)1);
        int _argIndex = 1;
        if (pollId == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, pollId);
        }
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"poll"}, (Callable)new Callable<PollEntity>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public PollEntity call() throws Exception {
                try (Cursor _cursor = DBUtil.query((RoomDatabase)PollDao_Impl.this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);){
                    PollEntity _result;
                    int _cursorIndexOfPollId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pollId");
                    int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
                    int _cursorIndexOfQuestion = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"question");
                    int _cursorIndexOfAnswers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"answers");
                    int _cursorIndexOfAnswerType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"answerType");
                    int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
                    int _cursorIndexOfClosedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"closedAt");
                    int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
                    int _cursorIndexOfIsVoted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isVoted");
                    int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
                    int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
                    int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
                    if (_cursor.moveToFirst()) {
                        _result = new PollEntity();
                        String _tmpPollId = _cursor.isNull(_cursorIndexOfPollId) ? null : _cursor.getString(_cursorIndexOfPollId);
                        _result.setPollId(_tmpPollId);
                        String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                        _result.setUserId(_tmpUserId);
                        String _tmpQuestion = _cursor.isNull(_cursorIndexOfQuestion) ? null : _cursor.getString(_cursorIndexOfQuestion);
                        _result.setQuestion(_tmpQuestion);
                        String _tmp = _cursor.isNull(_cursorIndexOfAnswers) ? null : _cursor.getString(_cursorIndexOfAnswers);
                        List<AmityPollAnswer> _tmpAnswers = PollDao_Impl.this.__pollAnswersConverter.jsonToAnswers(_tmp);
                        _result.setAnswers(_tmpAnswers);
                        String _tmpAnswerType = _cursor.isNull(_cursorIndexOfAnswerType) ? null : _cursor.getString(_cursorIndexOfAnswerType);
                        _result.setAnswerType(_tmpAnswerType);
                        String _tmpStatus = _cursor.isNull(_cursorIndexOfStatus) ? null : _cursor.getString(_cursorIndexOfStatus);
                        _result.setStatus(_tmpStatus);
                        String _tmp_1 = _cursor.isNull(_cursorIndexOfClosedAt) ? null : _cursor.getString(_cursorIndexOfClosedAt);
                        DateTime _tmpClosedAt = PollDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                        _result.setClosedAt(_tmpClosedAt);
                        int _tmp_2 = _cursor.getInt(_cursorIndexOfIsDeleted);
                        boolean _tmpIsDeleted = _tmp_2 != 0;
                        _result.setDeleted(_tmpIsDeleted);
                        int _tmp_3 = _cursor.getInt(_cursorIndexOfIsVoted);
                        boolean _tmpIsVoted = _tmp_3 != 0;
                        _result.setVoted(_tmpIsVoted);
                        String _tmp_4 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                        DateTime _tmpCreatedAt = PollDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                        _result.setCreatedAt(_tmpCreatedAt);
                        String _tmp_5 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                        DateTime _tmpUpdatedAt = PollDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                        _result.setUpdatedAt(_tmpUpdatedAt);
                        String _tmp_6 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                        DateTime _tmpExpiresAt = PollDao_Impl.this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                        _result.setExpiresAt(_tmpExpiresAt);
                    } else {
                        _result = null;
                    }
                    PollEntity pollEntity = _result;
                    return pollEntity;
                }
            }

            protected void finalize() {
                _statement.release();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PollEntity getByIdNowImpl(String id) {
        String _sql = "select * from poll where pollId = ? limit 1";
        RoomSQLiteQuery _statement = RoomSQLiteQuery.acquire((String)"select * from poll where pollId = ? limit 1", (int)1);
        int _argIndex = 1;
        if (id == null) {
            _statement.bindNull(_argIndex);
        } else {
            _statement.bindString(_argIndex, id);
        }
        this.__db.assertNotSuspendingTransaction();
        Cursor _cursor = DBUtil.query((RoomDatabase)this.__db, (SupportSQLiteQuery)_statement, (boolean)false, null);
        try {
            PollEntity _result;
            int _cursorIndexOfPollId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"pollId");
            int _cursorIndexOfUserId = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"userId");
            int _cursorIndexOfQuestion = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"question");
            int _cursorIndexOfAnswers = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"answers");
            int _cursorIndexOfAnswerType = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"answerType");
            int _cursorIndexOfStatus = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"status");
            int _cursorIndexOfClosedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"closedAt");
            int _cursorIndexOfIsDeleted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isDeleted");
            int _cursorIndexOfIsVoted = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"isVoted");
            int _cursorIndexOfCreatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"createdAt");
            int _cursorIndexOfUpdatedAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"updatedAt");
            int _cursorIndexOfExpiresAt = CursorUtil.getColumnIndexOrThrow((Cursor)_cursor, (String)"expiresAt");
            if (_cursor.moveToFirst()) {
                _result = new PollEntity();
                String _tmpPollId = _cursor.isNull(_cursorIndexOfPollId) ? null : _cursor.getString(_cursorIndexOfPollId);
                _result.setPollId(_tmpPollId);
                String _tmpUserId = _cursor.isNull(_cursorIndexOfUserId) ? null : _cursor.getString(_cursorIndexOfUserId);
                _result.setUserId(_tmpUserId);
                String _tmpQuestion = _cursor.isNull(_cursorIndexOfQuestion) ? null : _cursor.getString(_cursorIndexOfQuestion);
                _result.setQuestion(_tmpQuestion);
                String _tmp = _cursor.isNull(_cursorIndexOfAnswers) ? null : _cursor.getString(_cursorIndexOfAnswers);
                List<AmityPollAnswer> _tmpAnswers = this.__pollAnswersConverter.jsonToAnswers(_tmp);
                _result.setAnswers(_tmpAnswers);
                String _tmpAnswerType = _cursor.isNull(_cursorIndexOfAnswerType) ? null : _cursor.getString(_cursorIndexOfAnswerType);
                _result.setAnswerType(_tmpAnswerType);
                String _tmpStatus = _cursor.isNull(_cursorIndexOfStatus) ? null : _cursor.getString(_cursorIndexOfStatus);
                _result.setStatus(_tmpStatus);
                String _tmp_1 = _cursor.isNull(_cursorIndexOfClosedAt) ? null : _cursor.getString(_cursorIndexOfClosedAt);
                DateTime _tmpClosedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                _result.setClosedAt(_tmpClosedAt);
                int _tmp_2 = _cursor.getInt(_cursorIndexOfIsDeleted);
                boolean _tmpIsDeleted = _tmp_2 != 0;
                _result.setDeleted(_tmpIsDeleted);
                int _tmp_3 = _cursor.getInt(_cursorIndexOfIsVoted);
                boolean _tmpIsVoted = _tmp_3 != 0;
                _result.setVoted(_tmpIsVoted);
                String _tmp_4 = _cursor.isNull(_cursorIndexOfCreatedAt) ? null : _cursor.getString(_cursorIndexOfCreatedAt);
                DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                _result.setCreatedAt(_tmpCreatedAt);
                String _tmp_5 = _cursor.isNull(_cursorIndexOfUpdatedAt) ? null : _cursor.getString(_cursorIndexOfUpdatedAt);
                DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                _result.setUpdatedAt(_tmpUpdatedAt);
                String _tmp_6 = _cursor.isNull(_cursorIndexOfExpiresAt) ? null : _cursor.getString(_cursorIndexOfExpiresAt);
                DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                _result.setExpiresAt(_tmpExpiresAt);
            } else {
                _result = null;
            }
            PollEntity pollEntity = _result;
            return pollEntity;
        }
        finally {
            _cursor.close();
            _statement.release();
        }
    }

    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

