/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.social.data.story;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.SQLiteStatement;
import com.amity.socialcloud.sdk.entity.social.story.StoryEntity;
import com.amity.socialcloud.sdk.model.core.reaction.AmityReactionMap;
import com.amity.socialcloud.sdk.social.data.story.StoryDao;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.EkoReactionMapConverter;
import com.ekoapp.ekosdk.internal.data.converter.JsonArrayTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.JsonObjectTypeConverter;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class StoryDao_Impl
extends StoryDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<StoryEntity> __insertAdapterOfStoryEntity;
    private final JsonObjectTypeConverter __jsonObjectTypeConverter = new JsonObjectTypeConverter();
    private final JsonArrayTypeConverter __jsonArrayTypeConverter = new JsonArrayTypeConverter();
    private final EkoReactionMapConverter __ekoReactionMapConverter = new EkoReactionMapConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeleteOrUpdateAdapter<StoryEntity> __deleteAdapterOfStoryEntity;
    private final EntityDeleteOrUpdateAdapter<StoryEntity> __updateAdapterOfStoryEntity;

    public StoryDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfStoryEntity = new EntityInsertAdapter<StoryEntity>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `story` (`uniqueId`,`storyId`,`path`,`dataType`,`data`,`metadata`,`items`,`reactions`,`reactionCount`,`commentCount`,`flagCount`,`storyExpiresAt`,`isDeleted`,`targetType`,`targetId`,`creatorId`,`impression`,`reach`,`syncState`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull StoryEntity entity) {
                if (entity.getUniqueId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getUniqueId());
                }
                if (entity.getStoryId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getStoryId());
                }
                if (entity.getPath() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getPath());
                }
                if (entity.getDataType() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getDataType());
                }
                String _tmp = StoryDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(entity.getData());
                if (_tmp == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp);
                }
                String _tmp_1 = StoryDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(entity.getMetadata());
                if (_tmp_1 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_1);
                }
                String _tmp_2 = StoryDao_Impl.this.__jsonArrayTypeConverter.jsonObjectToString(entity.getItems());
                if (_tmp_2 == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, _tmp_2);
                }
                String _tmp_3 = StoryDao_Impl.this.__ekoReactionMapConverter.stringIntMapToString(entity.getReactions());
                if (_tmp_3 == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, _tmp_3);
                }
                statement.bindLong(9, (long)entity.getReactionCount());
                statement.bindLong(10, (long)entity.getCommentCount());
                statement.bindLong(11, (long)entity.getFlagCount());
                String _tmp_4 = StoryDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getStoryExpiresAt());
                if (_tmp_4 == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindText(12, _tmp_4);
                }
                int _tmp_5 = entity.isDeleted() ? 1 : 0;
                statement.bindLong(13, (long)_tmp_5);
                if (entity.getTargetType() == null) {
                    statement.bindNull(14);
                } else {
                    statement.bindText(14, entity.getTargetType());
                }
                if (entity.getTargetId() == null) {
                    statement.bindNull(15);
                } else {
                    statement.bindText(15, entity.getTargetId());
                }
                if (entity.getCreatorId() == null) {
                    statement.bindNull(16);
                } else {
                    statement.bindText(16, entity.getCreatorId());
                }
                statement.bindLong(17, (long)entity.getImpression());
                statement.bindLong(18, (long)entity.getReach());
                if (entity.getSyncState() == null) {
                    statement.bindNull(19);
                } else {
                    statement.bindText(19, entity.getSyncState());
                }
                String _tmp_6 = StoryDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_6 == null) {
                    statement.bindNull(20);
                } else {
                    statement.bindText(20, _tmp_6);
                }
                String _tmp_7 = StoryDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_7 == null) {
                    statement.bindNull(21);
                } else {
                    statement.bindText(21, _tmp_7);
                }
                String _tmp_8 = StoryDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_8 == null) {
                    statement.bindNull(22);
                } else {
                    statement.bindText(22, _tmp_8);
                }
            }
        };
        this.__deleteAdapterOfStoryEntity = new EntityDeleteOrUpdateAdapter<StoryEntity>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `story` WHERE `uniqueId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull StoryEntity entity) {
                if (entity.getUniqueId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getUniqueId());
                }
            }
        };
        this.__updateAdapterOfStoryEntity = new EntityDeleteOrUpdateAdapter<StoryEntity>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `story` SET `uniqueId` = ?,`storyId` = ?,`path` = ?,`dataType` = ?,`data` = ?,`metadata` = ?,`items` = ?,`reactions` = ?,`reactionCount` = ?,`commentCount` = ?,`flagCount` = ?,`storyExpiresAt` = ?,`isDeleted` = ?,`targetType` = ?,`targetId` = ?,`creatorId` = ?,`impression` = ?,`reach` = ?,`syncState` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `uniqueId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull StoryEntity entity) {
                if (entity.getUniqueId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getUniqueId());
                }
                if (entity.getStoryId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getStoryId());
                }
                if (entity.getPath() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getPath());
                }
                if (entity.getDataType() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getDataType());
                }
                String _tmp = StoryDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(entity.getData());
                if (_tmp == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp);
                }
                String _tmp_1 = StoryDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(entity.getMetadata());
                if (_tmp_1 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_1);
                }
                String _tmp_2 = StoryDao_Impl.this.__jsonArrayTypeConverter.jsonObjectToString(entity.getItems());
                if (_tmp_2 == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, _tmp_2);
                }
                String _tmp_3 = StoryDao_Impl.this.__ekoReactionMapConverter.stringIntMapToString(entity.getReactions());
                if (_tmp_3 == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, _tmp_3);
                }
                statement.bindLong(9, (long)entity.getReactionCount());
                statement.bindLong(10, (long)entity.getCommentCount());
                statement.bindLong(11, (long)entity.getFlagCount());
                String _tmp_4 = StoryDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getStoryExpiresAt());
                if (_tmp_4 == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindText(12, _tmp_4);
                }
                int _tmp_5 = entity.isDeleted() ? 1 : 0;
                statement.bindLong(13, (long)_tmp_5);
                if (entity.getTargetType() == null) {
                    statement.bindNull(14);
                } else {
                    statement.bindText(14, entity.getTargetType());
                }
                if (entity.getTargetId() == null) {
                    statement.bindNull(15);
                } else {
                    statement.bindText(15, entity.getTargetId());
                }
                if (entity.getCreatorId() == null) {
                    statement.bindNull(16);
                } else {
                    statement.bindText(16, entity.getCreatorId());
                }
                statement.bindLong(17, (long)entity.getImpression());
                statement.bindLong(18, (long)entity.getReach());
                if (entity.getSyncState() == null) {
                    statement.bindNull(19);
                } else {
                    statement.bindText(19, entity.getSyncState());
                }
                String _tmp_6 = StoryDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_6 == null) {
                    statement.bindNull(20);
                } else {
                    statement.bindText(20, _tmp_6);
                }
                String _tmp_7 = StoryDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_7 == null) {
                    statement.bindNull(21);
                } else {
                    statement.bindText(21, _tmp_7);
                }
                String _tmp_8 = StoryDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_8 == null) {
                    statement.bindNull(22);
                } else {
                    statement.bindText(22, _tmp_8);
                }
                if (entity.getUniqueId() == null) {
                    statement.bindNull(23);
                } else {
                    statement.bindText(23, entity.getUniqueId());
                }
            }
        };
    }

    @Override
    public void insertImpl(StoryEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfStoryEntity.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends StoryEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfStoryEntity.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(StoryEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfStoryEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void delete(List<? extends StoryEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfStoryEntity.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void updateImpl(StoryEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfStoryEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(StoryEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            StoryDao_Impl.super.insert(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends StoryEntity> objects) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            StoryDao_Impl.super.insert(objects);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(StoryEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            StoryDao_Impl.super.update(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public Flowable<StoryEntity> getStory(String storyId) {
        String _sql = "select * from story where storyId = ?";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"story"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("select * from story where storyId = ?");){
                StoryEntity _result;
                int _argIndex = 1;
                if (storyId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, storyId);
                }
                int _columnIndexOfUniqueId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"uniqueId");
                int _columnIndexOfStoryId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"storyId");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfDataType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"dataType");
                int _columnIndexOfData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"data");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfItems = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"items");
                int _columnIndexOfReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactions");
                int _columnIndexOfReactionCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionCount");
                int _columnIndexOfCommentCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"commentCount");
                int _columnIndexOfFlagCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flagCount");
                int _columnIndexOfStoryExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"storyExpiresAt");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetType");
                int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetId");
                int _columnIndexOfCreatorId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"creatorId");
                int _columnIndexOfImpression = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"impression");
                int _columnIndexOfReach = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reach");
                int _columnIndexOfSyncState = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"syncState");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new StoryEntity();
                    String _tmpUniqueId = _stmt.isNull(_columnIndexOfUniqueId) ? null : _stmt.getText(_columnIndexOfUniqueId);
                    _result.setUniqueId(_tmpUniqueId);
                    String _tmpStoryId = _stmt.isNull(_columnIndexOfStoryId) ? null : _stmt.getText(_columnIndexOfStoryId);
                    _result.setStoryId(_tmpStoryId);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _result.setPath(_tmpPath);
                    String _tmpDataType = _stmt.isNull(_columnIndexOfDataType) ? null : _stmt.getText(_columnIndexOfDataType);
                    _result.setDataType(_tmpDataType);
                    String _tmp = _stmt.isNull(_columnIndexOfData) ? null : _stmt.getText(_columnIndexOfData);
                    JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                    _result.setData(_tmpData);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_1);
                    _result.setMetadata(_tmpMetadata);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfItems) ? null : _stmt.getText(_columnIndexOfItems);
                    JsonArray _tmpItems = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_2);
                    _result.setItems(_tmpItems);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfReactions) ? null : _stmt.getText(_columnIndexOfReactions);
                    AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_3);
                    _result.setReactions(_tmpReactions);
                    int _tmpReactionCount = (int)_stmt.getLong(_columnIndexOfReactionCount);
                    _result.setReactionCount(_tmpReactionCount);
                    int _tmpCommentCount = (int)_stmt.getLong(_columnIndexOfCommentCount);
                    _result.setCommentCount(_tmpCommentCount);
                    int _tmpFlagCount = (int)_stmt.getLong(_columnIndexOfFlagCount);
                    _result.setFlagCount(_tmpFlagCount);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfStoryExpiresAt) ? null : _stmt.getText(_columnIndexOfStoryExpiresAt);
                    DateTime _tmpStoryExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setStoryExpiresAt(_tmpStoryExpiresAt);
                    int _tmp_5 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_5 != 0;
                    _result.setDeleted(_tmpIsDeleted);
                    String _tmpTargetType = _stmt.isNull(_columnIndexOfTargetType) ? null : _stmt.getText(_columnIndexOfTargetType);
                    _result.setTargetType(_tmpTargetType);
                    String _tmpTargetId = _stmt.isNull(_columnIndexOfTargetId) ? null : _stmt.getText(_columnIndexOfTargetId);
                    _result.setTargetId(_tmpTargetId);
                    String _tmpCreatorId = _stmt.isNull(_columnIndexOfCreatorId) ? null : _stmt.getText(_columnIndexOfCreatorId);
                    _result.setCreatorId(_tmpCreatorId);
                    int _tmpImpression = (int)_stmt.getLong(_columnIndexOfImpression);
                    _result.setImpression(_tmpImpression);
                    int _tmpReach = (int)_stmt.getLong(_columnIndexOfReach);
                    _result.setReach(_tmpReach);
                    String _tmpSyncState = _stmt.isNull(_columnIndexOfSyncState) ? null : _stmt.getText(_columnIndexOfSyncState);
                    _result.setSyncState(_tmpSyncState);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                StoryEntity storyEntity = _result;
                return storyEntity;
            }
        });
    }

    @Override
    public StoryEntity getByIdNowImpl(String uniqueId) {
        String _sql = "select * from story where uniqueId = ? limit 1";
        return (StoryEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("select * from story where uniqueId = ? limit 1");){
                StoryEntity _result;
                int _argIndex = 1;
                if (uniqueId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, uniqueId);
                }
                int _columnIndexOfUniqueId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"uniqueId");
                int _columnIndexOfStoryId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"storyId");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfDataType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"dataType");
                int _columnIndexOfData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"data");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfItems = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"items");
                int _columnIndexOfReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactions");
                int _columnIndexOfReactionCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionCount");
                int _columnIndexOfCommentCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"commentCount");
                int _columnIndexOfFlagCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flagCount");
                int _columnIndexOfStoryExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"storyExpiresAt");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetType");
                int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetId");
                int _columnIndexOfCreatorId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"creatorId");
                int _columnIndexOfImpression = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"impression");
                int _columnIndexOfReach = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reach");
                int _columnIndexOfSyncState = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"syncState");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new StoryEntity();
                    String _tmpUniqueId = _stmt.isNull(_columnIndexOfUniqueId) ? null : _stmt.getText(_columnIndexOfUniqueId);
                    _result.setUniqueId(_tmpUniqueId);
                    String _tmpStoryId = _stmt.isNull(_columnIndexOfStoryId) ? null : _stmt.getText(_columnIndexOfStoryId);
                    _result.setStoryId(_tmpStoryId);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _result.setPath(_tmpPath);
                    String _tmpDataType = _stmt.isNull(_columnIndexOfDataType) ? null : _stmt.getText(_columnIndexOfDataType);
                    _result.setDataType(_tmpDataType);
                    String _tmp = _stmt.isNull(_columnIndexOfData) ? null : _stmt.getText(_columnIndexOfData);
                    JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                    _result.setData(_tmpData);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_1);
                    _result.setMetadata(_tmpMetadata);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfItems) ? null : _stmt.getText(_columnIndexOfItems);
                    JsonArray _tmpItems = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_2);
                    _result.setItems(_tmpItems);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfReactions) ? null : _stmt.getText(_columnIndexOfReactions);
                    AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_3);
                    _result.setReactions(_tmpReactions);
                    int _tmpReactionCount = (int)_stmt.getLong(_columnIndexOfReactionCount);
                    _result.setReactionCount(_tmpReactionCount);
                    int _tmpCommentCount = (int)_stmt.getLong(_columnIndexOfCommentCount);
                    _result.setCommentCount(_tmpCommentCount);
                    int _tmpFlagCount = (int)_stmt.getLong(_columnIndexOfFlagCount);
                    _result.setFlagCount(_tmpFlagCount);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfStoryExpiresAt) ? null : _stmt.getText(_columnIndexOfStoryExpiresAt);
                    DateTime _tmpStoryExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setStoryExpiresAt(_tmpStoryExpiresAt);
                    int _tmp_5 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_5 != 0;
                    _result.setDeleted(_tmpIsDeleted);
                    String _tmpTargetType = _stmt.isNull(_columnIndexOfTargetType) ? null : _stmt.getText(_columnIndexOfTargetType);
                    _result.setTargetType(_tmpTargetType);
                    String _tmpTargetId = _stmt.isNull(_columnIndexOfTargetId) ? null : _stmt.getText(_columnIndexOfTargetId);
                    _result.setTargetId(_tmpTargetId);
                    String _tmpCreatorId = _stmt.isNull(_columnIndexOfCreatorId) ? null : _stmt.getText(_columnIndexOfCreatorId);
                    _result.setCreatorId(_tmpCreatorId);
                    int _tmpImpression = (int)_stmt.getLong(_columnIndexOfImpression);
                    _result.setImpression(_tmpImpression);
                    int _tmpReach = (int)_stmt.getLong(_columnIndexOfReach);
                    _result.setReach(_tmpReach);
                    String _tmpSyncState = _stmt.isNull(_columnIndexOfSyncState) ? null : _stmt.getText(_columnIndexOfSyncState);
                    _result.setSyncState(_tmpSyncState);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                StoryEntity storyEntity = _result;
                return storyEntity;
            }
        });
    }

    @Override
    public Flowable<StoryEntity> getLatestStoryImpl(String targetType, String targetId, int hash, int nonce, DateTime now) {
        String _sql = "SELECT * from story where story.targetType = ? and story.targetId = ?  and story.updatedAt > ? and story.uniqueId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (?) and amity_paging_id.nonce = (?) ) order by story.updatedAt  desc limit 1";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"story", "amity_paging_id"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from story where story.targetType = ? and story.targetId = ?  and story.updatedAt > ? and story.uniqueId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (?) and amity_paging_id.nonce = (?) ) order by story.updatedAt  desc limit 1");){
                StoryEntity _result;
                int _argIndex = 1;
                if (targetType == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, targetType);
                }
                _argIndex = 2;
                if (targetId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, targetId);
                }
                _argIndex = 3;
                String _tmp = this.__dateTimeTypeConverter.dateTimeToString(now);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, _tmp);
                }
                _argIndex = 4;
                _stmt.bindLong(_argIndex, (long)hash);
                _argIndex = 5;
                _stmt.bindLong(_argIndex, (long)nonce);
                int _columnIndexOfUniqueId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"uniqueId");
                int _columnIndexOfStoryId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"storyId");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfDataType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"dataType");
                int _columnIndexOfData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"data");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfItems = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"items");
                int _columnIndexOfReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactions");
                int _columnIndexOfReactionCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionCount");
                int _columnIndexOfCommentCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"commentCount");
                int _columnIndexOfFlagCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flagCount");
                int _columnIndexOfStoryExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"storyExpiresAt");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetType");
                int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetId");
                int _columnIndexOfCreatorId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"creatorId");
                int _columnIndexOfImpression = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"impression");
                int _columnIndexOfReach = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reach");
                int _columnIndexOfSyncState = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"syncState");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new StoryEntity();
                    String _tmpUniqueId = _stmt.isNull(_columnIndexOfUniqueId) ? null : _stmt.getText(_columnIndexOfUniqueId);
                    _result.setUniqueId(_tmpUniqueId);
                    String _tmpStoryId = _stmt.isNull(_columnIndexOfStoryId) ? null : _stmt.getText(_columnIndexOfStoryId);
                    _result.setStoryId(_tmpStoryId);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _result.setPath(_tmpPath);
                    String _tmpDataType = _stmt.isNull(_columnIndexOfDataType) ? null : _stmt.getText(_columnIndexOfDataType);
                    _result.setDataType(_tmpDataType);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfData) ? null : _stmt.getText(_columnIndexOfData);
                    JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_1);
                    _result.setData(_tmpData);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_2);
                    _result.setMetadata(_tmpMetadata);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfItems) ? null : _stmt.getText(_columnIndexOfItems);
                    JsonArray _tmpItems = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_3);
                    _result.setItems(_tmpItems);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfReactions) ? null : _stmt.getText(_columnIndexOfReactions);
                    AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_4);
                    _result.setReactions(_tmpReactions);
                    int _tmpReactionCount = (int)_stmt.getLong(_columnIndexOfReactionCount);
                    _result.setReactionCount(_tmpReactionCount);
                    int _tmpCommentCount = (int)_stmt.getLong(_columnIndexOfCommentCount);
                    _result.setCommentCount(_tmpCommentCount);
                    int _tmpFlagCount = (int)_stmt.getLong(_columnIndexOfFlagCount);
                    _result.setFlagCount(_tmpFlagCount);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfStoryExpiresAt) ? null : _stmt.getText(_columnIndexOfStoryExpiresAt);
                    DateTime _tmpStoryExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                    _result.setStoryExpiresAt(_tmpStoryExpiresAt);
                    int _tmp_6 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_6 != 0;
                    _result.setDeleted(_tmpIsDeleted);
                    String _tmpTargetType = _stmt.isNull(_columnIndexOfTargetType) ? null : _stmt.getText(_columnIndexOfTargetType);
                    _result.setTargetType(_tmpTargetType);
                    String _tmpTargetId = _stmt.isNull(_columnIndexOfTargetId) ? null : _stmt.getText(_columnIndexOfTargetId);
                    _result.setTargetId(_tmpTargetId);
                    String _tmpCreatorId = _stmt.isNull(_columnIndexOfCreatorId) ? null : _stmt.getText(_columnIndexOfCreatorId);
                    _result.setCreatorId(_tmpCreatorId);
                    int _tmpImpression = (int)_stmt.getLong(_columnIndexOfImpression);
                    _result.setImpression(_tmpImpression);
                    int _tmpReach = (int)_stmt.getLong(_columnIndexOfReach);
                    _result.setReach(_tmpReach);
                    String _tmpSyncState = _stmt.isNull(_columnIndexOfSyncState) ? null : _stmt.getText(_columnIndexOfSyncState);
                    _result.setSyncState(_tmpSyncState);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                StoryEntity storyEntity = _result;
                return storyEntity;
            }
        });
    }

    @Override
    public String getUniqueIdByStoryIdImpl(String storyId) {
        String _sql = "SELECT story.uniqueId from story where story.storyId = ? LIMIT 1";
        return (String)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT story.uniqueId from story where story.storyId = ? LIMIT 1");){
                int _argIndex = 1;
                if (storyId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, storyId);
                }
                String _result = _stmt.step() ? (_stmt.isNull(0) ? null : _stmt.getText(0)) : null;
                String string = _result;
                return string;
            }
        });
    }

    @Override
    public Flowable<StoryEntity> observeStoryImpl(String storyId) {
        String _sql = "SELECT story.* from story where story.storyId = ? LIMIT 1";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"story"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT story.* from story where story.storyId = ? LIMIT 1");){
                StoryEntity _result;
                int _argIndex = 1;
                if (storyId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, storyId);
                }
                int _columnIndexOfUniqueId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"uniqueId");
                int _columnIndexOfStoryId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"storyId");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfDataType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"dataType");
                int _columnIndexOfData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"data");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfItems = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"items");
                int _columnIndexOfReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactions");
                int _columnIndexOfReactionCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionCount");
                int _columnIndexOfCommentCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"commentCount");
                int _columnIndexOfFlagCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flagCount");
                int _columnIndexOfStoryExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"storyExpiresAt");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetType");
                int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetId");
                int _columnIndexOfCreatorId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"creatorId");
                int _columnIndexOfImpression = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"impression");
                int _columnIndexOfReach = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reach");
                int _columnIndexOfSyncState = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"syncState");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new StoryEntity();
                    String _tmpUniqueId = _stmt.isNull(_columnIndexOfUniqueId) ? null : _stmt.getText(_columnIndexOfUniqueId);
                    _result.setUniqueId(_tmpUniqueId);
                    String _tmpStoryId = _stmt.isNull(_columnIndexOfStoryId) ? null : _stmt.getText(_columnIndexOfStoryId);
                    _result.setStoryId(_tmpStoryId);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _result.setPath(_tmpPath);
                    String _tmpDataType = _stmt.isNull(_columnIndexOfDataType) ? null : _stmt.getText(_columnIndexOfDataType);
                    _result.setDataType(_tmpDataType);
                    String _tmp = _stmt.isNull(_columnIndexOfData) ? null : _stmt.getText(_columnIndexOfData);
                    JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                    _result.setData(_tmpData);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_1);
                    _result.setMetadata(_tmpMetadata);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfItems) ? null : _stmt.getText(_columnIndexOfItems);
                    JsonArray _tmpItems = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_2);
                    _result.setItems(_tmpItems);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfReactions) ? null : _stmt.getText(_columnIndexOfReactions);
                    AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_3);
                    _result.setReactions(_tmpReactions);
                    int _tmpReactionCount = (int)_stmt.getLong(_columnIndexOfReactionCount);
                    _result.setReactionCount(_tmpReactionCount);
                    int _tmpCommentCount = (int)_stmt.getLong(_columnIndexOfCommentCount);
                    _result.setCommentCount(_tmpCommentCount);
                    int _tmpFlagCount = (int)_stmt.getLong(_columnIndexOfFlagCount);
                    _result.setFlagCount(_tmpFlagCount);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfStoryExpiresAt) ? null : _stmt.getText(_columnIndexOfStoryExpiresAt);
                    DateTime _tmpStoryExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setStoryExpiresAt(_tmpStoryExpiresAt);
                    int _tmp_5 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_5 != 0;
                    _result.setDeleted(_tmpIsDeleted);
                    String _tmpTargetType = _stmt.isNull(_columnIndexOfTargetType) ? null : _stmt.getText(_columnIndexOfTargetType);
                    _result.setTargetType(_tmpTargetType);
                    String _tmpTargetId = _stmt.isNull(_columnIndexOfTargetId) ? null : _stmt.getText(_columnIndexOfTargetId);
                    _result.setTargetId(_tmpTargetId);
                    String _tmpCreatorId = _stmt.isNull(_columnIndexOfCreatorId) ? null : _stmt.getText(_columnIndexOfCreatorId);
                    _result.setCreatorId(_tmpCreatorId);
                    int _tmpImpression = (int)_stmt.getLong(_columnIndexOfImpression);
                    _result.setImpression(_tmpImpression);
                    int _tmpReach = (int)_stmt.getLong(_columnIndexOfReach);
                    _result.setReach(_tmpReach);
                    String _tmpSyncState = _stmt.isNull(_columnIndexOfSyncState) ? null : _stmt.getText(_columnIndexOfSyncState);
                    _result.setSyncState(_tmpSyncState);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                StoryEntity storyEntity = _result;
                return storyEntity;
            }
        });
    }

    @Override
    public StoryEntity getByStoryIdNowImpl(String storyId) {
        String _sql = "SELECT story.* from story where story.storyId = ? LIMIT 1";
        return (StoryEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT story.* from story where story.storyId = ? LIMIT 1");){
                StoryEntity _result;
                int _argIndex = 1;
                if (storyId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, storyId);
                }
                int _columnIndexOfUniqueId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"uniqueId");
                int _columnIndexOfStoryId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"storyId");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfDataType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"dataType");
                int _columnIndexOfData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"data");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfItems = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"items");
                int _columnIndexOfReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactions");
                int _columnIndexOfReactionCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionCount");
                int _columnIndexOfCommentCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"commentCount");
                int _columnIndexOfFlagCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flagCount");
                int _columnIndexOfStoryExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"storyExpiresAt");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetType");
                int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetId");
                int _columnIndexOfCreatorId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"creatorId");
                int _columnIndexOfImpression = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"impression");
                int _columnIndexOfReach = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reach");
                int _columnIndexOfSyncState = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"syncState");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new StoryEntity();
                    String _tmpUniqueId = _stmt.isNull(_columnIndexOfUniqueId) ? null : _stmt.getText(_columnIndexOfUniqueId);
                    _result.setUniqueId(_tmpUniqueId);
                    String _tmpStoryId = _stmt.isNull(_columnIndexOfStoryId) ? null : _stmt.getText(_columnIndexOfStoryId);
                    _result.setStoryId(_tmpStoryId);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _result.setPath(_tmpPath);
                    String _tmpDataType = _stmt.isNull(_columnIndexOfDataType) ? null : _stmt.getText(_columnIndexOfDataType);
                    _result.setDataType(_tmpDataType);
                    String _tmp = _stmt.isNull(_columnIndexOfData) ? null : _stmt.getText(_columnIndexOfData);
                    JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                    _result.setData(_tmpData);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_1);
                    _result.setMetadata(_tmpMetadata);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfItems) ? null : _stmt.getText(_columnIndexOfItems);
                    JsonArray _tmpItems = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_2);
                    _result.setItems(_tmpItems);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfReactions) ? null : _stmt.getText(_columnIndexOfReactions);
                    AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_3);
                    _result.setReactions(_tmpReactions);
                    int _tmpReactionCount = (int)_stmt.getLong(_columnIndexOfReactionCount);
                    _result.setReactionCount(_tmpReactionCount);
                    int _tmpCommentCount = (int)_stmt.getLong(_columnIndexOfCommentCount);
                    _result.setCommentCount(_tmpCommentCount);
                    int _tmpFlagCount = (int)_stmt.getLong(_columnIndexOfFlagCount);
                    _result.setFlagCount(_tmpFlagCount);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfStoryExpiresAt) ? null : _stmt.getText(_columnIndexOfStoryExpiresAt);
                    DateTime _tmpStoryExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setStoryExpiresAt(_tmpStoryExpiresAt);
                    int _tmp_5 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_5 != 0;
                    _result.setDeleted(_tmpIsDeleted);
                    String _tmpTargetType = _stmt.isNull(_columnIndexOfTargetType) ? null : _stmt.getText(_columnIndexOfTargetType);
                    _result.setTargetType(_tmpTargetType);
                    String _tmpTargetId = _stmt.isNull(_columnIndexOfTargetId) ? null : _stmt.getText(_columnIndexOfTargetId);
                    _result.setTargetId(_tmpTargetId);
                    String _tmpCreatorId = _stmt.isNull(_columnIndexOfCreatorId) ? null : _stmt.getText(_columnIndexOfCreatorId);
                    _result.setCreatorId(_tmpCreatorId);
                    int _tmpImpression = (int)_stmt.getLong(_columnIndexOfImpression);
                    _result.setImpression(_tmpImpression);
                    int _tmpReach = (int)_stmt.getLong(_columnIndexOfReach);
                    _result.setReach(_tmpReach);
                    String _tmpSyncState = _stmt.isNull(_columnIndexOfSyncState) ? null : _stmt.getText(_columnIndexOfSyncState);
                    _result.setSyncState(_tmpSyncState);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                StoryEntity storyEntity = _result;
                return storyEntity;
            }
        });
    }

    @Override
    public DateTime getHighestStoryExpiresAt(String targetType, String targetId, List<String> syncStates) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("SELECT storyExpiresAt from story where targetType = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and targetId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and syncState IN (");
        int _inputSize = syncStates.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") order by storyExpiresAt DESC LIMIT 1");
        String _sql = _stringBuilder.toString();
        return (DateTime)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare(_sql);){
                DateTime _result;
                int _argIndex = 1;
                if (targetType == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, targetType);
                }
                _argIndex = 2;
                if (targetId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, targetId);
                }
                _argIndex = 3;
                for (String _item : syncStates) {
                    if (_item == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindText(_argIndex, _item);
                    }
                    ++_argIndex;
                }
                if (_stmt.step()) {
                    String _tmp = _stmt.isNull(0) ? null : _stmt.getText(0);
                    _result = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                } else {
                    _result = null;
                }
                DateTime dateTime = _result;
                return dateTime;
            }
        });
    }

    @Override
    public int getStoryCount(String targetType, String targetId, List<String> syncStates) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("SELECT COUNT(*) from story where targetType = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and targetId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and syncState IN (");
        int _inputSize = syncStates.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        return (Integer)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare(_sql);){
                int _argIndex = 1;
                if (targetType == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, targetType);
                }
                _argIndex = 2;
                if (targetId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, targetId);
                }
                _argIndex = 3;
                for (String _item : syncStates) {
                    if (_item == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindText(_argIndex, _item);
                    }
                    ++_argIndex;
                }
                int _result = _stmt.step() ? (int)_stmt.getLong(0) : 0;
                Integer n = _result;
                return n;
            }
        });
    }

    @Override
    public List<StoryEntity> findCache(String targetType, String targetId) {
        String _sql = "SELECT story.* from story where targetType = ? and targetId = ? and syncState != 'synced'";
        return (List)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT story.* from story where targetType = ? and targetId = ? and syncState != 'synced'");){
                int _argIndex = 1;
                if (targetType == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, targetType);
                }
                _argIndex = 2;
                if (targetId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, targetId);
                }
                int _columnIndexOfUniqueId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"uniqueId");
                int _columnIndexOfStoryId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"storyId");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfDataType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"dataType");
                int _columnIndexOfData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"data");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfItems = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"items");
                int _columnIndexOfReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactions");
                int _columnIndexOfReactionCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionCount");
                int _columnIndexOfCommentCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"commentCount");
                int _columnIndexOfFlagCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flagCount");
                int _columnIndexOfStoryExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"storyExpiresAt");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetType");
                int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetId");
                int _columnIndexOfCreatorId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"creatorId");
                int _columnIndexOfImpression = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"impression");
                int _columnIndexOfReach = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reach");
                int _columnIndexOfSyncState = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"syncState");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<StoryEntity> _result = new ArrayList<StoryEntity>();
                while (_stmt.step()) {
                    StoryEntity _item = new StoryEntity();
                    String _tmpUniqueId = _stmt.isNull(_columnIndexOfUniqueId) ? null : _stmt.getText(_columnIndexOfUniqueId);
                    _item.setUniqueId(_tmpUniqueId);
                    String _tmpStoryId = _stmt.isNull(_columnIndexOfStoryId) ? null : _stmt.getText(_columnIndexOfStoryId);
                    _item.setStoryId(_tmpStoryId);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _item.setPath(_tmpPath);
                    String _tmpDataType = _stmt.isNull(_columnIndexOfDataType) ? null : _stmt.getText(_columnIndexOfDataType);
                    _item.setDataType(_tmpDataType);
                    String _tmp = _stmt.isNull(_columnIndexOfData) ? null : _stmt.getText(_columnIndexOfData);
                    JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                    _item.setData(_tmpData);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_1);
                    _item.setMetadata(_tmpMetadata);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfItems) ? null : _stmt.getText(_columnIndexOfItems);
                    JsonArray _tmpItems = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_2);
                    _item.setItems(_tmpItems);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfReactions) ? null : _stmt.getText(_columnIndexOfReactions);
                    AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_3);
                    _item.setReactions(_tmpReactions);
                    int _tmpReactionCount = (int)_stmt.getLong(_columnIndexOfReactionCount);
                    _item.setReactionCount(_tmpReactionCount);
                    int _tmpCommentCount = (int)_stmt.getLong(_columnIndexOfCommentCount);
                    _item.setCommentCount(_tmpCommentCount);
                    int _tmpFlagCount = (int)_stmt.getLong(_columnIndexOfFlagCount);
                    _item.setFlagCount(_tmpFlagCount);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfStoryExpiresAt) ? null : _stmt.getText(_columnIndexOfStoryExpiresAt);
                    DateTime _tmpStoryExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _item.setStoryExpiresAt(_tmpStoryExpiresAt);
                    int _tmp_5 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_5 != 0;
                    _item.setDeleted(_tmpIsDeleted);
                    String _tmpTargetType = _stmt.isNull(_columnIndexOfTargetType) ? null : _stmt.getText(_columnIndexOfTargetType);
                    _item.setTargetType(_tmpTargetType);
                    String _tmpTargetId = _stmt.isNull(_columnIndexOfTargetId) ? null : _stmt.getText(_columnIndexOfTargetId);
                    _item.setTargetId(_tmpTargetId);
                    String _tmpCreatorId = _stmt.isNull(_columnIndexOfCreatorId) ? null : _stmt.getText(_columnIndexOfCreatorId);
                    _item.setCreatorId(_tmpCreatorId);
                    int _tmpImpression = (int)_stmt.getLong(_columnIndexOfImpression);
                    _item.setImpression(_tmpImpression);
                    int _tmpReach = (int)_stmt.getLong(_columnIndexOfReach);
                    _item.setReach(_tmpReach);
                    String _tmpSyncState = _stmt.isNull(_columnIndexOfSyncState) ? null : _stmt.getText(_columnIndexOfSyncState);
                    _item.setSyncState(_tmpSyncState);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                    _item.setCreatedAt(_tmpCreatedAt);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                    _item.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                    _item.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item);
                }
                ArrayList<StoryEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "delete from story";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("delete from story");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @Override
    public Completable softDeleteStory(String storyId) {
        String _sql = "UPDATE story set isDeleted = 1 where storyId = ?";
        return RxRoom.createCompletable((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE story set isDeleted = 1 where storyId = ?");){
                int _argIndex = 1;
                if (storyId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, storyId);
                }
                _stmt.step();
                Unit unit = Unit.INSTANCE;
                return unit;
            }
        });
    }

    @Override
    public Completable hardDeleteStory(String storyId) {
        String _sql = "DELETE from story where storyId = ?";
        return RxRoom.createCompletable((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from story where storyId = ?");){
                int _argIndex = 1;
                if (storyId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, storyId);
                }
                _stmt.step();
                Unit unit = Unit.INSTANCE;
                return unit;
            }
        });
    }

    @Override
    public void hardDeleteNow(String storyId) {
        String _sql = "DELETE from story where storyId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from story where storyId = ?");){
                int _argIndex = 1;
                if (storyId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, storyId);
                }
                _stmt.step();
                Object var4_4 = null;
                return var4_4;
            }
        });
    }

    @Override
    public Completable dummyUpdateStory(String storyId) {
        String _sql = "update story set storyId = ? where storyId = ?";
        return RxRoom.createCompletable((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("update story set storyId = ? where storyId = ?");){
                int _argIndex = 1;
                if (storyId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, storyId);
                }
                _argIndex = 2;
                if (storyId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, storyId);
                }
                _stmt.step();
                Unit unit = Unit.INSTANCE;
                return unit;
            }
        });
    }

    @Override
    public void decrementCommentCount(String storyId) {
        String _sql = "UPDATE story set commentCount = MAX(commentCount - 1, 0)  where storyId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE story set commentCount = MAX(commentCount - 1, 0)  where storyId = ?");){
                int _argIndex = 1;
                if (storyId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, storyId);
                }
                _stmt.step();
                Object var4_4 = null;
                return var4_4;
            }
        });
    }

    @Override
    public Completable updateSyncState(String uniqueId, String syncState) {
        String _sql = "update story set syncState = ? where uniqueId = ?";
        return RxRoom.createCompletable((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("update story set syncState = ? where uniqueId = ?");){
                int _argIndex = 1;
                if (syncState == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, syncState);
                }
                _argIndex = 2;
                if (uniqueId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, uniqueId);
                }
                _stmt.step();
                Unit unit = Unit.INSTANCE;
                return unit;
            }
        });
    }

    @Override
    public void initSyncStateOnStartup() {
        String _sql = "UPDATE story set syncState = 'failed' where syncState = 'syncing'";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE story set syncState = 'failed' where syncState = 'syncing'");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

