/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.social.data.event;

import androidx.paging.PagingConfig;
import androidx.paging.PagingData;
import androidx.paging.PagingSource;
import co.amity.rxbridge.FlowableKt;
import com.amity.socialcloud.sdk.api.social.event.query.AmityEventOrderOption;
import com.amity.socialcloud.sdk.api.social.event.query.AmityEventSortOption;
import com.amity.socialcloud.sdk.common.AmityObjectRepository;
import com.amity.socialcloud.sdk.common.ModelMapper;
import com.amity.socialcloud.sdk.entity.social.event.EventEntity;
import com.amity.socialcloud.sdk.model.core.tag.AmityTags;
import com.amity.socialcloud.sdk.model.social.event.AmityEvent;
import com.amity.socialcloud.sdk.model.social.event.AmityEventOriginType;
import com.amity.socialcloud.sdk.model.social.event.AmityEventStatus;
import com.amity.socialcloud.sdk.model.social.event.AmityEventType;
import com.amity.socialcloud.sdk.social.data.event.EventDao;
import com.amity.socialcloud.sdk.social.data.event.EventLocalDataStore;
import com.amity.socialcloud.sdk.social.data.event.EventModelMapper;
import com.amity.socialcloud.sdk.social.data.event.EventRemoteDataStore;
import com.amity.socialcloud.sdk.social.data.event.EventRepository;
import com.amity.socialcloud.sdk.social.data.event.paging.EventQueryMediator;
import com.ekoapp.ekosdk.internal.api.dto.EkoDeletionDto;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator;
import com.ekoapp.ekosdk.internal.paging.QueryStreamPagerCreator;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.functions.Function;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u0014\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\fH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0010\u001a\u00020\tJc\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00120\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\t2\b\u0010\u0016\u001a\u0004\u0018\u00010\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 \u00a2\u0006\u0002\u0010!J\u008d\u0001\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00030#2\b\u0010$\u001a\u0004\u0018\u00010\t2\b\u0010%\u001a\u0004\u0018\u00010\t2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010&\u001a\u0004\u0018\u00010\u001c2\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020(2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\t2\b\u0010*\u001a\u0004\u0018\u00010\t2\b\u0010+\u001a\u0004\u0018\u00010\t2\b\u0010,\u001a\u0004\u0018\u00010\t2\b\u0010-\u001a\u0004\u0018\u00010.2\b\u0010/\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u00100J\u0087\u0001\u00101\u001a\b\u0012\u0004\u0012\u00020\u00030#2\u0006\u0010\u0010\u001a\u00020\t2\b\u0010$\u001a\u0004\u0018\u00010\t2\b\u0010%\u001a\u0004\u0018\u00010\t2\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010&\u001a\u0004\u0018\u00010\u001c2\b\u0010'\u001a\u0004\u0018\u00010(2\b\u0010)\u001a\u0004\u0018\u00010(2\b\u0010*\u001a\u0004\u0018\u00010\t2\b\u0010+\u001a\u0004\u0018\u00010\t2\b\u0010,\u001a\u0004\u0018\u00010\t2\b\u0010-\u001a\u0004\u0018\u00010.2\b\u0010/\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0002\u00102J\u000e\u00103\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\tJ^\u00104\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\t2\b\u0010\u0016\u001a\u0004\u0018\u00010\t2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\u0015\u00109\u001a\u00020:2\u0006\u0010\u0010\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b;\u00a8\u0006<"}, d2={"Lcom/amity/socialcloud/sdk/social/data/event/EventRepository;", "Lcom/amity/socialcloud/sdk/common/AmityObjectRepository;", "Lcom/amity/socialcloud/sdk/entity/social/event/EventEntity;", "Lcom/amity/socialcloud/sdk/model/social/event/AmityEvent;", "<init>", "()V", "fetchAndSave", "Lio/reactivex/rxjava3/core/Completable;", "objectId", "", "queryFromCache", "mapper", "Lcom/amity/socialcloud/sdk/common/ModelMapper;", "observeFromCache", "Lio/reactivex/rxjava3/core/Flowable;", "getEvent", "eventId", "getEventPagingData", "Landroidx/paging/PagingData;", "originType", "Lcom/amity/socialcloud/sdk/model/social/event/AmityEventOriginType;", "originId", "userId", "status", "Lcom/amity/socialcloud/sdk/model/social/event/AmityEventStatus;", "type", "Lcom/amity/socialcloud/sdk/model/social/event/AmityEventType;", "onlyAttendee", "", "sortBy", "Lcom/amity/socialcloud/sdk/api/social/event/query/AmityEventSortOption;", "orderBy", "Lcom/amity/socialcloud/sdk/api/social/event/query/AmityEventOrderOption;", "(Lcom/amity/socialcloud/sdk/model/social/event/AmityEventOriginType;Ljava/lang/String;Ljava/lang/String;Lcom/amity/socialcloud/sdk/model/social/event/AmityEventStatus;Lcom/amity/socialcloud/sdk/model/social/event/AmityEventType;Ljava/lang/Boolean;Lcom/amity/socialcloud/sdk/api/social/event/query/AmityEventSortOption;Lcom/amity/socialcloud/sdk/api/social/event/query/AmityEventOrderOption;)Lio/reactivex/rxjava3/core/Flowable;", "createEvent", "Lio/reactivex/rxjava3/core/Single;", "title", "description", "isInviteOnly", "startTime", "Lorg/joda/time/DateTime;", "endTime", "location", "externalUrl", "coverImageFileId", "tags", "Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;", "timezone", "(Ljava/lang/String;Ljava/lang/String;Lcom/amity/socialcloud/sdk/model/social/event/AmityEventType;Ljava/lang/Boolean;Lorg/joda/time/DateTime;Lorg/joda/time/DateTime;Lcom/amity/socialcloud/sdk/model/social/event/AmityEventOriginType;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Ljava/lang/String;)Lio/reactivex/rxjava3/core/Single;", "updateEvent", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/amity/socialcloud/sdk/model/social/event/AmityEventType;Ljava/lang/Boolean;Lorg/joda/time/DateTime;Lorg/joda/time/DateTime;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Ljava/lang/String;)Lio/reactivex/rxjava3/core/Single;", "deleteEvent", "getLatestEvent", "dynamicQueryStreamKeyCreator", "Lcom/ekoapp/ekosdk/internal/keycreator/DynamicQueryStreamKeyCreator;", "nonce", "", "notifyChanges", "", "notifyChanges$amity_sdk_release", "amity-sdk_release"})
public final class EventRepository
extends AmityObjectRepository<EventEntity, AmityEvent> {
    @Override
    @NotNull
    public Completable fetchAndSave(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        Completable completable = new EventRemoteDataStore().getEvent(objectId).flatMapCompletable((Function)fetchAndSave.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"flatMapCompletable(...)");
        return completable;
    }

    @Override
    @Nullable
    public EventEntity queryFromCache(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        return new EventLocalDataStore().getEvent(objectId);
    }

    @Override
    @NotNull
    public ModelMapper<EventEntity, AmityEvent> mapper() {
        return new EventModelMapper();
    }

    @Override
    @NotNull
    public Flowable<EventEntity> observeFromCache(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        return new EventLocalDataStore().observe(objectId);
    }

    @Nullable
    public final AmityEvent getEvent(@NotNull String eventId) {
        AmityEvent amityEvent;
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        EventEntity eventEntity = new EventLocalDataStore().getEvent(eventId);
        if (eventEntity != null) {
            EventEntity it = eventEntity;
            boolean bl = false;
            amityEvent = new EventModelMapper().map(it);
        } else {
            amityEvent = null;
        }
        return amityEvent;
    }

    @NotNull
    public final Flowable<PagingData<AmityEvent>> getEventPagingData(@Nullable AmityEventOriginType originType, @Nullable String originId, @Nullable String userId, @Nullable AmityEventStatus status, @Nullable AmityEventType type2, @Nullable Boolean onlyAttendee, @NotNull AmityEventSortOption sortBy, @NotNull AmityEventOrderOption orderBy) {
        Intrinsics.checkNotNullParameter((Object)((Object)sortBy), (String)"sortBy");
        Intrinsics.checkNotNullParameter((Object)((Object)orderBy), (String)"orderBy");
        QueryStreamPagerCreator pagerCreator = new QueryStreamPagerCreator(new PagingConfig(20, 0, true, 10, 0, 0, 48, null), null, new EventQueryMediator(originType, originId, userId, status, type2, onlyAttendee, sortBy, orderBy), () -> EventRepository.getEventPagingData$lambda$1(originType, originId, userId, status, type2, onlyAttendee, sortBy, orderBy), new EventModelMapper(), 2, null);
        return FlowableKt.toRx3(pagerCreator.create());
    }

    @NotNull
    public final Single<AmityEvent> createEvent(@Nullable String title, @Nullable String description, @Nullable AmityEventType type2, @Nullable Boolean isInviteOnly, @Nullable DateTime startTime, @NotNull DateTime endTime, @NotNull AmityEventOriginType originType, @NotNull String originId, @Nullable String location, @Nullable String externalUrl, @Nullable String coverImageFileId, @Nullable AmityTags tags, @Nullable String timezone) {
        Intrinsics.checkNotNullParameter((Object)endTime, (String)"endTime");
        Intrinsics.checkNotNullParameter((Object)((Object)originType), (String)"originType");
        Intrinsics.checkNotNullParameter((Object)originId, (String)"originId");
        Single single = new EventRemoteDataStore().createEvent(title, description, type2, isInviteOnly, startTime, endTime, originType, originId, location, externalUrl, coverImageFileId, tags, timezone).flatMap((Function)createEvent.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"flatMap(...)");
        return single;
    }

    @NotNull
    public final Single<AmityEvent> updateEvent(@NotNull String eventId, @Nullable String title, @Nullable String description, @Nullable AmityEventType type2, @Nullable Boolean isInviteOnly, @Nullable DateTime startTime, @Nullable DateTime endTime, @Nullable String location, @Nullable String externalUrl, @Nullable String coverImageFileId, @Nullable AmityTags tags, @Nullable String timezone) {
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Single single = new EventRemoteDataStore().updateEvent(eventId, title, description, type2, isInviteOnly, startTime, endTime, location, externalUrl, coverImageFileId, tags, timezone).flatMap((Function)updateEvent.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"flatMap(...)");
        return single;
    }

    @NotNull
    public final Completable deleteEvent(@NotNull String eventId) {
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Completable completable = new EventRemoteDataStore().deleteEvent(eventId).flatMapCompletable(new Function(eventId){
            final /* synthetic */ String $eventId;
            {
                this.$eventId = $eventId;
            }

            public final CompletableSource apply(EkoDeletionDto it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.isSuccess() ? (CompletableSource)Completable.fromAction(() -> deleteEvent.1.apply$lambda$0(this.$eventId)) : (CompletableSource)Completable.complete();
            }

            private static final void apply$lambda$0(String $eventId) {
                EventDao eventDao = UserDatabase.get().eventDao();
                eventDao.deleteById($eventId);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"flatMapCompletable(...)");
        return completable;
    }

    @NotNull
    public final Flowable<AmityEvent> getLatestEvent(@Nullable AmityEventOriginType originType, @Nullable String originId, @Nullable String userId, @Nullable AmityEventStatus status, @Nullable AmityEventType type2, @NotNull DynamicQueryStreamKeyCreator dynamicQueryStreamKeyCreator, int nonce, @NotNull AmityEventSortOption sortBy, @NotNull AmityEventOrderOption orderBy) {
        Intrinsics.checkNotNullParameter((Object)dynamicQueryStreamKeyCreator, (String)"dynamicQueryStreamKeyCreator");
        Intrinsics.checkNotNullParameter((Object)((Object)sortBy), (String)"sortBy");
        Intrinsics.checkNotNullParameter((Object)((Object)orderBy), (String)"orderBy");
        Flowable flowable = new EventLocalDataStore().getLatestEvent(originType, originId, userId, status, type2, dynamicQueryStreamKeyCreator, nonce, sortBy, orderBy).map((Function)getLatestEvent.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"map(...)");
        return flowable;
    }

    public final void notifyChanges$amity_sdk_release(@NotNull String eventId) {
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        new EventLocalDataStore().notifyChanges(eventId);
    }

    private static final PagingSource getEventPagingData$lambda$1(AmityEventOriginType $originType, String $originId, String $userId, AmityEventStatus $status, AmityEventType $type, Boolean $onlyAttendee, AmityEventSortOption $sortBy, AmityEventOrderOption $orderBy) {
        return new EventLocalDataStore().getEventPagingSource($originType, $originId, $userId, $status, $type, $onlyAttendee, $sortBy, $orderBy);
    }
}

