/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core.data.follow;

import androidx.paging.PagingSource;
import com.amity.socialcloud.sdk.model.core.follow.AmityFollowStatus;
import com.amity.socialcloud.sdk.model.core.follow.AmityFollowStatusFilter;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.model.EkoFollowCountEntity;
import com.ekoapp.ekosdk.internal.data.model.EkoUserFollowStatusEntity;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0014\u0010\t\u001a\u00020\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0007J\u0010\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00102\u0006\u0010\r\u001a\u00020\u000eJ\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000eJ\"\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\b0\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018J\"\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\b0\u00152\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018J\u001c\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\b0\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018J\u0016\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0016\u0010 \u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001e\u001a\u00020\u001fJ\u0010\u0010!\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\"\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u0016J\u0016\u0010$\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u0016J\u0016\u0010%\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010#\u001a\u00020\u0016J\u001a\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\b0\u00152\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010'\u001a\u00020\u001d2\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006("}, d2={"Lcom/amity/socialcloud/sdk/core/data/follow/FollowLocalDataStore;", "", "<init>", "()V", "saveFollow", "Lio/reactivex/rxjava3/core/Completable;", "follows", "", "Lcom/ekoapp/ekosdk/internal/data/model/EkoUserFollowStatusEntity;", "saveFollowCount", "followCounts", "Lcom/ekoapp/ekosdk/internal/data/model/EkoFollowCountEntity;", "getFollowCount", "userId", "", "observeFollowCount", "Lio/reactivex/rxjava3/core/Flowable;", "observeUserFollow", "sourceUserId", "targetUserId", "getFollowingsPagingSource", "Landroidx/paging/PagingSource;", "", "filter", "Lcom/amity/socialcloud/sdk/model/core/follow/AmityFollowStatusFilter;", "getFollowersPagingSource", "getLatestFollowing", "getLatestFollower", "updateFollower", "", "status", "Lcom/amity/socialcloud/sdk/model/core/follow/AmityFollowStatus;", "updateFollowing", "getFollowCountByIdNow", "updateFollowerCount", "followerCount", "updatePendingCount", "updateFollowingCount", "getBlockedPagingSource", "notifyUserUpdate", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nFollowLocalDataStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FollowLocalDataStore.kt\ncom/amity/socialcloud/sdk/core/data/follow/FollowLocalDataStore\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,122:1\n1869#2,2:123\n*S KotlinDebug\n*F\n+ 1 FollowLocalDataStore.kt\ncom/amity/socialcloud/sdk/core/data/follow/FollowLocalDataStore\n*L\n17#1:123,2\n*E\n"})
public final class FollowLocalDataStore {
    @NotNull
    public final Completable saveFollow(@NotNull List<EkoUserFollowStatusEntity> follows) {
        Intrinsics.checkNotNullParameter(follows, (String)"follows");
        Completable completable = Completable.fromAction(() -> FollowLocalDataStore.saveFollow$lambda$1(follows));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction(...)");
        return completable;
    }

    @NotNull
    public final Completable saveFollowCount(@NotNull List<EkoFollowCountEntity> followCounts) {
        Intrinsics.checkNotNullParameter(followCounts, (String)"followCounts");
        Completable completable = Completable.fromAction(() -> FollowLocalDataStore.saveFollowCount$lambda$2(followCounts));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction(...)");
        return completable;
    }

    @Nullable
    public final EkoFollowCountEntity getFollowCount(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return UserDatabase.get().followCountDao().getByIdNow(userId);
    }

    @NotNull
    public final Flowable<EkoFollowCountEntity> observeFollowCount(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Flowable<EkoFollowCountEntity> flowable = UserDatabase.get().followCountDao().getById(userId);
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"getById(...)");
        return flowable;
    }

    @NotNull
    public final Flowable<EkoUserFollowStatusEntity> observeUserFollow(@NotNull String sourceUserId, @NotNull String targetUserId) {
        Intrinsics.checkNotNullParameter((Object)sourceUserId, (String)"sourceUserId");
        Intrinsics.checkNotNullParameter((Object)targetUserId, (String)"targetUserId");
        Flowable<EkoUserFollowStatusEntity> flowable = UserDatabase.get().followDao().getUserFollowById(sourceUserId, targetUserId);
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"getUserFollowById(...)");
        return flowable;
    }

    @NotNull
    public final PagingSource<Integer, EkoUserFollowStatusEntity> getFollowingsPagingSource(@NotNull String userId, @NotNull AmityFollowStatusFilter filter) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        return UserDatabase.get().followingPagingDao().getFollowingPagingSource(userId, filter);
    }

    @NotNull
    public final PagingSource<Integer, EkoUserFollowStatusEntity> getFollowersPagingSource(@NotNull String userId, @NotNull AmityFollowStatusFilter filter) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        return UserDatabase.get().followingPagingDao().getFollowerPagingSource(userId, filter);
    }

    @NotNull
    public final Flowable<EkoUserFollowStatusEntity> getLatestFollowing(@NotNull String userId, @NotNull AmityFollowStatusFilter filter) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        Flowable<EkoUserFollowStatusEntity> flowable = UserDatabase.get().followDao().getLatestFollowing(userId, filter.getStatuses());
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"getLatestFollowing(...)");
        return flowable;
    }

    @NotNull
    public final Flowable<EkoUserFollowStatusEntity> getLatestFollower(@NotNull String userId, @NotNull AmityFollowStatusFilter filter) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        Flowable<EkoUserFollowStatusEntity> flowable = UserDatabase.get().followDao().getLatestFollower(userId, filter.getStatuses());
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"getLatestFollower(...)");
        return flowable;
    }

    public final void updateFollower(@NotNull String userId, @NotNull AmityFollowStatus status) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        UserDatabase.get().followDao().updateFollower(userId, status.getApiKey());
    }

    public final void updateFollowing(@NotNull String userId, @NotNull AmityFollowStatus status) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Intrinsics.checkNotNullParameter((Object)((Object)status), (String)"status");
        UserDatabase.get().followDao().updateFollowing(userId, status.getApiKey());
    }

    @Nullable
    public final EkoFollowCountEntity getFollowCountByIdNow(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return UserDatabase.get().followCountDao().getByIdNow(userId);
    }

    public final void updateFollowerCount(@NotNull String userId, int followerCount) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        UserDatabase.get().followCountDao().updateFollowerCount(userId, followerCount);
    }

    public final void updatePendingCount(@NotNull String userId, int followerCount) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        UserDatabase.get().followCountDao().updatePendingCount(userId, followerCount);
    }

    public final void updateFollowingCount(@NotNull String userId, int followerCount) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        UserDatabase.get().followCountDao().updateFollowingCount(userId, followerCount);
    }

    @NotNull
    public final PagingSource<Integer, EkoUserFollowStatusEntity> getBlockedPagingSource(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        return UserDatabase.get().followingPagingDao().getBlockedPagingSource(userId);
    }

    public final void notifyUserUpdate(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        UserDatabase.get().followDao().updateUser(userId);
    }

    private static final void saveFollow$lambda$1(List $follows) {
        UserDatabase.get().followDao().save($follows);
        Iterable $this$forEach$iv = $follows;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            EkoUserFollowStatusEntity it = (EkoUserFollowStatusEntity)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getStatus(), (Object)AmityFollowStatus.BLOCKED.getApiKey())) continue;
            UserDatabase.get().followDao().deleteBySourceAndTarget(it.getTargetUserId(), it.getSourceUserId());
        }
    }

    private static final void saveFollowCount$lambda$2(List $followCounts) {
        UserDatabase.get().followCountDao().save($followCounts);
    }
}

