/*
 * Decompiled with CFR 0.152.
 */
package org.amity.diagnostics;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.amity.assertions.Assertions;
import org.amity.diagnostics.Logger;
import org.amity.diagnostics.TimberLogger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0007J\b\u0010\u000b\u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/amity/diagnostics/Loggers;", "", "<init>", "()V", "PREFIX", "", "USE_SLF4J", "", "getLogger", "Lorg/amity/diagnostics/Logger;", "suffix", "shouldUseSLF4J", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nLoggers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Loggers.kt\norg/amity/diagnostics/Loggers\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,55:1\n1#2:56\n*E\n"})
public final class Loggers {
    @NotNull
    public static final Loggers INSTANCE = new Loggers();
    @NotNull
    public static final String PREFIX = "org.bson";
    private static final boolean USE_SLF4J = INSTANCE.shouldUseSLF4J();

    private Loggers() {
    }

    @JvmStatic
    @NotNull
    public static final Logger getLogger(@NotNull String suffix) {
        Intrinsics.checkNotNullParameter((Object)suffix, (String)"suffix");
        Assertions.notNull("suffix", suffix);
        if (!(!StringsKt.startsWith$default((String)suffix, (String)".", (boolean)false, (int)2, null) && !StringsKt.endsWith$default((String)suffix, (String)".", (boolean)false, (int)2, null))) {
            boolean bl = false;
            String string = "The suffix can not start or end with a '.'";
            throw new IllegalArgumentException(string.toString());
        }
        String name = "org.bson." + suffix;
        return new TimberLogger(name);
    }

    private final boolean shouldUseSLF4J() {
        boolean bl;
        try {
            Class.forName("org.slf4j.Logger");
            bl = true;
        }
        catch (ClassNotFoundException e) {
            bl = false;
        }
        return bl;
    }
}

