/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.sqlite.SQLiteStatement;
import com.amity.socialcloud.sdk.core.data.settings.network.core.user.UserSettingsEntity;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.UserSettingsDao;
import io.reactivex.rxjava3.core.Flowable;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class UserSettingsDao_Impl
extends UserSettingsDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<UserSettingsEntity> __insertAdapterOfUserSettingsEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeleteOrUpdateAdapter<UserSettingsEntity> __deleteAdapterOfUserSettingsEntity;
    private final EntityDeleteOrUpdateAdapter<UserSettingsEntity> __updateAdapterOfUserSettingsEntity;

    public UserSettingsDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfUserSettingsEntity = new EntityInsertAdapter<UserSettingsEntity>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `user_settings` (`settingId`,`isAllowUpdateDisplayName`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull UserSettingsEntity entity) {
                if (entity.getSettingId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getSettingId());
                }
                int _tmp = entity.isAllowUpdateDisplayName() ? 1 : 0;
                statement.bindLong(2, (long)_tmp);
                String _tmp_1 = UserSettingsDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_1 == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, _tmp_1);
                }
                String _tmp_2 = UserSettingsDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, _tmp_2);
                }
                String _tmp_3 = UserSettingsDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_3 == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp_3);
                }
            }
        };
        this.__deleteAdapterOfUserSettingsEntity = new EntityDeleteOrUpdateAdapter<UserSettingsEntity>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `user_settings` WHERE `settingId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull UserSettingsEntity entity) {
                if (entity.getSettingId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getSettingId());
                }
            }
        };
        this.__updateAdapterOfUserSettingsEntity = new EntityDeleteOrUpdateAdapter<UserSettingsEntity>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `user_settings` SET `settingId` = ?,`isAllowUpdateDisplayName` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `settingId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull UserSettingsEntity entity) {
                if (entity.getSettingId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getSettingId());
                }
                int _tmp = entity.isAllowUpdateDisplayName() ? 1 : 0;
                statement.bindLong(2, (long)_tmp);
                String _tmp_1 = UserSettingsDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_1 == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, _tmp_1);
                }
                String _tmp_2 = UserSettingsDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, _tmp_2);
                }
                String _tmp_3 = UserSettingsDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_3 == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp_3);
                }
                if (entity.getSettingId() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, entity.getSettingId());
                }
            }
        };
    }

    @Override
    public void insertImpl(UserSettingsEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfUserSettingsEntity.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends UserSettingsEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfUserSettingsEntity.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(UserSettingsEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfUserSettingsEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void delete(List<? extends UserSettingsEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfUserSettingsEntity.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void updateImpl(UserSettingsEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfUserSettingsEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(UserSettingsEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            UserSettingsDao_Impl.super.insert(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends UserSettingsEntity> objects) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            UserSettingsDao_Impl.super.insert(objects);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(UserSettingsEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            UserSettingsDao_Impl.super.update(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public Flowable<UserSettingsEntity> getUserSettings(String settingId) {
        String _sql = "select * from user_settings where settingId = ?";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"user_settings"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("select * from user_settings where settingId = ?");){
                UserSettingsEntity _result;
                int _argIndex = 1;
                if (settingId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, settingId);
                }
                int _columnIndexOfSettingId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"settingId");
                int _columnIndexOfIsAllowUpdateDisplayName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isAllowUpdateDisplayName");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new UserSettingsEntity();
                    String _tmpSettingId = _stmt.isNull(_columnIndexOfSettingId) ? null : _stmt.getText(_columnIndexOfSettingId);
                    _result.setSettingId(_tmpSettingId);
                    int _tmp = (int)_stmt.getLong(_columnIndexOfIsAllowUpdateDisplayName);
                    boolean _tmpIsAllowUpdateDisplayName = _tmp != 0;
                    _result.setAllowUpdateDisplayName(_tmpIsAllowUpdateDisplayName);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                UserSettingsEntity userSettingsEntity = _result;
                return userSettingsEntity;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "DELETE from user_settings";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from user_settings");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

