/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.SQLiteStatement;
import com.ekoapp.ekosdk.internal.SubChannelUnreadInfoEntity;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.SubChannelUnreadInfoDao;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class SubChannelUnreadInfoDao_Impl
extends SubChannelUnreadInfoDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<SubChannelUnreadInfoEntity> __insertAdapterOfSubChannelUnreadInfoEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeleteOrUpdateAdapter<SubChannelUnreadInfoEntity> __deleteAdapterOfSubChannelUnreadInfoEntity;
    private final EntityDeleteOrUpdateAdapter<SubChannelUnreadInfoEntity> __updateAdapterOfSubChannelUnreadInfoEntity;

    public SubChannelUnreadInfoDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfSubChannelUnreadInfoEntity = new EntityInsertAdapter<SubChannelUnreadInfoEntity>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `sub_channel_unread_info` (`subChannelId`,`channelId`,`unreadCount`,`isMentioned`,`readToSegment`,`lastSegment`,`lastMentionSegment`,`isDeleted`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull SubChannelUnreadInfoEntity entity) {
                if (entity.getSubChannelId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getSubChannelId());
                }
                if (entity.getChannelId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getChannelId());
                }
                statement.bindLong(3, (long)entity.getUnreadCount());
                int _tmp = entity.isMentioned() ? 1 : 0;
                statement.bindLong(4, (long)_tmp);
                statement.bindLong(5, (long)entity.getReadToSegment());
                statement.bindLong(6, (long)entity.getLastSegment());
                statement.bindLong(7, (long)entity.getLastMentionSegment());
                int _tmp_1 = entity.isDeleted() ? 1 : 0;
                statement.bindLong(8, (long)_tmp_1);
                String _tmp_2 = SubChannelUnreadInfoDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, _tmp_2);
                }
                String _tmp_3 = SubChannelUnreadInfoDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_3 == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindText(10, _tmp_3);
                }
                String _tmp_4 = SubChannelUnreadInfoDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_4 == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindText(11, _tmp_4);
                }
            }
        };
        this.__deleteAdapterOfSubChannelUnreadInfoEntity = new EntityDeleteOrUpdateAdapter<SubChannelUnreadInfoEntity>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `sub_channel_unread_info` WHERE `subChannelId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull SubChannelUnreadInfoEntity entity) {
                if (entity.getSubChannelId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getSubChannelId());
                }
            }
        };
        this.__updateAdapterOfSubChannelUnreadInfoEntity = new EntityDeleteOrUpdateAdapter<SubChannelUnreadInfoEntity>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `sub_channel_unread_info` SET `subChannelId` = ?,`channelId` = ?,`unreadCount` = ?,`isMentioned` = ?,`readToSegment` = ?,`lastSegment` = ?,`lastMentionSegment` = ?,`isDeleted` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `subChannelId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull SubChannelUnreadInfoEntity entity) {
                if (entity.getSubChannelId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getSubChannelId());
                }
                if (entity.getChannelId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getChannelId());
                }
                statement.bindLong(3, (long)entity.getUnreadCount());
                int _tmp = entity.isMentioned() ? 1 : 0;
                statement.bindLong(4, (long)_tmp);
                statement.bindLong(5, (long)entity.getReadToSegment());
                statement.bindLong(6, (long)entity.getLastSegment());
                statement.bindLong(7, (long)entity.getLastMentionSegment());
                int _tmp_1 = entity.isDeleted() ? 1 : 0;
                statement.bindLong(8, (long)_tmp_1);
                String _tmp_2 = SubChannelUnreadInfoDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, _tmp_2);
                }
                String _tmp_3 = SubChannelUnreadInfoDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_3 == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindText(10, _tmp_3);
                }
                String _tmp_4 = SubChannelUnreadInfoDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_4 == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindText(11, _tmp_4);
                }
                if (entity.getSubChannelId() == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindText(12, entity.getSubChannelId());
                }
            }
        };
    }

    @Override
    public void insertImpl(SubChannelUnreadInfoEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfSubChannelUnreadInfoEntity.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends SubChannelUnreadInfoEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfSubChannelUnreadInfoEntity.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(SubChannelUnreadInfoEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfSubChannelUnreadInfoEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void delete(List<? extends SubChannelUnreadInfoEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfSubChannelUnreadInfoEntity.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void updateImpl(SubChannelUnreadInfoEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfSubChannelUnreadInfoEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(SubChannelUnreadInfoEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            SubChannelUnreadInfoDao_Impl.super.insert(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends SubChannelUnreadInfoEntity> objects) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            SubChannelUnreadInfoDao_Impl.super.insert(objects);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(SubChannelUnreadInfoEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            SubChannelUnreadInfoDao_Impl.super.update(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public SubChannelUnreadInfoEntity getByIdNow(String subChannelId) {
        String _sql = "SELECT * from sub_channel_unread_info where subChannelId = ? LIMIT 1";
        return (SubChannelUnreadInfoEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from sub_channel_unread_info where subChannelId = ? LIMIT 1");){
                SubChannelUnreadInfoEntity _result;
                int _argIndex = 1;
                if (subChannelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, subChannelId);
                }
                int _columnIndexOfSubChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"subChannelId");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfUnreadCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"unreadCount");
                int _columnIndexOfIsMentioned = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isMentioned");
                int _columnIndexOfReadToSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"readToSegment");
                int _columnIndexOfLastSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastSegment");
                int _columnIndexOfLastMentionSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastMentionSegment");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new SubChannelUnreadInfoEntity();
                    String _tmpSubChannelId = _stmt.isNull(_columnIndexOfSubChannelId) ? null : _stmt.getText(_columnIndexOfSubChannelId);
                    _result.setSubChannelId(_tmpSubChannelId);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _result.setChannelId(_tmpChannelId);
                    int _tmpUnreadCount = (int)_stmt.getLong(_columnIndexOfUnreadCount);
                    _result.setUnreadCount(_tmpUnreadCount);
                    int _tmp = (int)_stmt.getLong(_columnIndexOfIsMentioned);
                    boolean _tmpIsMentioned = _tmp != 0;
                    _result.setMentioned(_tmpIsMentioned);
                    int _tmpReadToSegment = (int)_stmt.getLong(_columnIndexOfReadToSegment);
                    _result.setReadToSegment(_tmpReadToSegment);
                    int _tmpLastSegment = (int)_stmt.getLong(_columnIndexOfLastSegment);
                    _result.setLastSegment(_tmpLastSegment);
                    int _tmpLastMentionSegment = (int)_stmt.getLong(_columnIndexOfLastMentionSegment);
                    _result.setLastMentionSegment(_tmpLastMentionSegment);
                    int _tmp_1 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_1 != 0;
                    _result.setDeleted(_tmpIsDeleted);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                SubChannelUnreadInfoEntity subChannelUnreadInfoEntity = _result;
                return subChannelUnreadInfoEntity;
            }
        });
    }

    @Override
    public Flowable<SubChannelUnreadInfoEntity> getById(String subChannelId) {
        String _sql = "SELECT * from sub_channel_unread_info where subChannelId = ? LIMIT 1";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"sub_channel_unread_info"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from sub_channel_unread_info where subChannelId = ? LIMIT 1");){
                SubChannelUnreadInfoEntity _result;
                int _argIndex = 1;
                if (subChannelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, subChannelId);
                }
                int _columnIndexOfSubChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"subChannelId");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfUnreadCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"unreadCount");
                int _columnIndexOfIsMentioned = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isMentioned");
                int _columnIndexOfReadToSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"readToSegment");
                int _columnIndexOfLastSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastSegment");
                int _columnIndexOfLastMentionSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastMentionSegment");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new SubChannelUnreadInfoEntity();
                    String _tmpSubChannelId = _stmt.isNull(_columnIndexOfSubChannelId) ? null : _stmt.getText(_columnIndexOfSubChannelId);
                    _result.setSubChannelId(_tmpSubChannelId);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _result.setChannelId(_tmpChannelId);
                    int _tmpUnreadCount = (int)_stmt.getLong(_columnIndexOfUnreadCount);
                    _result.setUnreadCount(_tmpUnreadCount);
                    int _tmp = (int)_stmt.getLong(_columnIndexOfIsMentioned);
                    boolean _tmpIsMentioned = _tmp != 0;
                    _result.setMentioned(_tmpIsMentioned);
                    int _tmpReadToSegment = (int)_stmt.getLong(_columnIndexOfReadToSegment);
                    _result.setReadToSegment(_tmpReadToSegment);
                    int _tmpLastSegment = (int)_stmt.getLong(_columnIndexOfLastSegment);
                    _result.setLastSegment(_tmpLastSegment);
                    int _tmpLastMentionSegment = (int)_stmt.getLong(_columnIndexOfLastMentionSegment);
                    _result.setLastMentionSegment(_tmpLastMentionSegment);
                    int _tmp_1 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_1 != 0;
                    _result.setDeleted(_tmpIsDeleted);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                SubChannelUnreadInfoEntity subChannelUnreadInfoEntity = _result;
                return subChannelUnreadInfoEntity;
            }
        });
    }

    @Override
    public List<SubChannelUnreadInfoEntity> getByChannelIdNow(String channelId) {
        String _sql = "SELECT * from sub_channel_unread_info where channelId = ? and isDeleted = 0";
        return (List)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from sub_channel_unread_info where channelId = ? and isDeleted = 0");){
                int _argIndex = 1;
                if (channelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, channelId);
                }
                int _columnIndexOfSubChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"subChannelId");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfUnreadCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"unreadCount");
                int _columnIndexOfIsMentioned = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isMentioned");
                int _columnIndexOfReadToSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"readToSegment");
                int _columnIndexOfLastSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastSegment");
                int _columnIndexOfLastMentionSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastMentionSegment");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<SubChannelUnreadInfoEntity> _result = new ArrayList<SubChannelUnreadInfoEntity>();
                while (_stmt.step()) {
                    SubChannelUnreadInfoEntity _item = new SubChannelUnreadInfoEntity();
                    String _tmpSubChannelId = _stmt.isNull(_columnIndexOfSubChannelId) ? null : _stmt.getText(_columnIndexOfSubChannelId);
                    _item.setSubChannelId(_tmpSubChannelId);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _item.setChannelId(_tmpChannelId);
                    int _tmpUnreadCount = (int)_stmt.getLong(_columnIndexOfUnreadCount);
                    _item.setUnreadCount(_tmpUnreadCount);
                    int _tmp = (int)_stmt.getLong(_columnIndexOfIsMentioned);
                    boolean _tmpIsMentioned = _tmp != 0;
                    _item.setMentioned(_tmpIsMentioned);
                    int _tmpReadToSegment = (int)_stmt.getLong(_columnIndexOfReadToSegment);
                    _item.setReadToSegment(_tmpReadToSegment);
                    int _tmpLastSegment = (int)_stmt.getLong(_columnIndexOfLastSegment);
                    _item.setLastSegment(_tmpLastSegment);
                    int _tmpLastMentionSegment = (int)_stmt.getLong(_columnIndexOfLastMentionSegment);
                    _item.setLastMentionSegment(_tmpLastMentionSegment);
                    int _tmp_1 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_1 != 0;
                    _item.setDeleted(_tmpIsDeleted);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _item.setCreatedAt(_tmpCreatedAt);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _item.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _item.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item);
                }
                ArrayList<SubChannelUnreadInfoEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public List<String> getDeletedIds(List<String> subChannelIds) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("SELECT subChannelId from sub_channel_unread_info where subChannelId in (");
        int _inputSize = subChannelIds.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") and isDeleted = 1");
        String _sql = _stringBuilder.toString();
        return (List)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare(_sql);){
                int _argIndex = 1;
                for (String _item : subChannelIds) {
                    if (_item == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindText(_argIndex, _item);
                    }
                    ++_argIndex;
                }
                ArrayList<String> _result = new ArrayList<String>();
                while (_stmt.step()) {
                    String _item_1 = _stmt.isNull(0) ? null : _stmt.getText(0);
                    _result.add(_item_1);
                }
                ArrayList<String> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "DELETE from sub_channel_unread_info";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from sub_channel_unread_info");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @Override
    public void deleteById(String subChannelId) {
        String _sql = "UPDATE sub_channel_unread_info SET isDeleted = 1 where subChannelId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE sub_channel_unread_info SET isDeleted = 1 where subChannelId = ?");){
                int _argIndex = 1;
                if (subChannelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, subChannelId);
                }
                _stmt.step();
                Object var4_4 = null;
                return var4_4;
            }
        });
    }

    @Override
    public void deleteByChannelId(String channelId) {
        String _sql = "UPDATE sub_channel_unread_info SET isDeleted = 1 where channelId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE sub_channel_unread_info SET isDeleted = 1 where channelId = ?");){
                int _argIndex = 1;
                if (channelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, channelId);
                }
                _stmt.step();
                Object var4_4 = null;
                return var4_4;
            }
        });
    }

    @Override
    public void deleteCacheByChannelId(String channelId) {
        String _sql = "DELETE from sub_channel_unread_info where channelId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from sub_channel_unread_info where channelId = ?");){
                int _argIndex = 1;
                if (channelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, channelId);
                }
                _stmt.step();
                Object var4_4 = null;
                return var4_4;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

