/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.SQLiteStatement;
import com.ekoapp.ekosdk.internal.SubChannelEntity;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.SubChannelDao;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class SubChannelDao_Impl
extends SubChannelDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<SubChannelEntity> __insertAdapterOfSubChannelEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeleteOrUpdateAdapter<SubChannelEntity> __deleteAdapterOfSubChannelEntity;
    private final EntityDeleteOrUpdateAdapter<SubChannelEntity> __updateAdapterOfSubChannelEntity;

    public SubChannelDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfSubChannelEntity = new EntityInsertAdapter<SubChannelEntity>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `sub_channel` (`subChannelId`,`channelId`,`channelPublicId`,`networkId`,`channelType`,`name`,`messageCount`,`isDeleted`,`latestMessageId`,`lastActivity`,`creatorId`,`creatorPublicId`,`path`,`editedAt`,`subChannelMarkerHash`,`userSubChannelMarkerHash`,`messagePreviewId`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull SubChannelEntity entity) {
                if (entity.getSubChannelId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getSubChannelId());
                }
                if (entity.getChannelId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getChannelId());
                }
                if (entity.getChannelPublicId() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getChannelPublicId());
                }
                if (entity.getNetworkId() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getNetworkId());
                }
                if (entity.getChannelType() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, entity.getChannelType());
                }
                if (entity.getName() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, entity.getName());
                }
                statement.bindLong(7, (long)entity.getMessageCount());
                int _tmp = entity.isDeleted() ? 1 : 0;
                statement.bindLong(8, (long)_tmp);
                if (entity.getLatestMessageId() == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, entity.getLatestMessageId());
                }
                String _tmp_1 = SubChannelDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getLastActivity());
                if (_tmp_1 == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindText(10, _tmp_1);
                }
                if (entity.getCreatorId() == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindText(11, entity.getCreatorId());
                }
                if (entity.getCreatorPublicId() == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindText(12, entity.getCreatorPublicId());
                }
                if (entity.getPath() == null) {
                    statement.bindNull(13);
                } else {
                    statement.bindText(13, entity.getPath());
                }
                String _tmp_2 = SubChannelDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getEditedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(14);
                } else {
                    statement.bindText(14, _tmp_2);
                }
                statement.bindLong(15, (long)entity.getSubChannelMarkerHash());
                statement.bindLong(16, (long)entity.getUserSubChannelMarkerHash());
                if (entity.getMessagePreviewId() == null) {
                    statement.bindNull(17);
                } else {
                    statement.bindText(17, entity.getMessagePreviewId());
                }
                String _tmp_3 = SubChannelDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_3 == null) {
                    statement.bindNull(18);
                } else {
                    statement.bindText(18, _tmp_3);
                }
                String _tmp_4 = SubChannelDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_4 == null) {
                    statement.bindNull(19);
                } else {
                    statement.bindText(19, _tmp_4);
                }
                String _tmp_5 = SubChannelDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_5 == null) {
                    statement.bindNull(20);
                } else {
                    statement.bindText(20, _tmp_5);
                }
            }
        };
        this.__deleteAdapterOfSubChannelEntity = new EntityDeleteOrUpdateAdapter<SubChannelEntity>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `sub_channel` WHERE `channelId` = ? AND `subChannelId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull SubChannelEntity entity) {
                if (entity.getChannelId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getChannelId());
                }
                if (entity.getSubChannelId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getSubChannelId());
                }
            }
        };
        this.__updateAdapterOfSubChannelEntity = new EntityDeleteOrUpdateAdapter<SubChannelEntity>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `sub_channel` SET `subChannelId` = ?,`channelId` = ?,`channelPublicId` = ?,`networkId` = ?,`channelType` = ?,`name` = ?,`messageCount` = ?,`isDeleted` = ?,`latestMessageId` = ?,`lastActivity` = ?,`creatorId` = ?,`creatorPublicId` = ?,`path` = ?,`editedAt` = ?,`subChannelMarkerHash` = ?,`userSubChannelMarkerHash` = ?,`messagePreviewId` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `channelId` = ? AND `subChannelId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull SubChannelEntity entity) {
                if (entity.getSubChannelId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getSubChannelId());
                }
                if (entity.getChannelId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getChannelId());
                }
                if (entity.getChannelPublicId() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getChannelPublicId());
                }
                if (entity.getNetworkId() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getNetworkId());
                }
                if (entity.getChannelType() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, entity.getChannelType());
                }
                if (entity.getName() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, entity.getName());
                }
                statement.bindLong(7, (long)entity.getMessageCount());
                int _tmp = entity.isDeleted() ? 1 : 0;
                statement.bindLong(8, (long)_tmp);
                if (entity.getLatestMessageId() == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, entity.getLatestMessageId());
                }
                String _tmp_1 = SubChannelDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getLastActivity());
                if (_tmp_1 == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindText(10, _tmp_1);
                }
                if (entity.getCreatorId() == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindText(11, entity.getCreatorId());
                }
                if (entity.getCreatorPublicId() == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindText(12, entity.getCreatorPublicId());
                }
                if (entity.getPath() == null) {
                    statement.bindNull(13);
                } else {
                    statement.bindText(13, entity.getPath());
                }
                String _tmp_2 = SubChannelDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getEditedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(14);
                } else {
                    statement.bindText(14, _tmp_2);
                }
                statement.bindLong(15, (long)entity.getSubChannelMarkerHash());
                statement.bindLong(16, (long)entity.getUserSubChannelMarkerHash());
                if (entity.getMessagePreviewId() == null) {
                    statement.bindNull(17);
                } else {
                    statement.bindText(17, entity.getMessagePreviewId());
                }
                String _tmp_3 = SubChannelDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_3 == null) {
                    statement.bindNull(18);
                } else {
                    statement.bindText(18, _tmp_3);
                }
                String _tmp_4 = SubChannelDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_4 == null) {
                    statement.bindNull(19);
                } else {
                    statement.bindText(19, _tmp_4);
                }
                String _tmp_5 = SubChannelDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_5 == null) {
                    statement.bindNull(20);
                } else {
                    statement.bindText(20, _tmp_5);
                }
                if (entity.getChannelId() == null) {
                    statement.bindNull(21);
                } else {
                    statement.bindText(21, entity.getChannelId());
                }
                if (entity.getSubChannelId() == null) {
                    statement.bindNull(22);
                } else {
                    statement.bindText(22, entity.getSubChannelId());
                }
            }
        };
    }

    @Override
    public void insertImpl(SubChannelEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfSubChannelEntity.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends SubChannelEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfSubChannelEntity.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(SubChannelEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfSubChannelEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void delete(List<? extends SubChannelEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfSubChannelEntity.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void updateImpl(SubChannelEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfSubChannelEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(SubChannelEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            SubChannelDao_Impl.super.insert(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends SubChannelEntity> objects) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            SubChannelDao_Impl.super.insert(objects);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(SubChannelEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            SubChannelDao_Impl.super.update(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public Flowable<SubChannelEntity> getSubChannel(String subChanelId) {
        String _sql = "select * from sub_channel where subChannelId = ?";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"sub_channel"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("select * from sub_channel where subChannelId = ?");){
                SubChannelEntity _result;
                int _argIndex = 1;
                if (subChanelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, subChanelId);
                }
                int _columnIndexOfSubChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"subChannelId");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfChannelPublicId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelPublicId");
                int _columnIndexOfNetworkId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"networkId");
                int _columnIndexOfChannelType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelType");
                int _columnIndexOfName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"name");
                int _columnIndexOfMessageCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messageCount");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfLatestMessageId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"latestMessageId");
                int _columnIndexOfLastActivity = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastActivity");
                int _columnIndexOfCreatorId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"creatorId");
                int _columnIndexOfCreatorPublicId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"creatorPublicId");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfEditedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"editedAt");
                int _columnIndexOfSubChannelMarkerHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"subChannelMarkerHash");
                int _columnIndexOfUserSubChannelMarkerHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userSubChannelMarkerHash");
                int _columnIndexOfMessagePreviewId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messagePreviewId");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new SubChannelEntity();
                    String _tmpSubChannelId = _stmt.isNull(_columnIndexOfSubChannelId) ? null : _stmt.getText(_columnIndexOfSubChannelId);
                    _result.setSubChannelId(_tmpSubChannelId);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _result.setChannelId(_tmpChannelId);
                    String _tmpChannelPublicId = _stmt.isNull(_columnIndexOfChannelPublicId) ? null : _stmt.getText(_columnIndexOfChannelPublicId);
                    _result.setChannelPublicId(_tmpChannelPublicId);
                    String _tmpNetworkId = _stmt.isNull(_columnIndexOfNetworkId) ? null : _stmt.getText(_columnIndexOfNetworkId);
                    _result.setNetworkId(_tmpNetworkId);
                    String _tmpChannelType = _stmt.isNull(_columnIndexOfChannelType) ? null : _stmt.getText(_columnIndexOfChannelType);
                    _result.setChannelType(_tmpChannelType);
                    String _tmpName = _stmt.isNull(_columnIndexOfName) ? null : _stmt.getText(_columnIndexOfName);
                    _result.setName(_tmpName);
                    int _tmpMessageCount = (int)_stmt.getLong(_columnIndexOfMessageCount);
                    _result.setMessageCount(_tmpMessageCount);
                    int _tmp = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp != 0;
                    _result.setDeleted(_tmpIsDeleted);
                    String _tmpLatestMessageId = _stmt.isNull(_columnIndexOfLatestMessageId) ? null : _stmt.getText(_columnIndexOfLatestMessageId);
                    _result.setLatestMessageId(_tmpLatestMessageId);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfLastActivity) ? null : _stmt.getText(_columnIndexOfLastActivity);
                    DateTime _tmpLastActivity = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setLastActivity(_tmpLastActivity);
                    String _tmpCreatorId = _stmt.isNull(_columnIndexOfCreatorId) ? null : _stmt.getText(_columnIndexOfCreatorId);
                    _result.setCreatorId(_tmpCreatorId);
                    String _tmpCreatorPublicId = _stmt.isNull(_columnIndexOfCreatorPublicId) ? null : _stmt.getText(_columnIndexOfCreatorPublicId);
                    _result.setCreatorPublicId(_tmpCreatorPublicId);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _result.setPath(_tmpPath);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfEditedAt) ? null : _stmt.getText(_columnIndexOfEditedAt);
                    DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setEditedAt(_tmpEditedAt);
                    int _tmpSubChannelMarkerHash = (int)_stmt.getLong(_columnIndexOfSubChannelMarkerHash);
                    _result.setSubChannelMarkerHash(_tmpSubChannelMarkerHash);
                    int _tmpUserSubChannelMarkerHash = (int)_stmt.getLong(_columnIndexOfUserSubChannelMarkerHash);
                    _result.setUserSubChannelMarkerHash(_tmpUserSubChannelMarkerHash);
                    String _tmpMessagePreviewId = _stmt.isNull(_columnIndexOfMessagePreviewId) ? null : _stmt.getText(_columnIndexOfMessagePreviewId);
                    _result.setMessagePreviewId(_tmpMessagePreviewId);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                SubChannelEntity subChannelEntity = _result;
                return subChannelEntity;
            }
        });
    }

    @Override
    public SubChannelEntity getByIdNowImpl(String id) {
        String _sql = "select * from sub_channel where subChannelId = ? limit 1";
        return (SubChannelEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("select * from sub_channel where subChannelId = ? limit 1");){
                SubChannelEntity _result;
                int _argIndex = 1;
                if (id == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, id);
                }
                int _columnIndexOfSubChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"subChannelId");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfChannelPublicId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelPublicId");
                int _columnIndexOfNetworkId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"networkId");
                int _columnIndexOfChannelType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelType");
                int _columnIndexOfName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"name");
                int _columnIndexOfMessageCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messageCount");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfLatestMessageId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"latestMessageId");
                int _columnIndexOfLastActivity = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastActivity");
                int _columnIndexOfCreatorId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"creatorId");
                int _columnIndexOfCreatorPublicId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"creatorPublicId");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfEditedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"editedAt");
                int _columnIndexOfSubChannelMarkerHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"subChannelMarkerHash");
                int _columnIndexOfUserSubChannelMarkerHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userSubChannelMarkerHash");
                int _columnIndexOfMessagePreviewId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messagePreviewId");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new SubChannelEntity();
                    String _tmpSubChannelId = _stmt.isNull(_columnIndexOfSubChannelId) ? null : _stmt.getText(_columnIndexOfSubChannelId);
                    _result.setSubChannelId(_tmpSubChannelId);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _result.setChannelId(_tmpChannelId);
                    String _tmpChannelPublicId = _stmt.isNull(_columnIndexOfChannelPublicId) ? null : _stmt.getText(_columnIndexOfChannelPublicId);
                    _result.setChannelPublicId(_tmpChannelPublicId);
                    String _tmpNetworkId = _stmt.isNull(_columnIndexOfNetworkId) ? null : _stmt.getText(_columnIndexOfNetworkId);
                    _result.setNetworkId(_tmpNetworkId);
                    String _tmpChannelType = _stmt.isNull(_columnIndexOfChannelType) ? null : _stmt.getText(_columnIndexOfChannelType);
                    _result.setChannelType(_tmpChannelType);
                    String _tmpName = _stmt.isNull(_columnIndexOfName) ? null : _stmt.getText(_columnIndexOfName);
                    _result.setName(_tmpName);
                    int _tmpMessageCount = (int)_stmt.getLong(_columnIndexOfMessageCount);
                    _result.setMessageCount(_tmpMessageCount);
                    int _tmp = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp != 0;
                    _result.setDeleted(_tmpIsDeleted);
                    String _tmpLatestMessageId = _stmt.isNull(_columnIndexOfLatestMessageId) ? null : _stmt.getText(_columnIndexOfLatestMessageId);
                    _result.setLatestMessageId(_tmpLatestMessageId);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfLastActivity) ? null : _stmt.getText(_columnIndexOfLastActivity);
                    DateTime _tmpLastActivity = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setLastActivity(_tmpLastActivity);
                    String _tmpCreatorId = _stmt.isNull(_columnIndexOfCreatorId) ? null : _stmt.getText(_columnIndexOfCreatorId);
                    _result.setCreatorId(_tmpCreatorId);
                    String _tmpCreatorPublicId = _stmt.isNull(_columnIndexOfCreatorPublicId) ? null : _stmt.getText(_columnIndexOfCreatorPublicId);
                    _result.setCreatorPublicId(_tmpCreatorPublicId);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _result.setPath(_tmpPath);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfEditedAt) ? null : _stmt.getText(_columnIndexOfEditedAt);
                    DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setEditedAt(_tmpEditedAt);
                    int _tmpSubChannelMarkerHash = (int)_stmt.getLong(_columnIndexOfSubChannelMarkerHash);
                    _result.setSubChannelMarkerHash(_tmpSubChannelMarkerHash);
                    int _tmpUserSubChannelMarkerHash = (int)_stmt.getLong(_columnIndexOfUserSubChannelMarkerHash);
                    _result.setUserSubChannelMarkerHash(_tmpUserSubChannelMarkerHash);
                    String _tmpMessagePreviewId = _stmt.isNull(_columnIndexOfMessagePreviewId) ? null : _stmt.getText(_columnIndexOfMessagePreviewId);
                    _result.setMessagePreviewId(_tmpMessagePreviewId);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                SubChannelEntity subChannelEntity = _result;
                return subChannelEntity;
            }
        });
    }

    @Override
    public Flowable<List<SubChannelEntity>> observeSubChanel(String subChanelId) {
        String _sql = "select * from sub_channel where subChannelId IN (?)";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"sub_channel"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("select * from sub_channel where subChannelId IN (?)");){
                int _argIndex = 1;
                if (subChanelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, subChanelId);
                }
                int _columnIndexOfSubChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"subChannelId");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfChannelPublicId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelPublicId");
                int _columnIndexOfNetworkId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"networkId");
                int _columnIndexOfChannelType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelType");
                int _columnIndexOfName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"name");
                int _columnIndexOfMessageCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messageCount");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfLatestMessageId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"latestMessageId");
                int _columnIndexOfLastActivity = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastActivity");
                int _columnIndexOfCreatorId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"creatorId");
                int _columnIndexOfCreatorPublicId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"creatorPublicId");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfEditedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"editedAt");
                int _columnIndexOfSubChannelMarkerHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"subChannelMarkerHash");
                int _columnIndexOfUserSubChannelMarkerHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userSubChannelMarkerHash");
                int _columnIndexOfMessagePreviewId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messagePreviewId");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<SubChannelEntity> _result = new ArrayList<SubChannelEntity>();
                while (_stmt.step()) {
                    SubChannelEntity _item = new SubChannelEntity();
                    String _tmpSubChannelId = _stmt.isNull(_columnIndexOfSubChannelId) ? null : _stmt.getText(_columnIndexOfSubChannelId);
                    _item.setSubChannelId(_tmpSubChannelId);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _item.setChannelId(_tmpChannelId);
                    String _tmpChannelPublicId = _stmt.isNull(_columnIndexOfChannelPublicId) ? null : _stmt.getText(_columnIndexOfChannelPublicId);
                    _item.setChannelPublicId(_tmpChannelPublicId);
                    String _tmpNetworkId = _stmt.isNull(_columnIndexOfNetworkId) ? null : _stmt.getText(_columnIndexOfNetworkId);
                    _item.setNetworkId(_tmpNetworkId);
                    String _tmpChannelType = _stmt.isNull(_columnIndexOfChannelType) ? null : _stmt.getText(_columnIndexOfChannelType);
                    _item.setChannelType(_tmpChannelType);
                    String _tmpName = _stmt.isNull(_columnIndexOfName) ? null : _stmt.getText(_columnIndexOfName);
                    _item.setName(_tmpName);
                    int _tmpMessageCount = (int)_stmt.getLong(_columnIndexOfMessageCount);
                    _item.setMessageCount(_tmpMessageCount);
                    int _tmp = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp != 0;
                    _item.setDeleted(_tmpIsDeleted);
                    String _tmpLatestMessageId = _stmt.isNull(_columnIndexOfLatestMessageId) ? null : _stmt.getText(_columnIndexOfLatestMessageId);
                    _item.setLatestMessageId(_tmpLatestMessageId);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfLastActivity) ? null : _stmt.getText(_columnIndexOfLastActivity);
                    DateTime _tmpLastActivity = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _item.setLastActivity(_tmpLastActivity);
                    String _tmpCreatorId = _stmt.isNull(_columnIndexOfCreatorId) ? null : _stmt.getText(_columnIndexOfCreatorId);
                    _item.setCreatorId(_tmpCreatorId);
                    String _tmpCreatorPublicId = _stmt.isNull(_columnIndexOfCreatorPublicId) ? null : _stmt.getText(_columnIndexOfCreatorPublicId);
                    _item.setCreatorPublicId(_tmpCreatorPublicId);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _item.setPath(_tmpPath);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfEditedAt) ? null : _stmt.getText(_columnIndexOfEditedAt);
                    DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _item.setEditedAt(_tmpEditedAt);
                    int _tmpSubChannelMarkerHash = (int)_stmt.getLong(_columnIndexOfSubChannelMarkerHash);
                    _item.setSubChannelMarkerHash(_tmpSubChannelMarkerHash);
                    int _tmpUserSubChannelMarkerHash = (int)_stmt.getLong(_columnIndexOfUserSubChannelMarkerHash);
                    _item.setUserSubChannelMarkerHash(_tmpUserSubChannelMarkerHash);
                    String _tmpMessagePreviewId = _stmt.isNull(_columnIndexOfMessagePreviewId) ? null : _stmt.getText(_columnIndexOfMessagePreviewId);
                    _item.setMessagePreviewId(_tmpMessagePreviewId);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _item.setCreatedAt(_tmpCreatedAt);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _item.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                    _item.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item);
                }
                ArrayList<SubChannelEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public Flowable<SubChannelEntity> getLatestSubChannelImpl(Boolean isDeleted, int hash, int nonce, DateTime now) {
        String _sql = "SELECT * from sub_channel where case when ? is not null then sub_channel.isDeleted = ? else sub_channel.subChannelId is not null end and sub_channel.updatedAt > ? and sub_channel.subChannelId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (?) and amity_paging_id.nonce = (?) ) order by sub_channel.updatedAt desc limit 1";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"sub_channel", "amity_paging_id"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from sub_channel where case when ? is not null then sub_channel.isDeleted = ? else sub_channel.subChannelId is not null end and sub_channel.updatedAt > ? and sub_channel.subChannelId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (?) and amity_paging_id.nonce = (?) ) order by sub_channel.updatedAt desc limit 1");){
                SubChannelEntity _result;
                Integer _tmp_1;
                Integer _tmp;
                int _argIndex = 1;
                Integer n = isDeleted == null ? null : (_tmp = Integer.valueOf(isDeleted != false ? 1 : 0));
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp.intValue());
                }
                _argIndex = 2;
                Integer n2 = isDeleted == null ? null : (_tmp_1 = Integer.valueOf(isDeleted != false ? 1 : 0));
                if (_tmp_1 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp_1.intValue());
                }
                _argIndex = 3;
                String _tmp_2 = this.__dateTimeTypeConverter.dateTimeToString(now);
                if (_tmp_2 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, _tmp_2);
                }
                _argIndex = 4;
                _stmt.bindLong(_argIndex, (long)hash);
                _argIndex = 5;
                _stmt.bindLong(_argIndex, (long)nonce);
                int _columnIndexOfSubChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"subChannelId");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfChannelPublicId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelPublicId");
                int _columnIndexOfNetworkId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"networkId");
                int _columnIndexOfChannelType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelType");
                int _columnIndexOfName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"name");
                int _columnIndexOfMessageCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messageCount");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfLatestMessageId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"latestMessageId");
                int _columnIndexOfLastActivity = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastActivity");
                int _columnIndexOfCreatorId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"creatorId");
                int _columnIndexOfCreatorPublicId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"creatorPublicId");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfEditedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"editedAt");
                int _columnIndexOfSubChannelMarkerHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"subChannelMarkerHash");
                int _columnIndexOfUserSubChannelMarkerHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userSubChannelMarkerHash");
                int _columnIndexOfMessagePreviewId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messagePreviewId");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new SubChannelEntity();
                    String _tmpSubChannelId = _stmt.isNull(_columnIndexOfSubChannelId) ? null : _stmt.getText(_columnIndexOfSubChannelId);
                    _result.setSubChannelId(_tmpSubChannelId);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _result.setChannelId(_tmpChannelId);
                    String _tmpChannelPublicId = _stmt.isNull(_columnIndexOfChannelPublicId) ? null : _stmt.getText(_columnIndexOfChannelPublicId);
                    _result.setChannelPublicId(_tmpChannelPublicId);
                    String _tmpNetworkId = _stmt.isNull(_columnIndexOfNetworkId) ? null : _stmt.getText(_columnIndexOfNetworkId);
                    _result.setNetworkId(_tmpNetworkId);
                    String _tmpChannelType = _stmt.isNull(_columnIndexOfChannelType) ? null : _stmt.getText(_columnIndexOfChannelType);
                    _result.setChannelType(_tmpChannelType);
                    String _tmpName = _stmt.isNull(_columnIndexOfName) ? null : _stmt.getText(_columnIndexOfName);
                    _result.setName(_tmpName);
                    int _tmpMessageCount = (int)_stmt.getLong(_columnIndexOfMessageCount);
                    _result.setMessageCount(_tmpMessageCount);
                    int _tmp_3 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_3 != 0;
                    _result.setDeleted(_tmpIsDeleted);
                    String _tmpLatestMessageId = _stmt.isNull(_columnIndexOfLatestMessageId) ? null : _stmt.getText(_columnIndexOfLatestMessageId);
                    _result.setLatestMessageId(_tmpLatestMessageId);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfLastActivity) ? null : _stmt.getText(_columnIndexOfLastActivity);
                    DateTime _tmpLastActivity = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setLastActivity(_tmpLastActivity);
                    String _tmpCreatorId = _stmt.isNull(_columnIndexOfCreatorId) ? null : _stmt.getText(_columnIndexOfCreatorId);
                    _result.setCreatorId(_tmpCreatorId);
                    String _tmpCreatorPublicId = _stmt.isNull(_columnIndexOfCreatorPublicId) ? null : _stmt.getText(_columnIndexOfCreatorPublicId);
                    _result.setCreatorPublicId(_tmpCreatorPublicId);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _result.setPath(_tmpPath);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfEditedAt) ? null : _stmt.getText(_columnIndexOfEditedAt);
                    DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                    _result.setEditedAt(_tmpEditedAt);
                    int _tmpSubChannelMarkerHash = (int)_stmt.getLong(_columnIndexOfSubChannelMarkerHash);
                    _result.setSubChannelMarkerHash(_tmpSubChannelMarkerHash);
                    int _tmpUserSubChannelMarkerHash = (int)_stmt.getLong(_columnIndexOfUserSubChannelMarkerHash);
                    _result.setUserSubChannelMarkerHash(_tmpUserSubChannelMarkerHash);
                    String _tmpMessagePreviewId = _stmt.isNull(_columnIndexOfMessagePreviewId) ? null : _stmt.getText(_columnIndexOfMessagePreviewId);
                    _result.setMessagePreviewId(_tmpMessagePreviewId);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                SubChannelEntity subChannelEntity = _result;
                return subChannelEntity;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "delete from sub_channel";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("delete from sub_channel");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @Override
    public Completable deleteById(String subChanelId) {
        String _sql = "delete from sub_channel where subChannelId = ?";
        return RxRoom.createCompletable((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("delete from sub_channel where subChannelId = ?");){
                int _argIndex = 1;
                if (subChanelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, subChanelId);
                }
                _stmt.step();
                Unit unit = Unit.INSTANCE;
                return unit;
            }
        });
    }

    @Override
    public Completable softDeleteById(String subChanelId) {
        String _sql = "update sub_channel set isDeleted = 1 where subChannelId = ? ";
        return RxRoom.createCompletable((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("update sub_channel set isDeleted = 1 where subChannelId = ? ");){
                int _argIndex = 1;
                if (subChanelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, subChanelId);
                }
                _stmt.step();
                Unit unit = Unit.INSTANCE;
                return unit;
            }
        });
    }

    @Override
    public void updateMarkerHash(String subChannelId, int hash) {
        String _sql = "UPDATE sub_channel set subChannelMarkerHash = ? where subChannelId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE sub_channel set subChannelMarkerHash = ? where subChannelId = ?");){
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, (long)hash);
                _argIndex = 2;
                if (subChannelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, subChannelId);
                }
                _stmt.step();
                Object var5_5 = null;
                return var5_5;
            }
        });
    }

    @Override
    public void updateUserMarkerHash(String subChannelId, int hash) {
        String _sql = "UPDATE sub_channel set userSubChannelMarkerHash = ? where subChannelId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE sub_channel set userSubChannelMarkerHash = ? where subChannelId = ?");){
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, (long)hash);
                _argIndex = 2;
                if (subChannelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, subChannelId);
                }
                _stmt.step();
                Object var5_5 = null;
                return var5_5;
            }
        });
    }

    @Override
    public void updateLastActivity(String subChannelId, DateTime lastActivity) {
        String _sql = "UPDATE sub_channel set lastActivity = ? where subChannelId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE sub_channel set lastActivity = ? where subChannelId = ?");){
                int _argIndex = 1;
                String _tmp = this.__dateTimeTypeConverter.dateTimeToString(lastActivity);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, _tmp);
                }
                _argIndex = 2;
                if (subChannelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, subChannelId);
                }
                _stmt.step();
                Object var7_7 = null;
                return var7_7;
            }
        });
    }

    @Override
    public void updateLatestMessage(String subChannelId, String messageId) {
        String _sql = "UPDATE sub_channel set latestMessageId = ? where subChannelId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE sub_channel set latestMessageId = ? where subChannelId = ?");){
                int _argIndex = 1;
                if (messageId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, messageId);
                }
                _argIndex = 2;
                if (subChannelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, subChannelId);
                }
                _stmt.step();
                Object var5_5 = null;
                return var5_5;
            }
        });
    }

    @Override
    public void updateMessagePreview(String subChannelId, String messagePreviewId) {
        String _sql = "UPDATE sub_channel set messagePreviewId = ? where subChannelId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE sub_channel set messagePreviewId = ? where subChannelId = ?");){
                int _argIndex = 1;
                if (messagePreviewId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, messagePreviewId);
                }
                _argIndex = 2;
                if (subChannelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, subChannelId);
                }
                _stmt.step();
                Object var5_5 = null;
                return var5_5;
            }
        });
    }

    @Override
    public void notifyChanges(String subChannelId) {
        String _sql = "UPDATE sub_channel set subChannelId = ? where subChannelId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE sub_channel set subChannelId = ? where subChannelId = ?");){
                int _argIndex = 1;
                if (subChannelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, subChannelId);
                }
                _argIndex = 2;
                if (subChannelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, subChannelId);
                }
                _stmt.step();
                Object var4_4 = null;
                return var4_4;
            }
        });
    }

    @Override
    public void notifySubChannelsChanges(List<String> subChannelIds, int hash) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("UPDATE sub_channel set subChannelMarkerHash = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" where subChannelId in (");
        int _inputSize = subChannelIds.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare(_sql);){
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, (long)hash);
                _argIndex = 2;
                for (String _item : subChannelIds) {
                    if (_item == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindText(_argIndex, _item);
                    }
                    ++_argIndex;
                }
                _stmt.step();
                Iterator iterator = null;
                return iterator;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

