/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.sqlite.SQLiteStatement;
import com.ekoapp.ekosdk.internal.data.converter.EkoPushConfigStateConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoPushConfigDao;
import com.ekoapp.ekosdk.internal.data.model.EkoPushConfig;
import io.reactivex.rxjava3.core.Flowable;
import java.util.Collections;
import java.util.List;

public final class EkoPushConfigDao_Impl
extends EkoPushConfigDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<EkoPushConfig> __insertAdapterOfEkoPushConfig;
    private final EkoPushConfigStateConverter __ekoPushConfigStateConverter = new EkoPushConfigStateConverter();

    public EkoPushConfigDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfEkoPushConfig = new EntityInsertAdapter<EkoPushConfig>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `push_config` (`userId`,`deviceId`,`state`) VALUES (?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull EkoPushConfig entity) {
                if (entity.getUserId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getUserId());
                }
                if (entity.getDeviceId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getDeviceId());
                }
                String _tmp = EkoPushConfigDao_Impl.this.__ekoPushConfigStateConverter.ekoPushConfigStateToString(entity.getState());
                if (_tmp == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, _tmp);
                }
            }
        };
    }

    @Override
    public void insert(EkoPushConfig pushConfig) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfEkoPushConfig.insert(_connection, (Object)pushConfig);
            return null;
        });
    }

    @Override
    Flowable<Integer> countRegisteredConfig() {
        String _sql = "SELECT count(*) from push_config where state = 'registered'";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"push_config"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT count(*) from push_config where state = 'registered'");){
                Integer _result;
                if (_stmt.step()) {
                    Integer _tmp = _stmt.isNull(0) ? null : Integer.valueOf((int)_stmt.getLong(0));
                    _result = _tmp;
                } else {
                    _result = null;
                }
                Integer n = _result;
                return n;
            }
        });
    }

    @Override
    public Flowable<EkoPushConfig> getPushConfig(String userId) {
        String _sql = "SELECT * from push_config where userId = ? LIMIT 1";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"push_config"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from push_config where userId = ? LIMIT 1");){
                EkoPushConfig _result;
                int _argIndex = 1;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfDeviceId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"deviceId");
                int _columnIndexOfState = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"state");
                if (_stmt.step()) {
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    String _tmpDeviceId = _stmt.isNull(_columnIndexOfDeviceId) ? null : _stmt.getText(_columnIndexOfDeviceId);
                    String _tmp = _stmt.isNull(_columnIndexOfState) ? null : _stmt.getText(_columnIndexOfState);
                    EkoPushConfig.State _tmpState = this.__ekoPushConfigStateConverter.stringToEkoPushConfigState(_tmp);
                    _result = new EkoPushConfig(_tmpUserId, _tmpDeviceId, _tmpState);
                } else {
                    _result = null;
                }
                EkoPushConfig ekoPushConfig = _result;
                return ekoPushConfig;
            }
        });
    }

    @Override
    public void unregisterAll() {
        String _sql = "UPDATE push_config set state = 'unregistered'";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE push_config set state = 'unregistered'");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @Override
    public void clearUnregisteredPushConfigForUser(String userId) {
        String _sql = "DELETE FROM push_config WHERE userId = ? and state = 'unregistered'";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE FROM push_config WHERE userId = ? and state = 'unregistered'");){
                int _argIndex = 1;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                _stmt.step();
                Object var4_4 = null;
                return var4_4;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

