/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.SQLiteStatement;
import com.amity.socialcloud.sdk.model.core.reaction.AmityReactionMap;
import com.amity.socialcloud.sdk.model.core.tag.AmityTags;
import com.ekoapp.ekosdk.internal.EkoMessageEntity;
import com.ekoapp.ekosdk.internal.api.dto.EkoMentioneesDto;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.EkoReactionMapConverter;
import com.ekoapp.ekosdk.internal.data.converter.EkoTagsTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.JsonArrayTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.JsonObjectTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.MentioneesConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoMessageDao;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class EkoMessageDao_Impl
extends EkoMessageDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<EkoMessageEntity> __insertAdapterOfEkoMessageEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EkoTagsTypeConverter __ekoTagsTypeConverter = new EkoTagsTypeConverter();
    private final EkoReactionMapConverter __ekoReactionMapConverter = new EkoReactionMapConverter();
    private final JsonObjectTypeConverter __jsonObjectTypeConverter = new JsonObjectTypeConverter();
    private final MentioneesConverter __mentioneesConverter = new MentioneesConverter();
    private final JsonArrayTypeConverter __jsonArrayTypeConverter = new JsonArrayTypeConverter();
    private final EntityDeleteOrUpdateAdapter<EkoMessageEntity> __deleteAdapterOfEkoMessageEntity;
    private final EntityDeleteOrUpdateAdapter<EkoMessageEntity> __updateAdapterOfEkoMessageEntity;

    public EkoMessageDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfEkoMessageEntity = new EntityInsertAdapter<EkoMessageEntity>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `message` (`uniqueId`,`messageId`,`subChannelId`,`channelId`,`userId`,`parentId`,`channelSegment`,`childrenNumber`,`editedAt`,`isDeleted`,`flagCount`,`tags`,`reactions`,`reactionCount`,`type`,`data`,`metadata`,`mentionees`,`pii`,`path`,`syncState`,`messageMarkerHash`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull EkoMessageEntity entity) {
                if (entity.getUniqueId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getUniqueId());
                }
                if (entity.getMessageId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getMessageId());
                }
                if (entity.getSubChannelId() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getSubChannelId());
                }
                if (entity.getChannelId() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getChannelId());
                }
                if (entity.getUserId() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, entity.getUserId());
                }
                if (entity.getParentId() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, entity.getParentId());
                }
                statement.bindLong(7, (long)entity.getChannelSegment());
                statement.bindLong(8, (long)entity.getChildrenNumber());
                String _tmp = EkoMessageDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getEditedAt());
                if (_tmp == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, _tmp);
                }
                int _tmp_1 = entity.isDeleted() ? 1 : 0;
                statement.bindLong(10, (long)_tmp_1);
                statement.bindLong(11, (long)entity.getFlagCount());
                String _tmp_2 = EkoMessageDao_Impl.this.__ekoTagsTypeConverter.ekoTagsToString(entity.getTags());
                if (_tmp_2 == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindText(12, _tmp_2);
                }
                String _tmp_3 = EkoMessageDao_Impl.this.__ekoReactionMapConverter.stringIntMapToString(entity.getReactions());
                if (_tmp_3 == null) {
                    statement.bindNull(13);
                } else {
                    statement.bindText(13, _tmp_3);
                }
                statement.bindLong(14, (long)entity.getReactionCount());
                if (entity.getType() == null) {
                    statement.bindNull(15);
                } else {
                    statement.bindText(15, entity.getType());
                }
                String _tmp_4 = EkoMessageDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(entity.getData());
                if (_tmp_4 == null) {
                    statement.bindNull(16);
                } else {
                    statement.bindText(16, _tmp_4);
                }
                String _tmp_5 = EkoMessageDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(entity.getMetadata());
                if (_tmp_5 == null) {
                    statement.bindNull(17);
                } else {
                    statement.bindText(17, _tmp_5);
                }
                String _tmp_6 = EkoMessageDao_Impl.this.__mentioneesConverter.mentioneesToJson(entity.getMentionees());
                if (_tmp_6 == null) {
                    statement.bindNull(18);
                } else {
                    statement.bindText(18, _tmp_6);
                }
                String _tmp_7 = EkoMessageDao_Impl.this.__jsonArrayTypeConverter.jsonObjectToString(entity.getPii());
                if (_tmp_7 == null) {
                    statement.bindNull(19);
                } else {
                    statement.bindText(19, _tmp_7);
                }
                if (entity.getPath() == null) {
                    statement.bindNull(20);
                } else {
                    statement.bindText(20, entity.getPath());
                }
                if (entity.getSyncState() == null) {
                    statement.bindNull(21);
                } else {
                    statement.bindText(21, entity.getSyncState());
                }
                statement.bindLong(22, (long)entity.getMessageMarkerHash());
                String _tmp_8 = EkoMessageDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_8 == null) {
                    statement.bindNull(23);
                } else {
                    statement.bindText(23, _tmp_8);
                }
                String _tmp_9 = EkoMessageDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_9 == null) {
                    statement.bindNull(24);
                } else {
                    statement.bindText(24, _tmp_9);
                }
                String _tmp_10 = EkoMessageDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_10 == null) {
                    statement.bindNull(25);
                } else {
                    statement.bindText(25, _tmp_10);
                }
            }
        };
        this.__deleteAdapterOfEkoMessageEntity = new EntityDeleteOrUpdateAdapter<EkoMessageEntity>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `message` WHERE `uniqueId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull EkoMessageEntity entity) {
                if (entity.getUniqueId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getUniqueId());
                }
            }
        };
        this.__updateAdapterOfEkoMessageEntity = new EntityDeleteOrUpdateAdapter<EkoMessageEntity>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `message` SET `uniqueId` = ?,`messageId` = ?,`subChannelId` = ?,`channelId` = ?,`userId` = ?,`parentId` = ?,`channelSegment` = ?,`childrenNumber` = ?,`editedAt` = ?,`isDeleted` = ?,`flagCount` = ?,`tags` = ?,`reactions` = ?,`reactionCount` = ?,`type` = ?,`data` = ?,`metadata` = ?,`mentionees` = ?,`pii` = ?,`path` = ?,`syncState` = ?,`messageMarkerHash` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `uniqueId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull EkoMessageEntity entity) {
                if (entity.getUniqueId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getUniqueId());
                }
                if (entity.getMessageId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getMessageId());
                }
                if (entity.getSubChannelId() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getSubChannelId());
                }
                if (entity.getChannelId() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getChannelId());
                }
                if (entity.getUserId() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, entity.getUserId());
                }
                if (entity.getParentId() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, entity.getParentId());
                }
                statement.bindLong(7, (long)entity.getChannelSegment());
                statement.bindLong(8, (long)entity.getChildrenNumber());
                String _tmp = EkoMessageDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getEditedAt());
                if (_tmp == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, _tmp);
                }
                int _tmp_1 = entity.isDeleted() ? 1 : 0;
                statement.bindLong(10, (long)_tmp_1);
                statement.bindLong(11, (long)entity.getFlagCount());
                String _tmp_2 = EkoMessageDao_Impl.this.__ekoTagsTypeConverter.ekoTagsToString(entity.getTags());
                if (_tmp_2 == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindText(12, _tmp_2);
                }
                String _tmp_3 = EkoMessageDao_Impl.this.__ekoReactionMapConverter.stringIntMapToString(entity.getReactions());
                if (_tmp_3 == null) {
                    statement.bindNull(13);
                } else {
                    statement.bindText(13, _tmp_3);
                }
                statement.bindLong(14, (long)entity.getReactionCount());
                if (entity.getType() == null) {
                    statement.bindNull(15);
                } else {
                    statement.bindText(15, entity.getType());
                }
                String _tmp_4 = EkoMessageDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(entity.getData());
                if (_tmp_4 == null) {
                    statement.bindNull(16);
                } else {
                    statement.bindText(16, _tmp_4);
                }
                String _tmp_5 = EkoMessageDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(entity.getMetadata());
                if (_tmp_5 == null) {
                    statement.bindNull(17);
                } else {
                    statement.bindText(17, _tmp_5);
                }
                String _tmp_6 = EkoMessageDao_Impl.this.__mentioneesConverter.mentioneesToJson(entity.getMentionees());
                if (_tmp_6 == null) {
                    statement.bindNull(18);
                } else {
                    statement.bindText(18, _tmp_6);
                }
                String _tmp_7 = EkoMessageDao_Impl.this.__jsonArrayTypeConverter.jsonObjectToString(entity.getPii());
                if (_tmp_7 == null) {
                    statement.bindNull(19);
                } else {
                    statement.bindText(19, _tmp_7);
                }
                if (entity.getPath() == null) {
                    statement.bindNull(20);
                } else {
                    statement.bindText(20, entity.getPath());
                }
                if (entity.getSyncState() == null) {
                    statement.bindNull(21);
                } else {
                    statement.bindText(21, entity.getSyncState());
                }
                statement.bindLong(22, (long)entity.getMessageMarkerHash());
                String _tmp_8 = EkoMessageDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_8 == null) {
                    statement.bindNull(23);
                } else {
                    statement.bindText(23, _tmp_8);
                }
                String _tmp_9 = EkoMessageDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_9 == null) {
                    statement.bindNull(24);
                } else {
                    statement.bindText(24, _tmp_9);
                }
                String _tmp_10 = EkoMessageDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_10 == null) {
                    statement.bindNull(25);
                } else {
                    statement.bindText(25, _tmp_10);
                }
                if (entity.getUniqueId() == null) {
                    statement.bindNull(26);
                } else {
                    statement.bindText(26, entity.getUniqueId());
                }
            }
        };
    }

    @Override
    public void insertImpl(EkoMessageEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfEkoMessageEntity.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends EkoMessageEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfEkoMessageEntity.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(EkoMessageEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfEkoMessageEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void delete(List<? extends EkoMessageEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfEkoMessageEntity.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void updateImpl(EkoMessageEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfEkoMessageEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(EkoMessageEntity message) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoMessageDao_Impl.super.insert(message);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends EkoMessageEntity> messages) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoMessageDao_Impl.super.insert(messages);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(EkoMessageEntity message) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoMessageDao_Impl.super.update(message);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void retainLatestFromChannel(String channelId, int offset) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoMessageDao_Impl.super.retainLatestFromChannel(channelId, offset);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void softDeleteFromChannelByUserId(String channelId, String userId) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoMessageDao_Impl.super.softDeleteFromChannelByUserId(channelId, userId);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void updateUser(String userId) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoMessageDao_Impl.super.updateUser(userId);
            return Unit.INSTANCE;
        });
    }

    @Override
    public Flowable<EkoMessageEntity> getLatestMessageImpl(String subChannelId, Boolean isDeleted) {
        String _sql = "SELECT message.* from message where message.subChannelId = ? and message.isDeleted = case when ? is not null then ? else isDeleted end order by channelSegment DESC LIMIT 1";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"message"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT message.* from message where message.subChannelId = ? and message.isDeleted = case when ? is not null then ? else isDeleted end order by channelSegment DESC LIMIT 1");){
                EkoMessageEntity _result;
                Integer _tmp_1;
                Integer _tmp;
                int _argIndex = 1;
                if (subChannelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, subChannelId);
                }
                _argIndex = 2;
                Integer n = isDeleted == null ? null : (_tmp = Integer.valueOf(isDeleted != false ? 1 : 0));
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp.intValue());
                }
                _argIndex = 3;
                Integer n2 = isDeleted == null ? null : (_tmp_1 = Integer.valueOf(isDeleted != false ? 1 : 0));
                if (_tmp_1 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp_1.intValue());
                }
                int _columnIndexOfUniqueId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"uniqueId");
                int _columnIndexOfMessageId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messageId");
                int _columnIndexOfSubChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"subChannelId");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfParentId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"parentId");
                int _columnIndexOfChannelSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelSegment");
                int _columnIndexOfChildrenNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"childrenNumber");
                int _columnIndexOfEditedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"editedAt");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfFlagCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flagCount");
                int _columnIndexOfTags = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"tags");
                int _columnIndexOfReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactions");
                int _columnIndexOfReactionCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionCount");
                int _columnIndexOfType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"type");
                int _columnIndexOfData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"data");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfMentionees = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mentionees");
                int _columnIndexOfPii = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pii");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfSyncState = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"syncState");
                int _columnIndexOfMessageMarkerHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messageMarkerHash");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new EkoMessageEntity();
                    String _tmpUniqueId = _stmt.isNull(_columnIndexOfUniqueId) ? null : _stmt.getText(_columnIndexOfUniqueId);
                    _result.setUniqueId(_tmpUniqueId);
                    String _tmpMessageId = _stmt.isNull(_columnIndexOfMessageId) ? null : _stmt.getText(_columnIndexOfMessageId);
                    _result.setMessageId(_tmpMessageId);
                    String _tmpSubChannelId = _stmt.isNull(_columnIndexOfSubChannelId) ? null : _stmt.getText(_columnIndexOfSubChannelId);
                    _result.setSubChannelId(_tmpSubChannelId);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _result.setChannelId(_tmpChannelId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _result.setUserId(_tmpUserId);
                    String _tmpParentId = _stmt.isNull(_columnIndexOfParentId) ? null : _stmt.getText(_columnIndexOfParentId);
                    _result.setParentId(_tmpParentId);
                    int _tmpChannelSegment = (int)_stmt.getLong(_columnIndexOfChannelSegment);
                    _result.setChannelSegment(_tmpChannelSegment);
                    int _tmpChildrenNumber = (int)_stmt.getLong(_columnIndexOfChildrenNumber);
                    _result.setChildrenNumber(_tmpChildrenNumber);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfEditedAt) ? null : _stmt.getText(_columnIndexOfEditedAt);
                    DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setEditedAt(_tmpEditedAt);
                    int _tmp_3 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_3 != 0;
                    _result.setDeleted(_tmpIsDeleted);
                    int _tmpFlagCount = (int)_stmt.getLong(_columnIndexOfFlagCount);
                    _result.setFlagCount(_tmpFlagCount);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfTags) ? null : _stmt.getText(_columnIndexOfTags);
                    AmityTags _tmpTags = this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_4);
                    _result.setTags(_tmpTags);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfReactions) ? null : _stmt.getText(_columnIndexOfReactions);
                    AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_5);
                    _result.setReactions(_tmpReactions);
                    int _tmpReactionCount = (int)_stmt.getLong(_columnIndexOfReactionCount);
                    _result.setReactionCount(_tmpReactionCount);
                    String _tmpType = _stmt.isNull(_columnIndexOfType) ? null : _stmt.getText(_columnIndexOfType);
                    _result.setType(_tmpType);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfData) ? null : _stmt.getText(_columnIndexOfData);
                    JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_6);
                    _result.setData(_tmpData);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_7);
                    _result.setMetadata(_tmpMetadata);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfMentionees) ? null : _stmt.getText(_columnIndexOfMentionees);
                    List<EkoMentioneesDto> _tmpMentionees = this.__mentioneesConverter.jsonToMentionees(_tmp_8);
                    _result.setMentionees(_tmpMentionees);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfPii) ? null : _stmt.getText(_columnIndexOfPii);
                    JsonArray _tmpPii = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_9);
                    _result.setPii(_tmpPii);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _result.setPath(_tmpPath);
                    String _tmpSyncState = _stmt.isNull(_columnIndexOfSyncState) ? null : _stmt.getText(_columnIndexOfSyncState);
                    _result.setSyncState(_tmpSyncState);
                    int _tmpMessageMarkerHash = (int)_stmt.getLong(_columnIndexOfMessageMarkerHash);
                    _result.setMessageMarkerHash(_tmpMessageMarkerHash);
                    String _tmp_10 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_11 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_12 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_12);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                EkoMessageEntity ekoMessageEntity = _result;
                return ekoMessageEntity;
            }
        });
    }

    @Override
    public Flowable<EkoMessageEntity> getLatestMessageImpl(String subChannelId, Boolean isFilterByParentId, String parentId, boolean isIncludingTags, String[] includingTags, boolean isExcludingTags, String[] excludingTags, Boolean isDeleted, int hash, int nonce, DateTime now) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("SELECT * from message where message.subChannelId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and ");
        _stringBuilder.append("?");
        _stringBuilder.append(" is not null then message.parentId = ");
        _stringBuilder.append("?");
        _stringBuilder.append("  when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and ");
        _stringBuilder.append("?");
        _stringBuilder.append(" is null then message.parentId is null  else message.messageId is not null end and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" then message.messageId in (SELECT messageId from message_tag where tagName in (");
        int _inputSize = includingTags.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")) else message.messageId is not null end and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" then message.messageId not in (SELECT messageId from message_tag where tagName in (");
        int _inputSize_1 = excludingTags.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize_1);
        _stringBuilder.append(")) else message.messageId is not null end and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" is not null then message.isDeleted = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" else message.messageId is not null end and message.updatedAt > ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and message.uniqueId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (");
        _stringBuilder.append("?");
        _stringBuilder.append(") and amity_paging_id.nonce = (");
        _stringBuilder.append("?");
        _stringBuilder.append(") ) order by message.updatedAt desc limit 1");
        String _sql = _stringBuilder.toString();
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"message", "message_tag", "amity_paging_id"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare(_sql);){
                EkoMessageEntity _result;
                Integer _tmp_5;
                Integer _tmp_4;
                Integer _tmp_1;
                Integer _tmp;
                int _argIndex = 1;
                if (subChannelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, subChannelId);
                }
                _argIndex = 2;
                Integer n = isFilterByParentId == null ? null : (_tmp = Integer.valueOf(isFilterByParentId != false ? 1 : 0));
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp.intValue());
                }
                _argIndex = 3;
                if (parentId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, parentId);
                }
                _argIndex = 4;
                if (parentId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, parentId);
                }
                _argIndex = 5;
                Integer n2 = isFilterByParentId == null ? null : (_tmp_1 = Integer.valueOf(isFilterByParentId != false ? 1 : 0));
                if (_tmp_1 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp_1.intValue());
                }
                _argIndex = 6;
                if (parentId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, parentId);
                }
                _argIndex = 7;
                int _tmp_2 = isIncludingTags ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp_2);
                _argIndex = 8;
                for (String _item : includingTags) {
                    if (_item == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindText(_argIndex, _item);
                    }
                    ++_argIndex;
                }
                _argIndex = 8 + _inputSize;
                int _tmp_3 = isExcludingTags ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp_3);
                _argIndex = 9 + _inputSize;
                for (String _item_1 : excludingTags) {
                    if (_item_1 == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindText(_argIndex, _item_1);
                    }
                    ++_argIndex;
                }
                _argIndex = 9 + _inputSize + _inputSize_1;
                Integer n3 = isDeleted == null ? null : (_tmp_4 = Integer.valueOf(isDeleted != false ? 1 : 0));
                if (_tmp_4 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp_4.intValue());
                }
                _argIndex = 10 + _inputSize + _inputSize_1;
                Integer n4 = isDeleted == null ? null : (_tmp_5 = Integer.valueOf(isDeleted != false ? 1 : 0));
                if (_tmp_5 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp_5.intValue());
                }
                _argIndex = 11 + _inputSize + _inputSize_1;
                String _tmp_6 = this.__dateTimeTypeConverter.dateTimeToString(now);
                if (_tmp_6 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, _tmp_6);
                }
                _argIndex = 12 + _inputSize + _inputSize_1;
                _stmt.bindLong(_argIndex, (long)hash);
                _argIndex = 13 + _inputSize + _inputSize_1;
                _stmt.bindLong(_argIndex, (long)nonce);
                int _columnIndexOfUniqueId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"uniqueId");
                int _columnIndexOfMessageId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messageId");
                int _columnIndexOfSubChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"subChannelId");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfParentId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"parentId");
                int _columnIndexOfChannelSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelSegment");
                int _columnIndexOfChildrenNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"childrenNumber");
                int _columnIndexOfEditedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"editedAt");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfFlagCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flagCount");
                int _columnIndexOfTags = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"tags");
                int _columnIndexOfReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactions");
                int _columnIndexOfReactionCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionCount");
                int _columnIndexOfType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"type");
                int _columnIndexOfData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"data");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfMentionees = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mentionees");
                int _columnIndexOfPii = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pii");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfSyncState = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"syncState");
                int _columnIndexOfMessageMarkerHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messageMarkerHash");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new EkoMessageEntity();
                    String _tmpUniqueId = _stmt.isNull(_columnIndexOfUniqueId) ? null : _stmt.getText(_columnIndexOfUniqueId);
                    _result.setUniqueId(_tmpUniqueId);
                    String _tmpMessageId = _stmt.isNull(_columnIndexOfMessageId) ? null : _stmt.getText(_columnIndexOfMessageId);
                    _result.setMessageId(_tmpMessageId);
                    String _tmpSubChannelId = _stmt.isNull(_columnIndexOfSubChannelId) ? null : _stmt.getText(_columnIndexOfSubChannelId);
                    _result.setSubChannelId(_tmpSubChannelId);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _result.setChannelId(_tmpChannelId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _result.setUserId(_tmpUserId);
                    String _tmpParentId = _stmt.isNull(_columnIndexOfParentId) ? null : _stmt.getText(_columnIndexOfParentId);
                    _result.setParentId(_tmpParentId);
                    int _tmpChannelSegment = (int)_stmt.getLong(_columnIndexOfChannelSegment);
                    _result.setChannelSegment(_tmpChannelSegment);
                    int _tmpChildrenNumber = (int)_stmt.getLong(_columnIndexOfChildrenNumber);
                    _result.setChildrenNumber(_tmpChildrenNumber);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfEditedAt) ? null : _stmt.getText(_columnIndexOfEditedAt);
                    DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                    _result.setEditedAt(_tmpEditedAt);
                    int _tmp_8 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_8 != 0;
                    _result.setDeleted(_tmpIsDeleted);
                    int _tmpFlagCount = (int)_stmt.getLong(_columnIndexOfFlagCount);
                    _result.setFlagCount(_tmpFlagCount);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfTags) ? null : _stmt.getText(_columnIndexOfTags);
                    AmityTags _tmpTags = this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_9);
                    _result.setTags(_tmpTags);
                    String _tmp_10 = _stmt.isNull(_columnIndexOfReactions) ? null : _stmt.getText(_columnIndexOfReactions);
                    AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_10);
                    _result.setReactions(_tmpReactions);
                    int _tmpReactionCount = (int)_stmt.getLong(_columnIndexOfReactionCount);
                    _result.setReactionCount(_tmpReactionCount);
                    String _tmpType = _stmt.isNull(_columnIndexOfType) ? null : _stmt.getText(_columnIndexOfType);
                    _result.setType(_tmpType);
                    String _tmp_11 = _stmt.isNull(_columnIndexOfData) ? null : _stmt.getText(_columnIndexOfData);
                    JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_11);
                    _result.setData(_tmpData);
                    String _tmp_12 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_12);
                    _result.setMetadata(_tmpMetadata);
                    String _tmp_13 = _stmt.isNull(_columnIndexOfMentionees) ? null : _stmt.getText(_columnIndexOfMentionees);
                    List<EkoMentioneesDto> _tmpMentionees = this.__mentioneesConverter.jsonToMentionees(_tmp_13);
                    _result.setMentionees(_tmpMentionees);
                    String _tmp_14 = _stmt.isNull(_columnIndexOfPii) ? null : _stmt.getText(_columnIndexOfPii);
                    JsonArray _tmpPii = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_14);
                    _result.setPii(_tmpPii);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _result.setPath(_tmpPath);
                    String _tmpSyncState = _stmt.isNull(_columnIndexOfSyncState) ? null : _stmt.getText(_columnIndexOfSyncState);
                    _result.setSyncState(_tmpSyncState);
                    int _tmpMessageMarkerHash = (int)_stmt.getLong(_columnIndexOfMessageMarkerHash);
                    _result.setMessageMarkerHash(_tmpMessageMarkerHash);
                    String _tmp_15 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_15);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_16 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_16);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_17 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_17);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                EkoMessageEntity ekoMessageEntity = _result;
                return ekoMessageEntity;
            }
        });
    }

    @Override
    public int getHighestSegment(String subChannelId) {
        String _sql = "SELECT channelSegment from message where subChannelId = ? and syncState = 'synced' order by channelSegment DESC LIMIT 1";
        return (Integer)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT channelSegment from message where subChannelId = ? and syncState = 'synced' order by channelSegment DESC LIMIT 1");){
                int _argIndex = 1;
                if (subChannelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, subChannelId);
                }
                int _result = _stmt.step() ? (int)_stmt.getLong(0) : 0;
                Integer n = _result;
                return n;
            }
        });
    }

    @Override
    public List<EkoMessageEntity> getOldMessages(String channelId, int offset) {
        String _sql = "SELECT * from message where channelId = ? order by createdAt DESC LIMIT -1 OFFSET ?";
        return (List)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from message where channelId = ? order by createdAt DESC LIMIT -1 OFFSET ?");){
                int _argIndex = 1;
                if (channelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, channelId);
                }
                _argIndex = 2;
                _stmt.bindLong(_argIndex, (long)offset);
                int _columnIndexOfUniqueId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"uniqueId");
                int _columnIndexOfMessageId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messageId");
                int _columnIndexOfSubChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"subChannelId");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfParentId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"parentId");
                int _columnIndexOfChannelSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelSegment");
                int _columnIndexOfChildrenNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"childrenNumber");
                int _columnIndexOfEditedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"editedAt");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfFlagCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flagCount");
                int _columnIndexOfTags = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"tags");
                int _columnIndexOfReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactions");
                int _columnIndexOfReactionCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionCount");
                int _columnIndexOfType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"type");
                int _columnIndexOfData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"data");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfMentionees = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mentionees");
                int _columnIndexOfPii = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pii");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfSyncState = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"syncState");
                int _columnIndexOfMessageMarkerHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messageMarkerHash");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<EkoMessageEntity> _result = new ArrayList<EkoMessageEntity>();
                while (_stmt.step()) {
                    EkoMessageEntity _item = new EkoMessageEntity();
                    String _tmpUniqueId = _stmt.isNull(_columnIndexOfUniqueId) ? null : _stmt.getText(_columnIndexOfUniqueId);
                    _item.setUniqueId(_tmpUniqueId);
                    String _tmpMessageId = _stmt.isNull(_columnIndexOfMessageId) ? null : _stmt.getText(_columnIndexOfMessageId);
                    _item.setMessageId(_tmpMessageId);
                    String _tmpSubChannelId = _stmt.isNull(_columnIndexOfSubChannelId) ? null : _stmt.getText(_columnIndexOfSubChannelId);
                    _item.setSubChannelId(_tmpSubChannelId);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _item.setChannelId(_tmpChannelId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _item.setUserId(_tmpUserId);
                    String _tmpParentId = _stmt.isNull(_columnIndexOfParentId) ? null : _stmt.getText(_columnIndexOfParentId);
                    _item.setParentId(_tmpParentId);
                    int _tmpChannelSegment = (int)_stmt.getLong(_columnIndexOfChannelSegment);
                    _item.setChannelSegment(_tmpChannelSegment);
                    int _tmpChildrenNumber = (int)_stmt.getLong(_columnIndexOfChildrenNumber);
                    _item.setChildrenNumber(_tmpChildrenNumber);
                    String _tmp = _stmt.isNull(_columnIndexOfEditedAt) ? null : _stmt.getText(_columnIndexOfEditedAt);
                    DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _item.setEditedAt(_tmpEditedAt);
                    int _tmp_1 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_1 != 0;
                    _item.setDeleted(_tmpIsDeleted);
                    int _tmpFlagCount = (int)_stmt.getLong(_columnIndexOfFlagCount);
                    _item.setFlagCount(_tmpFlagCount);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfTags) ? null : _stmt.getText(_columnIndexOfTags);
                    AmityTags _tmpTags = this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_2);
                    _item.setTags(_tmpTags);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfReactions) ? null : _stmt.getText(_columnIndexOfReactions);
                    AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_3);
                    _item.setReactions(_tmpReactions);
                    int _tmpReactionCount = (int)_stmt.getLong(_columnIndexOfReactionCount);
                    _item.setReactionCount(_tmpReactionCount);
                    String _tmpType = _stmt.isNull(_columnIndexOfType) ? null : _stmt.getText(_columnIndexOfType);
                    _item.setType(_tmpType);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfData) ? null : _stmt.getText(_columnIndexOfData);
                    JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                    _item.setData(_tmpData);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_5);
                    _item.setMetadata(_tmpMetadata);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfMentionees) ? null : _stmt.getText(_columnIndexOfMentionees);
                    List<EkoMentioneesDto> _tmpMentionees = this.__mentioneesConverter.jsonToMentionees(_tmp_6);
                    _item.setMentionees(_tmpMentionees);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfPii) ? null : _stmt.getText(_columnIndexOfPii);
                    JsonArray _tmpPii = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_7);
                    _item.setPii(_tmpPii);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _item.setPath(_tmpPath);
                    String _tmpSyncState = _stmt.isNull(_columnIndexOfSyncState) ? null : _stmt.getText(_columnIndexOfSyncState);
                    _item.setSyncState(_tmpSyncState);
                    int _tmpMessageMarkerHash = (int)_stmt.getLong(_columnIndexOfMessageMarkerHash);
                    _item.setMessageMarkerHash(_tmpMessageMarkerHash);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                    _item.setCreatedAt(_tmpCreatedAt);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                    _item.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_10 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                    _item.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item);
                }
                ArrayList<EkoMessageEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public Flowable<EkoMessageEntity> getByIdImpl(String messageId) {
        String _sql = "SELECT message.* from message where message.messageId = ? LIMIT 1";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"message"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT message.* from message where message.messageId = ? LIMIT 1");){
                EkoMessageEntity _result;
                int _argIndex = 1;
                if (messageId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, messageId);
                }
                int _columnIndexOfUniqueId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"uniqueId");
                int _columnIndexOfMessageId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messageId");
                int _columnIndexOfSubChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"subChannelId");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfParentId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"parentId");
                int _columnIndexOfChannelSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelSegment");
                int _columnIndexOfChildrenNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"childrenNumber");
                int _columnIndexOfEditedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"editedAt");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfFlagCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flagCount");
                int _columnIndexOfTags = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"tags");
                int _columnIndexOfReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactions");
                int _columnIndexOfReactionCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionCount");
                int _columnIndexOfType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"type");
                int _columnIndexOfData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"data");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfMentionees = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mentionees");
                int _columnIndexOfPii = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pii");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfSyncState = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"syncState");
                int _columnIndexOfMessageMarkerHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messageMarkerHash");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new EkoMessageEntity();
                    String _tmpUniqueId = _stmt.isNull(_columnIndexOfUniqueId) ? null : _stmt.getText(_columnIndexOfUniqueId);
                    _result.setUniqueId(_tmpUniqueId);
                    String _tmpMessageId = _stmt.isNull(_columnIndexOfMessageId) ? null : _stmt.getText(_columnIndexOfMessageId);
                    _result.setMessageId(_tmpMessageId);
                    String _tmpSubChannelId = _stmt.isNull(_columnIndexOfSubChannelId) ? null : _stmt.getText(_columnIndexOfSubChannelId);
                    _result.setSubChannelId(_tmpSubChannelId);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _result.setChannelId(_tmpChannelId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _result.setUserId(_tmpUserId);
                    String _tmpParentId = _stmt.isNull(_columnIndexOfParentId) ? null : _stmt.getText(_columnIndexOfParentId);
                    _result.setParentId(_tmpParentId);
                    int _tmpChannelSegment = (int)_stmt.getLong(_columnIndexOfChannelSegment);
                    _result.setChannelSegment(_tmpChannelSegment);
                    int _tmpChildrenNumber = (int)_stmt.getLong(_columnIndexOfChildrenNumber);
                    _result.setChildrenNumber(_tmpChildrenNumber);
                    String _tmp = _stmt.isNull(_columnIndexOfEditedAt) ? null : _stmt.getText(_columnIndexOfEditedAt);
                    DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _result.setEditedAt(_tmpEditedAt);
                    int _tmp_1 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_1 != 0;
                    _result.setDeleted(_tmpIsDeleted);
                    int _tmpFlagCount = (int)_stmt.getLong(_columnIndexOfFlagCount);
                    _result.setFlagCount(_tmpFlagCount);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfTags) ? null : _stmt.getText(_columnIndexOfTags);
                    AmityTags _tmpTags = this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_2);
                    _result.setTags(_tmpTags);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfReactions) ? null : _stmt.getText(_columnIndexOfReactions);
                    AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_3);
                    _result.setReactions(_tmpReactions);
                    int _tmpReactionCount = (int)_stmt.getLong(_columnIndexOfReactionCount);
                    _result.setReactionCount(_tmpReactionCount);
                    String _tmpType = _stmt.isNull(_columnIndexOfType) ? null : _stmt.getText(_columnIndexOfType);
                    _result.setType(_tmpType);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfData) ? null : _stmt.getText(_columnIndexOfData);
                    JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                    _result.setData(_tmpData);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_5);
                    _result.setMetadata(_tmpMetadata);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfMentionees) ? null : _stmt.getText(_columnIndexOfMentionees);
                    List<EkoMentioneesDto> _tmpMentionees = this.__mentioneesConverter.jsonToMentionees(_tmp_6);
                    _result.setMentionees(_tmpMentionees);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfPii) ? null : _stmt.getText(_columnIndexOfPii);
                    JsonArray _tmpPii = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_7);
                    _result.setPii(_tmpPii);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _result.setPath(_tmpPath);
                    String _tmpSyncState = _stmt.isNull(_columnIndexOfSyncState) ? null : _stmt.getText(_columnIndexOfSyncState);
                    _result.setSyncState(_tmpSyncState);
                    int _tmpMessageMarkerHash = (int)_stmt.getLong(_columnIndexOfMessageMarkerHash);
                    _result.setMessageMarkerHash(_tmpMessageMarkerHash);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_10 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                EkoMessageEntity ekoMessageEntity = _result;
                return ekoMessageEntity;
            }
        });
    }

    @Override
    public String getUniqueIdByMessageIdImpl(String messageId) {
        String _sql = "SELECT message.uniqueId from message where message.messageId = ? LIMIT 1";
        return (String)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT message.uniqueId from message where message.messageId = ? LIMIT 1");){
                int _argIndex = 1;
                if (messageId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, messageId);
                }
                String _result = _stmt.step() ? (_stmt.isNull(0) ? null : _stmt.getText(0)) : null;
                String string = _result;
                return string;
            }
        });
    }

    @Override
    public EkoMessageEntity getByIdNowImpl(String uniqueId) {
        String _sql = "SELECT message.* from message where message.uniqueId = ? LIMIT 1";
        return (EkoMessageEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT message.* from message where message.uniqueId = ? LIMIT 1");){
                EkoMessageEntity _result;
                int _argIndex = 1;
                if (uniqueId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, uniqueId);
                }
                int _columnIndexOfUniqueId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"uniqueId");
                int _columnIndexOfMessageId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messageId");
                int _columnIndexOfSubChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"subChannelId");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfParentId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"parentId");
                int _columnIndexOfChannelSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelSegment");
                int _columnIndexOfChildrenNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"childrenNumber");
                int _columnIndexOfEditedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"editedAt");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfFlagCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flagCount");
                int _columnIndexOfTags = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"tags");
                int _columnIndexOfReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactions");
                int _columnIndexOfReactionCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionCount");
                int _columnIndexOfType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"type");
                int _columnIndexOfData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"data");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfMentionees = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mentionees");
                int _columnIndexOfPii = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pii");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfSyncState = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"syncState");
                int _columnIndexOfMessageMarkerHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messageMarkerHash");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new EkoMessageEntity();
                    String _tmpUniqueId = _stmt.isNull(_columnIndexOfUniqueId) ? null : _stmt.getText(_columnIndexOfUniqueId);
                    _result.setUniqueId(_tmpUniqueId);
                    String _tmpMessageId = _stmt.isNull(_columnIndexOfMessageId) ? null : _stmt.getText(_columnIndexOfMessageId);
                    _result.setMessageId(_tmpMessageId);
                    String _tmpSubChannelId = _stmt.isNull(_columnIndexOfSubChannelId) ? null : _stmt.getText(_columnIndexOfSubChannelId);
                    _result.setSubChannelId(_tmpSubChannelId);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _result.setChannelId(_tmpChannelId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _result.setUserId(_tmpUserId);
                    String _tmpParentId = _stmt.isNull(_columnIndexOfParentId) ? null : _stmt.getText(_columnIndexOfParentId);
                    _result.setParentId(_tmpParentId);
                    int _tmpChannelSegment = (int)_stmt.getLong(_columnIndexOfChannelSegment);
                    _result.setChannelSegment(_tmpChannelSegment);
                    int _tmpChildrenNumber = (int)_stmt.getLong(_columnIndexOfChildrenNumber);
                    _result.setChildrenNumber(_tmpChildrenNumber);
                    String _tmp = _stmt.isNull(_columnIndexOfEditedAt) ? null : _stmt.getText(_columnIndexOfEditedAt);
                    DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _result.setEditedAt(_tmpEditedAt);
                    int _tmp_1 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_1 != 0;
                    _result.setDeleted(_tmpIsDeleted);
                    int _tmpFlagCount = (int)_stmt.getLong(_columnIndexOfFlagCount);
                    _result.setFlagCount(_tmpFlagCount);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfTags) ? null : _stmt.getText(_columnIndexOfTags);
                    AmityTags _tmpTags = this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_2);
                    _result.setTags(_tmpTags);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfReactions) ? null : _stmt.getText(_columnIndexOfReactions);
                    AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_3);
                    _result.setReactions(_tmpReactions);
                    int _tmpReactionCount = (int)_stmt.getLong(_columnIndexOfReactionCount);
                    _result.setReactionCount(_tmpReactionCount);
                    String _tmpType = _stmt.isNull(_columnIndexOfType) ? null : _stmt.getText(_columnIndexOfType);
                    _result.setType(_tmpType);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfData) ? null : _stmt.getText(_columnIndexOfData);
                    JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                    _result.setData(_tmpData);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_5);
                    _result.setMetadata(_tmpMetadata);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfMentionees) ? null : _stmt.getText(_columnIndexOfMentionees);
                    List<EkoMentioneesDto> _tmpMentionees = this.__mentioneesConverter.jsonToMentionees(_tmp_6);
                    _result.setMentionees(_tmpMentionees);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfPii) ? null : _stmt.getText(_columnIndexOfPii);
                    JsonArray _tmpPii = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_7);
                    _result.setPii(_tmpPii);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _result.setPath(_tmpPath);
                    String _tmpSyncState = _stmt.isNull(_columnIndexOfSyncState) ? null : _stmt.getText(_columnIndexOfSyncState);
                    _result.setSyncState(_tmpSyncState);
                    int _tmpMessageMarkerHash = (int)_stmt.getLong(_columnIndexOfMessageMarkerHash);
                    _result.setMessageMarkerHash(_tmpMessageMarkerHash);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_10 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                EkoMessageEntity ekoMessageEntity = _result;
                return ekoMessageEntity;
            }
        });
    }

    @Override
    public EkoMessageEntity getByMessageIdNowImpl(String messageId) {
        String _sql = "SELECT message.* from message where message.messageId = ? LIMIT 1";
        return (EkoMessageEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT message.* from message where message.messageId = ? LIMIT 1");){
                EkoMessageEntity _result;
                int _argIndex = 1;
                if (messageId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, messageId);
                }
                int _columnIndexOfUniqueId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"uniqueId");
                int _columnIndexOfMessageId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messageId");
                int _columnIndexOfSubChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"subChannelId");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfParentId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"parentId");
                int _columnIndexOfChannelSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelSegment");
                int _columnIndexOfChildrenNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"childrenNumber");
                int _columnIndexOfEditedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"editedAt");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfFlagCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flagCount");
                int _columnIndexOfTags = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"tags");
                int _columnIndexOfReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactions");
                int _columnIndexOfReactionCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionCount");
                int _columnIndexOfType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"type");
                int _columnIndexOfData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"data");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfMentionees = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mentionees");
                int _columnIndexOfPii = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pii");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfSyncState = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"syncState");
                int _columnIndexOfMessageMarkerHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messageMarkerHash");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new EkoMessageEntity();
                    String _tmpUniqueId = _stmt.isNull(_columnIndexOfUniqueId) ? null : _stmt.getText(_columnIndexOfUniqueId);
                    _result.setUniqueId(_tmpUniqueId);
                    String _tmpMessageId = _stmt.isNull(_columnIndexOfMessageId) ? null : _stmt.getText(_columnIndexOfMessageId);
                    _result.setMessageId(_tmpMessageId);
                    String _tmpSubChannelId = _stmt.isNull(_columnIndexOfSubChannelId) ? null : _stmt.getText(_columnIndexOfSubChannelId);
                    _result.setSubChannelId(_tmpSubChannelId);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _result.setChannelId(_tmpChannelId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _result.setUserId(_tmpUserId);
                    String _tmpParentId = _stmt.isNull(_columnIndexOfParentId) ? null : _stmt.getText(_columnIndexOfParentId);
                    _result.setParentId(_tmpParentId);
                    int _tmpChannelSegment = (int)_stmt.getLong(_columnIndexOfChannelSegment);
                    _result.setChannelSegment(_tmpChannelSegment);
                    int _tmpChildrenNumber = (int)_stmt.getLong(_columnIndexOfChildrenNumber);
                    _result.setChildrenNumber(_tmpChildrenNumber);
                    String _tmp = _stmt.isNull(_columnIndexOfEditedAt) ? null : _stmt.getText(_columnIndexOfEditedAt);
                    DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _result.setEditedAt(_tmpEditedAt);
                    int _tmp_1 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_1 != 0;
                    _result.setDeleted(_tmpIsDeleted);
                    int _tmpFlagCount = (int)_stmt.getLong(_columnIndexOfFlagCount);
                    _result.setFlagCount(_tmpFlagCount);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfTags) ? null : _stmt.getText(_columnIndexOfTags);
                    AmityTags _tmpTags = this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_2);
                    _result.setTags(_tmpTags);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfReactions) ? null : _stmt.getText(_columnIndexOfReactions);
                    AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_3);
                    _result.setReactions(_tmpReactions);
                    int _tmpReactionCount = (int)_stmt.getLong(_columnIndexOfReactionCount);
                    _result.setReactionCount(_tmpReactionCount);
                    String _tmpType = _stmt.isNull(_columnIndexOfType) ? null : _stmt.getText(_columnIndexOfType);
                    _result.setType(_tmpType);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfData) ? null : _stmt.getText(_columnIndexOfData);
                    JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                    _result.setData(_tmpData);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_5);
                    _result.setMetadata(_tmpMetadata);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfMentionees) ? null : _stmt.getText(_columnIndexOfMentionees);
                    List<EkoMentioneesDto> _tmpMentionees = this.__mentioneesConverter.jsonToMentionees(_tmp_6);
                    _result.setMentionees(_tmpMentionees);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfPii) ? null : _stmt.getText(_columnIndexOfPii);
                    JsonArray _tmpPii = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_7);
                    _result.setPii(_tmpPii);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _result.setPath(_tmpPath);
                    String _tmpSyncState = _stmt.isNull(_columnIndexOfSyncState) ? null : _stmt.getText(_columnIndexOfSyncState);
                    _result.setSyncState(_tmpSyncState);
                    int _tmpMessageMarkerHash = (int)_stmt.getLong(_columnIndexOfMessageMarkerHash);
                    _result.setMessageMarkerHash(_tmpMessageMarkerHash);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_10 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                EkoMessageEntity ekoMessageEntity = _result;
                return ekoMessageEntity;
            }
        });
    }

    @Override
    public List<EkoMessageEntity> getByIdsNowImpl(List<String> uniqueIds) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("SELECT message.* from message where message.uniqueId IN (");
        int _inputSize = uniqueIds.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        return (List)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare(_sql);){
                int _argIndex = 1;
                for (String _item : uniqueIds) {
                    if (_item == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindText(_argIndex, _item);
                    }
                    ++_argIndex;
                }
                int _columnIndexOfUniqueId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"uniqueId");
                int _columnIndexOfMessageId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messageId");
                int _columnIndexOfSubChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"subChannelId");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfParentId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"parentId");
                int _columnIndexOfChannelSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelSegment");
                int _columnIndexOfChildrenNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"childrenNumber");
                int _columnIndexOfEditedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"editedAt");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfFlagCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flagCount");
                int _columnIndexOfTags = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"tags");
                int _columnIndexOfReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactions");
                int _columnIndexOfReactionCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionCount");
                int _columnIndexOfType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"type");
                int _columnIndexOfData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"data");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfMentionees = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mentionees");
                int _columnIndexOfPii = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pii");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfSyncState = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"syncState");
                int _columnIndexOfMessageMarkerHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messageMarkerHash");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<EkoMessageEntity> _result = new ArrayList<EkoMessageEntity>();
                while (_stmt.step()) {
                    EkoMessageEntity _item_1 = new EkoMessageEntity();
                    String _tmpUniqueId = _stmt.isNull(_columnIndexOfUniqueId) ? null : _stmt.getText(_columnIndexOfUniqueId);
                    _item_1.setUniqueId(_tmpUniqueId);
                    String _tmpMessageId = _stmt.isNull(_columnIndexOfMessageId) ? null : _stmt.getText(_columnIndexOfMessageId);
                    _item_1.setMessageId(_tmpMessageId);
                    String _tmpSubChannelId = _stmt.isNull(_columnIndexOfSubChannelId) ? null : _stmt.getText(_columnIndexOfSubChannelId);
                    _item_1.setSubChannelId(_tmpSubChannelId);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _item_1.setChannelId(_tmpChannelId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _item_1.setUserId(_tmpUserId);
                    String _tmpParentId = _stmt.isNull(_columnIndexOfParentId) ? null : _stmt.getText(_columnIndexOfParentId);
                    _item_1.setParentId(_tmpParentId);
                    int _tmpChannelSegment = (int)_stmt.getLong(_columnIndexOfChannelSegment);
                    _item_1.setChannelSegment(_tmpChannelSegment);
                    int _tmpChildrenNumber = (int)_stmt.getLong(_columnIndexOfChildrenNumber);
                    _item_1.setChildrenNumber(_tmpChildrenNumber);
                    String _tmp = _stmt.isNull(_columnIndexOfEditedAt) ? null : _stmt.getText(_columnIndexOfEditedAt);
                    DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _item_1.setEditedAt(_tmpEditedAt);
                    int _tmp_1 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_1 != 0;
                    _item_1.setDeleted(_tmpIsDeleted);
                    int _tmpFlagCount = (int)_stmt.getLong(_columnIndexOfFlagCount);
                    _item_1.setFlagCount(_tmpFlagCount);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfTags) ? null : _stmt.getText(_columnIndexOfTags);
                    AmityTags _tmpTags = this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_2);
                    _item_1.setTags(_tmpTags);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfReactions) ? null : _stmt.getText(_columnIndexOfReactions);
                    AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_3);
                    _item_1.setReactions(_tmpReactions);
                    int _tmpReactionCount = (int)_stmt.getLong(_columnIndexOfReactionCount);
                    _item_1.setReactionCount(_tmpReactionCount);
                    String _tmpType = _stmt.isNull(_columnIndexOfType) ? null : _stmt.getText(_columnIndexOfType);
                    _item_1.setType(_tmpType);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfData) ? null : _stmt.getText(_columnIndexOfData);
                    JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                    _item_1.setData(_tmpData);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_5);
                    _item_1.setMetadata(_tmpMetadata);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfMentionees) ? null : _stmt.getText(_columnIndexOfMentionees);
                    List<EkoMentioneesDto> _tmpMentionees = this.__mentioneesConverter.jsonToMentionees(_tmp_6);
                    _item_1.setMentionees(_tmpMentionees);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfPii) ? null : _stmt.getText(_columnIndexOfPii);
                    JsonArray _tmpPii = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_7);
                    _item_1.setPii(_tmpPii);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _item_1.setPath(_tmpPath);
                    String _tmpSyncState = _stmt.isNull(_columnIndexOfSyncState) ? null : _stmt.getText(_columnIndexOfSyncState);
                    _item_1.setSyncState(_tmpSyncState);
                    int _tmpMessageMarkerHash = (int)_stmt.getLong(_columnIndexOfMessageMarkerHash);
                    _item_1.setMessageMarkerHash(_tmpMessageMarkerHash);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                    _item_1.setCreatedAt(_tmpCreatedAt);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                    _item_1.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_10 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                    _item_1.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item_1);
                }
                ArrayList<EkoMessageEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public Flowable<List<EkoMessageEntity>> observeMessagesWithTypeImpl(String subChannelId, boolean isFilterByParentId, String parentId, boolean isFilterByTags, String[] includingTags, String[] excludingTags, Boolean isDeleted, List<String> type2, Boolean isSortedAsc) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("SELECT message.* from message where message.subChannelId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and ");
        _stringBuilder.append("?");
        _stringBuilder.append(" is not null then message.parentId = ");
        _stringBuilder.append("?");
        _stringBuilder.append("  when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and ");
        _stringBuilder.append("?");
        _stringBuilder.append(" is null then message.parentId is null  else message.messageId is not null end and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" then message.messageId in (SELECT messageId from message_tag where tagName in (");
        int _inputSize = includingTags == null ? 1 : includingTags.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append("))  else message.messageId is not null end and message.messageId not in (SELECT messageId from message_tag where tagName in (");
        int _inputSize_1 = excludingTags == null ? 1 : excludingTags.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize_1);
        _stringBuilder.append(")) and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" is not null then message.isDeleted = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" else message.messageId is not null end and message.type IN (");
        int _inputSize_2 = type2 == null ? 1 : type2.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize_2);
        _stringBuilder.append(") order by case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" = 1 then message.createdAt end asc, case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" = 0 then message.createdAt end desc");
        String _sql = _stringBuilder.toString();
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"message", "message_tag"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare(_sql);){
                Integer _tmp_6;
                Integer _tmp_5;
                Integer _tmp_4;
                Integer _tmp_3;
                int _argIndex = 1;
                if (subChannelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, subChannelId);
                }
                _argIndex = 2;
                int _tmp = isFilterByParentId ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp);
                _argIndex = 3;
                if (parentId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, parentId);
                }
                _argIndex = 4;
                if (parentId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, parentId);
                }
                _argIndex = 5;
                int _tmp_1 = isFilterByParentId ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp_1);
                _argIndex = 6;
                if (parentId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, parentId);
                }
                _argIndex = 7;
                int _tmp_2 = isFilterByTags ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp_2);
                _argIndex = 8;
                if (includingTags == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    for (String _item : includingTags) {
                        if (_item == null) {
                            _stmt.bindNull(_argIndex);
                        } else {
                            _stmt.bindText(_argIndex, _item);
                        }
                        ++_argIndex;
                    }
                }
                _argIndex = 8 + _inputSize;
                if (excludingTags == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    for (String _item_1 : excludingTags) {
                        if (_item_1 == null) {
                            _stmt.bindNull(_argIndex);
                        } else {
                            _stmt.bindText(_argIndex, _item_1);
                        }
                        ++_argIndex;
                    }
                }
                _argIndex = 8 + _inputSize + _inputSize_1;
                Integer n = isDeleted == null ? null : (_tmp_3 = Integer.valueOf(isDeleted != false ? 1 : 0));
                if (_tmp_3 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp_3.intValue());
                }
                _argIndex = 9 + _inputSize + _inputSize_1;
                Integer n2 = isDeleted == null ? null : (_tmp_4 = Integer.valueOf(isDeleted != false ? 1 : 0));
                if (_tmp_4 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp_4.intValue());
                }
                _argIndex = 10 + _inputSize + _inputSize_1;
                if (type2 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    for (String _item_2 : type2) {
                        if (_item_2 == null) {
                            _stmt.bindNull(_argIndex);
                        } else {
                            _stmt.bindText(_argIndex, _item_2);
                        }
                        ++_argIndex;
                    }
                }
                _argIndex = 10 + _inputSize + _inputSize_1 + _inputSize_2;
                Integer n3 = isSortedAsc == null ? null : (_tmp_5 = Integer.valueOf(isSortedAsc != false ? 1 : 0));
                if (_tmp_5 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp_5.intValue());
                }
                _argIndex = 11 + _inputSize + _inputSize_1 + _inputSize_2;
                Integer n4 = isSortedAsc == null ? null : (_tmp_6 = Integer.valueOf(isSortedAsc != false ? 1 : 0));
                if (_tmp_6 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp_6.intValue());
                }
                int _columnIndexOfUniqueId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"uniqueId");
                int _columnIndexOfMessageId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messageId");
                int _columnIndexOfSubChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"subChannelId");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfParentId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"parentId");
                int _columnIndexOfChannelSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelSegment");
                int _columnIndexOfChildrenNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"childrenNumber");
                int _columnIndexOfEditedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"editedAt");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfFlagCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flagCount");
                int _columnIndexOfTags = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"tags");
                int _columnIndexOfReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactions");
                int _columnIndexOfReactionCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionCount");
                int _columnIndexOfType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"type");
                int _columnIndexOfData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"data");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfMentionees = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mentionees");
                int _columnIndexOfPii = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pii");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfSyncState = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"syncState");
                int _columnIndexOfMessageMarkerHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messageMarkerHash");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<EkoMessageEntity> _result = new ArrayList<EkoMessageEntity>();
                while (_stmt.step()) {
                    EkoMessageEntity _item_3 = new EkoMessageEntity();
                    String _tmpUniqueId = _stmt.isNull(_columnIndexOfUniqueId) ? null : _stmt.getText(_columnIndexOfUniqueId);
                    _item_3.setUniqueId(_tmpUniqueId);
                    String _tmpMessageId = _stmt.isNull(_columnIndexOfMessageId) ? null : _stmt.getText(_columnIndexOfMessageId);
                    _item_3.setMessageId(_tmpMessageId);
                    String _tmpSubChannelId = _stmt.isNull(_columnIndexOfSubChannelId) ? null : _stmt.getText(_columnIndexOfSubChannelId);
                    _item_3.setSubChannelId(_tmpSubChannelId);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _item_3.setChannelId(_tmpChannelId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _item_3.setUserId(_tmpUserId);
                    String _tmpParentId = _stmt.isNull(_columnIndexOfParentId) ? null : _stmt.getText(_columnIndexOfParentId);
                    _item_3.setParentId(_tmpParentId);
                    int _tmpChannelSegment = (int)_stmt.getLong(_columnIndexOfChannelSegment);
                    _item_3.setChannelSegment(_tmpChannelSegment);
                    int _tmpChildrenNumber = (int)_stmt.getLong(_columnIndexOfChildrenNumber);
                    _item_3.setChildrenNumber(_tmpChildrenNumber);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfEditedAt) ? null : _stmt.getText(_columnIndexOfEditedAt);
                    DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                    _item_3.setEditedAt(_tmpEditedAt);
                    int _tmp_8 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_8 != 0;
                    _item_3.setDeleted(_tmpIsDeleted);
                    int _tmpFlagCount = (int)_stmt.getLong(_columnIndexOfFlagCount);
                    _item_3.setFlagCount(_tmpFlagCount);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfTags) ? null : _stmt.getText(_columnIndexOfTags);
                    AmityTags _tmpTags = this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_9);
                    _item_3.setTags(_tmpTags);
                    String _tmp_10 = _stmt.isNull(_columnIndexOfReactions) ? null : _stmt.getText(_columnIndexOfReactions);
                    AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_10);
                    _item_3.setReactions(_tmpReactions);
                    int _tmpReactionCount = (int)_stmt.getLong(_columnIndexOfReactionCount);
                    _item_3.setReactionCount(_tmpReactionCount);
                    String _tmpType = _stmt.isNull(_columnIndexOfType) ? null : _stmt.getText(_columnIndexOfType);
                    _item_3.setType(_tmpType);
                    String _tmp_11 = _stmt.isNull(_columnIndexOfData) ? null : _stmt.getText(_columnIndexOfData);
                    JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_11);
                    _item_3.setData(_tmpData);
                    String _tmp_12 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_12);
                    _item_3.setMetadata(_tmpMetadata);
                    String _tmp_13 = _stmt.isNull(_columnIndexOfMentionees) ? null : _stmt.getText(_columnIndexOfMentionees);
                    List<EkoMentioneesDto> _tmpMentionees = this.__mentioneesConverter.jsonToMentionees(_tmp_13);
                    _item_3.setMentionees(_tmpMentionees);
                    String _tmp_14 = _stmt.isNull(_columnIndexOfPii) ? null : _stmt.getText(_columnIndexOfPii);
                    JsonArray _tmpPii = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_14);
                    _item_3.setPii(_tmpPii);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _item_3.setPath(_tmpPath);
                    String _tmpSyncState = _stmt.isNull(_columnIndexOfSyncState) ? null : _stmt.getText(_columnIndexOfSyncState);
                    _item_3.setSyncState(_tmpSyncState);
                    int _tmpMessageMarkerHash = (int)_stmt.getLong(_columnIndexOfMessageMarkerHash);
                    _item_3.setMessageMarkerHash(_tmpMessageMarkerHash);
                    String _tmp_15 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_15);
                    _item_3.setCreatedAt(_tmpCreatedAt);
                    String _tmp_16 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_16);
                    _item_3.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_17 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_17);
                    _item_3.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item_3);
                }
                ArrayList<EkoMessageEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public Flowable<List<EkoMessageEntity>> observeMessagesImpl(String subChannelId, boolean isFilterByParentId, String parentId, boolean isFilterByTags, String[] includingTags, String[] excludingTags, Boolean isDeleted, boolean isSortedAsc) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("SELECT message.* from message where message.subChannelId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and ");
        _stringBuilder.append("?");
        _stringBuilder.append(" is not null then message.parentId = ");
        _stringBuilder.append("?");
        _stringBuilder.append("  when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and ");
        _stringBuilder.append("?");
        _stringBuilder.append(" is null then message.parentId is null  else message.messageId is not null end and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" then message.messageId in (SELECT messageId from message_tag where tagName in (");
        int _inputSize = includingTags.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append("))  else message.messageId is not null end and message.messageId not in (SELECT messageId from message_tag where tagName in (");
        int _inputSize_1 = excludingTags.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize_1);
        _stringBuilder.append(")) and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" is not null then message.isDeleted = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" else message.messageId is not null end order by case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" = 1 then message.createdAt end asc, case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" = 0 then message.createdAt end desc");
        String _sql = _stringBuilder.toString();
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"message", "message_tag"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare(_sql);){
                Integer _tmp_4;
                Integer _tmp_3;
                int _argIndex = 1;
                if (subChannelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, subChannelId);
                }
                _argIndex = 2;
                int _tmp = isFilterByParentId ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp);
                _argIndex = 3;
                if (parentId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, parentId);
                }
                _argIndex = 4;
                if (parentId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, parentId);
                }
                _argIndex = 5;
                int _tmp_1 = isFilterByParentId ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp_1);
                _argIndex = 6;
                if (parentId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, parentId);
                }
                _argIndex = 7;
                int _tmp_2 = isFilterByTags ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp_2);
                _argIndex = 8;
                for (String _item : includingTags) {
                    if (_item == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindText(_argIndex, _item);
                    }
                    ++_argIndex;
                }
                _argIndex = 8 + _inputSize;
                for (String _item_1 : excludingTags) {
                    if (_item_1 == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindText(_argIndex, _item_1);
                    }
                    ++_argIndex;
                }
                _argIndex = 8 + _inputSize + _inputSize_1;
                Integer n = isDeleted == null ? null : (_tmp_3 = Integer.valueOf(isDeleted != false ? 1 : 0));
                if (_tmp_3 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp_3.intValue());
                }
                _argIndex = 9 + _inputSize + _inputSize_1;
                Integer n2 = isDeleted == null ? null : (_tmp_4 = Integer.valueOf(isDeleted != false ? 1 : 0));
                if (_tmp_4 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp_4.intValue());
                }
                _argIndex = 10 + _inputSize + _inputSize_1;
                int _tmp_5 = isSortedAsc ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp_5);
                _argIndex = 11 + _inputSize + _inputSize_1;
                int _tmp_6 = isSortedAsc ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp_6);
                int _columnIndexOfUniqueId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"uniqueId");
                int _columnIndexOfMessageId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messageId");
                int _columnIndexOfSubChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"subChannelId");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfParentId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"parentId");
                int _columnIndexOfChannelSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelSegment");
                int _columnIndexOfChildrenNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"childrenNumber");
                int _columnIndexOfEditedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"editedAt");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfFlagCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flagCount");
                int _columnIndexOfTags = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"tags");
                int _columnIndexOfReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactions");
                int _columnIndexOfReactionCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionCount");
                int _columnIndexOfType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"type");
                int _columnIndexOfData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"data");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfMentionees = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mentionees");
                int _columnIndexOfPii = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pii");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfSyncState = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"syncState");
                int _columnIndexOfMessageMarkerHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messageMarkerHash");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<EkoMessageEntity> _result = new ArrayList<EkoMessageEntity>();
                while (_stmt.step()) {
                    EkoMessageEntity _item_2 = new EkoMessageEntity();
                    String _tmpUniqueId = _stmt.isNull(_columnIndexOfUniqueId) ? null : _stmt.getText(_columnIndexOfUniqueId);
                    _item_2.setUniqueId(_tmpUniqueId);
                    String _tmpMessageId = _stmt.isNull(_columnIndexOfMessageId) ? null : _stmt.getText(_columnIndexOfMessageId);
                    _item_2.setMessageId(_tmpMessageId);
                    String _tmpSubChannelId = _stmt.isNull(_columnIndexOfSubChannelId) ? null : _stmt.getText(_columnIndexOfSubChannelId);
                    _item_2.setSubChannelId(_tmpSubChannelId);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _item_2.setChannelId(_tmpChannelId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _item_2.setUserId(_tmpUserId);
                    String _tmpParentId = _stmt.isNull(_columnIndexOfParentId) ? null : _stmt.getText(_columnIndexOfParentId);
                    _item_2.setParentId(_tmpParentId);
                    int _tmpChannelSegment = (int)_stmt.getLong(_columnIndexOfChannelSegment);
                    _item_2.setChannelSegment(_tmpChannelSegment);
                    int _tmpChildrenNumber = (int)_stmt.getLong(_columnIndexOfChildrenNumber);
                    _item_2.setChildrenNumber(_tmpChildrenNumber);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfEditedAt) ? null : _stmt.getText(_columnIndexOfEditedAt);
                    DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                    _item_2.setEditedAt(_tmpEditedAt);
                    int _tmp_8 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_8 != 0;
                    _item_2.setDeleted(_tmpIsDeleted);
                    int _tmpFlagCount = (int)_stmt.getLong(_columnIndexOfFlagCount);
                    _item_2.setFlagCount(_tmpFlagCount);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfTags) ? null : _stmt.getText(_columnIndexOfTags);
                    AmityTags _tmpTags = this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_9);
                    _item_2.setTags(_tmpTags);
                    String _tmp_10 = _stmt.isNull(_columnIndexOfReactions) ? null : _stmt.getText(_columnIndexOfReactions);
                    AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_10);
                    _item_2.setReactions(_tmpReactions);
                    int _tmpReactionCount = (int)_stmt.getLong(_columnIndexOfReactionCount);
                    _item_2.setReactionCount(_tmpReactionCount);
                    String _tmpType = _stmt.isNull(_columnIndexOfType) ? null : _stmt.getText(_columnIndexOfType);
                    _item_2.setType(_tmpType);
                    String _tmp_11 = _stmt.isNull(_columnIndexOfData) ? null : _stmt.getText(_columnIndexOfData);
                    JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_11);
                    _item_2.setData(_tmpData);
                    String _tmp_12 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_12);
                    _item_2.setMetadata(_tmpMetadata);
                    String _tmp_13 = _stmt.isNull(_columnIndexOfMentionees) ? null : _stmt.getText(_columnIndexOfMentionees);
                    List<EkoMentioneesDto> _tmpMentionees = this.__mentioneesConverter.jsonToMentionees(_tmp_13);
                    _item_2.setMentionees(_tmpMentionees);
                    String _tmp_14 = _stmt.isNull(_columnIndexOfPii) ? null : _stmt.getText(_columnIndexOfPii);
                    JsonArray _tmpPii = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_14);
                    _item_2.setPii(_tmpPii);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _item_2.setPath(_tmpPath);
                    String _tmpSyncState = _stmt.isNull(_columnIndexOfSyncState) ? null : _stmt.getText(_columnIndexOfSyncState);
                    _item_2.setSyncState(_tmpSyncState);
                    int _tmpMessageMarkerHash = (int)_stmt.getLong(_columnIndexOfMessageMarkerHash);
                    _item_2.setMessageMarkerHash(_tmpMessageMarkerHash);
                    String _tmp_15 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_15);
                    _item_2.setCreatedAt(_tmpCreatedAt);
                    String _tmp_16 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_16);
                    _item_2.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_17 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_17);
                    _item_2.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item_2);
                }
                ArrayList<EkoMessageEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public Flowable<EkoMessageEntity> getLatestMessageWithTypeImpl(String subChannelId, Boolean isFilterByParentId, String parentId, boolean isIncludingTags, String[] includingTags, boolean isExcludingTags, String[] excludingTags, Boolean isDeleted, List<String> type2, int hash, int nonce, DateTime now) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("SELECT * from message where message.subChannelId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and ");
        _stringBuilder.append("?");
        _stringBuilder.append(" is not null then message.parentId = ");
        _stringBuilder.append("?");
        _stringBuilder.append("  when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and ");
        _stringBuilder.append("?");
        _stringBuilder.append(" is null then message.parentId is null  else message.messageId is not null end and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" then message.messageId in (SELECT messageId from message_tag where tagName in (");
        int _inputSize = includingTags.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")) else message.messageId is not null end and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" then message.messageId not in (SELECT messageId from message_tag where tagName in (");
        int _inputSize_1 = excludingTags.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize_1);
        _stringBuilder.append(")) else message.messageId is not null end and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" is not null then message.isDeleted = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" else message.messageId is not null end and message.updatedAt > ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and message.uniqueId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (");
        _stringBuilder.append("?");
        _stringBuilder.append(") and amity_paging_id.nonce = (");
        _stringBuilder.append("?");
        _stringBuilder.append(") ) and message.type in (");
        int _inputSize_2 = type2.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize_2);
        _stringBuilder.append(") order by message.updatedAt desc limit 1");
        String _sql = _stringBuilder.toString();
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"message", "message_tag", "amity_paging_id"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare(_sql);){
                EkoMessageEntity _result;
                Integer _tmp_5;
                Integer _tmp_4;
                Integer _tmp_1;
                Integer _tmp;
                int _argIndex = 1;
                if (subChannelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, subChannelId);
                }
                _argIndex = 2;
                Integer n = isFilterByParentId == null ? null : (_tmp = Integer.valueOf(isFilterByParentId != false ? 1 : 0));
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp.intValue());
                }
                _argIndex = 3;
                if (parentId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, parentId);
                }
                _argIndex = 4;
                if (parentId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, parentId);
                }
                _argIndex = 5;
                Integer n2 = isFilterByParentId == null ? null : (_tmp_1 = Integer.valueOf(isFilterByParentId != false ? 1 : 0));
                if (_tmp_1 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp_1.intValue());
                }
                _argIndex = 6;
                if (parentId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, parentId);
                }
                _argIndex = 7;
                int _tmp_2 = isIncludingTags ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp_2);
                _argIndex = 8;
                for (String _item : includingTags) {
                    if (_item == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindText(_argIndex, _item);
                    }
                    ++_argIndex;
                }
                _argIndex = 8 + _inputSize;
                int _tmp_3 = isExcludingTags ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp_3);
                _argIndex = 9 + _inputSize;
                for (String _item_1 : excludingTags) {
                    if (_item_1 == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindText(_argIndex, _item_1);
                    }
                    ++_argIndex;
                }
                _argIndex = 9 + _inputSize + _inputSize_1;
                Integer n3 = isDeleted == null ? null : (_tmp_4 = Integer.valueOf(isDeleted != false ? 1 : 0));
                if (_tmp_4 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp_4.intValue());
                }
                _argIndex = 10 + _inputSize + _inputSize_1;
                Integer n4 = isDeleted == null ? null : (_tmp_5 = Integer.valueOf(isDeleted != false ? 1 : 0));
                if (_tmp_5 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp_5.intValue());
                }
                _argIndex = 11 + _inputSize + _inputSize_1;
                String _tmp_6 = this.__dateTimeTypeConverter.dateTimeToString(now);
                if (_tmp_6 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, _tmp_6);
                }
                _argIndex = 12 + _inputSize + _inputSize_1;
                _stmt.bindLong(_argIndex, (long)hash);
                _argIndex = 13 + _inputSize + _inputSize_1;
                _stmt.bindLong(_argIndex, (long)nonce);
                _argIndex = 14 + _inputSize + _inputSize_1;
                for (String _item_2 : type2) {
                    if (_item_2 == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindText(_argIndex, _item_2);
                    }
                    ++_argIndex;
                }
                int _columnIndexOfUniqueId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"uniqueId");
                int _columnIndexOfMessageId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messageId");
                int _columnIndexOfSubChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"subChannelId");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfParentId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"parentId");
                int _columnIndexOfChannelSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelSegment");
                int _columnIndexOfChildrenNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"childrenNumber");
                int _columnIndexOfEditedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"editedAt");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfFlagCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flagCount");
                int _columnIndexOfTags = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"tags");
                int _columnIndexOfReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactions");
                int _columnIndexOfReactionCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionCount");
                int _columnIndexOfType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"type");
                int _columnIndexOfData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"data");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfMentionees = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mentionees");
                int _columnIndexOfPii = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pii");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfSyncState = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"syncState");
                int _columnIndexOfMessageMarkerHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messageMarkerHash");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new EkoMessageEntity();
                    String _tmpUniqueId = _stmt.isNull(_columnIndexOfUniqueId) ? null : _stmt.getText(_columnIndexOfUniqueId);
                    _result.setUniqueId(_tmpUniqueId);
                    String _tmpMessageId = _stmt.isNull(_columnIndexOfMessageId) ? null : _stmt.getText(_columnIndexOfMessageId);
                    _result.setMessageId(_tmpMessageId);
                    String _tmpSubChannelId = _stmt.isNull(_columnIndexOfSubChannelId) ? null : _stmt.getText(_columnIndexOfSubChannelId);
                    _result.setSubChannelId(_tmpSubChannelId);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _result.setChannelId(_tmpChannelId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _result.setUserId(_tmpUserId);
                    String _tmpParentId = _stmt.isNull(_columnIndexOfParentId) ? null : _stmt.getText(_columnIndexOfParentId);
                    _result.setParentId(_tmpParentId);
                    int _tmpChannelSegment = (int)_stmt.getLong(_columnIndexOfChannelSegment);
                    _result.setChannelSegment(_tmpChannelSegment);
                    int _tmpChildrenNumber = (int)_stmt.getLong(_columnIndexOfChildrenNumber);
                    _result.setChildrenNumber(_tmpChildrenNumber);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfEditedAt) ? null : _stmt.getText(_columnIndexOfEditedAt);
                    DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                    _result.setEditedAt(_tmpEditedAt);
                    int _tmp_8 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_8 != 0;
                    _result.setDeleted(_tmpIsDeleted);
                    int _tmpFlagCount = (int)_stmt.getLong(_columnIndexOfFlagCount);
                    _result.setFlagCount(_tmpFlagCount);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfTags) ? null : _stmt.getText(_columnIndexOfTags);
                    AmityTags _tmpTags = this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_9);
                    _result.setTags(_tmpTags);
                    String _tmp_10 = _stmt.isNull(_columnIndexOfReactions) ? null : _stmt.getText(_columnIndexOfReactions);
                    AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_10);
                    _result.setReactions(_tmpReactions);
                    int _tmpReactionCount = (int)_stmt.getLong(_columnIndexOfReactionCount);
                    _result.setReactionCount(_tmpReactionCount);
                    String _tmpType = _stmt.isNull(_columnIndexOfType) ? null : _stmt.getText(_columnIndexOfType);
                    _result.setType(_tmpType);
                    String _tmp_11 = _stmt.isNull(_columnIndexOfData) ? null : _stmt.getText(_columnIndexOfData);
                    JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_11);
                    _result.setData(_tmpData);
                    String _tmp_12 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_12);
                    _result.setMetadata(_tmpMetadata);
                    String _tmp_13 = _stmt.isNull(_columnIndexOfMentionees) ? null : _stmt.getText(_columnIndexOfMentionees);
                    List<EkoMentioneesDto> _tmpMentionees = this.__mentioneesConverter.jsonToMentionees(_tmp_13);
                    _result.setMentionees(_tmpMentionees);
                    String _tmp_14 = _stmt.isNull(_columnIndexOfPii) ? null : _stmt.getText(_columnIndexOfPii);
                    JsonArray _tmpPii = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_14);
                    _result.setPii(_tmpPii);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _result.setPath(_tmpPath);
                    String _tmpSyncState = _stmt.isNull(_columnIndexOfSyncState) ? null : _stmt.getText(_columnIndexOfSyncState);
                    _result.setSyncState(_tmpSyncState);
                    int _tmpMessageMarkerHash = (int)_stmt.getLong(_columnIndexOfMessageMarkerHash);
                    _result.setMessageMarkerHash(_tmpMessageMarkerHash);
                    String _tmp_15 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_15);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_16 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_16);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_17 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_17);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                EkoMessageEntity ekoMessageEntity = _result;
                return ekoMessageEntity;
            }
        });
    }

    @Override
    public Flowable<EkoMessageEntity> getLatestUnsyncMessageImpl(String subChannelId, Boolean isFilterByParentId, String parentId, boolean isIncludingTags, String[] includingTags, boolean isExcludingTags, String[] excludingTags, Boolean isDeleted, int hash, int nonce) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("SELECT * from message where message.subChannelId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and ");
        _stringBuilder.append("?");
        _stringBuilder.append(" is not null then message.parentId = ");
        _stringBuilder.append("?");
        _stringBuilder.append("  when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and ");
        _stringBuilder.append("?");
        _stringBuilder.append(" is null then message.parentId is null  else message.messageId is not null end and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" then message.messageId in (SELECT messageId from message_tag where tagName in (");
        int _inputSize = includingTags.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")) else message.messageId is not null end and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" then message.messageId not in (SELECT messageId from message_tag where tagName in (");
        int _inputSize_1 = excludingTags.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize_1);
        _stringBuilder.append(")) else message.messageId is not null end and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" is not null then message.isDeleted = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" else message.messageId is not null end and message.syncState != 'synced'  and message.uniqueId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (");
        _stringBuilder.append("?");
        _stringBuilder.append(") and amity_paging_id.nonce = (");
        _stringBuilder.append("?");
        _stringBuilder.append(") ) order by message.updatedAt desc limit 1");
        String _sql = _stringBuilder.toString();
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"message", "message_tag", "amity_paging_id"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare(_sql);){
                EkoMessageEntity _result;
                Integer _tmp_5;
                Integer _tmp_4;
                Integer _tmp_1;
                Integer _tmp;
                int _argIndex = 1;
                if (subChannelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, subChannelId);
                }
                _argIndex = 2;
                Integer n = isFilterByParentId == null ? null : (_tmp = Integer.valueOf(isFilterByParentId != false ? 1 : 0));
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp.intValue());
                }
                _argIndex = 3;
                if (parentId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, parentId);
                }
                _argIndex = 4;
                if (parentId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, parentId);
                }
                _argIndex = 5;
                Integer n2 = isFilterByParentId == null ? null : (_tmp_1 = Integer.valueOf(isFilterByParentId != false ? 1 : 0));
                if (_tmp_1 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp_1.intValue());
                }
                _argIndex = 6;
                if (parentId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, parentId);
                }
                _argIndex = 7;
                int _tmp_2 = isIncludingTags ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp_2);
                _argIndex = 8;
                for (String _item : includingTags) {
                    if (_item == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindText(_argIndex, _item);
                    }
                    ++_argIndex;
                }
                _argIndex = 8 + _inputSize;
                int _tmp_3 = isExcludingTags ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp_3);
                _argIndex = 9 + _inputSize;
                for (String _item_1 : excludingTags) {
                    if (_item_1 == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindText(_argIndex, _item_1);
                    }
                    ++_argIndex;
                }
                _argIndex = 9 + _inputSize + _inputSize_1;
                Integer n3 = isDeleted == null ? null : (_tmp_4 = Integer.valueOf(isDeleted != false ? 1 : 0));
                if (_tmp_4 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp_4.intValue());
                }
                _argIndex = 10 + _inputSize + _inputSize_1;
                Integer n4 = isDeleted == null ? null : (_tmp_5 = Integer.valueOf(isDeleted != false ? 1 : 0));
                if (_tmp_5 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp_5.intValue());
                }
                _argIndex = 11 + _inputSize + _inputSize_1;
                _stmt.bindLong(_argIndex, (long)hash);
                _argIndex = 12 + _inputSize + _inputSize_1;
                _stmt.bindLong(_argIndex, (long)nonce);
                int _columnIndexOfUniqueId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"uniqueId");
                int _columnIndexOfMessageId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messageId");
                int _columnIndexOfSubChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"subChannelId");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfParentId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"parentId");
                int _columnIndexOfChannelSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelSegment");
                int _columnIndexOfChildrenNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"childrenNumber");
                int _columnIndexOfEditedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"editedAt");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfFlagCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flagCount");
                int _columnIndexOfTags = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"tags");
                int _columnIndexOfReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactions");
                int _columnIndexOfReactionCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionCount");
                int _columnIndexOfType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"type");
                int _columnIndexOfData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"data");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfMentionees = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mentionees");
                int _columnIndexOfPii = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pii");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfSyncState = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"syncState");
                int _columnIndexOfMessageMarkerHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messageMarkerHash");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new EkoMessageEntity();
                    String _tmpUniqueId = _stmt.isNull(_columnIndexOfUniqueId) ? null : _stmt.getText(_columnIndexOfUniqueId);
                    _result.setUniqueId(_tmpUniqueId);
                    String _tmpMessageId = _stmt.isNull(_columnIndexOfMessageId) ? null : _stmt.getText(_columnIndexOfMessageId);
                    _result.setMessageId(_tmpMessageId);
                    String _tmpSubChannelId = _stmt.isNull(_columnIndexOfSubChannelId) ? null : _stmt.getText(_columnIndexOfSubChannelId);
                    _result.setSubChannelId(_tmpSubChannelId);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _result.setChannelId(_tmpChannelId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _result.setUserId(_tmpUserId);
                    String _tmpParentId = _stmt.isNull(_columnIndexOfParentId) ? null : _stmt.getText(_columnIndexOfParentId);
                    _result.setParentId(_tmpParentId);
                    int _tmpChannelSegment = (int)_stmt.getLong(_columnIndexOfChannelSegment);
                    _result.setChannelSegment(_tmpChannelSegment);
                    int _tmpChildrenNumber = (int)_stmt.getLong(_columnIndexOfChildrenNumber);
                    _result.setChildrenNumber(_tmpChildrenNumber);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfEditedAt) ? null : _stmt.getText(_columnIndexOfEditedAt);
                    DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                    _result.setEditedAt(_tmpEditedAt);
                    int _tmp_7 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_7 != 0;
                    _result.setDeleted(_tmpIsDeleted);
                    int _tmpFlagCount = (int)_stmt.getLong(_columnIndexOfFlagCount);
                    _result.setFlagCount(_tmpFlagCount);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfTags) ? null : _stmt.getText(_columnIndexOfTags);
                    AmityTags _tmpTags = this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_8);
                    _result.setTags(_tmpTags);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfReactions) ? null : _stmt.getText(_columnIndexOfReactions);
                    AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_9);
                    _result.setReactions(_tmpReactions);
                    int _tmpReactionCount = (int)_stmt.getLong(_columnIndexOfReactionCount);
                    _result.setReactionCount(_tmpReactionCount);
                    String _tmpType = _stmt.isNull(_columnIndexOfType) ? null : _stmt.getText(_columnIndexOfType);
                    _result.setType(_tmpType);
                    String _tmp_10 = _stmt.isNull(_columnIndexOfData) ? null : _stmt.getText(_columnIndexOfData);
                    JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_10);
                    _result.setData(_tmpData);
                    String _tmp_11 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_11);
                    _result.setMetadata(_tmpMetadata);
                    String _tmp_12 = _stmt.isNull(_columnIndexOfMentionees) ? null : _stmt.getText(_columnIndexOfMentionees);
                    List<EkoMentioneesDto> _tmpMentionees = this.__mentioneesConverter.jsonToMentionees(_tmp_12);
                    _result.setMentionees(_tmpMentionees);
                    String _tmp_13 = _stmt.isNull(_columnIndexOfPii) ? null : _stmt.getText(_columnIndexOfPii);
                    JsonArray _tmpPii = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_13);
                    _result.setPii(_tmpPii);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _result.setPath(_tmpPath);
                    String _tmpSyncState = _stmt.isNull(_columnIndexOfSyncState) ? null : _stmt.getText(_columnIndexOfSyncState);
                    _result.setSyncState(_tmpSyncState);
                    int _tmpMessageMarkerHash = (int)_stmt.getLong(_columnIndexOfMessageMarkerHash);
                    _result.setMessageMarkerHash(_tmpMessageMarkerHash);
                    String _tmp_14 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_14);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_15 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_15);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_16 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_16);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                EkoMessageEntity ekoMessageEntity = _result;
                return ekoMessageEntity;
            }
        });
    }

    @Override
    public Flowable<EkoMessageEntity> getLatestUnsyncMessageWithTypeImpl(String subChannelId, Boolean isFilterByParentId, String parentId, boolean isIncludingTags, String[] includingTags, boolean isExcludingTags, String[] excludingTags, Boolean isDeleted, List<String> type2, int hash, int nonce) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("SELECT * from message where message.subChannelId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and ");
        _stringBuilder.append("?");
        _stringBuilder.append(" is not null then message.parentId = ");
        _stringBuilder.append("?");
        _stringBuilder.append("  when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and ");
        _stringBuilder.append("?");
        _stringBuilder.append(" is null then message.parentId is null  else message.messageId is not null end and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" then message.messageId in (SELECT messageId from message_tag where tagName in (");
        int _inputSize = includingTags.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")) else message.messageId is not null end and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" then message.messageId not in (SELECT messageId from message_tag where tagName in (");
        int _inputSize_1 = excludingTags.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize_1);
        _stringBuilder.append(")) else message.messageId is not null end and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" is not null then message.isDeleted = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" else message.messageId is not null end and message.syncState != 'synced'  and message.uniqueId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (");
        _stringBuilder.append("?");
        _stringBuilder.append(") and amity_paging_id.nonce = (");
        _stringBuilder.append("?");
        _stringBuilder.append(") ) and message.type in (");
        int _inputSize_2 = type2.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize_2);
        _stringBuilder.append(") order by message.updatedAt desc limit 1");
        String _sql = _stringBuilder.toString();
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"message", "message_tag", "amity_paging_id"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare(_sql);){
                EkoMessageEntity _result;
                Integer _tmp_5;
                Integer _tmp_4;
                Integer _tmp_1;
                Integer _tmp;
                int _argIndex = 1;
                if (subChannelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, subChannelId);
                }
                _argIndex = 2;
                Integer n = isFilterByParentId == null ? null : (_tmp = Integer.valueOf(isFilterByParentId != false ? 1 : 0));
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp.intValue());
                }
                _argIndex = 3;
                if (parentId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, parentId);
                }
                _argIndex = 4;
                if (parentId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, parentId);
                }
                _argIndex = 5;
                Integer n2 = isFilterByParentId == null ? null : (_tmp_1 = Integer.valueOf(isFilterByParentId != false ? 1 : 0));
                if (_tmp_1 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp_1.intValue());
                }
                _argIndex = 6;
                if (parentId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, parentId);
                }
                _argIndex = 7;
                int _tmp_2 = isIncludingTags ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp_2);
                _argIndex = 8;
                for (String _item : includingTags) {
                    if (_item == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindText(_argIndex, _item);
                    }
                    ++_argIndex;
                }
                _argIndex = 8 + _inputSize;
                int _tmp_3 = isExcludingTags ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp_3);
                _argIndex = 9 + _inputSize;
                for (String _item_1 : excludingTags) {
                    if (_item_1 == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindText(_argIndex, _item_1);
                    }
                    ++_argIndex;
                }
                _argIndex = 9 + _inputSize + _inputSize_1;
                Integer n3 = isDeleted == null ? null : (_tmp_4 = Integer.valueOf(isDeleted != false ? 1 : 0));
                if (_tmp_4 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp_4.intValue());
                }
                _argIndex = 10 + _inputSize + _inputSize_1;
                Integer n4 = isDeleted == null ? null : (_tmp_5 = Integer.valueOf(isDeleted != false ? 1 : 0));
                if (_tmp_5 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp_5.intValue());
                }
                _argIndex = 11 + _inputSize + _inputSize_1;
                _stmt.bindLong(_argIndex, (long)hash);
                _argIndex = 12 + _inputSize + _inputSize_1;
                _stmt.bindLong(_argIndex, (long)nonce);
                _argIndex = 13 + _inputSize + _inputSize_1;
                for (String _item_2 : type2) {
                    if (_item_2 == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindText(_argIndex, _item_2);
                    }
                    ++_argIndex;
                }
                int _columnIndexOfUniqueId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"uniqueId");
                int _columnIndexOfMessageId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messageId");
                int _columnIndexOfSubChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"subChannelId");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfParentId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"parentId");
                int _columnIndexOfChannelSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelSegment");
                int _columnIndexOfChildrenNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"childrenNumber");
                int _columnIndexOfEditedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"editedAt");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfFlagCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flagCount");
                int _columnIndexOfTags = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"tags");
                int _columnIndexOfReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactions");
                int _columnIndexOfReactionCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionCount");
                int _columnIndexOfType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"type");
                int _columnIndexOfData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"data");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfMentionees = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mentionees");
                int _columnIndexOfPii = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pii");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfSyncState = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"syncState");
                int _columnIndexOfMessageMarkerHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messageMarkerHash");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new EkoMessageEntity();
                    String _tmpUniqueId = _stmt.isNull(_columnIndexOfUniqueId) ? null : _stmt.getText(_columnIndexOfUniqueId);
                    _result.setUniqueId(_tmpUniqueId);
                    String _tmpMessageId = _stmt.isNull(_columnIndexOfMessageId) ? null : _stmt.getText(_columnIndexOfMessageId);
                    _result.setMessageId(_tmpMessageId);
                    String _tmpSubChannelId = _stmt.isNull(_columnIndexOfSubChannelId) ? null : _stmt.getText(_columnIndexOfSubChannelId);
                    _result.setSubChannelId(_tmpSubChannelId);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _result.setChannelId(_tmpChannelId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _result.setUserId(_tmpUserId);
                    String _tmpParentId = _stmt.isNull(_columnIndexOfParentId) ? null : _stmt.getText(_columnIndexOfParentId);
                    _result.setParentId(_tmpParentId);
                    int _tmpChannelSegment = (int)_stmt.getLong(_columnIndexOfChannelSegment);
                    _result.setChannelSegment(_tmpChannelSegment);
                    int _tmpChildrenNumber = (int)_stmt.getLong(_columnIndexOfChildrenNumber);
                    _result.setChildrenNumber(_tmpChildrenNumber);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfEditedAt) ? null : _stmt.getText(_columnIndexOfEditedAt);
                    DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                    _result.setEditedAt(_tmpEditedAt);
                    int _tmp_7 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_7 != 0;
                    _result.setDeleted(_tmpIsDeleted);
                    int _tmpFlagCount = (int)_stmt.getLong(_columnIndexOfFlagCount);
                    _result.setFlagCount(_tmpFlagCount);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfTags) ? null : _stmt.getText(_columnIndexOfTags);
                    AmityTags _tmpTags = this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_8);
                    _result.setTags(_tmpTags);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfReactions) ? null : _stmt.getText(_columnIndexOfReactions);
                    AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_9);
                    _result.setReactions(_tmpReactions);
                    int _tmpReactionCount = (int)_stmt.getLong(_columnIndexOfReactionCount);
                    _result.setReactionCount(_tmpReactionCount);
                    String _tmpType = _stmt.isNull(_columnIndexOfType) ? null : _stmt.getText(_columnIndexOfType);
                    _result.setType(_tmpType);
                    String _tmp_10 = _stmt.isNull(_columnIndexOfData) ? null : _stmt.getText(_columnIndexOfData);
                    JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_10);
                    _result.setData(_tmpData);
                    String _tmp_11 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_11);
                    _result.setMetadata(_tmpMetadata);
                    String _tmp_12 = _stmt.isNull(_columnIndexOfMentionees) ? null : _stmt.getText(_columnIndexOfMentionees);
                    List<EkoMentioneesDto> _tmpMentionees = this.__mentioneesConverter.jsonToMentionees(_tmp_12);
                    _result.setMentionees(_tmpMentionees);
                    String _tmp_13 = _stmt.isNull(_columnIndexOfPii) ? null : _stmt.getText(_columnIndexOfPii);
                    JsonArray _tmpPii = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_13);
                    _result.setPii(_tmpPii);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _result.setPath(_tmpPath);
                    String _tmpSyncState = _stmt.isNull(_columnIndexOfSyncState) ? null : _stmt.getText(_columnIndexOfSyncState);
                    _result.setSyncState(_tmpSyncState);
                    int _tmpMessageMarkerHash = (int)_stmt.getLong(_columnIndexOfMessageMarkerHash);
                    _result.setMessageMarkerHash(_tmpMessageMarkerHash);
                    String _tmp_14 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_14);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_15 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_15);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_16 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_16);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                EkoMessageEntity ekoMessageEntity = _result;
                return ekoMessageEntity;
            }
        });
    }

    @Override
    public List<EkoMessageEntity> getCacheBeforeMessageIdImpl(String messageId) {
        String _sql = "SELECT * FROM message WHERE createdAt < (SELECT createdAt FROM message WHERE messageId = ?) ORDER BY createdAt DESC LIMIT 20";
        return (List)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * FROM message WHERE createdAt < (SELECT createdAt FROM message WHERE messageId = ?) ORDER BY createdAt DESC LIMIT 20");){
                int _argIndex = 1;
                if (messageId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, messageId);
                }
                int _columnIndexOfUniqueId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"uniqueId");
                int _columnIndexOfMessageId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messageId");
                int _columnIndexOfSubChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"subChannelId");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfParentId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"parentId");
                int _columnIndexOfChannelSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelSegment");
                int _columnIndexOfChildrenNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"childrenNumber");
                int _columnIndexOfEditedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"editedAt");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfFlagCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flagCount");
                int _columnIndexOfTags = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"tags");
                int _columnIndexOfReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactions");
                int _columnIndexOfReactionCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionCount");
                int _columnIndexOfType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"type");
                int _columnIndexOfData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"data");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfMentionees = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mentionees");
                int _columnIndexOfPii = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pii");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfSyncState = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"syncState");
                int _columnIndexOfMessageMarkerHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messageMarkerHash");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<EkoMessageEntity> _result = new ArrayList<EkoMessageEntity>();
                while (_stmt.step()) {
                    EkoMessageEntity _item = new EkoMessageEntity();
                    String _tmpUniqueId = _stmt.isNull(_columnIndexOfUniqueId) ? null : _stmt.getText(_columnIndexOfUniqueId);
                    _item.setUniqueId(_tmpUniqueId);
                    String _tmpMessageId = _stmt.isNull(_columnIndexOfMessageId) ? null : _stmt.getText(_columnIndexOfMessageId);
                    _item.setMessageId(_tmpMessageId);
                    String _tmpSubChannelId = _stmt.isNull(_columnIndexOfSubChannelId) ? null : _stmt.getText(_columnIndexOfSubChannelId);
                    _item.setSubChannelId(_tmpSubChannelId);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _item.setChannelId(_tmpChannelId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _item.setUserId(_tmpUserId);
                    String _tmpParentId = _stmt.isNull(_columnIndexOfParentId) ? null : _stmt.getText(_columnIndexOfParentId);
                    _item.setParentId(_tmpParentId);
                    int _tmpChannelSegment = (int)_stmt.getLong(_columnIndexOfChannelSegment);
                    _item.setChannelSegment(_tmpChannelSegment);
                    int _tmpChildrenNumber = (int)_stmt.getLong(_columnIndexOfChildrenNumber);
                    _item.setChildrenNumber(_tmpChildrenNumber);
                    String _tmp = _stmt.isNull(_columnIndexOfEditedAt) ? null : _stmt.getText(_columnIndexOfEditedAt);
                    DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _item.setEditedAt(_tmpEditedAt);
                    int _tmp_1 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_1 != 0;
                    _item.setDeleted(_tmpIsDeleted);
                    int _tmpFlagCount = (int)_stmt.getLong(_columnIndexOfFlagCount);
                    _item.setFlagCount(_tmpFlagCount);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfTags) ? null : _stmt.getText(_columnIndexOfTags);
                    AmityTags _tmpTags = this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_2);
                    _item.setTags(_tmpTags);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfReactions) ? null : _stmt.getText(_columnIndexOfReactions);
                    AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_3);
                    _item.setReactions(_tmpReactions);
                    int _tmpReactionCount = (int)_stmt.getLong(_columnIndexOfReactionCount);
                    _item.setReactionCount(_tmpReactionCount);
                    String _tmpType = _stmt.isNull(_columnIndexOfType) ? null : _stmt.getText(_columnIndexOfType);
                    _item.setType(_tmpType);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfData) ? null : _stmt.getText(_columnIndexOfData);
                    JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                    _item.setData(_tmpData);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_5);
                    _item.setMetadata(_tmpMetadata);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfMentionees) ? null : _stmt.getText(_columnIndexOfMentionees);
                    List<EkoMentioneesDto> _tmpMentionees = this.__mentioneesConverter.jsonToMentionees(_tmp_6);
                    _item.setMentionees(_tmpMentionees);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfPii) ? null : _stmt.getText(_columnIndexOfPii);
                    JsonArray _tmpPii = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_7);
                    _item.setPii(_tmpPii);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _item.setPath(_tmpPath);
                    String _tmpSyncState = _stmt.isNull(_columnIndexOfSyncState) ? null : _stmt.getText(_columnIndexOfSyncState);
                    _item.setSyncState(_tmpSyncState);
                    int _tmpMessageMarkerHash = (int)_stmt.getLong(_columnIndexOfMessageMarkerHash);
                    _item.setMessageMarkerHash(_tmpMessageMarkerHash);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                    _item.setCreatedAt(_tmpCreatedAt);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                    _item.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_10 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                    _item.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item);
                }
                ArrayList<EkoMessageEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public List<EkoMessageEntity> getCacheAfterMessageIdImpl(String messageId) {
        String _sql = "SELECT * FROM message WHERE createdAt > (SELECT createdAt FROM message WHERE messageId = ?) ORDER BY createdAt ASC LIMIT 20";
        return (List)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * FROM message WHERE createdAt > (SELECT createdAt FROM message WHERE messageId = ?) ORDER BY createdAt ASC LIMIT 20");){
                int _argIndex = 1;
                if (messageId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, messageId);
                }
                int _columnIndexOfUniqueId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"uniqueId");
                int _columnIndexOfMessageId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messageId");
                int _columnIndexOfSubChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"subChannelId");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfParentId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"parentId");
                int _columnIndexOfChannelSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelSegment");
                int _columnIndexOfChildrenNumber = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"childrenNumber");
                int _columnIndexOfEditedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"editedAt");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfFlagCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flagCount");
                int _columnIndexOfTags = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"tags");
                int _columnIndexOfReactions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactions");
                int _columnIndexOfReactionCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"reactionCount");
                int _columnIndexOfType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"type");
                int _columnIndexOfData = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"data");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfMentionees = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mentionees");
                int _columnIndexOfPii = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pii");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfSyncState = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"syncState");
                int _columnIndexOfMessageMarkerHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messageMarkerHash");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<EkoMessageEntity> _result = new ArrayList<EkoMessageEntity>();
                while (_stmt.step()) {
                    EkoMessageEntity _item = new EkoMessageEntity();
                    String _tmpUniqueId = _stmt.isNull(_columnIndexOfUniqueId) ? null : _stmt.getText(_columnIndexOfUniqueId);
                    _item.setUniqueId(_tmpUniqueId);
                    String _tmpMessageId = _stmt.isNull(_columnIndexOfMessageId) ? null : _stmt.getText(_columnIndexOfMessageId);
                    _item.setMessageId(_tmpMessageId);
                    String _tmpSubChannelId = _stmt.isNull(_columnIndexOfSubChannelId) ? null : _stmt.getText(_columnIndexOfSubChannelId);
                    _item.setSubChannelId(_tmpSubChannelId);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _item.setChannelId(_tmpChannelId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _item.setUserId(_tmpUserId);
                    String _tmpParentId = _stmt.isNull(_columnIndexOfParentId) ? null : _stmt.getText(_columnIndexOfParentId);
                    _item.setParentId(_tmpParentId);
                    int _tmpChannelSegment = (int)_stmt.getLong(_columnIndexOfChannelSegment);
                    _item.setChannelSegment(_tmpChannelSegment);
                    int _tmpChildrenNumber = (int)_stmt.getLong(_columnIndexOfChildrenNumber);
                    _item.setChildrenNumber(_tmpChildrenNumber);
                    String _tmp = _stmt.isNull(_columnIndexOfEditedAt) ? null : _stmt.getText(_columnIndexOfEditedAt);
                    DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _item.setEditedAt(_tmpEditedAt);
                    int _tmp_1 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_1 != 0;
                    _item.setDeleted(_tmpIsDeleted);
                    int _tmpFlagCount = (int)_stmt.getLong(_columnIndexOfFlagCount);
                    _item.setFlagCount(_tmpFlagCount);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfTags) ? null : _stmt.getText(_columnIndexOfTags);
                    AmityTags _tmpTags = this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_2);
                    _item.setTags(_tmpTags);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfReactions) ? null : _stmt.getText(_columnIndexOfReactions);
                    AmityReactionMap _tmpReactions = this.__ekoReactionMapConverter.stringToStringIntMap(_tmp_3);
                    _item.setReactions(_tmpReactions);
                    int _tmpReactionCount = (int)_stmt.getLong(_columnIndexOfReactionCount);
                    _item.setReactionCount(_tmpReactionCount);
                    String _tmpType = _stmt.isNull(_columnIndexOfType) ? null : _stmt.getText(_columnIndexOfType);
                    _item.setType(_tmpType);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfData) ? null : _stmt.getText(_columnIndexOfData);
                    JsonObject _tmpData = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                    _item.setData(_tmpData);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_5);
                    _item.setMetadata(_tmpMetadata);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfMentionees) ? null : _stmt.getText(_columnIndexOfMentionees);
                    List<EkoMentioneesDto> _tmpMentionees = this.__mentioneesConverter.jsonToMentionees(_tmp_6);
                    _item.setMentionees(_tmpMentionees);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfPii) ? null : _stmt.getText(_columnIndexOfPii);
                    JsonArray _tmpPii = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_7);
                    _item.setPii(_tmpPii);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _item.setPath(_tmpPath);
                    String _tmpSyncState = _stmt.isNull(_columnIndexOfSyncState) ? null : _stmt.getText(_columnIndexOfSyncState);
                    _item.setSyncState(_tmpSyncState);
                    int _tmpMessageMarkerHash = (int)_stmt.getLong(_columnIndexOfMessageMarkerHash);
                    _item.setMessageMarkerHash(_tmpMessageMarkerHash);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                    _item.setCreatedAt(_tmpCreatedAt);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                    _item.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_10 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                    _item.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item);
                }
                ArrayList<EkoMessageEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "DELETE from message";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from message");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @Override
    public void cleanUpSyncingStateOnStartup() {
        String _sql = "UPDATE message set syncState = 'failed' where syncState = 'syncing'";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE message set syncState = 'failed' where syncState = 'syncing'");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @Override
    public void cleanUpUploadingStateOnStartup() {
        String _sql = "UPDATE message set syncState = 'failed' where syncState = 'uploading'";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE message set syncState = 'failed' where syncState = 'uploading'");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @Override
    public void cleanUpFailedMessages() {
        String _sql = "DELETE from message where syncState = 'failed'";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from message where syncState = 'failed'");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @Override
    public Completable updateSyncState(String messageId, String state) {
        String _sql = "UPDATE message set syncState = ? where messageId = ?";
        return RxRoom.createCompletable((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE message set syncState = ? where messageId = ?");){
                int _argIndex = 1;
                if (state == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, state);
                }
                _argIndex = 2;
                if (messageId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, messageId);
                }
                _stmt.step();
                Unit unit = Unit.INSTANCE;
                return unit;
            }
        });
    }

    @Override
    public void deleteAllFromChannel(String channelId) {
        String _sql = "DELETE from message where channelId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from message where channelId = ?");){
                int _argIndex = 1;
                if (channelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, channelId);
                }
                _stmt.step();
                Object var4_4 = null;
                return var4_4;
            }
        });
    }

    @Override
    public Completable hardDeleteMessage(String messageId) {
        String _sql = "DELETE from message where messageId = ?";
        return RxRoom.createCompletable((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from message where messageId = ?");){
                int _argIndex = 1;
                if (messageId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, messageId);
                }
                _stmt.step();
                Unit unit = Unit.INSTANCE;
                return unit;
            }
        });
    }

    @Override
    public void hardDeleteAllFromChannel(String channelId) {
        String _sql = "DELETE from message where channelId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from message where channelId = ?");){
                int _argIndex = 1;
                if (channelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, channelId);
                }
                _stmt.step();
                Object var4_4 = null;
                return var4_4;
            }
        });
    }

    @Override
    public void softDeleteFromChannelByUserIdImpl(String channelId, String userId) {
        String _sql = "UPDATE message set isDeleted = 1, data = null where channelId = ? and userId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE message set isDeleted = 1, data = null where channelId = ? and userId = ?");){
                int _argIndex = 1;
                if (channelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, channelId);
                }
                _argIndex = 2;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                _stmt.step();
                Object var5_5 = null;
                return var5_5;
            }
        });
    }

    @Override
    public void updateUserImpl(String userId) {
        String _sql = "UPDATE message set userId = ? where userId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE message set userId = ? where userId = ?");){
                int _argIndex = 1;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                _argIndex = 2;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                _stmt.step();
                Object var4_4 = null;
                return var4_4;
            }
        });
    }

    @Override
    public void updateMarkerHash(String messageId, int hash) {
        String _sql = "UPDATE message set messageMarkerHash = ? where messageId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE message set messageMarkerHash = ? where messageId = ?");){
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, (long)hash);
                _argIndex = 2;
                if (messageId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, messageId);
                }
                _stmt.step();
                Object var5_5 = null;
                return var5_5;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

