/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.SQLiteStatement;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoFeedDao;
import com.ekoapp.ekosdk.internal.entity.FeedEntity;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class EkoFeedDao_Impl
extends EkoFeedDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<FeedEntity> __insertAdapterOfFeedEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeleteOrUpdateAdapter<FeedEntity> __deleteAdapterOfFeedEntity;
    private final EntityDeleteOrUpdateAdapter<FeedEntity> __updateAdapterOfFeedEntity;

    public EkoFeedDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfFeedEntity = new EntityInsertAdapter<FeedEntity>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `feed` (`feedId`,`feedType`,`targetId`,`targetType`,`postCount`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull FeedEntity entity) {
                if (entity.getFeedId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getFeedId());
                }
                if (entity.getFeedType() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getFeedType());
                }
                if (entity.getTargetId() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getTargetId());
                }
                if (entity.getTargetType() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getTargetType());
                }
                statement.bindLong(5, (long)entity.getPostCount());
                String _tmp = EkoFeedDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp);
                }
                String _tmp_1 = EkoFeedDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_1 == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, _tmp_1);
                }
                String _tmp_2 = EkoFeedDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_2 == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, _tmp_2);
                }
            }
        };
        this.__deleteAdapterOfFeedEntity = new EntityDeleteOrUpdateAdapter<FeedEntity>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `feed` WHERE `feedId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull FeedEntity entity) {
                if (entity.getFeedId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getFeedId());
                }
            }
        };
        this.__updateAdapterOfFeedEntity = new EntityDeleteOrUpdateAdapter<FeedEntity>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `feed` SET `feedId` = ?,`feedType` = ?,`targetId` = ?,`targetType` = ?,`postCount` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `feedId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull FeedEntity entity) {
                if (entity.getFeedId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getFeedId());
                }
                if (entity.getFeedType() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getFeedType());
                }
                if (entity.getTargetId() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getTargetId());
                }
                if (entity.getTargetType() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getTargetType());
                }
                statement.bindLong(5, (long)entity.getPostCount());
                String _tmp = EkoFeedDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp);
                }
                String _tmp_1 = EkoFeedDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_1 == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, _tmp_1);
                }
                String _tmp_2 = EkoFeedDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_2 == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, _tmp_2);
                }
                if (entity.getFeedId() == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, entity.getFeedId());
                }
            }
        };
    }

    @Override
    public void insertImpl(FeedEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfFeedEntity.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends FeedEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfFeedEntity.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(FeedEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfFeedEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void delete(List<? extends FeedEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfFeedEntity.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void updateImpl(FeedEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfFeedEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(FeedEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoFeedDao_Impl.super.insert(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends FeedEntity> objects) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoFeedDao_Impl.super.insert(objects);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(FeedEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoFeedDao_Impl.super.update(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public FeedEntity getByIdNowImpl(String feedId) {
        String _sql = "SELECT * from feed where feed.feedId = ? LIMIT 1";
        return (FeedEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from feed where feed.feedId = ? LIMIT 1");){
                FeedEntity _result;
                int _argIndex = 1;
                if (feedId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, feedId);
                }
                int _columnIndexOfFeedId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"feedId");
                int _columnIndexOfFeedType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"feedType");
                int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetId");
                int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetType");
                int _columnIndexOfPostCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"postCount");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new FeedEntity();
                    String _tmpFeedId = _stmt.isNull(_columnIndexOfFeedId) ? null : _stmt.getText(_columnIndexOfFeedId);
                    _result.setFeedId(_tmpFeedId);
                    String _tmpFeedType = _stmt.isNull(_columnIndexOfFeedType) ? null : _stmt.getText(_columnIndexOfFeedType);
                    _result.setFeedType(_tmpFeedType);
                    String _tmpTargetId = _stmt.isNull(_columnIndexOfTargetId) ? null : _stmt.getText(_columnIndexOfTargetId);
                    _result.setTargetId(_tmpTargetId);
                    String _tmpTargetType = _stmt.isNull(_columnIndexOfTargetType) ? null : _stmt.getText(_columnIndexOfTargetType);
                    _result.setTargetType(_tmpTargetType);
                    int _tmpPostCount = (int)_stmt.getLong(_columnIndexOfPostCount);
                    _result.setPostCount(_tmpPostCount);
                    String _tmp = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                FeedEntity feedEntity = _result;
                return feedEntity;
            }
        });
    }

    @Override
    public List<FeedEntity> getByIdsNowImpl(List<String> ids) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("SELECT * from feed where feed.feedId IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        return (List)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare(_sql);){
                int _argIndex = 1;
                for (String _item : ids) {
                    if (_item == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindText(_argIndex, _item);
                    }
                    ++_argIndex;
                }
                int _columnIndexOfFeedId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"feedId");
                int _columnIndexOfFeedType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"feedType");
                int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetId");
                int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetType");
                int _columnIndexOfPostCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"postCount");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<FeedEntity> _result = new ArrayList<FeedEntity>();
                while (_stmt.step()) {
                    FeedEntity _item_1 = new FeedEntity();
                    String _tmpFeedId = _stmt.isNull(_columnIndexOfFeedId) ? null : _stmt.getText(_columnIndexOfFeedId);
                    _item_1.setFeedId(_tmpFeedId);
                    String _tmpFeedType = _stmt.isNull(_columnIndexOfFeedType) ? null : _stmt.getText(_columnIndexOfFeedType);
                    _item_1.setFeedType(_tmpFeedType);
                    String _tmpTargetId = _stmt.isNull(_columnIndexOfTargetId) ? null : _stmt.getText(_columnIndexOfTargetId);
                    _item_1.setTargetId(_tmpTargetId);
                    String _tmpTargetType = _stmt.isNull(_columnIndexOfTargetType) ? null : _stmt.getText(_columnIndexOfTargetType);
                    _item_1.setTargetType(_tmpTargetType);
                    int _tmpPostCount = (int)_stmt.getLong(_columnIndexOfPostCount);
                    _item_1.setPostCount(_tmpPostCount);
                    String _tmp = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _item_1.setCreatedAt(_tmpCreatedAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _item_1.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _item_1.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item_1);
                }
                ArrayList<FeedEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public Flowable<FeedEntity> getCommunityFeedImpl(String targetId, String feedType) {
        String _sql = "SELECT * from feed where feed.targetId = ? and feed.feedType = ?";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"feed"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from feed where feed.targetId = ? and feed.feedType = ?");){
                FeedEntity _result;
                int _argIndex = 1;
                if (targetId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, targetId);
                }
                _argIndex = 2;
                if (feedType == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, feedType);
                }
                int _columnIndexOfFeedId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"feedId");
                int _columnIndexOfFeedType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"feedType");
                int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetId");
                int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetType");
                int _columnIndexOfPostCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"postCount");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new FeedEntity();
                    String _tmpFeedId = _stmt.isNull(_columnIndexOfFeedId) ? null : _stmt.getText(_columnIndexOfFeedId);
                    _result.setFeedId(_tmpFeedId);
                    String _tmpFeedType = _stmt.isNull(_columnIndexOfFeedType) ? null : _stmt.getText(_columnIndexOfFeedType);
                    _result.setFeedType(_tmpFeedType);
                    String _tmpTargetId = _stmt.isNull(_columnIndexOfTargetId) ? null : _stmt.getText(_columnIndexOfTargetId);
                    _result.setTargetId(_tmpTargetId);
                    String _tmpTargetType = _stmt.isNull(_columnIndexOfTargetType) ? null : _stmt.getText(_columnIndexOfTargetType);
                    _result.setTargetType(_tmpTargetType);
                    int _tmpPostCount = (int)_stmt.getLong(_columnIndexOfPostCount);
                    _result.setPostCount(_tmpPostCount);
                    String _tmp = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                FeedEntity feedEntity = _result;
                return feedEntity;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "DELETE from feed";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from feed");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

