/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.SQLiteStatement;
import com.amity.socialcloud.sdk.entity.social.category.CommunityCategoryEntity;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.JsonObjectTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommunityCategoryDao;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class EkoCommunityCategoryDao_Impl
extends EkoCommunityCategoryDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<CommunityCategoryEntity> __insertAdapterOfCommunityCategoryEntity;
    private final JsonObjectTypeConverter __jsonObjectTypeConverter = new JsonObjectTypeConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeleteOrUpdateAdapter<CommunityCategoryEntity> __deleteAdapterOfCommunityCategoryEntity;
    private final EntityDeleteOrUpdateAdapter<CommunityCategoryEntity> __updateAdapterOfCommunityCategoryEntity;

    public EkoCommunityCategoryDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfCommunityCategoryEntity = new EntityInsertAdapter<CommunityCategoryEntity>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `community_category` (`categoryId`,`name`,`avatarFileId`,`metadata`,`isDeleted`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull CommunityCategoryEntity entity) {
                if (entity.getCategoryId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getCategoryId());
                }
                if (entity.getName() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getName());
                }
                if (entity.getAvatarFileId() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getAvatarFileId());
                }
                String _tmp = EkoCommunityCategoryDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(entity.getMetadata());
                if (_tmp == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, _tmp);
                }
                int _tmp_1 = entity.isDeleted() ? 1 : 0;
                statement.bindLong(5, (long)_tmp_1);
                String _tmp_2 = EkoCommunityCategoryDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_2);
                }
                String _tmp_3 = EkoCommunityCategoryDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_3 == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, _tmp_3);
                }
                String _tmp_4 = EkoCommunityCategoryDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_4 == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, _tmp_4);
                }
            }
        };
        this.__deleteAdapterOfCommunityCategoryEntity = new EntityDeleteOrUpdateAdapter<CommunityCategoryEntity>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `community_category` WHERE `categoryId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull CommunityCategoryEntity entity) {
                if (entity.getCategoryId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getCategoryId());
                }
            }
        };
        this.__updateAdapterOfCommunityCategoryEntity = new EntityDeleteOrUpdateAdapter<CommunityCategoryEntity>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `community_category` SET `categoryId` = ?,`name` = ?,`avatarFileId` = ?,`metadata` = ?,`isDeleted` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `categoryId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull CommunityCategoryEntity entity) {
                if (entity.getCategoryId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getCategoryId());
                }
                if (entity.getName() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getName());
                }
                if (entity.getAvatarFileId() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getAvatarFileId());
                }
                String _tmp = EkoCommunityCategoryDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(entity.getMetadata());
                if (_tmp == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, _tmp);
                }
                int _tmp_1 = entity.isDeleted() ? 1 : 0;
                statement.bindLong(5, (long)_tmp_1);
                String _tmp_2 = EkoCommunityCategoryDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_2);
                }
                String _tmp_3 = EkoCommunityCategoryDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_3 == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, _tmp_3);
                }
                String _tmp_4 = EkoCommunityCategoryDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_4 == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, _tmp_4);
                }
                if (entity.getCategoryId() == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, entity.getCategoryId());
                }
            }
        };
    }

    @Override
    public void insertImpl(CommunityCategoryEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfCommunityCategoryEntity.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends CommunityCategoryEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfCommunityCategoryEntity.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(List<? extends CommunityCategoryEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfCommunityCategoryEntity.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(CommunityCategoryEntity category) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfCommunityCategoryEntity.handle(_connection, (Object)category);
            return null;
        });
    }

    @Override
    public void updateImpl(CommunityCategoryEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfCommunityCategoryEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(CommunityCategoryEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoCommunityCategoryDao_Impl.super.insert(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends CommunityCategoryEntity> objects) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoCommunityCategoryDao_Impl.super.insert(objects);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(CommunityCategoryEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoCommunityCategoryDao_Impl.super.update(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    CommunityCategoryEntity getByIdNowImpl(String id) {
        String _sql = "SELECT * from community_category where community_category.categoryId = (?)";
        return (CommunityCategoryEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from community_category where community_category.categoryId = (?)");){
                CommunityCategoryEntity _result;
                int _argIndex = 1;
                if (id == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, id);
                }
                int _columnIndexOfCategoryId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"categoryId");
                int _columnIndexOfName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"name");
                int _columnIndexOfAvatarFileId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"avatarFileId");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new CommunityCategoryEntity();
                    String _tmpCategoryId = _stmt.isNull(_columnIndexOfCategoryId) ? null : _stmt.getText(_columnIndexOfCategoryId);
                    _result.setCategoryId(_tmpCategoryId);
                    String _tmpName = _stmt.isNull(_columnIndexOfName) ? null : _stmt.getText(_columnIndexOfName);
                    _result.setName(_tmpName);
                    String _tmpAvatarFileId = _stmt.isNull(_columnIndexOfAvatarFileId) ? null : _stmt.getText(_columnIndexOfAvatarFileId);
                    _result.setAvatarFileId(_tmpAvatarFileId);
                    String _tmp = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                    _result.setMetadata(_tmpMetadata);
                    int _tmp_1 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_1 != 0;
                    _result.setDeleted(_tmpIsDeleted);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                CommunityCategoryEntity communityCategoryEntity = _result;
                return communityCategoryEntity;
            }
        });
    }

    @Override
    Flowable<CommunityCategoryEntity> observeByIdImpl(String id) {
        String _sql = "SELECT * from community_category where community_category.categoryId = (?)";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"community_category"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from community_category where community_category.categoryId = (?)");){
                CommunityCategoryEntity _result;
                int _argIndex = 1;
                if (id == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, id);
                }
                int _columnIndexOfCategoryId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"categoryId");
                int _columnIndexOfName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"name");
                int _columnIndexOfAvatarFileId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"avatarFileId");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new CommunityCategoryEntity();
                    String _tmpCategoryId = _stmt.isNull(_columnIndexOfCategoryId) ? null : _stmt.getText(_columnIndexOfCategoryId);
                    _result.setCategoryId(_tmpCategoryId);
                    String _tmpName = _stmt.isNull(_columnIndexOfName) ? null : _stmt.getText(_columnIndexOfName);
                    _result.setName(_tmpName);
                    String _tmpAvatarFileId = _stmt.isNull(_columnIndexOfAvatarFileId) ? null : _stmt.getText(_columnIndexOfAvatarFileId);
                    _result.setAvatarFileId(_tmpAvatarFileId);
                    String _tmp = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                    _result.setMetadata(_tmpMetadata);
                    int _tmp_1 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_1 != 0;
                    _result.setDeleted(_tmpIsDeleted);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                CommunityCategoryEntity communityCategoryEntity = _result;
                return communityCategoryEntity;
            }
        });
    }

    @Override
    List<CommunityCategoryEntity> getByIdsNowImpl(List<String> ids) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("SELECT * from community_category where community_category.categoryId IN (");
        int _inputSize = ids == null ? 1 : ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        return (List)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare(_sql);){
                int _argIndex = 1;
                if (ids == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    for (String _item : ids) {
                        if (_item == null) {
                            _stmt.bindNull(_argIndex);
                        } else {
                            _stmt.bindText(_argIndex, _item);
                        }
                        ++_argIndex;
                    }
                }
                int _columnIndexOfCategoryId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"categoryId");
                int _columnIndexOfName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"name");
                int _columnIndexOfAvatarFileId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"avatarFileId");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<CommunityCategoryEntity> _result = new ArrayList<CommunityCategoryEntity>();
                while (_stmt.step()) {
                    CommunityCategoryEntity _item_1 = new CommunityCategoryEntity();
                    String _tmpCategoryId = _stmt.isNull(_columnIndexOfCategoryId) ? null : _stmt.getText(_columnIndexOfCategoryId);
                    _item_1.setCategoryId(_tmpCategoryId);
                    String _tmpName = _stmt.isNull(_columnIndexOfName) ? null : _stmt.getText(_columnIndexOfName);
                    _item_1.setName(_tmpName);
                    String _tmpAvatarFileId = _stmt.isNull(_columnIndexOfAvatarFileId) ? null : _stmt.getText(_columnIndexOfAvatarFileId);
                    _item_1.setAvatarFileId(_tmpAvatarFileId);
                    String _tmp = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                    _item_1.setMetadata(_tmpMetadata);
                    int _tmp_1 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_1 != 0;
                    _item_1.setDeleted(_tmpIsDeleted);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _item_1.setCreatedAt(_tmpCreatedAt);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _item_1.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _item_1.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item_1);
                }
                ArrayList<CommunityCategoryEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    Flowable<CommunityCategoryEntity> getLatestCategoryImpl(Boolean isDeleted, int hash, int nonce, DateTime now) {
        String _sql = "SELECT * from community_category where community_category.isDeleted = (case when ? is null then isDeleted else ? end) and community_category.updatedAt > ? and community_category.categoryId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (?) and amity_paging_id.nonce = (?) ) order by community_category.updatedAt  desc limit 1";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"community_category", "amity_paging_id"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from community_category where community_category.isDeleted = (case when ? is null then isDeleted else ? end) and community_category.updatedAt > ? and community_category.categoryId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (?) and amity_paging_id.nonce = (?) ) order by community_category.updatedAt  desc limit 1");){
                CommunityCategoryEntity _result;
                Integer _tmp_1;
                Integer _tmp;
                int _argIndex = 1;
                Integer n = isDeleted == null ? null : (_tmp = Integer.valueOf(isDeleted != false ? 1 : 0));
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp.intValue());
                }
                _argIndex = 2;
                Integer n2 = isDeleted == null ? null : (_tmp_1 = Integer.valueOf(isDeleted != false ? 1 : 0));
                if (_tmp_1 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp_1.intValue());
                }
                _argIndex = 3;
                String _tmp_2 = this.__dateTimeTypeConverter.dateTimeToString(now);
                if (_tmp_2 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, _tmp_2);
                }
                _argIndex = 4;
                _stmt.bindLong(_argIndex, (long)hash);
                _argIndex = 5;
                _stmt.bindLong(_argIndex, (long)nonce);
                int _columnIndexOfCategoryId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"categoryId");
                int _columnIndexOfName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"name");
                int _columnIndexOfAvatarFileId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"avatarFileId");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new CommunityCategoryEntity();
                    String _tmpCategoryId = _stmt.isNull(_columnIndexOfCategoryId) ? null : _stmt.getText(_columnIndexOfCategoryId);
                    _result.setCategoryId(_tmpCategoryId);
                    String _tmpName = _stmt.isNull(_columnIndexOfName) ? null : _stmt.getText(_columnIndexOfName);
                    _result.setName(_tmpName);
                    String _tmpAvatarFileId = _stmt.isNull(_columnIndexOfAvatarFileId) ? null : _stmt.getText(_columnIndexOfAvatarFileId);
                    _result.setAvatarFileId(_tmpAvatarFileId);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_3);
                    _result.setMetadata(_tmpMetadata);
                    int _tmp_4 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_4 != 0;
                    _result.setDeleted(_tmpIsDeleted);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                CommunityCategoryEntity communityCategoryEntity = _result;
                return communityCategoryEntity;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "DELETE from community_category";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from community_category");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

