/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.SQLiteStatement;
import com.amity.socialcloud.sdk.model.core.tag.AmityTags;
import com.ekoapp.ekosdk.EkoChannelExtra;
import com.ekoapp.ekosdk.EkoChannelWithMembershipAndExtra;
import com.ekoapp.ekosdk.internal.EkoChannelEntity;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.EkoTagsTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.JsonObjectTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoChannelDao;
import com.ekoapp.ekosdk.internal.entity.ChannelMembershipEntity;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class EkoChannelDao_Impl
extends EkoChannelDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<EkoChannelEntity> __insertAdapterOfEkoChannelEntity;
    private final JsonObjectTypeConverter __jsonObjectTypeConverter = new JsonObjectTypeConverter();
    private final EkoTagsTypeConverter __ekoTagsTypeConverter = new EkoTagsTypeConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeleteOrUpdateAdapter<EkoChannelEntity> __deleteAdapterOfEkoChannelEntity;
    private final EntityDeleteOrUpdateAdapter<EkoChannelEntity> __updateAdapterOfEkoChannelEntity;

    public EkoChannelDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfEkoChannelEntity = new EntityInsertAdapter<EkoChannelEntity>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `channel` (`channelId`,`internalChannelId`,`channelType`,`displayName`,`avatarFileId`,`metadata`,`tags`,`memberCount`,`moderatorMemberCount`,`messageCount`,`isRateLimited`,`isMuted`,`isDeleted`,`lastActivity`,`path`,`channelMarkerHash`,`messagePreviewId`,`isPublic`,`attachedToPostId`,`attachedToVideoStreamId`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull EkoChannelEntity entity) {
                if (entity.getChannelId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getChannelId());
                }
                if (entity.getInternalChannelId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getInternalChannelId());
                }
                if (entity.getChannelType() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getChannelType());
                }
                if (entity.getDisplayName() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getDisplayName());
                }
                if (entity.getAvatarFileId() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, entity.getAvatarFileId());
                }
                String _tmp = EkoChannelDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(entity.getMetadata());
                if (_tmp == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp);
                }
                String _tmp_1 = EkoChannelDao_Impl.this.__ekoTagsTypeConverter.ekoTagsToString(entity.getTags());
                if (_tmp_1 == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, _tmp_1);
                }
                statement.bindLong(8, (long)entity.getMemberCount());
                statement.bindLong(9, (long)entity.getModeratorMemberCount());
                statement.bindLong(10, (long)entity.getMessageCount());
                int _tmp_2 = entity.isRateLimited() ? 1 : 0;
                statement.bindLong(11, (long)_tmp_2);
                int _tmp_3 = entity.isMuted() ? 1 : 0;
                statement.bindLong(12, (long)_tmp_3);
                int _tmp_4 = entity.isDeleted() ? 1 : 0;
                statement.bindLong(13, (long)_tmp_4);
                String _tmp_5 = EkoChannelDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getLastActivity());
                if (_tmp_5 == null) {
                    statement.bindNull(14);
                } else {
                    statement.bindText(14, _tmp_5);
                }
                if (entity.getPath() == null) {
                    statement.bindNull(15);
                } else {
                    statement.bindText(15, entity.getPath());
                }
                statement.bindLong(16, (long)entity.getChannelMarkerHash());
                if (entity.getMessagePreviewId() == null) {
                    statement.bindNull(17);
                } else {
                    statement.bindText(17, entity.getMessagePreviewId());
                }
                int _tmp_6 = entity.isPublic() ? 1 : 0;
                statement.bindLong(18, (long)_tmp_6);
                if (entity.getAttachedToPostId() == null) {
                    statement.bindNull(19);
                } else {
                    statement.bindText(19, entity.getAttachedToPostId());
                }
                if (entity.getAttachedToVideoStreamId() == null) {
                    statement.bindNull(20);
                } else {
                    statement.bindText(20, entity.getAttachedToVideoStreamId());
                }
                String _tmp_7 = EkoChannelDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_7 == null) {
                    statement.bindNull(21);
                } else {
                    statement.bindText(21, _tmp_7);
                }
                String _tmp_8 = EkoChannelDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_8 == null) {
                    statement.bindNull(22);
                } else {
                    statement.bindText(22, _tmp_8);
                }
                String _tmp_9 = EkoChannelDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_9 == null) {
                    statement.bindNull(23);
                } else {
                    statement.bindText(23, _tmp_9);
                }
            }
        };
        this.__deleteAdapterOfEkoChannelEntity = new EntityDeleteOrUpdateAdapter<EkoChannelEntity>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `channel` WHERE `channelId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull EkoChannelEntity entity) {
                if (entity.getChannelId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getChannelId());
                }
            }
        };
        this.__updateAdapterOfEkoChannelEntity = new EntityDeleteOrUpdateAdapter<EkoChannelEntity>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `channel` SET `channelId` = ?,`internalChannelId` = ?,`channelType` = ?,`displayName` = ?,`avatarFileId` = ?,`metadata` = ?,`tags` = ?,`memberCount` = ?,`moderatorMemberCount` = ?,`messageCount` = ?,`isRateLimited` = ?,`isMuted` = ?,`isDeleted` = ?,`lastActivity` = ?,`path` = ?,`channelMarkerHash` = ?,`messagePreviewId` = ?,`isPublic` = ?,`attachedToPostId` = ?,`attachedToVideoStreamId` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `channelId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull EkoChannelEntity entity) {
                if (entity.getChannelId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getChannelId());
                }
                if (entity.getInternalChannelId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getInternalChannelId());
                }
                if (entity.getChannelType() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getChannelType());
                }
                if (entity.getDisplayName() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getDisplayName());
                }
                if (entity.getAvatarFileId() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, entity.getAvatarFileId());
                }
                String _tmp = EkoChannelDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(entity.getMetadata());
                if (_tmp == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp);
                }
                String _tmp_1 = EkoChannelDao_Impl.this.__ekoTagsTypeConverter.ekoTagsToString(entity.getTags());
                if (_tmp_1 == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, _tmp_1);
                }
                statement.bindLong(8, (long)entity.getMemberCount());
                statement.bindLong(9, (long)entity.getModeratorMemberCount());
                statement.bindLong(10, (long)entity.getMessageCount());
                int _tmp_2 = entity.isRateLimited() ? 1 : 0;
                statement.bindLong(11, (long)_tmp_2);
                int _tmp_3 = entity.isMuted() ? 1 : 0;
                statement.bindLong(12, (long)_tmp_3);
                int _tmp_4 = entity.isDeleted() ? 1 : 0;
                statement.bindLong(13, (long)_tmp_4);
                String _tmp_5 = EkoChannelDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getLastActivity());
                if (_tmp_5 == null) {
                    statement.bindNull(14);
                } else {
                    statement.bindText(14, _tmp_5);
                }
                if (entity.getPath() == null) {
                    statement.bindNull(15);
                } else {
                    statement.bindText(15, entity.getPath());
                }
                statement.bindLong(16, (long)entity.getChannelMarkerHash());
                if (entity.getMessagePreviewId() == null) {
                    statement.bindNull(17);
                } else {
                    statement.bindText(17, entity.getMessagePreviewId());
                }
                int _tmp_6 = entity.isPublic() ? 1 : 0;
                statement.bindLong(18, (long)_tmp_6);
                if (entity.getAttachedToPostId() == null) {
                    statement.bindNull(19);
                } else {
                    statement.bindText(19, entity.getAttachedToPostId());
                }
                if (entity.getAttachedToVideoStreamId() == null) {
                    statement.bindNull(20);
                } else {
                    statement.bindText(20, entity.getAttachedToVideoStreamId());
                }
                String _tmp_7 = EkoChannelDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_7 == null) {
                    statement.bindNull(21);
                } else {
                    statement.bindText(21, _tmp_7);
                }
                String _tmp_8 = EkoChannelDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_8 == null) {
                    statement.bindNull(22);
                } else {
                    statement.bindText(22, _tmp_8);
                }
                String _tmp_9 = EkoChannelDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_9 == null) {
                    statement.bindNull(23);
                } else {
                    statement.bindText(23, _tmp_9);
                }
                if (entity.getChannelId() == null) {
                    statement.bindNull(24);
                } else {
                    statement.bindText(24, entity.getChannelId());
                }
            }
        };
    }

    @Override
    public void insertImpl(EkoChannelEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfEkoChannelEntity.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends EkoChannelEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfEkoChannelEntity.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(EkoChannelEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfEkoChannelEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void delete(List<? extends EkoChannelEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfEkoChannelEntity.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void updateImpl(EkoChannelEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfEkoChannelEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(EkoChannelEntity channel) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoChannelDao_Impl.super.insert(channel);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends EkoChannelEntity> channels) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoChannelDao_Impl.super.insert(channels);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(EkoChannelEntity channel) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoChannelDao_Impl.super.update(channel);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void deleteById(String channelId) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoChannelDao_Impl.super.deleteById(channelId);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void deleteAllLocallyInactiveChannelsAndUpdateAllActiveChannelsToNotReading() {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoChannelDao_Impl.super.deleteAllLocallyInactiveChannelsAndUpdateAllActiveChannelsToNotReading();
            return Unit.INSTANCE;
        });
    }

    @Override
    public Flowable<List<EkoChannelWithMembershipAndExtra>> getAllJoinedChannelsImpl(String userId, String membership) {
        String _sql = "SELECT channel.*, channel_membership.readToSegment as membership_readToSegment, channel_extra.localReadToSegment as extra_localReadToSegment, channel_membership.lastMentionedSegment as membership_lastMentionedSegment, channel_extra.localLastMentionedSegment as extra_localLastMentionedSegment from channel, channel_membership, channel_extra where channel.channelId = channel_membership.channelId and channel.channelId = channel_extra.channelId and channel.channelId in (SELECT channelId from channel_membership where membership = ?) and channel_membership.userId = ?";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"channel", "channel_membership", "channel_extra"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT channel.*, channel_membership.readToSegment as membership_readToSegment, channel_extra.localReadToSegment as extra_localReadToSegment, channel_membership.lastMentionedSegment as membership_lastMentionedSegment, channel_extra.localLastMentionedSegment as extra_localLastMentionedSegment from channel, channel_membership, channel_extra where channel.channelId = channel_membership.channelId and channel.channelId = channel_extra.channelId and channel.channelId in (SELECT channelId from channel_membership where membership = ?) and channel_membership.userId = ?");){
                int _argIndex = 1;
                if (membership == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, membership);
                }
                _argIndex = 2;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfInternalChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"internalChannelId");
                int _columnIndexOfChannelType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelType");
                int _columnIndexOfDisplayName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"displayName");
                int _columnIndexOfAvatarFileId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"avatarFileId");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfTags = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"tags");
                int _columnIndexOfMemberCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"memberCount");
                int _columnIndexOfModeratorMemberCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"moderatorMemberCount");
                int _columnIndexOfMessageCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messageCount");
                int _columnIndexOfIsRateLimited = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isRateLimited");
                int _columnIndexOfIsMuted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isMuted");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfLastActivity = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastActivity");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfChannelMarkerHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelMarkerHash");
                int _columnIndexOfMessagePreviewId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messagePreviewId");
                int _columnIndexOfIsPublic = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isPublic");
                int _columnIndexOfAttachedToPostId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"attachedToPostId");
                int _columnIndexOfAttachedToVideoStreamId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"attachedToVideoStreamId");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                int _columnIndexOfReadToSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"membership_readToSegment");
                int _columnIndexOfLocalReadToSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"extra_localReadToSegment");
                int _columnIndexOfLastMentionedSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"membership_lastMentionedSegment");
                int _columnIndexOfLocalLastMentionedSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"extra_localLastMentionedSegment");
                ArrayList<EkoChannelWithMembershipAndExtra> _result = new ArrayList<EkoChannelWithMembershipAndExtra>();
                while (_stmt.step()) {
                    EkoChannelExtra _tmpChannelExtra;
                    ChannelMembershipEntity _tmpChannelMembership;
                    if (!_stmt.isNull(_columnIndexOfReadToSegment) || !_stmt.isNull(_columnIndexOfLastMentionedSegment)) {
                        _tmpChannelMembership = new ChannelMembershipEntity();
                        int _tmpReadToSegment = (int)_stmt.getLong(_columnIndexOfReadToSegment);
                        _tmpChannelMembership.setReadToSegment(_tmpReadToSegment);
                        int _tmpLastMentionedSegment = (int)_stmt.getLong(_columnIndexOfLastMentionedSegment);
                        _tmpChannelMembership.setLastMentionedSegment(_tmpLastMentionedSegment);
                    } else {
                        _tmpChannelMembership = null;
                    }
                    if (!_stmt.isNull(_columnIndexOfLocalReadToSegment) || !_stmt.isNull(_columnIndexOfLocalLastMentionedSegment)) {
                        _tmpChannelExtra = new EkoChannelExtra(null);
                        int _tmpLocalReadToSegment = (int)_stmt.getLong(_columnIndexOfLocalReadToSegment);
                        _tmpChannelExtra.setLocalReadToSegment(_tmpLocalReadToSegment);
                        int _tmpLocalLastMentionedSegment = (int)_stmt.getLong(_columnIndexOfLocalLastMentionedSegment);
                        _tmpChannelExtra.setLocalLastMentionedSegment(_tmpLocalLastMentionedSegment);
                    } else {
                        _tmpChannelExtra = null;
                    }
                    EkoChannelWithMembershipAndExtra _item = new EkoChannelWithMembershipAndExtra();
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _item.setChannelId(_tmpChannelId);
                    String _tmpInternalChannelId = _stmt.isNull(_columnIndexOfInternalChannelId) ? null : _stmt.getText(_columnIndexOfInternalChannelId);
                    _item.setInternalChannelId(_tmpInternalChannelId);
                    String _tmpChannelType = _stmt.isNull(_columnIndexOfChannelType) ? null : _stmt.getText(_columnIndexOfChannelType);
                    _item.setChannelType(_tmpChannelType);
                    String _tmpDisplayName = _stmt.isNull(_columnIndexOfDisplayName) ? null : _stmt.getText(_columnIndexOfDisplayName);
                    _item.setDisplayName(_tmpDisplayName);
                    String _tmpAvatarFileId = _stmt.isNull(_columnIndexOfAvatarFileId) ? null : _stmt.getText(_columnIndexOfAvatarFileId);
                    _item.setAvatarFileId(_tmpAvatarFileId);
                    String _tmp = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                    _item.setMetadata(_tmpMetadata);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfTags) ? null : _stmt.getText(_columnIndexOfTags);
                    AmityTags _tmpTags = this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_1);
                    _item.setTags(_tmpTags);
                    int _tmpMemberCount = (int)_stmt.getLong(_columnIndexOfMemberCount);
                    _item.setMemberCount(_tmpMemberCount);
                    int _tmpModeratorMemberCount = (int)_stmt.getLong(_columnIndexOfModeratorMemberCount);
                    _item.setModeratorMemberCount(_tmpModeratorMemberCount);
                    int _tmpMessageCount = (int)_stmt.getLong(_columnIndexOfMessageCount);
                    _item.setMessageCount(_tmpMessageCount);
                    int _tmp_2 = (int)_stmt.getLong(_columnIndexOfIsRateLimited);
                    boolean _tmpIsRateLimited = _tmp_2 != 0;
                    _item.setRateLimited(_tmpIsRateLimited);
                    int _tmp_3 = (int)_stmt.getLong(_columnIndexOfIsMuted);
                    boolean _tmpIsMuted = _tmp_3 != 0;
                    _item.setMuted(_tmpIsMuted);
                    int _tmp_4 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_4 != 0;
                    _item.setDeleted(_tmpIsDeleted);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfLastActivity) ? null : _stmt.getText(_columnIndexOfLastActivity);
                    DateTime _tmpLastActivity = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                    _item.setLastActivity(_tmpLastActivity);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _item.setPath(_tmpPath);
                    int _tmpChannelMarkerHash = (int)_stmt.getLong(_columnIndexOfChannelMarkerHash);
                    _item.setChannelMarkerHash(_tmpChannelMarkerHash);
                    String _tmpMessagePreviewId = _stmt.isNull(_columnIndexOfMessagePreviewId) ? null : _stmt.getText(_columnIndexOfMessagePreviewId);
                    _item.setMessagePreviewId(_tmpMessagePreviewId);
                    int _tmp_6 = (int)_stmt.getLong(_columnIndexOfIsPublic);
                    boolean _tmpIsPublic = _tmp_6 != 0;
                    _item.setPublic(_tmpIsPublic);
                    String _tmpAttachedToPostId = _stmt.isNull(_columnIndexOfAttachedToPostId) ? null : _stmt.getText(_columnIndexOfAttachedToPostId);
                    _item.setAttachedToPostId(_tmpAttachedToPostId);
                    String _tmpAttachedToVideoStreamId = _stmt.isNull(_columnIndexOfAttachedToVideoStreamId) ? null : _stmt.getText(_columnIndexOfAttachedToVideoStreamId);
                    _item.setAttachedToVideoStreamId(_tmpAttachedToVideoStreamId);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                    _item.setCreatedAt(_tmpCreatedAt);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                    _item.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                    _item.setExpiresAt(_tmpExpiresAt);
                    _item.setChannelMembership(_tmpChannelMembership);
                    _item.setChannelExtra(_tmpChannelExtra);
                    _result.add(_item);
                }
                ArrayList<EkoChannelWithMembershipAndExtra> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public Flowable<EkoChannelEntity> getLatestChannelImpl(String[] types, boolean isFilterByMemberships, String userId, String[] memberships, boolean isIncludingTags, String[] includingTags, boolean isExcludingTags, String[] excludingTags, Boolean isDeleted, int hash, int nonce, DateTime now) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("SELECT * from channel where channel.channelType in (");
        int _inputSize = types.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" then channel.channelId in (SELECT channelId from channel_membership where membership in (");
        int _inputSize_1 = memberships.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize_1);
        _stringBuilder.append(") and userId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(") else channel.channelId is not null end and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" then channel.channelId in (SELECT channelId from channel_tag where tagName in (");
        int _inputSize_2 = includingTags.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize_2);
        _stringBuilder.append(")) else channel.channelId is not null end and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" then channel.channelId not in (SELECT channelId from channel_tag where tagName in (");
        int _inputSize_3 = excludingTags.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize_3);
        _stringBuilder.append(")) else channel.channelId is not null end and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" is not null then channel.isDeleted = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" else channel.channelId is not null end and channel.updatedAt > ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and channel.channelId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (");
        _stringBuilder.append("?");
        _stringBuilder.append(") and amity_paging_id.nonce = (");
        _stringBuilder.append("?");
        _stringBuilder.append(") ) order by channel.updatedAt  desc limit 1");
        String _sql = _stringBuilder.toString();
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"channel", "channel_membership", "channel_tag", "amity_paging_id"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare(_sql);){
                EkoChannelEntity _result;
                Integer _tmp_4;
                Integer _tmp_3;
                int _argIndex = 1;
                for (String _item : types) {
                    if (_item == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindText(_argIndex, _item);
                    }
                    ++_argIndex;
                }
                _argIndex = 1 + _inputSize;
                int _tmp = isFilterByMemberships ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp);
                _argIndex = 2 + _inputSize;
                for (String _item_1 : memberships) {
                    if (_item_1 == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindText(_argIndex, _item_1);
                    }
                    ++_argIndex;
                }
                _argIndex = 2 + _inputSize + _inputSize_1;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                _argIndex = 3 + _inputSize + _inputSize_1;
                int _tmp_1 = isIncludingTags ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp_1);
                _argIndex = 4 + _inputSize + _inputSize_1;
                for (String _item_2 : includingTags) {
                    if (_item_2 == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindText(_argIndex, _item_2);
                    }
                    ++_argIndex;
                }
                _argIndex = 4 + _inputSize + _inputSize_1 + _inputSize_2;
                int _tmp_2 = isExcludingTags ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp_2);
                _argIndex = 5 + _inputSize + _inputSize_1 + _inputSize_2;
                for (String _item_3 : excludingTags) {
                    if (_item_3 == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindText(_argIndex, _item_3);
                    }
                    ++_argIndex;
                }
                _argIndex = 5 + _inputSize + _inputSize_1 + _inputSize_2 + _inputSize_3;
                Integer n = isDeleted == null ? null : (_tmp_3 = Integer.valueOf(isDeleted != false ? 1 : 0));
                if (_tmp_3 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp_3.intValue());
                }
                _argIndex = 6 + _inputSize + _inputSize_1 + _inputSize_2 + _inputSize_3;
                Integer n2 = isDeleted == null ? null : (_tmp_4 = Integer.valueOf(isDeleted != false ? 1 : 0));
                if (_tmp_4 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp_4.intValue());
                }
                _argIndex = 7 + _inputSize + _inputSize_1 + _inputSize_2 + _inputSize_3;
                String _tmp_5 = this.__dateTimeTypeConverter.dateTimeToString(now);
                if (_tmp_5 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, _tmp_5);
                }
                _argIndex = 8 + _inputSize + _inputSize_1 + _inputSize_2 + _inputSize_3;
                _stmt.bindLong(_argIndex, (long)hash);
                _argIndex = 9 + _inputSize + _inputSize_1 + _inputSize_2 + _inputSize_3;
                _stmt.bindLong(_argIndex, (long)nonce);
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfInternalChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"internalChannelId");
                int _columnIndexOfChannelType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelType");
                int _columnIndexOfDisplayName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"displayName");
                int _columnIndexOfAvatarFileId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"avatarFileId");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfTags = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"tags");
                int _columnIndexOfMemberCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"memberCount");
                int _columnIndexOfModeratorMemberCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"moderatorMemberCount");
                int _columnIndexOfMessageCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messageCount");
                int _columnIndexOfIsRateLimited = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isRateLimited");
                int _columnIndexOfIsMuted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isMuted");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfLastActivity = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastActivity");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfChannelMarkerHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelMarkerHash");
                int _columnIndexOfMessagePreviewId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messagePreviewId");
                int _columnIndexOfIsPublic = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isPublic");
                int _columnIndexOfAttachedToPostId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"attachedToPostId");
                int _columnIndexOfAttachedToVideoStreamId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"attachedToVideoStreamId");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new EkoChannelEntity();
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _result.setChannelId(_tmpChannelId);
                    String _tmpInternalChannelId = _stmt.isNull(_columnIndexOfInternalChannelId) ? null : _stmt.getText(_columnIndexOfInternalChannelId);
                    _result.setInternalChannelId(_tmpInternalChannelId);
                    String _tmpChannelType = _stmt.isNull(_columnIndexOfChannelType) ? null : _stmt.getText(_columnIndexOfChannelType);
                    _result.setChannelType(_tmpChannelType);
                    String _tmpDisplayName = _stmt.isNull(_columnIndexOfDisplayName) ? null : _stmt.getText(_columnIndexOfDisplayName);
                    _result.setDisplayName(_tmpDisplayName);
                    String _tmpAvatarFileId = _stmt.isNull(_columnIndexOfAvatarFileId) ? null : _stmt.getText(_columnIndexOfAvatarFileId);
                    _result.setAvatarFileId(_tmpAvatarFileId);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_6);
                    _result.setMetadata(_tmpMetadata);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfTags) ? null : _stmt.getText(_columnIndexOfTags);
                    AmityTags _tmpTags = this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_7);
                    _result.setTags(_tmpTags);
                    int _tmpMemberCount = (int)_stmt.getLong(_columnIndexOfMemberCount);
                    _result.setMemberCount(_tmpMemberCount);
                    int _tmpModeratorMemberCount = (int)_stmt.getLong(_columnIndexOfModeratorMemberCount);
                    _result.setModeratorMemberCount(_tmpModeratorMemberCount);
                    int _tmpMessageCount = (int)_stmt.getLong(_columnIndexOfMessageCount);
                    _result.setMessageCount(_tmpMessageCount);
                    int _tmp_8 = (int)_stmt.getLong(_columnIndexOfIsRateLimited);
                    boolean _tmpIsRateLimited = _tmp_8 != 0;
                    _result.setRateLimited(_tmpIsRateLimited);
                    int _tmp_9 = (int)_stmt.getLong(_columnIndexOfIsMuted);
                    boolean _tmpIsMuted = _tmp_9 != 0;
                    _result.setMuted(_tmpIsMuted);
                    int _tmp_10 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_10 != 0;
                    _result.setDeleted(_tmpIsDeleted);
                    String _tmp_11 = _stmt.isNull(_columnIndexOfLastActivity) ? null : _stmt.getText(_columnIndexOfLastActivity);
                    DateTime _tmpLastActivity = this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                    _result.setLastActivity(_tmpLastActivity);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _result.setPath(_tmpPath);
                    int _tmpChannelMarkerHash = (int)_stmt.getLong(_columnIndexOfChannelMarkerHash);
                    _result.setChannelMarkerHash(_tmpChannelMarkerHash);
                    String _tmpMessagePreviewId = _stmt.isNull(_columnIndexOfMessagePreviewId) ? null : _stmt.getText(_columnIndexOfMessagePreviewId);
                    _result.setMessagePreviewId(_tmpMessagePreviewId);
                    int _tmp_12 = (int)_stmt.getLong(_columnIndexOfIsPublic);
                    boolean _tmpIsPublic = _tmp_12 != 0;
                    _result.setPublic(_tmpIsPublic);
                    String _tmpAttachedToPostId = _stmt.isNull(_columnIndexOfAttachedToPostId) ? null : _stmt.getText(_columnIndexOfAttachedToPostId);
                    _result.setAttachedToPostId(_tmpAttachedToPostId);
                    String _tmpAttachedToVideoStreamId = _stmt.isNull(_columnIndexOfAttachedToVideoStreamId) ? null : _stmt.getText(_columnIndexOfAttachedToVideoStreamId);
                    _result.setAttachedToVideoStreamId(_tmpAttachedToVideoStreamId);
                    String _tmp_13 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_13);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_14 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_14);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_15 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_15);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                EkoChannelEntity ekoChannelEntity = _result;
                return ekoChannelEntity;
            }
        });
    }

    @Override
    public Flowable<EkoChannelWithMembershipAndExtra> getChannelImpl(String channelId) {
        String _sql = "SELECT channel.*, channel_membership.readToSegment as membership_readToSegment, channel_extra.localReadToSegment as extra_localReadToSegment, channel_membership.lastMentionedSegment as membership_lastMentionedSegment, channel_extra.localLastMentionedSegment as extra_localLastMentionedSegment from channel, channel_membership, channel_extra where channel.channelId = channel_membership.channelId and channel.channelId = channel_extra.channelId and channel.channelId = ? LIMIT 1";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"channel", "channel_membership", "channel_extra"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT channel.*, channel_membership.readToSegment as membership_readToSegment, channel_extra.localReadToSegment as extra_localReadToSegment, channel_membership.lastMentionedSegment as membership_lastMentionedSegment, channel_extra.localLastMentionedSegment as extra_localLastMentionedSegment from channel, channel_membership, channel_extra where channel.channelId = channel_membership.channelId and channel.channelId = channel_extra.channelId and channel.channelId = ? LIMIT 1");){
                EkoChannelWithMembershipAndExtra _result;
                int _argIndex = 1;
                if (channelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, channelId);
                }
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfInternalChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"internalChannelId");
                int _columnIndexOfChannelType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelType");
                int _columnIndexOfDisplayName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"displayName");
                int _columnIndexOfAvatarFileId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"avatarFileId");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfTags = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"tags");
                int _columnIndexOfMemberCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"memberCount");
                int _columnIndexOfModeratorMemberCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"moderatorMemberCount");
                int _columnIndexOfMessageCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messageCount");
                int _columnIndexOfIsRateLimited = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isRateLimited");
                int _columnIndexOfIsMuted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isMuted");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfLastActivity = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastActivity");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfChannelMarkerHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelMarkerHash");
                int _columnIndexOfMessagePreviewId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messagePreviewId");
                int _columnIndexOfIsPublic = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isPublic");
                int _columnIndexOfAttachedToPostId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"attachedToPostId");
                int _columnIndexOfAttachedToVideoStreamId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"attachedToVideoStreamId");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                int _columnIndexOfReadToSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"membership_readToSegment");
                int _columnIndexOfLocalReadToSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"extra_localReadToSegment");
                int _columnIndexOfLastMentionedSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"membership_lastMentionedSegment");
                int _columnIndexOfLocalLastMentionedSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"extra_localLastMentionedSegment");
                if (_stmt.step()) {
                    EkoChannelExtra _tmpChannelExtra;
                    ChannelMembershipEntity _tmpChannelMembership;
                    if (!_stmt.isNull(_columnIndexOfReadToSegment) || !_stmt.isNull(_columnIndexOfLastMentionedSegment)) {
                        _tmpChannelMembership = new ChannelMembershipEntity();
                        int _tmpReadToSegment = (int)_stmt.getLong(_columnIndexOfReadToSegment);
                        _tmpChannelMembership.setReadToSegment(_tmpReadToSegment);
                        int _tmpLastMentionedSegment = (int)_stmt.getLong(_columnIndexOfLastMentionedSegment);
                        _tmpChannelMembership.setLastMentionedSegment(_tmpLastMentionedSegment);
                    } else {
                        _tmpChannelMembership = null;
                    }
                    if (!_stmt.isNull(_columnIndexOfLocalReadToSegment) || !_stmt.isNull(_columnIndexOfLocalLastMentionedSegment)) {
                        _tmpChannelExtra = new EkoChannelExtra(null);
                        int _tmpLocalReadToSegment = (int)_stmt.getLong(_columnIndexOfLocalReadToSegment);
                        _tmpChannelExtra.setLocalReadToSegment(_tmpLocalReadToSegment);
                        int _tmpLocalLastMentionedSegment = (int)_stmt.getLong(_columnIndexOfLocalLastMentionedSegment);
                        _tmpChannelExtra.setLocalLastMentionedSegment(_tmpLocalLastMentionedSegment);
                    } else {
                        _tmpChannelExtra = null;
                    }
                    _result = new EkoChannelWithMembershipAndExtra();
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _result.setChannelId(_tmpChannelId);
                    String _tmpInternalChannelId = _stmt.isNull(_columnIndexOfInternalChannelId) ? null : _stmt.getText(_columnIndexOfInternalChannelId);
                    _result.setInternalChannelId(_tmpInternalChannelId);
                    String _tmpChannelType = _stmt.isNull(_columnIndexOfChannelType) ? null : _stmt.getText(_columnIndexOfChannelType);
                    _result.setChannelType(_tmpChannelType);
                    String _tmpDisplayName = _stmt.isNull(_columnIndexOfDisplayName) ? null : _stmt.getText(_columnIndexOfDisplayName);
                    _result.setDisplayName(_tmpDisplayName);
                    String _tmpAvatarFileId = _stmt.isNull(_columnIndexOfAvatarFileId) ? null : _stmt.getText(_columnIndexOfAvatarFileId);
                    _result.setAvatarFileId(_tmpAvatarFileId);
                    String _tmp = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                    _result.setMetadata(_tmpMetadata);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfTags) ? null : _stmt.getText(_columnIndexOfTags);
                    AmityTags _tmpTags = this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_1);
                    _result.setTags(_tmpTags);
                    int _tmpMemberCount = (int)_stmt.getLong(_columnIndexOfMemberCount);
                    _result.setMemberCount(_tmpMemberCount);
                    int _tmpModeratorMemberCount = (int)_stmt.getLong(_columnIndexOfModeratorMemberCount);
                    _result.setModeratorMemberCount(_tmpModeratorMemberCount);
                    int _tmpMessageCount = (int)_stmt.getLong(_columnIndexOfMessageCount);
                    _result.setMessageCount(_tmpMessageCount);
                    int _tmp_2 = (int)_stmt.getLong(_columnIndexOfIsRateLimited);
                    boolean _tmpIsRateLimited = _tmp_2 != 0;
                    _result.setRateLimited(_tmpIsRateLimited);
                    int _tmp_3 = (int)_stmt.getLong(_columnIndexOfIsMuted);
                    boolean _tmpIsMuted = _tmp_3 != 0;
                    _result.setMuted(_tmpIsMuted);
                    int _tmp_4 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_4 != 0;
                    _result.setDeleted(_tmpIsDeleted);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfLastActivity) ? null : _stmt.getText(_columnIndexOfLastActivity);
                    DateTime _tmpLastActivity = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                    _result.setLastActivity(_tmpLastActivity);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _result.setPath(_tmpPath);
                    int _tmpChannelMarkerHash = (int)_stmt.getLong(_columnIndexOfChannelMarkerHash);
                    _result.setChannelMarkerHash(_tmpChannelMarkerHash);
                    String _tmpMessagePreviewId = _stmt.isNull(_columnIndexOfMessagePreviewId) ? null : _stmt.getText(_columnIndexOfMessagePreviewId);
                    _result.setMessagePreviewId(_tmpMessagePreviewId);
                    int _tmp_6 = (int)_stmt.getLong(_columnIndexOfIsPublic);
                    boolean _tmpIsPublic = _tmp_6 != 0;
                    _result.setPublic(_tmpIsPublic);
                    String _tmpAttachedToPostId = _stmt.isNull(_columnIndexOfAttachedToPostId) ? null : _stmt.getText(_columnIndexOfAttachedToPostId);
                    _result.setAttachedToPostId(_tmpAttachedToPostId);
                    String _tmpAttachedToVideoStreamId = _stmt.isNull(_columnIndexOfAttachedToVideoStreamId) ? null : _stmt.getText(_columnIndexOfAttachedToVideoStreamId);
                    _result.setAttachedToVideoStreamId(_tmpAttachedToVideoStreamId);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                    _result.setExpiresAt(_tmpExpiresAt);
                    _result.setChannelMembership(_tmpChannelMembership);
                    _result.setChannelExtra(_tmpChannelExtra);
                } else {
                    _result = null;
                }
                EkoChannelWithMembershipAndExtra ekoChannelWithMembershipAndExtra = _result;
                return ekoChannelWithMembershipAndExtra;
            }
        });
    }

    @Override
    public EkoChannelWithMembershipAndExtra getByIdNowImpl(String channelId) {
        String _sql = "SELECT channel.*, channel_membership.readToSegment as membership_readToSegment, channel_extra.localReadToSegment as extra_localReadToSegment, channel_membership.lastMentionedSegment as membership_lastMentionedSegment, channel_extra.localLastMentionedSegment as extra_localLastMentionedSegment from channel, channel_membership, channel_extra where channel.channelId = channel_membership.channelId and channel.channelId = channel_extra.channelId and channel.channelId = ? LIMIT 1";
        return (EkoChannelWithMembershipAndExtra)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT channel.*, channel_membership.readToSegment as membership_readToSegment, channel_extra.localReadToSegment as extra_localReadToSegment, channel_membership.lastMentionedSegment as membership_lastMentionedSegment, channel_extra.localLastMentionedSegment as extra_localLastMentionedSegment from channel, channel_membership, channel_extra where channel.channelId = channel_membership.channelId and channel.channelId = channel_extra.channelId and channel.channelId = ? LIMIT 1");){
                EkoChannelWithMembershipAndExtra _result;
                int _argIndex = 1;
                if (channelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, channelId);
                }
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfInternalChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"internalChannelId");
                int _columnIndexOfChannelType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelType");
                int _columnIndexOfDisplayName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"displayName");
                int _columnIndexOfAvatarFileId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"avatarFileId");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfTags = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"tags");
                int _columnIndexOfMemberCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"memberCount");
                int _columnIndexOfModeratorMemberCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"moderatorMemberCount");
                int _columnIndexOfMessageCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messageCount");
                int _columnIndexOfIsRateLimited = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isRateLimited");
                int _columnIndexOfIsMuted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isMuted");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfLastActivity = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastActivity");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfChannelMarkerHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelMarkerHash");
                int _columnIndexOfMessagePreviewId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messagePreviewId");
                int _columnIndexOfIsPublic = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isPublic");
                int _columnIndexOfAttachedToPostId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"attachedToPostId");
                int _columnIndexOfAttachedToVideoStreamId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"attachedToVideoStreamId");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                int _columnIndexOfReadToSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"membership_readToSegment");
                int _columnIndexOfLocalReadToSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"extra_localReadToSegment");
                int _columnIndexOfLastMentionedSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"membership_lastMentionedSegment");
                int _columnIndexOfLocalLastMentionedSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"extra_localLastMentionedSegment");
                if (_stmt.step()) {
                    EkoChannelExtra _tmpChannelExtra;
                    ChannelMembershipEntity _tmpChannelMembership;
                    if (!_stmt.isNull(_columnIndexOfReadToSegment) || !_stmt.isNull(_columnIndexOfLastMentionedSegment)) {
                        _tmpChannelMembership = new ChannelMembershipEntity();
                        int _tmpReadToSegment = (int)_stmt.getLong(_columnIndexOfReadToSegment);
                        _tmpChannelMembership.setReadToSegment(_tmpReadToSegment);
                        int _tmpLastMentionedSegment = (int)_stmt.getLong(_columnIndexOfLastMentionedSegment);
                        _tmpChannelMembership.setLastMentionedSegment(_tmpLastMentionedSegment);
                    } else {
                        _tmpChannelMembership = null;
                    }
                    if (!_stmt.isNull(_columnIndexOfLocalReadToSegment) || !_stmt.isNull(_columnIndexOfLocalLastMentionedSegment)) {
                        _tmpChannelExtra = new EkoChannelExtra(null);
                        int _tmpLocalReadToSegment = (int)_stmt.getLong(_columnIndexOfLocalReadToSegment);
                        _tmpChannelExtra.setLocalReadToSegment(_tmpLocalReadToSegment);
                        int _tmpLocalLastMentionedSegment = (int)_stmt.getLong(_columnIndexOfLocalLastMentionedSegment);
                        _tmpChannelExtra.setLocalLastMentionedSegment(_tmpLocalLastMentionedSegment);
                    } else {
                        _tmpChannelExtra = null;
                    }
                    _result = new EkoChannelWithMembershipAndExtra();
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _result.setChannelId(_tmpChannelId);
                    String _tmpInternalChannelId = _stmt.isNull(_columnIndexOfInternalChannelId) ? null : _stmt.getText(_columnIndexOfInternalChannelId);
                    _result.setInternalChannelId(_tmpInternalChannelId);
                    String _tmpChannelType = _stmt.isNull(_columnIndexOfChannelType) ? null : _stmt.getText(_columnIndexOfChannelType);
                    _result.setChannelType(_tmpChannelType);
                    String _tmpDisplayName = _stmt.isNull(_columnIndexOfDisplayName) ? null : _stmt.getText(_columnIndexOfDisplayName);
                    _result.setDisplayName(_tmpDisplayName);
                    String _tmpAvatarFileId = _stmt.isNull(_columnIndexOfAvatarFileId) ? null : _stmt.getText(_columnIndexOfAvatarFileId);
                    _result.setAvatarFileId(_tmpAvatarFileId);
                    String _tmp = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                    _result.setMetadata(_tmpMetadata);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfTags) ? null : _stmt.getText(_columnIndexOfTags);
                    AmityTags _tmpTags = this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_1);
                    _result.setTags(_tmpTags);
                    int _tmpMemberCount = (int)_stmt.getLong(_columnIndexOfMemberCount);
                    _result.setMemberCount(_tmpMemberCount);
                    int _tmpModeratorMemberCount = (int)_stmt.getLong(_columnIndexOfModeratorMemberCount);
                    _result.setModeratorMemberCount(_tmpModeratorMemberCount);
                    int _tmpMessageCount = (int)_stmt.getLong(_columnIndexOfMessageCount);
                    _result.setMessageCount(_tmpMessageCount);
                    int _tmp_2 = (int)_stmt.getLong(_columnIndexOfIsRateLimited);
                    boolean _tmpIsRateLimited = _tmp_2 != 0;
                    _result.setRateLimited(_tmpIsRateLimited);
                    int _tmp_3 = (int)_stmt.getLong(_columnIndexOfIsMuted);
                    boolean _tmpIsMuted = _tmp_3 != 0;
                    _result.setMuted(_tmpIsMuted);
                    int _tmp_4 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_4 != 0;
                    _result.setDeleted(_tmpIsDeleted);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfLastActivity) ? null : _stmt.getText(_columnIndexOfLastActivity);
                    DateTime _tmpLastActivity = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                    _result.setLastActivity(_tmpLastActivity);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _result.setPath(_tmpPath);
                    int _tmpChannelMarkerHash = (int)_stmt.getLong(_columnIndexOfChannelMarkerHash);
                    _result.setChannelMarkerHash(_tmpChannelMarkerHash);
                    String _tmpMessagePreviewId = _stmt.isNull(_columnIndexOfMessagePreviewId) ? null : _stmt.getText(_columnIndexOfMessagePreviewId);
                    _result.setMessagePreviewId(_tmpMessagePreviewId);
                    int _tmp_6 = (int)_stmt.getLong(_columnIndexOfIsPublic);
                    boolean _tmpIsPublic = _tmp_6 != 0;
                    _result.setPublic(_tmpIsPublic);
                    String _tmpAttachedToPostId = _stmt.isNull(_columnIndexOfAttachedToPostId) ? null : _stmt.getText(_columnIndexOfAttachedToPostId);
                    _result.setAttachedToPostId(_tmpAttachedToPostId);
                    String _tmpAttachedToVideoStreamId = _stmt.isNull(_columnIndexOfAttachedToVideoStreamId) ? null : _stmt.getText(_columnIndexOfAttachedToVideoStreamId);
                    _result.setAttachedToVideoStreamId(_tmpAttachedToVideoStreamId);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                    _result.setExpiresAt(_tmpExpiresAt);
                    _result.setChannelMembership(_tmpChannelMembership);
                    _result.setChannelExtra(_tmpChannelExtra);
                } else {
                    _result = null;
                }
                EkoChannelWithMembershipAndExtra ekoChannelWithMembershipAndExtra = _result;
                return ekoChannelWithMembershipAndExtra;
            }
        });
    }

    @Override
    public EkoChannelEntity getByInternalIdNowImpl(String internalId) {
        String _sql = "SELECT channel.* from channel where channel.internalChannelId = ? LIMIT 1";
        return (EkoChannelEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT channel.* from channel where channel.internalChannelId = ? LIMIT 1");){
                EkoChannelEntity _result;
                int _argIndex = 1;
                if (internalId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, internalId);
                }
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfInternalChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"internalChannelId");
                int _columnIndexOfChannelType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelType");
                int _columnIndexOfDisplayName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"displayName");
                int _columnIndexOfAvatarFileId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"avatarFileId");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfTags = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"tags");
                int _columnIndexOfMemberCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"memberCount");
                int _columnIndexOfModeratorMemberCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"moderatorMemberCount");
                int _columnIndexOfMessageCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messageCount");
                int _columnIndexOfIsRateLimited = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isRateLimited");
                int _columnIndexOfIsMuted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isMuted");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfLastActivity = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastActivity");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfChannelMarkerHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelMarkerHash");
                int _columnIndexOfMessagePreviewId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messagePreviewId");
                int _columnIndexOfIsPublic = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isPublic");
                int _columnIndexOfAttachedToPostId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"attachedToPostId");
                int _columnIndexOfAttachedToVideoStreamId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"attachedToVideoStreamId");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new EkoChannelEntity();
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _result.setChannelId(_tmpChannelId);
                    String _tmpInternalChannelId = _stmt.isNull(_columnIndexOfInternalChannelId) ? null : _stmt.getText(_columnIndexOfInternalChannelId);
                    _result.setInternalChannelId(_tmpInternalChannelId);
                    String _tmpChannelType = _stmt.isNull(_columnIndexOfChannelType) ? null : _stmt.getText(_columnIndexOfChannelType);
                    _result.setChannelType(_tmpChannelType);
                    String _tmpDisplayName = _stmt.isNull(_columnIndexOfDisplayName) ? null : _stmt.getText(_columnIndexOfDisplayName);
                    _result.setDisplayName(_tmpDisplayName);
                    String _tmpAvatarFileId = _stmt.isNull(_columnIndexOfAvatarFileId) ? null : _stmt.getText(_columnIndexOfAvatarFileId);
                    _result.setAvatarFileId(_tmpAvatarFileId);
                    String _tmp = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                    _result.setMetadata(_tmpMetadata);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfTags) ? null : _stmt.getText(_columnIndexOfTags);
                    AmityTags _tmpTags = this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_1);
                    _result.setTags(_tmpTags);
                    int _tmpMemberCount = (int)_stmt.getLong(_columnIndexOfMemberCount);
                    _result.setMemberCount(_tmpMemberCount);
                    int _tmpModeratorMemberCount = (int)_stmt.getLong(_columnIndexOfModeratorMemberCount);
                    _result.setModeratorMemberCount(_tmpModeratorMemberCount);
                    int _tmpMessageCount = (int)_stmt.getLong(_columnIndexOfMessageCount);
                    _result.setMessageCount(_tmpMessageCount);
                    int _tmp_2 = (int)_stmt.getLong(_columnIndexOfIsRateLimited);
                    boolean _tmpIsRateLimited = _tmp_2 != 0;
                    _result.setRateLimited(_tmpIsRateLimited);
                    int _tmp_3 = (int)_stmt.getLong(_columnIndexOfIsMuted);
                    boolean _tmpIsMuted = _tmp_3 != 0;
                    _result.setMuted(_tmpIsMuted);
                    int _tmp_4 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_4 != 0;
                    _result.setDeleted(_tmpIsDeleted);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfLastActivity) ? null : _stmt.getText(_columnIndexOfLastActivity);
                    DateTime _tmpLastActivity = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                    _result.setLastActivity(_tmpLastActivity);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _result.setPath(_tmpPath);
                    int _tmpChannelMarkerHash = (int)_stmt.getLong(_columnIndexOfChannelMarkerHash);
                    _result.setChannelMarkerHash(_tmpChannelMarkerHash);
                    String _tmpMessagePreviewId = _stmt.isNull(_columnIndexOfMessagePreviewId) ? null : _stmt.getText(_columnIndexOfMessagePreviewId);
                    _result.setMessagePreviewId(_tmpMessagePreviewId);
                    int _tmp_6 = (int)_stmt.getLong(_columnIndexOfIsPublic);
                    boolean _tmpIsPublic = _tmp_6 != 0;
                    _result.setPublic(_tmpIsPublic);
                    String _tmpAttachedToPostId = _stmt.isNull(_columnIndexOfAttachedToPostId) ? null : _stmt.getText(_columnIndexOfAttachedToPostId);
                    _result.setAttachedToPostId(_tmpAttachedToPostId);
                    String _tmpAttachedToVideoStreamId = _stmt.isNull(_columnIndexOfAttachedToVideoStreamId) ? null : _stmt.getText(_columnIndexOfAttachedToVideoStreamId);
                    _result.setAttachedToVideoStreamId(_tmpAttachedToVideoStreamId);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                EkoChannelEntity ekoChannelEntity = _result;
                return ekoChannelEntity;
            }
        });
    }

    @Override
    public List<EkoChannelWithMembershipAndExtra> getByIdsNowImpl(List<String> ids) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("SELECT channel.*, channel_membership.readToSegment as membership_readToSegment, channel_extra.localReadToSegment as extra_localReadToSegment, channel_membership.lastMentionedSegment as membership_lastMentionedSegment, channel_extra.localLastMentionedSegment as extra_localLastMentionedSegment from channel, channel_membership, channel_extra where channel.channelId = channel_membership.channelId and channel.channelId = channel_extra.channelId and channel.channelId  IN (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        return (List)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare(_sql);){
                int _argIndex = 1;
                for (String _item : ids) {
                    if (_item == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindText(_argIndex, _item);
                    }
                    ++_argIndex;
                }
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfInternalChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"internalChannelId");
                int _columnIndexOfChannelType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelType");
                int _columnIndexOfDisplayName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"displayName");
                int _columnIndexOfAvatarFileId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"avatarFileId");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfTags = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"tags");
                int _columnIndexOfMemberCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"memberCount");
                int _columnIndexOfModeratorMemberCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"moderatorMemberCount");
                int _columnIndexOfMessageCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messageCount");
                int _columnIndexOfIsRateLimited = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isRateLimited");
                int _columnIndexOfIsMuted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isMuted");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfLastActivity = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastActivity");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfChannelMarkerHash = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelMarkerHash");
                int _columnIndexOfMessagePreviewId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"messagePreviewId");
                int _columnIndexOfIsPublic = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isPublic");
                int _columnIndexOfAttachedToPostId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"attachedToPostId");
                int _columnIndexOfAttachedToVideoStreamId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"attachedToVideoStreamId");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                int _columnIndexOfReadToSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"membership_readToSegment");
                int _columnIndexOfLocalReadToSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"extra_localReadToSegment");
                int _columnIndexOfLastMentionedSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"membership_lastMentionedSegment");
                int _columnIndexOfLocalLastMentionedSegment = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"extra_localLastMentionedSegment");
                ArrayList<EkoChannelWithMembershipAndExtra> _result = new ArrayList<EkoChannelWithMembershipAndExtra>();
                while (_stmt.step()) {
                    EkoChannelExtra _tmpChannelExtra;
                    ChannelMembershipEntity _tmpChannelMembership;
                    if (!_stmt.isNull(_columnIndexOfReadToSegment) || !_stmt.isNull(_columnIndexOfLastMentionedSegment)) {
                        _tmpChannelMembership = new ChannelMembershipEntity();
                        int _tmpReadToSegment = (int)_stmt.getLong(_columnIndexOfReadToSegment);
                        _tmpChannelMembership.setReadToSegment(_tmpReadToSegment);
                        int _tmpLastMentionedSegment = (int)_stmt.getLong(_columnIndexOfLastMentionedSegment);
                        _tmpChannelMembership.setLastMentionedSegment(_tmpLastMentionedSegment);
                    } else {
                        _tmpChannelMembership = null;
                    }
                    if (!_stmt.isNull(_columnIndexOfLocalReadToSegment) || !_stmt.isNull(_columnIndexOfLocalLastMentionedSegment)) {
                        _tmpChannelExtra = new EkoChannelExtra(null);
                        int _tmpLocalReadToSegment = (int)_stmt.getLong(_columnIndexOfLocalReadToSegment);
                        _tmpChannelExtra.setLocalReadToSegment(_tmpLocalReadToSegment);
                        int _tmpLocalLastMentionedSegment = (int)_stmt.getLong(_columnIndexOfLocalLastMentionedSegment);
                        _tmpChannelExtra.setLocalLastMentionedSegment(_tmpLocalLastMentionedSegment);
                    } else {
                        _tmpChannelExtra = null;
                    }
                    EkoChannelWithMembershipAndExtra _item_1 = new EkoChannelWithMembershipAndExtra();
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _item_1.setChannelId(_tmpChannelId);
                    String _tmpInternalChannelId = _stmt.isNull(_columnIndexOfInternalChannelId) ? null : _stmt.getText(_columnIndexOfInternalChannelId);
                    _item_1.setInternalChannelId(_tmpInternalChannelId);
                    String _tmpChannelType = _stmt.isNull(_columnIndexOfChannelType) ? null : _stmt.getText(_columnIndexOfChannelType);
                    _item_1.setChannelType(_tmpChannelType);
                    String _tmpDisplayName = _stmt.isNull(_columnIndexOfDisplayName) ? null : _stmt.getText(_columnIndexOfDisplayName);
                    _item_1.setDisplayName(_tmpDisplayName);
                    String _tmpAvatarFileId = _stmt.isNull(_columnIndexOfAvatarFileId) ? null : _stmt.getText(_columnIndexOfAvatarFileId);
                    _item_1.setAvatarFileId(_tmpAvatarFileId);
                    String _tmp = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                    _item_1.setMetadata(_tmpMetadata);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfTags) ? null : _stmt.getText(_columnIndexOfTags);
                    AmityTags _tmpTags = this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_1);
                    _item_1.setTags(_tmpTags);
                    int _tmpMemberCount = (int)_stmt.getLong(_columnIndexOfMemberCount);
                    _item_1.setMemberCount(_tmpMemberCount);
                    int _tmpModeratorMemberCount = (int)_stmt.getLong(_columnIndexOfModeratorMemberCount);
                    _item_1.setModeratorMemberCount(_tmpModeratorMemberCount);
                    int _tmpMessageCount = (int)_stmt.getLong(_columnIndexOfMessageCount);
                    _item_1.setMessageCount(_tmpMessageCount);
                    int _tmp_2 = (int)_stmt.getLong(_columnIndexOfIsRateLimited);
                    boolean _tmpIsRateLimited = _tmp_2 != 0;
                    _item_1.setRateLimited(_tmpIsRateLimited);
                    int _tmp_3 = (int)_stmt.getLong(_columnIndexOfIsMuted);
                    boolean _tmpIsMuted = _tmp_3 != 0;
                    _item_1.setMuted(_tmpIsMuted);
                    int _tmp_4 = (int)_stmt.getLong(_columnIndexOfIsDeleted);
                    boolean _tmpIsDeleted = _tmp_4 != 0;
                    _item_1.setDeleted(_tmpIsDeleted);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfLastActivity) ? null : _stmt.getText(_columnIndexOfLastActivity);
                    DateTime _tmpLastActivity = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                    _item_1.setLastActivity(_tmpLastActivity);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _item_1.setPath(_tmpPath);
                    int _tmpChannelMarkerHash = (int)_stmt.getLong(_columnIndexOfChannelMarkerHash);
                    _item_1.setChannelMarkerHash(_tmpChannelMarkerHash);
                    String _tmpMessagePreviewId = _stmt.isNull(_columnIndexOfMessagePreviewId) ? null : _stmt.getText(_columnIndexOfMessagePreviewId);
                    _item_1.setMessagePreviewId(_tmpMessagePreviewId);
                    int _tmp_6 = (int)_stmt.getLong(_columnIndexOfIsPublic);
                    boolean _tmpIsPublic = _tmp_6 != 0;
                    _item_1.setPublic(_tmpIsPublic);
                    String _tmpAttachedToPostId = _stmt.isNull(_columnIndexOfAttachedToPostId) ? null : _stmt.getText(_columnIndexOfAttachedToPostId);
                    _item_1.setAttachedToPostId(_tmpAttachedToPostId);
                    String _tmpAttachedToVideoStreamId = _stmt.isNull(_columnIndexOfAttachedToVideoStreamId) ? null : _stmt.getText(_columnIndexOfAttachedToVideoStreamId);
                    _item_1.setAttachedToVideoStreamId(_tmpAttachedToVideoStreamId);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                    _item_1.setCreatedAt(_tmpCreatedAt);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                    _item_1.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                    _item_1.setExpiresAt(_tmpExpiresAt);
                    _item_1.setChannelMembership(_tmpChannelMembership);
                    _item_1.setChannelExtra(_tmpChannelExtra);
                    _result.add(_item_1);
                }
                ArrayList<EkoChannelWithMembershipAndExtra> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public Flowable<List<String>> getActiveIds(String userId) {
        String _sql = "SELECT channelId from channel where channelId in (SELECT channelId from channel_membership where membership = 'member' and userId = ?)";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"channel", "channel_membership"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT channelId from channel where channelId in (SELECT channelId from channel_membership where membership = 'member' and userId = ?)");){
                int _argIndex = 1;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                ArrayList<String> _result = new ArrayList<String>();
                while (_stmt.step()) {
                    String _item = _stmt.isNull(0) ? null : _stmt.getText(0);
                    _result.add(_item);
                }
                ArrayList<String> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public List<String> getInactiveIds(String userId) {
        String _sql = "SELECT channelId from channel where channelId in (SELECT channelId from channel_membership where (membership = 'none' or membership = 'banned') and userId = ?)";
        return (List)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT channelId from channel where channelId in (SELECT channelId from channel_membership where (membership = 'none' or membership = 'banned') and userId = ?)");){
                int _argIndex = 1;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                ArrayList<String> _result = new ArrayList<String>();
                while (_stmt.step()) {
                    String _item = _stmt.isNull(0) ? null : _stmt.getText(0);
                    _result.add(_item);
                }
                ArrayList<String> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public String getMessagePreviewId(String channelId) {
        String _sql = "SELECT messagePreviewId FROM  channel WHERE channelId = ? LIMIT 1";
        return (String)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT messagePreviewId FROM  channel WHERE channelId = ? LIMIT 1");){
                int _argIndex = 1;
                if (channelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, channelId);
                }
                String _result = _stmt.step() ? (_stmt.isNull(0) ? null : _stmt.getText(0)) : null;
                String string = _result;
                return string;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "DELETE from channel";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from channel");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @Override
    public void updateLastActivity(String channelId, DateTime lastActivity) {
        String _sql = "UPDATE channel set lastActivity = ? where channelId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE channel set lastActivity = ? where channelId = ?");){
                int _argIndex = 1;
                String _tmp = this.__dateTimeTypeConverter.dateTimeToString(lastActivity);
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, _tmp);
                }
                _argIndex = 2;
                if (channelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, channelId);
                }
                _stmt.step();
                Object var7_7 = null;
                return var7_7;
            }
        });
    }

    @Override
    public void updateIsMuted(String channelId, boolean isMuted) {
        String _sql = "UPDATE channel set isMuted = ? where channelId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE channel set isMuted = ? where channelId = ?");){
                int _argIndex = 1;
                int _tmp = isMuted ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp);
                _argIndex = 2;
                if (channelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, channelId);
                }
                _stmt.step();
                Object var6_6 = null;
                return var6_6;
            }
        });
    }

    @Override
    public void notifyChanges(String channelId) {
        String _sql = "UPDATE channel set channelId = ? where channelId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE channel set channelId = ? where channelId = ?");){
                int _argIndex = 1;
                if (channelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, channelId);
                }
                _argIndex = 2;
                if (channelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, channelId);
                }
                _stmt.step();
                Object var4_4 = null;
                return var4_4;
            }
        });
    }

    @Override
    public void updateMessageCount(String channelId, int messageCount) {
        String _sql = "UPDATE channel set messageCount = ? where channelId = ? and messageCount < ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE channel set messageCount = ? where channelId = ? and messageCount < ?");){
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, (long)messageCount);
                _argIndex = 2;
                if (channelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, channelId);
                }
                _argIndex = 3;
                _stmt.bindLong(_argIndex, (long)messageCount);
                _stmt.step();
                Object var5_5 = null;
                return var5_5;
            }
        });
    }

    @Override
    public void deleteByIdImpl(String channelId) {
        String _sql = "DELETE from channel where channelId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from channel where channelId = ?");){
                int _argIndex = 1;
                if (channelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, channelId);
                }
                _stmt.step();
                Object var4_4 = null;
                return var4_4;
            }
        });
    }

    @Override
    public void updateMarkerHash(String channelId, int hash) {
        String _sql = "UPDATE channel set channelMarkerHash = ? where channelId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE channel set channelMarkerHash = ? where channelId = ?");){
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, (long)hash);
                _argIndex = 2;
                if (channelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, channelId);
                }
                _stmt.step();
                Object var5_5 = null;
                return var5_5;
            }
        });
    }

    @Override
    public void updateMessagePreview(String channelId, String messagePreviewId) {
        String _sql = "UPDATE channel set messagePreviewId = ? where channelId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE channel set messagePreviewId = ? where channelId = ?");){
                int _argIndex = 1;
                if (messagePreviewId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, messagePreviewId);
                }
                _argIndex = 2;
                if (channelId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, channelId);
                }
                _stmt.step();
                Object var5_5 = null;
                return var5_5;
            }
        });
    }

    @Override
    public void notifyChannelsChanges(List<String> channelIds, int hash) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("UPDATE channel set channelMarkerHash = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" where channelId in (");
        int _inputSize = channelIds.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare(_sql);){
                int _argIndex = 1;
                _stmt.bindLong(_argIndex, (long)hash);
                _argIndex = 2;
                for (String _item : channelIds) {
                    if (_item == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindText(_argIndex, _item);
                    }
                    ++_argIndex;
                }
                _stmt.step();
                Iterator iterator = null;
                return iterator;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

