/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.video.data.watch;

import com.amity.socialcloud.sdk.entity.video.watch.WatchSessionEntity;
import com.amity.socialcloud.sdk.video.data.watch.WatchSessionDao;
import com.amity.socialcloud.sdk.video.data.watch.WatchSessionSyncState;
import com.ekoapp.ekosdk.EkoObject;
import com.ekoapp.ekosdk.EkoObjectRepository;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J%\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00052\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0002\u0010\u000bJ\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\u0011\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0007J\u0014\u0010\u0017\u001a\u00020\u00102\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0014\u0010\u0019\u001a\u00020\u00102\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0014\u0010\u001a\u001a\u00020\u00102\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006J\u0016\u0010\u001b\u001a\u00020\u00102\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002\u00a8\u0006\u001c"}, d2={"Lcom/amity/socialcloud/sdk/video/data/watch/WatchSessionRepository;", "Lcom/ekoapp/ekosdk/EkoObjectRepository;", "<init>", "()V", "getWatchSessionCollection", "Lio/reactivex/rxjava3/core/Flowable;", "", "Lcom/amity/socialcloud/sdk/entity/video/watch/WatchSessionEntity;", "syncStateArray", "", "Lcom/amity/socialcloud/sdk/video/data/watch/WatchSessionSyncState;", "([Lcom/amity/socialcloud/sdk/video/data/watch/WatchSessionSyncState;)Lio/reactivex/rxjava3/core/Flowable;", "getById", "sessionId", "", "resetSyncState", "", "createWatchSession", "roomId", "startedAt", "Lorg/joda/time/DateTime;", "updateWatchSession", "watchEntity", "markAsSyncing", "watchEntities", "markAsSynced", "markAsFailed", "deleteIfExceedRetry", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nWatchSessionRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WatchSessionRepository.kt\ncom/amity/socialcloud/sdk/video/data/watch/WatchSessionRepository\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,78:1\n13472#2,2:79\n37#3:81\n36#3,3:82\n1869#4,2:85\n1869#4,2:87\n1869#4,2:89\n1869#4,2:91\n*S KotlinDebug\n*F\n+ 1 WatchSessionRepository.kt\ncom/amity/socialcloud/sdk/video/data/watch/WatchSessionRepository\n*L\n14#1:79,2\n15#1:81\n15#1:82,3\n44#1:85,2\n50#1:87,2\n59#1:89,2\n69#1:91,2\n*E\n"})
public final class WatchSessionRepository
extends EkoObjectRepository {
    @NotNull
    public final Flowable<List<WatchSessionEntity>> getWatchSessionCollection(@NotNull WatchSessionSyncState[] syncStateArray) {
        Intrinsics.checkNotNullParameter((Object)syncStateArray, (String)"syncStateArray");
        WatchSessionDao watchDao = UserDatabase.get().watchSessionDao();
        ArrayList<String> syncStateList = new ArrayList<String>();
        WatchSessionSyncState[] $this$forEach$iv = syncStateArray;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            WatchSessionSyncState element$iv;
            WatchSessionSyncState it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            syncStateList.add(it.getKey());
        }
        Collection $this$toTypedArray$iv = syncStateList;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return watchDao.getAll(thisCollection$iv.toArray(new String[0]));
    }

    @NotNull
    public final Flowable<WatchSessionEntity> getById(@NotNull String sessionId) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        WatchSessionDao watchDao = UserDatabase.get().watchSessionDao();
        return watchDao.getById(sessionId);
    }

    public final void resetSyncState() {
        WatchSessionDao watchDao = UserDatabase.get().watchSessionDao();
        watchDao.updateSyncState(WatchSessionSyncState.SYNCING, WatchSessionSyncState.PENDING);
    }

    public final void createWatchSession(@NotNull String sessionId, @NotNull String roomId, @NotNull DateTime startedAt) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)roomId, (String)"roomId");
        Intrinsics.checkNotNullParameter((Object)startedAt, (String)"startedAt");
        WatchSessionDao watchDao = UserDatabase.get().watchSessionDao();
        WatchSessionEntity watchSession = new WatchSessionEntity();
        watchSession.setSessionId(sessionId);
        watchSession.setRoomId(roomId);
        watchSession.setStartTime(startedAt);
        watchDao.insert((EkoObject)watchSession);
    }

    public final void updateWatchSession(@NotNull WatchSessionEntity watchEntity) {
        Intrinsics.checkNotNullParameter((Object)watchEntity, (String)"watchEntity");
        WatchSessionDao watchDao = UserDatabase.get().watchSessionDao();
        watchDao.update((EkoObject)watchEntity);
    }

    public final void markAsSyncing(@NotNull List<WatchSessionEntity> watchEntities) {
        Intrinsics.checkNotNullParameter(watchEntities, (String)"watchEntities");
        WatchSessionDao watchDao = UserDatabase.get().watchSessionDao();
        Iterable $this$forEach$iv = watchEntities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WatchSessionEntity it = (WatchSessionEntity)element$iv;
            boolean bl = false;
            it.setSyncState(WatchSessionSyncState.SYNCING.getKey());
        }
        watchDao.update(watchEntities);
    }

    public final void markAsSynced(@NotNull List<WatchSessionEntity> watchEntities) {
        Intrinsics.checkNotNullParameter(watchEntities, (String)"watchEntities");
        WatchSessionDao watchDao = UserDatabase.get().watchSessionDao();
        Iterable $this$forEach$iv = watchEntities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WatchSessionEntity it = (WatchSessionEntity)element$iv;
            boolean bl = false;
            it.setSyncState(WatchSessionSyncState.SYNCED.getKey());
            it.setSyncedAt(DateTime.now());
        }
        watchDao.update(watchEntities);
    }

    public final void markAsFailed(@NotNull List<WatchSessionEntity> watchEntities) {
        Intrinsics.checkNotNullParameter(watchEntities, (String)"watchEntities");
        WatchSessionDao watchDao = UserDatabase.get().watchSessionDao();
        Iterable $this$forEach$iv = watchEntities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WatchSessionEntity it = (WatchSessionEntity)element$iv;
            boolean bl = false;
            it.setSyncState(WatchSessionSyncState.PENDING.getKey());
            int n = it.getRetryCount();
            it.setRetryCount(n + 1);
        }
        watchDao.update(watchEntities);
        this.deleteIfExceedRetry(watchEntities);
    }

    private final void deleteIfExceedRetry(List<WatchSessionEntity> watchEntities) {
        WatchSessionDao watchDao = UserDatabase.get().watchSessionDao();
        Iterable $this$forEach$iv = watchEntities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            WatchSessionEntity it = (WatchSessionEntity)element$iv;
            boolean bl = false;
            if (it.getRetryCount() < 3) continue;
            watchDao.delete((EkoObject)it);
        }
    }
}

