/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.video.data.moderation;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.sqlite.SQLiteStatement;
import com.amity.socialcloud.sdk.entity.video.stream.StreamModerationEntity;
import com.amity.socialcloud.sdk.video.data.moderation.StreamModerationDao;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.JsonArrayTypeConverter;
import com.google.gson.JsonArray;
import io.reactivex.rxjava3.core.Flowable;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class StreamModerationDao_Impl
extends StreamModerationDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<StreamModerationEntity> __insertAdapterOfStreamModerationEntity;
    private final JsonArrayTypeConverter __jsonArrayTypeConverter = new JsonArrayTypeConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeleteOrUpdateAdapter<StreamModerationEntity> __deleteAdapterOfStreamModerationEntity;
    private final EntityDeleteOrUpdateAdapter<StreamModerationEntity> __updateAdapterOfStreamModerationEntity;

    public StreamModerationDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfStreamModerationEntity = new EntityInsertAdapter<StreamModerationEntity>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `stream_moderation` (`moderationId`,`streamId`,`flagLabels`,`terminateLabels`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull StreamModerationEntity entity) {
                if (entity.getModerationId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getModerationId());
                }
                if (entity.getStreamId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getStreamId());
                }
                String _tmp = StreamModerationDao_Impl.this.__jsonArrayTypeConverter.jsonObjectToString(entity.getFlagLabels());
                if (_tmp == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, _tmp);
                }
                String _tmp_1 = StreamModerationDao_Impl.this.__jsonArrayTypeConverter.jsonObjectToString(entity.getTerminateLabels());
                if (_tmp_1 == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, _tmp_1);
                }
                String _tmp_2 = StreamModerationDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp_2);
                }
                String _tmp_3 = StreamModerationDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_3 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_3);
                }
                String _tmp_4 = StreamModerationDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_4 == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, _tmp_4);
                }
            }
        };
        this.__deleteAdapterOfStreamModerationEntity = new EntityDeleteOrUpdateAdapter<StreamModerationEntity>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `stream_moderation` WHERE `moderationId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull StreamModerationEntity entity) {
                if (entity.getModerationId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getModerationId());
                }
            }
        };
        this.__updateAdapterOfStreamModerationEntity = new EntityDeleteOrUpdateAdapter<StreamModerationEntity>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `stream_moderation` SET `moderationId` = ?,`streamId` = ?,`flagLabels` = ?,`terminateLabels` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `moderationId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull StreamModerationEntity entity) {
                if (entity.getModerationId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getModerationId());
                }
                if (entity.getStreamId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getStreamId());
                }
                String _tmp = StreamModerationDao_Impl.this.__jsonArrayTypeConverter.jsonObjectToString(entity.getFlagLabels());
                if (_tmp == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, _tmp);
                }
                String _tmp_1 = StreamModerationDao_Impl.this.__jsonArrayTypeConverter.jsonObjectToString(entity.getTerminateLabels());
                if (_tmp_1 == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, _tmp_1);
                }
                String _tmp_2 = StreamModerationDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp_2);
                }
                String _tmp_3 = StreamModerationDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_3 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_3);
                }
                String _tmp_4 = StreamModerationDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_4 == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, _tmp_4);
                }
                if (entity.getModerationId() == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, entity.getModerationId());
                }
            }
        };
    }

    @Override
    public void insertImpl(StreamModerationEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfStreamModerationEntity.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends StreamModerationEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfStreamModerationEntity.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(StreamModerationEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfStreamModerationEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void delete(List<? extends StreamModerationEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfStreamModerationEntity.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void updateImpl(StreamModerationEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfStreamModerationEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(StreamModerationEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            StreamModerationDao_Impl.super.insert(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends StreamModerationEntity> objects) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            StreamModerationDao_Impl.super.insert(objects);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(StreamModerationEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            StreamModerationDao_Impl.super.update(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public Flowable<StreamModerationEntity> getByIdImpl(String moderationId) {
        String _sql = "SELECT * from stream_moderation where moderationId = ?";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"stream_moderation"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from stream_moderation where moderationId = ?");){
                StreamModerationEntity _result;
                int _argIndex = 1;
                if (moderationId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, moderationId);
                }
                int _columnIndexOfModerationId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"moderationId");
                int _columnIndexOfStreamId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"streamId");
                int _columnIndexOfFlagLabels = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flagLabels");
                int _columnIndexOfTerminateLabels = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"terminateLabels");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new StreamModerationEntity();
                    String _tmpModerationId = _stmt.isNull(_columnIndexOfModerationId) ? null : _stmt.getText(_columnIndexOfModerationId);
                    _result.setModerationId(_tmpModerationId);
                    String _tmpStreamId = _stmt.isNull(_columnIndexOfStreamId) ? null : _stmt.getText(_columnIndexOfStreamId);
                    _result.setStreamId(_tmpStreamId);
                    String _tmp = _stmt.isNull(_columnIndexOfFlagLabels) ? null : _stmt.getText(_columnIndexOfFlagLabels);
                    JsonArray _tmpFlagLabels = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp);
                    _result.setFlagLabels(_tmpFlagLabels);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfTerminateLabels) ? null : _stmt.getText(_columnIndexOfTerminateLabels);
                    JsonArray _tmpTerminateLabels = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_1);
                    _result.setTerminateLabels(_tmpTerminateLabels);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                StreamModerationEntity streamModerationEntity = _result;
                return streamModerationEntity;
            }
        });
    }

    @Override
    public StreamModerationEntity getByIdNowImpl(String moderationId) {
        String _sql = "SELECT * from stream_moderation where moderationId = ?";
        return (StreamModerationEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from stream_moderation where moderationId = ?");){
                StreamModerationEntity _result;
                int _argIndex = 1;
                if (moderationId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, moderationId);
                }
                int _columnIndexOfModerationId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"moderationId");
                int _columnIndexOfStreamId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"streamId");
                int _columnIndexOfFlagLabels = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"flagLabels");
                int _columnIndexOfTerminateLabels = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"terminateLabels");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new StreamModerationEntity();
                    String _tmpModerationId = _stmt.isNull(_columnIndexOfModerationId) ? null : _stmt.getText(_columnIndexOfModerationId);
                    _result.setModerationId(_tmpModerationId);
                    String _tmpStreamId = _stmt.isNull(_columnIndexOfStreamId) ? null : _stmt.getText(_columnIndexOfStreamId);
                    _result.setStreamId(_tmpStreamId);
                    String _tmp = _stmt.isNull(_columnIndexOfFlagLabels) ? null : _stmt.getText(_columnIndexOfFlagLabels);
                    JsonArray _tmpFlagLabels = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp);
                    _result.setFlagLabels(_tmpFlagLabels);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfTerminateLabels) ? null : _stmt.getText(_columnIndexOfTerminateLabels);
                    JsonArray _tmpTerminateLabels = this.__jsonArrayTypeConverter.stringToJsonObject(_tmp_1);
                    _result.setTerminateLabels(_tmpTerminateLabels);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                StreamModerationEntity streamModerationEntity = _result;
                return streamModerationEntity;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "DELETE from stream_moderation";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from stream_moderation");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

