/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.social.data.story;

import androidx.room.Dao;
import androidx.room.Query;
import com.amity.socialcloud.sdk.entity.social.story.StoryEntity;
import com.amity.socialcloud.sdk.model.social.story.AmityStory;
import com.ekoapp.ekosdk.internal.data.dao.EkoObjectDao;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0004\b'\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH'J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH'J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH'J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH'J\u0010\u0010\u000e\u001a\u00020\n2\u0006\u0010\u0007\u001a\u00020\bH'J\u0010\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH'J\b\u0010\u0010\u001a\u00020\rH'J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020\bH'J\u0018\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\u0014\u001a\u00020\bH'J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0012\u001a\u00020\bH\u0016J8\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\b\b\u0002\u0010\u001c\u001a\u00020\u001dH'J,\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u001f2\u0006\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aJ\u0010\u0010 \u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\bJ\u0012\u0010!\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0007\u001a\u00020\bH'J\u0018\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\bH'J\u0014\u0010#\u001a\b\u0012\u0004\u0012\u00020\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0014\u0010$\u001a\u0004\u0018\u00010\u00022\b\u0010\u0007\u001a\u0004\u0018\u00010\bH'J\u0010\u0010%\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0007\u001a\u00020\bJ(\u0010&\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\b2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\b0(H'J&\u0010)\u001a\u00020\u001a2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\b2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\b0(H'J\b\u0010*\u001a\u00020\rH'J\u001e\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00020(2\u0006\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\bH'\u00a8\u0006,"}, d2={"Lcom/amity/socialcloud/sdk/social/data/story/StoryDao;", "Lcom/ekoapp/ekosdk/internal/data/dao/EkoObjectDao;", "Lcom/amity/socialcloud/sdk/entity/social/story/StoryEntity;", "<init>", "()V", "getStory", "Lio/reactivex/rxjava3/core/Flowable;", "storyId", "", "softDeleteStory", "Lio/reactivex/rxjava3/core/Completable;", "hardDeleteStory", "hardDeleteNow", "", "dummyUpdateStory", "decrementCommentCount", "deleteAll", "getByIdNowImpl", "uniqueId", "updateSyncState", "syncState", "getByIdNow", "getLatestStoryImpl", "targetType", "targetId", "hash", "", "nonce", "now", "Lorg/joda/time/DateTime;", "getLatestStory", "Lcom/amity/socialcloud/sdk/model/social/story/AmityStory$TargetType;", "getUniqueIdByStoryId", "getUniqueIdByStoryIdImpl", "observeStoryImpl", "observeStory", "getByStoryIdNowImpl", "getByStoryIdNow", "getHighestStoryExpiresAt", "syncStates", "", "getStoryCount", "initSyncStateOnStartup", "findCache", "amity-sdk_release"})
@Dao
public abstract class StoryDao
extends EkoObjectDao<StoryEntity> {
    @Query(value="select * from story where storyId = :storyId")
    @NotNull
    public abstract Flowable<StoryEntity> getStory(@NotNull String var1);

    @Query(value="UPDATE story set isDeleted = 1 where storyId = :storyId")
    @NotNull
    public abstract Completable softDeleteStory(@NotNull String var1);

    @Query(value="DELETE from story where storyId = :storyId")
    @NotNull
    public abstract Completable hardDeleteStory(@NotNull String var1);

    @Query(value="DELETE from story where storyId = :storyId")
    public abstract void hardDeleteNow(@NotNull String var1);

    @Query(value="update story set storyId = :storyId where storyId = :storyId")
    @NotNull
    public abstract Completable dummyUpdateStory(@NotNull String var1);

    @Query(value="UPDATE story set commentCount = MAX(commentCount - 1, 0)  where storyId = :storyId")
    public abstract void decrementCommentCount(@NotNull String var1);

    @Override
    @Query(value="delete from story")
    public abstract void deleteAll();

    @Query(value="select * from story where uniqueId = :uniqueId limit 1")
    @Nullable
    public abstract StoryEntity getByIdNowImpl(@NotNull String var1);

    @Query(value="update story set syncState = :syncState where uniqueId = :uniqueId")
    @NotNull
    public abstract Completable updateSyncState(@NotNull String var1, @NotNull String var2);

    @Override
    @Nullable
    public StoryEntity getByIdNow(@NotNull String uniqueId) {
        Intrinsics.checkNotNullParameter((Object)uniqueId, (String)"uniqueId");
        return this.getByIdNowImpl(uniqueId);
    }

    @Query(value="SELECT * from story where story.targetType = :targetType and story.targetId = :targetId  and story.updatedAt > :now and story.uniqueId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (:hash) and amity_paging_id.nonce = (:nonce) ) order by story.updatedAt  desc limit 1")
    @NotNull
    public abstract Flowable<StoryEntity> getLatestStoryImpl(@NotNull String var1, @NotNull String var2, int var3, int var4, @NotNull DateTime var5);

    public static /* synthetic */ Flowable getLatestStoryImpl$default(StoryDao storyDao, String string, String string2, int n, int n2, DateTime dateTime, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getLatestStoryImpl");
        }
        if ((n3 & 0x10) != 0) {
            DateTime dateTime2 = DateTime.now();
            Intrinsics.checkNotNullExpressionValue((Object)dateTime2, (String)"now(...)");
            dateTime = dateTime2;
        }
        return storyDao.getLatestStoryImpl(string, string2, n, n2, dateTime);
    }

    @NotNull
    public final Flowable<StoryEntity> getLatestStory(@NotNull AmityStory.TargetType targetType, @NotNull String targetId, int hash, int nonce) {
        Intrinsics.checkNotNullParameter((Object)((Object)targetType), (String)"targetType");
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        return StoryDao.getLatestStoryImpl$default(this, targetType.getApiKey(), targetId, hash, nonce, null, 16, null);
    }

    @Nullable
    public final String getUniqueIdByStoryId(@NotNull String storyId) {
        Intrinsics.checkNotNullParameter((Object)storyId, (String)"storyId");
        return this.getUniqueIdByStoryIdImpl(storyId);
    }

    @Query(value="SELECT story.uniqueId from story where story.storyId = :storyId LIMIT 1")
    @Nullable
    public abstract String getUniqueIdByStoryIdImpl(@NotNull String var1);

    @Query(value="SELECT story.* from story where story.storyId = :storyId LIMIT 1")
    @NotNull
    public abstract Flowable<StoryEntity> observeStoryImpl(@Nullable String var1);

    @NotNull
    public final Flowable<StoryEntity> observeStory(@NotNull String storyId) {
        Intrinsics.checkNotNullParameter((Object)storyId, (String)"storyId");
        return this.observeStoryImpl(storyId);
    }

    @Query(value="SELECT story.* from story where story.storyId = :storyId LIMIT 1")
    @Nullable
    public abstract StoryEntity getByStoryIdNowImpl(@Nullable String var1);

    @Nullable
    public final StoryEntity getByStoryIdNow(@NotNull String storyId) {
        Intrinsics.checkNotNullParameter((Object)storyId, (String)"storyId");
        return this.getByStoryIdNowImpl(storyId);
    }

    @Query(value="SELECT storyExpiresAt from story where targetType = :targetType and targetId = :targetId and syncState IN (:syncStates) order by storyExpiresAt DESC LIMIT 1")
    @Nullable
    public abstract DateTime getHighestStoryExpiresAt(@NotNull String var1, @NotNull String var2, @NotNull List<String> var3);

    @Query(value="SELECT COUNT(*) from story where targetType = :targetType and targetId = :targetId and syncState IN (:syncStates)")
    public abstract int getStoryCount(@NotNull String var1, @NotNull String var2, @NotNull List<String> var3);

    @Query(value="UPDATE story set syncState = 'failed' where syncState = 'syncing'")
    public abstract void initSyncStateOnStartup();

    @Query(value="SELECT story.* from story where targetType = :targetType and targetId = :targetId and syncState != 'synced'")
    @NotNull
    public abstract List<StoryEntity> findCache(@NotNull String var1, @NotNull String var2);
}

