/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.social.data.event;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteConnectionUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.SQLiteConnection;
import androidx.sqlite.SQLiteStatement;
import com.amity.socialcloud.sdk.entity.social.event.EventResponseEntity;
import com.amity.socialcloud.sdk.social.data.event.EventResponseDao;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class EventResponseDao_Impl
extends EventResponseDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<EventResponseEntity> __insertAdapterOfEventResponseEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeleteOrUpdateAdapter<EventResponseEntity> __deleteAdapterOfEventResponseEntity;
    private final EntityDeleteOrUpdateAdapter<EventResponseEntity> __updateAdapterOfEventResponseEntity;

    public EventResponseDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfEventResponseEntity = new EntityInsertAdapter<EventResponseEntity>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `event_response` (`rsvpId`,`status`,`eventId`,`userId`,`respondedAt`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull EventResponseEntity entity) {
                if (entity.getRsvpId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getRsvpId());
                }
                if (entity.getStatus() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getStatus());
                }
                if (entity.getEventId() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getEventId());
                }
                if (entity.getUserId() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getUserId());
                }
                String _tmp = EventResponseDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getRespondedAt());
                if (_tmp == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp);
                }
                String _tmp_1 = EventResponseDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_1 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_1);
                }
                String _tmp_2 = EventResponseDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, _tmp_2);
                }
                String _tmp_3 = EventResponseDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_3 == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, _tmp_3);
                }
            }
        };
        this.__deleteAdapterOfEventResponseEntity = new EntityDeleteOrUpdateAdapter<EventResponseEntity>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `event_response` WHERE `rsvpId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull EventResponseEntity entity) {
                if (entity.getRsvpId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getRsvpId());
                }
            }
        };
        this.__updateAdapterOfEventResponseEntity = new EntityDeleteOrUpdateAdapter<EventResponseEntity>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `event_response` SET `rsvpId` = ?,`status` = ?,`eventId` = ?,`userId` = ?,`respondedAt` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `rsvpId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull EventResponseEntity entity) {
                if (entity.getRsvpId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getRsvpId());
                }
                if (entity.getStatus() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getStatus());
                }
                if (entity.getEventId() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getEventId());
                }
                if (entity.getUserId() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getUserId());
                }
                String _tmp = EventResponseDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getRespondedAt());
                if (_tmp == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp);
                }
                String _tmp_1 = EventResponseDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_1 == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, _tmp_1);
                }
                String _tmp_2 = EventResponseDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, _tmp_2);
                }
                String _tmp_3 = EventResponseDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_3 == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, _tmp_3);
                }
                if (entity.getRsvpId() == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, entity.getRsvpId());
                }
            }
        };
    }

    @Override
    public void insertImpl(EventResponseEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfEventResponseEntity.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends EventResponseEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfEventResponseEntity.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(EventResponseEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfEventResponseEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void delete(List<? extends EventResponseEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfEventResponseEntity.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void updateImpl(EventResponseEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfEventResponseEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(EventResponseEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EventResponseDao_Impl.super.insert(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends EventResponseEntity> objects) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EventResponseDao_Impl.super.insert(objects);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(EventResponseEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EventResponseDao_Impl.super.update(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public Flowable<EventResponseEntity> getEventResponseImpl(String rsvpId) {
        String _sql = "SELECT * FROM event_response WHERE rsvpId = ? LIMIT 1";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"event_response"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * FROM event_response WHERE rsvpId = ? LIMIT 1");){
                EventResponseEntity _result;
                int _argIndex = 1;
                if (rsvpId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, rsvpId);
                }
                int _columnIndexOfRsvpId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"rsvpId");
                int _columnIndexOfStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"status");
                int _columnIndexOfEventId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eventId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfRespondedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"respondedAt");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new EventResponseEntity();
                    String _tmpRsvpId = _stmt.isNull(_columnIndexOfRsvpId) ? null : _stmt.getText(_columnIndexOfRsvpId);
                    _result.setRsvpId(_tmpRsvpId);
                    String _tmpStatus = _stmt.isNull(_columnIndexOfStatus) ? null : _stmt.getText(_columnIndexOfStatus);
                    _result.setStatus(_tmpStatus);
                    String _tmpEventId = _stmt.isNull(_columnIndexOfEventId) ? null : _stmt.getText(_columnIndexOfEventId);
                    _result.setEventId(_tmpEventId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _result.setUserId(_tmpUserId);
                    String _tmp = _stmt.isNull(_columnIndexOfRespondedAt) ? null : _stmt.getText(_columnIndexOfRespondedAt);
                    DateTime _tmpRespondedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _result.setRespondedAt(_tmpRespondedAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                EventResponseEntity eventResponseEntity = _result;
                return eventResponseEntity;
            }
        });
    }

    @Override
    public Flowable<List<EventResponseEntity>> observeEventResponseImpl(String rsvpId) {
        String _sql = "SELECT * FROM event_response WHERE rsvpId = ?";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"event_response"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * FROM event_response WHERE rsvpId = ?");){
                int _argIndex = 1;
                if (rsvpId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, rsvpId);
                }
                int _columnIndexOfRsvpId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"rsvpId");
                int _columnIndexOfStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"status");
                int _columnIndexOfEventId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eventId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfRespondedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"respondedAt");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<EventResponseEntity> _result = new ArrayList<EventResponseEntity>();
                while (_stmt.step()) {
                    EventResponseEntity _item = new EventResponseEntity();
                    String _tmpRsvpId = _stmt.isNull(_columnIndexOfRsvpId) ? null : _stmt.getText(_columnIndexOfRsvpId);
                    _item.setRsvpId(_tmpRsvpId);
                    String _tmpStatus = _stmt.isNull(_columnIndexOfStatus) ? null : _stmt.getText(_columnIndexOfStatus);
                    _item.setStatus(_tmpStatus);
                    String _tmpEventId = _stmt.isNull(_columnIndexOfEventId) ? null : _stmt.getText(_columnIndexOfEventId);
                    _item.setEventId(_tmpEventId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _item.setUserId(_tmpUserId);
                    String _tmp = _stmt.isNull(_columnIndexOfRespondedAt) ? null : _stmt.getText(_columnIndexOfRespondedAt);
                    DateTime _tmpRespondedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _item.setRespondedAt(_tmpRespondedAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _item.setCreatedAt(_tmpCreatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _item.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _item.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item);
                }
                ArrayList<EventResponseEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public EventResponseEntity getByIdNowImpl(String rsvpId) {
        String _sql = "SELECT * FROM event_response WHERE rsvpId = ? LIMIT 1";
        return (EventResponseEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * FROM event_response WHERE rsvpId = ? LIMIT 1");){
                EventResponseEntity _result;
                int _argIndex = 1;
                if (rsvpId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, rsvpId);
                }
                int _columnIndexOfRsvpId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"rsvpId");
                int _columnIndexOfStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"status");
                int _columnIndexOfEventId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eventId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfRespondedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"respondedAt");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new EventResponseEntity();
                    String _tmpRsvpId = _stmt.isNull(_columnIndexOfRsvpId) ? null : _stmt.getText(_columnIndexOfRsvpId);
                    _result.setRsvpId(_tmpRsvpId);
                    String _tmpStatus = _stmt.isNull(_columnIndexOfStatus) ? null : _stmt.getText(_columnIndexOfStatus);
                    _result.setStatus(_tmpStatus);
                    String _tmpEventId = _stmt.isNull(_columnIndexOfEventId) ? null : _stmt.getText(_columnIndexOfEventId);
                    _result.setEventId(_tmpEventId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _result.setUserId(_tmpUserId);
                    String _tmp = _stmt.isNull(_columnIndexOfRespondedAt) ? null : _stmt.getText(_columnIndexOfRespondedAt);
                    DateTime _tmpRespondedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _result.setRespondedAt(_tmpRespondedAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                EventResponseEntity eventResponseEntity = _result;
                return eventResponseEntity;
            }
        });
    }

    @Override
    public List<EventResponseEntity> getByIdsNowImpl(List<String> rsvpIds) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("SELECT * FROM event_response WHERE rsvpId IN (");
        int _inputSize = rsvpIds.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        return (List)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare(_sql);){
                int _argIndex = 1;
                for (String _item : rsvpIds) {
                    if (_item == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindText(_argIndex, _item);
                    }
                    ++_argIndex;
                }
                int _columnIndexOfRsvpId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"rsvpId");
                int _columnIndexOfStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"status");
                int _columnIndexOfEventId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eventId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfRespondedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"respondedAt");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<EventResponseEntity> _result = new ArrayList<EventResponseEntity>();
                while (_stmt.step()) {
                    EventResponseEntity _item_1 = new EventResponseEntity();
                    String _tmpRsvpId = _stmt.isNull(_columnIndexOfRsvpId) ? null : _stmt.getText(_columnIndexOfRsvpId);
                    _item_1.setRsvpId(_tmpRsvpId);
                    String _tmpStatus = _stmt.isNull(_columnIndexOfStatus) ? null : _stmt.getText(_columnIndexOfStatus);
                    _item_1.setStatus(_tmpStatus);
                    String _tmpEventId = _stmt.isNull(_columnIndexOfEventId) ? null : _stmt.getText(_columnIndexOfEventId);
                    _item_1.setEventId(_tmpEventId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _item_1.setUserId(_tmpUserId);
                    String _tmp = _stmt.isNull(_columnIndexOfRespondedAt) ? null : _stmt.getText(_columnIndexOfRespondedAt);
                    DateTime _tmpRespondedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _item_1.setRespondedAt(_tmpRespondedAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _item_1.setCreatedAt(_tmpCreatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _item_1.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _item_1.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item_1);
                }
                ArrayList<EventResponseEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public Flowable<List<EventResponseEntity>> getByEventIdImpl(String eventId) {
        String _sql = "SELECT * FROM event_response WHERE eventId = ?";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"event_response"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * FROM event_response WHERE eventId = ?");){
                int _argIndex = 1;
                if (eventId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, eventId);
                }
                int _columnIndexOfRsvpId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"rsvpId");
                int _columnIndexOfStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"status");
                int _columnIndexOfEventId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eventId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfRespondedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"respondedAt");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<EventResponseEntity> _result = new ArrayList<EventResponseEntity>();
                while (_stmt.step()) {
                    EventResponseEntity _item = new EventResponseEntity();
                    String _tmpRsvpId = _stmt.isNull(_columnIndexOfRsvpId) ? null : _stmt.getText(_columnIndexOfRsvpId);
                    _item.setRsvpId(_tmpRsvpId);
                    String _tmpStatus = _stmt.isNull(_columnIndexOfStatus) ? null : _stmt.getText(_columnIndexOfStatus);
                    _item.setStatus(_tmpStatus);
                    String _tmpEventId = _stmt.isNull(_columnIndexOfEventId) ? null : _stmt.getText(_columnIndexOfEventId);
                    _item.setEventId(_tmpEventId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _item.setUserId(_tmpUserId);
                    String _tmp = _stmt.isNull(_columnIndexOfRespondedAt) ? null : _stmt.getText(_columnIndexOfRespondedAt);
                    DateTime _tmpRespondedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _item.setRespondedAt(_tmpRespondedAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _item.setCreatedAt(_tmpCreatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _item.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _item.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item);
                }
                ArrayList<EventResponseEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public Flowable<EventResponseEntity> getByEventAndUserImpl(String eventId, String userId) {
        String _sql = "SELECT * FROM event_response WHERE eventId = ? AND userId = ? LIMIT 1";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"event_response"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * FROM event_response WHERE eventId = ? AND userId = ? LIMIT 1");){
                EventResponseEntity _result;
                int _argIndex = 1;
                if (eventId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, eventId);
                }
                _argIndex = 2;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                int _columnIndexOfRsvpId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"rsvpId");
                int _columnIndexOfStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"status");
                int _columnIndexOfEventId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eventId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfRespondedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"respondedAt");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new EventResponseEntity();
                    String _tmpRsvpId = _stmt.isNull(_columnIndexOfRsvpId) ? null : _stmt.getText(_columnIndexOfRsvpId);
                    _result.setRsvpId(_tmpRsvpId);
                    String _tmpStatus = _stmt.isNull(_columnIndexOfStatus) ? null : _stmt.getText(_columnIndexOfStatus);
                    _result.setStatus(_tmpStatus);
                    String _tmpEventId = _stmt.isNull(_columnIndexOfEventId) ? null : _stmt.getText(_columnIndexOfEventId);
                    _result.setEventId(_tmpEventId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _result.setUserId(_tmpUserId);
                    String _tmp = _stmt.isNull(_columnIndexOfRespondedAt) ? null : _stmt.getText(_columnIndexOfRespondedAt);
                    DateTime _tmpRespondedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _result.setRespondedAt(_tmpRespondedAt);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                EventResponseEntity eventResponseEntity = _result;
                return eventResponseEntity;
            }
        });
    }

    @Override
    public Flowable<EventResponseEntity> getLatestEventResponseImpl(String eventId, boolean isFilterByStatus, String status, int hash, int nonce, DateTime now) {
        String _sql = "SELECT * FROM event_response WHERE eventId = ? AND (? = 0 OR status = ?) AND updatedAt > ? AND rsvpId NOT IN (SELECT id FROM amity_paging_id WHERE hash = ? AND nonce = ?) ORDER BY updatedAt DESC LIMIT 1";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"event_response", "amity_paging_id"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * FROM event_response WHERE eventId = ? AND (? = 0 OR status = ?) AND updatedAt > ? AND rsvpId NOT IN (SELECT id FROM amity_paging_id WHERE hash = ? AND nonce = ?) ORDER BY updatedAt DESC LIMIT 1");){
                EventResponseEntity _result;
                int _argIndex = 1;
                if (eventId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, eventId);
                }
                _argIndex = 2;
                int _tmp = isFilterByStatus ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp);
                _argIndex = 3;
                if (status == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, status);
                }
                _argIndex = 4;
                String _tmp_1 = this.__dateTimeTypeConverter.dateTimeToString(now);
                if (_tmp_1 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, _tmp_1);
                }
                _argIndex = 5;
                _stmt.bindLong(_argIndex, (long)hash);
                _argIndex = 6;
                _stmt.bindLong(_argIndex, (long)nonce);
                int _columnIndexOfRsvpId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"rsvpId");
                int _columnIndexOfStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"status");
                int _columnIndexOfEventId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eventId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfRespondedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"respondedAt");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new EventResponseEntity();
                    String _tmpRsvpId = _stmt.isNull(_columnIndexOfRsvpId) ? null : _stmt.getText(_columnIndexOfRsvpId);
                    _result.setRsvpId(_tmpRsvpId);
                    String _tmpStatus = _stmt.isNull(_columnIndexOfStatus) ? null : _stmt.getText(_columnIndexOfStatus);
                    _result.setStatus(_tmpStatus);
                    String _tmpEventId = _stmt.isNull(_columnIndexOfEventId) ? null : _stmt.getText(_columnIndexOfEventId);
                    _result.setEventId(_tmpEventId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _result.setUserId(_tmpUserId);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfRespondedAt) ? null : _stmt.getText(_columnIndexOfRespondedAt);
                    DateTime _tmpRespondedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setRespondedAt(_tmpRespondedAt);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                EventResponseEntity eventResponseEntity = _result;
                return eventResponseEntity;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "DELETE FROM event_response";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE FROM event_response");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @Override
    public int deleteByIdImpl(String rsvpId) {
        String _sql = "DELETE FROM event_response WHERE rsvpId = ?";
        return (Integer)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE FROM event_response WHERE rsvpId = ?");){
                int _argIndex = 1;
                if (rsvpId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, rsvpId);
                }
                _stmt.step();
                Integer n = SQLiteConnectionUtil.getTotalChangedRows((SQLiteConnection)_connection);
                return n;
            }
        });
    }

    @Override
    public int deleteByEventIdImpl(String eventId) {
        String _sql = "DELETE FROM event_response WHERE eventId = ?";
        return (Integer)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE FROM event_response WHERE eventId = ?");){
                int _argIndex = 1;
                if (eventId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, eventId);
                }
                _stmt.step();
                Integer n = SQLiteConnectionUtil.getTotalChangedRows((SQLiteConnection)_connection);
                return n;
            }
        });
    }

    @Override
    public void notifyChanges(String rsvpId) {
        String _sql = "UPDATE event_response SET rsvpId = ? WHERE rsvpId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE event_response SET rsvpId = ? WHERE rsvpId = ?");){
                int _argIndex = 1;
                if (rsvpId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, rsvpId);
                }
                _argIndex = 2;
                if (rsvpId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, rsvpId);
                }
                _stmt.step();
                Object var4_4 = null;
                return var4_4;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

