/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.social.data.community.membership;

import androidx.paging.PagingSource;
import com.amity.socialcloud.sdk.api.core.AmityCoreClient;
import com.amity.socialcloud.sdk.api.social.member.query.AmityCommunityMembershipSortOption;
import com.amity.socialcloud.sdk.model.chat.member.AmityMembershipType;
import com.amity.socialcloud.sdk.model.core.permission.AmityPermissions;
import com.amity.socialcloud.sdk.model.core.role.AmityRoles;
import com.amity.socialcloud.sdk.model.social.member.AmityCommunityMembership;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommunityMembershipDao;
import com.ekoapp.ekosdk.internal.entity.CommunityEntity;
import com.ekoapp.ekosdk.internal.entity.CommunityMembershipEntity;
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0014\u0010\t\u001a\u00020\u00052\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0007J\u0018\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000eJG\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000b0\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\u0002\u0010\u001bJG\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000b0\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u00072\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\u0002\u0010\u001bJU\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000b0\u00112\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u00142\u000e\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00072\u0006\u0010\u0019\u001a\u00020\u001a2\n\b\u0002\u0010\u001e\u001a\u0004\u0018\u00010\u000e2\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018\u00a2\u0006\u0002\u0010\u001fJ:\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0!2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00160\u00072\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0012J\u000e\u0010%\u001a\u00020&2\u0006\u0010\u000f\u001a\u00020\u000e\u00a8\u0006'"}, d2={"Lcom/amity/socialcloud/sdk/social/data/community/membership/CommunityMembershipLocalDataStore;", "", "<init>", "()V", "saveCommunities", "Lio/reactivex/rxjava3/core/Completable;", "communities", "", "Lcom/ekoapp/ekosdk/internal/entity/CommunityEntity;", "saveMemberships", "memberships", "Lcom/ekoapp/ekosdk/internal/entity/CommunityMembershipEntity;", "getMembership", "communityId", "", "userId", "getMemberQueryPagingSource", "Landroidx/paging/PagingSource;", "", "roles", "Lcom/amity/socialcloud/sdk/model/core/role/AmityRoles;", "filters", "Lcom/amity/socialcloud/sdk/model/social/member/AmityCommunityMembership;", "isDeleted", "", "sortBy", "Lcom/amity/socialcloud/sdk/api/social/member/query/AmityCommunityMembershipSortOption;", "(Ljava/lang/String;Lcom/amity/socialcloud/sdk/model/core/role/AmityRoles;Ljava/util/List;Ljava/lang/Boolean;Lcom/amity/socialcloud/sdk/api/social/member/query/AmityCommunityMembershipSortOption;)Landroidx/paging/PagingSource;", "getMemberDynamicQueryPagingSource", "getMemberSearchPagingSource", "keyword", "(Ljava/lang/String;Lcom/amity/socialcloud/sdk/model/core/role/AmityRoles;Ljava/util/List;Lcom/amity/socialcloud/sdk/api/social/member/query/AmityCommunityMembershipSortOption;Ljava/lang/String;Ljava/lang/Boolean;)Landroidx/paging/PagingSource;", "getLatestCommunityMember", "Lio/reactivex/rxjava3/core/Flowable;", "dynamicQueryStreamKeyCreator", "Lcom/ekoapp/ekosdk/internal/keycreator/DynamicQueryStreamKeyCreator;", "nonce", "notifyUserUpdate", "", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nCommunityMembershipLocalDataStore.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CommunityMembershipLocalDataStore.kt\ncom/amity/socialcloud/sdk/social/data/community/membership/CommunityMembershipLocalDataStore\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,147:1\n1563#2:148\n1634#2,3:149\n1869#2,2:152\n*S KotlinDebug\n*F\n+ 1 CommunityMembershipLocalDataStore.kt\ncom/amity/socialcloud/sdk/social/data/community/membership/CommunityMembershipLocalDataStore\n*L\n135#1:148\n135#1:149,3\n24#1:152,2\n*E\n"})
public final class CommunityMembershipLocalDataStore {
    @NotNull
    public final Completable saveCommunities(@NotNull List<? extends CommunityEntity> communities) {
        Intrinsics.checkNotNullParameter(communities, (String)"communities");
        Completable completable = Completable.fromAction(() -> CommunityMembershipLocalDataStore.saveCommunities$lambda$1(communities));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction(...)");
        return completable;
    }

    @NotNull
    public final Completable saveMemberships(@NotNull List<CommunityMembershipEntity> memberships) {
        Intrinsics.checkNotNullParameter(memberships, (String)"memberships");
        Completable completable = Completable.fromAction(() -> CommunityMembershipLocalDataStore.saveMemberships$lambda$3(memberships));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction(...)");
        return completable;
    }

    @Nullable
    public final CommunityMembershipEntity getMembership(@NotNull String communityId, @NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        Ref.ObjectRef membership = new Ref.ObjectRef();
        Completable.fromCallable(() -> CommunityMembershipLocalDataStore.getMembership$lambda$4(communityId, userId, membership)).subscribeOn(Schedulers.io()).blockingAwait();
        return (CommunityMembershipEntity)membership.element;
    }

    @NotNull
    public final PagingSource<Integer, CommunityMembershipEntity> getMemberQueryPagingSource(@NotNull String communityId, @NotNull AmityRoles roles, @NotNull List<? extends AmityCommunityMembership> filters, @Nullable Boolean isDeleted, @NotNull AmityCommunityMembershipSortOption sortBy) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Intrinsics.checkNotNullParameter((Object)roles, (String)"roles");
        Intrinsics.checkNotNullParameter(filters, (String)"filters");
        Intrinsics.checkNotNullParameter((Object)((Object)sortBy), (String)"sortBy");
        return UserDatabase.get().communityMembersPagingDao().queryCommunityMembership(communityId, roles, filters, isDeleted, sortBy);
    }

    @NotNull
    public final PagingSource<Integer, CommunityMembershipEntity> getMemberDynamicQueryPagingSource(@NotNull String communityId, @NotNull AmityRoles roles, @NotNull List<? extends AmityCommunityMembership> filters, @Nullable Boolean isDeleted, @NotNull AmityCommunityMembershipSortOption sortBy) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Intrinsics.checkNotNullParameter((Object)roles, (String)"roles");
        Intrinsics.checkNotNullParameter(filters, (String)"filters");
        Intrinsics.checkNotNullParameter((Object)((Object)sortBy), (String)"sortBy");
        return UserDatabase.get().communityMembersDynamicQueryPagingDao().queryCommunityMembership(communityId, roles, filters, isDeleted, sortBy);
    }

    @NotNull
    public final PagingSource<Integer, CommunityMembershipEntity> getMemberSearchPagingSource(@NotNull String communityId, @NotNull AmityRoles roles, @Nullable List<? extends AmityCommunityMembership> filters, @NotNull AmityCommunityMembershipSortOption sortBy, @Nullable String keyword, @Nullable Boolean isDeleted) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Intrinsics.checkNotNullParameter((Object)roles, (String)"roles");
        Intrinsics.checkNotNullParameter((Object)((Object)sortBy), (String)"sortBy");
        return UserDatabase.get().communityMemberSearchPagingDao().searchCommunityMembership(communityId, roles, filters, sortBy, keyword, isDeleted);
    }

    public static /* synthetic */ PagingSource getMemberSearchPagingSource$default(CommunityMembershipLocalDataStore communityMembershipLocalDataStore, String string, AmityRoles amityRoles, List list, AmityCommunityMembershipSortOption amityCommunityMembershipSortOption, String string2, Boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            string2 = null;
        }
        return communityMembershipLocalDataStore.getMemberSearchPagingSource(string, amityRoles, list, amityCommunityMembershipSortOption, string2, bl);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Flowable<CommunityMembershipEntity> getLatestCommunityMember(@NotNull String communityId, @NotNull List<? extends AmityCommunityMembership> memberships, @NotNull AmityRoles roles, @NotNull DynamicQueryStreamKeyCreator dynamicQueryStreamKeyCreator, int nonce) {
        Collection<String> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Intrinsics.checkNotNullParameter(memberships, (String)"memberships");
        Intrinsics.checkNotNullParameter((Object)roles, (String)"roles");
        Intrinsics.checkNotNullParameter((Object)dynamicQueryStreamKeyCreator, (String)"dynamicQueryStreamKeyCreator");
        Iterable iterable = memberships;
        String string = communityId;
        EkoCommunityMembershipDao ekoCommunityMembershipDao = UserDatabase.get().communityMembershipDao();
        boolean $i$f$map = false;
        void var9_10 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            AmityCommunityMembership amityCommunityMembership = (AmityCommunityMembership)((Object)item$iv$iv);
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getValue());
        }
        collection = (List)destination$iv$iv;
        Flowable<CommunityMembershipEntity> flowable = ekoCommunityMembershipDao.getLatestCommunityMembership(string, (List<String>)collection, roles, ((Object)dynamicQueryStreamKeyCreator.toMap()).hashCode(), nonce, DateTime.now());
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"getLatestCommunityMembership(...)");
        return flowable;
    }

    public final void notifyUserUpdate(@NotNull String userId) {
        Intrinsics.checkNotNullParameter((Object)userId, (String)"userId");
        UserDatabase.get().communityMembershipDao().updateUser(userId);
    }

    private static final void saveCommunities$lambda$1(List $communities) {
        Iterable $this$forEach$iv = $communities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string;
            boolean bl;
            CommunityEntity it = (CommunityEntity)element$iv;
            boolean bl2 = false;
            EkoCommunityMembershipDao dao = UserDatabase.get().communityMembershipDao();
            if (dao.getByCommunityIdAndUserIdNow(it.getCommunityId(), AmityCoreClient.INSTANCE.getUserId()) != null) continue;
            CommunityMembershipEntity defaultMembership = new CommunityMembershipEntity();
            defaultMembership.setCommunityId(it.getCommunityId());
            defaultMembership.setUserId(AmityCoreClient.INSTANCE.getUserId());
            defaultMembership.setRoles(new AmityRoles());
            defaultMembership.setPermissions(new AmityPermissions());
            Boolean bl3 = it.isJoined();
            boolean bl4 = bl = bl3 != null ? bl3 : false;
            if (bl) {
                string = AmityMembershipType.MEMBER.getApiKey();
            } else if (!bl) {
                string = AmityMembershipType.NONE.getApiKey();
            } else {
                throw new NoWhenBranchMatchedException();
            }
            defaultMembership.setCommunityMembership(string);
            defaultMembership.setLastJoin(null);
            defaultMembership.setCreatedAt(DateTime.now());
            defaultMembership.setUpdatedAt(DateTime.now());
            dao.insert(defaultMembership);
        }
    }

    private static final void saveMemberships$lambda$3(List $memberships) {
        block0: {
            UserDatabase.get().communityMembershipDao().save($memberships);
            UserDatabase.get().pinDao().updatePin();
            CommunityMembershipEntity communityMembershipEntity = (CommunityMembershipEntity)CollectionsKt.firstOrNull((List)$memberships);
            if (communityMembershipEntity == null) break block0;
            CommunityMembershipEntity it = communityMembershipEntity;
            boolean bl = false;
            UserDatabase.get().postDao().notifyPostByTarget("community", it.getCommunityId());
        }
    }

    private static final Unit getMembership$lambda$4(String $communityId, String $userId, Ref.ObjectRef $membership) {
        EkoCommunityMembershipDao membershipDao = UserDatabase.get().communityMembershipDao();
        CommunityMembershipEntity entity = membershipDao.getByCommunityIdAndUserIdNow($communityId, $userId);
        if (entity != null) {
            $membership.element = entity;
        }
        return Unit.INSTANCE;
    }
}

