/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.social.data.community;

import androidx.paging.PagingSource;
import com.amity.socialcloud.sdk.api.social.community.query.AmityCommunitySortOption;
import com.amity.socialcloud.sdk.model.core.tag.AmityTags;
import com.amity.socialcloud.sdk.model.social.community.AmityCommunityFilter;
import com.amity.socialcloud.sdk.model.social.community.AmityCommunityMembershipStatusFilter;
import com.amity.socialcloud.sdk.model.social.feed.AmityFeedType;
import com.amity.socialcloud.sdk.social.data.community.CommunityLocalDataStore;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.dao.AmitySearchCommunitiesPagingDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommunityDao;
import com.ekoapp.ekosdk.internal.data.dao.EkoFeedDao;
import com.ekoapp.ekosdk.internal.entity.CommunityEntity;
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J \u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00070\nJ\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\u0006\u001a\u00020\u0007J\u0014\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\nJ\u000e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007J\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u0007J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\t2\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0016J\u000e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u0007JI\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00050\u001a2\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u00182\u0006\u0010\"\u001a\u00020\u0018\u00a2\u0006\u0002\u0010#JI\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00050\u001a2\u0006\u0010\u001b\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u00182\u0006\u0010\"\u001a\u00020\u0018\u00a2\u0006\u0002\u0010#J;\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u001d\u001a\u00020\u001e2\b\u0010!\u001a\u0004\u0018\u00010\u00182\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\u0013\u00a2\u0006\u0002\u0010)J>\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00050\u001a2\u0006\u0010+\u001a\u00020\u00072\b\u0010\u001d\u001a\u0004\u0018\u00010,2\b\u0010-\u001a\u0004\u0018\u00010.2\u000e\u0010/\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\nJ\u000e\u00100\u001a\u0002012\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u00062"}, d2={"Lcom/amity/socialcloud/sdk/social/data/community/CommunityLocalDataStore;", "", "<init>", "()V", "getCommunityById", "Lcom/ekoapp/ekosdk/internal/entity/CommunityEntity;", "communityId", "", "getCommunities", "Lio/reactivex/rxjava3/core/Flowable;", "", "ids", "observeCommunity", "saveCommunities", "Lio/reactivex/rxjava3/core/Completable;", "communities", "updateJoinCommunity", "deleteCommunity", "getPostCount", "", "targetId", "feedType", "Lcom/amity/socialcloud/sdk/model/social/feed/AmityFeedType;", "hasInLocal", "", "getCommunityPagingSource", "Landroidx/paging/PagingSource;", "keyword", "categoryId", "filter", "Lcom/amity/socialcloud/sdk/model/social/community/AmityCommunityFilter;", "sortOption", "Lcom/amity/socialcloud/sdk/api/social/community/query/AmityCommunitySortOption;", "isDeleted", "includeDiscoverablePrivateCommunity", "(Ljava/lang/String;Ljava/lang/String;Lcom/amity/socialcloud/sdk/model/social/community/AmityCommunityFilter;Lcom/amity/socialcloud/sdk/api/social/community/query/AmityCommunitySortOption;Ljava/lang/Boolean;Z)Landroidx/paging/PagingSource;", "searchCommunityPagingSource", "getLatestCommunity", "dynamicQueryStreamKeyCreator", "Lcom/ekoapp/ekosdk/internal/keycreator/DynamicQueryStreamKeyCreator;", "nonce", "(Ljava/lang/String;Lcom/amity/socialcloud/sdk/model/social/community/AmityCommunityFilter;Ljava/lang/Boolean;Lcom/ekoapp/ekosdk/internal/keycreator/DynamicQueryStreamKeyCreator;I)Lio/reactivex/rxjava3/core/Flowable;", "getSearchCommunitiesPagingSource", "query", "Lcom/amity/socialcloud/sdk/model/social/community/AmityCommunityMembershipStatusFilter;", "tags", "Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;", "categoryIds", "notifyChanges", "", "amity-sdk_release"})
public final class CommunityLocalDataStore {
    @Nullable
    public final CommunityEntity getCommunityById(@NotNull String communityId) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Ref.ObjectRef community = new Ref.ObjectRef();
        Completable.fromCallable(() -> CommunityLocalDataStore.getCommunityById$lambda$0(communityId, community)).subscribeOn(Schedulers.io()).blockingAwait();
        return (CommunityEntity)community.element;
    }

    @NotNull
    public final Flowable<List<CommunityEntity>> getCommunities(@NotNull List<String> ids) {
        Intrinsics.checkNotNullParameter(ids, (String)"ids");
        Flowable flowable = UserDatabase.get().communityDao().observeByCommunityIds(ids).map(new Function(ids){
            final /* synthetic */ List<String> $ids;
            {
                this.$ids = $ids;
            }

            /*
             * WARNING - void declaration
             */
            public final List<CommunityEntity> apply(List<CommunityEntity> entities) {
                void $this$associateTo$iv$iv;
                Intrinsics.checkNotNullParameter(entities, (String)"entities");
                Iterable $this$associate$iv = CollectionsKt.withIndex((Iterable)this.$ids);
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                Iterable iterable = $this$associate$iv;
                Map destination$iv$iv = new LinkedHashMap<K, V>(capacity$iv);
                boolean $i$f$associateTo = false;
                for (T element$iv$iv : $this$associateTo$iv$iv) {
                    Map map = destination$iv$iv;
                    IndexedValue it = (IndexedValue)element$iv$iv;
                    boolean bl = false;
                    Pair pair = TuplesKt.to((Object)it.getValue(), (Object)it.getIndex());
                    map.put(pair.getFirst(), pair.getSecond());
                }
                Map orderById = destination$iv$iv;
                Iterable $this$sortedBy$iv = entities;
                boolean $i$f$sortedBy = false;
                List sortedCommunities = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(orderById){
                    final /* synthetic */ Map $orderById$inlined;
                    {
                        this.$orderById$inlined = map;
                    }

                    public final int compare(T a, T b) {
                        CommunityEntity it = (CommunityEntity)a;
                        boolean bl = false;
                        Comparable comparable = (Integer)this.$orderById$inlined.get(it.getCommunityId());
                        it = (CommunityEntity)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Integer)this.$orderById$inlined.get(it.getCommunityId())));
                    }
                });
                return sortedCommunities;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"map(...)");
        return flowable;
    }

    @NotNull
    public final Flowable<CommunityEntity> observeCommunity(@NotNull String communityId) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Flowable<CommunityEntity> flowable = UserDatabase.get().communityDao().getByCommunityId(communityId);
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"getByCommunityId(...)");
        return flowable;
    }

    @NotNull
    public final Completable saveCommunities(@NotNull List<? extends CommunityEntity> communities) {
        Intrinsics.checkNotNullParameter(communities, (String)"communities");
        Completable completable = Completable.fromAction(() -> CommunityLocalDataStore.saveCommunities$lambda$1(communities));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction(...)");
        return completable;
    }

    @NotNull
    public final Completable updateJoinCommunity(@NotNull String communityId) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Completable completable = Completable.fromAction(() -> CommunityLocalDataStore.updateJoinCommunity$lambda$2(communityId));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromAction(...)");
        return completable;
    }

    @NotNull
    public final Completable deleteCommunity(@NotNull String communityId) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        Completable completable = UserDatabase.get().communityDao().deleteByCommunityId(communityId);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"deleteByCommunityId(...)");
        return completable;
    }

    @NotNull
    public final Flowable<Integer> getPostCount(@NotNull String targetId, @NotNull AmityFeedType feedType) {
        Intrinsics.checkNotNullParameter((Object)targetId, (String)"targetId");
        Intrinsics.checkNotNullParameter((Object)((Object)feedType), (String)"feedType");
        EkoFeedDao feedDao = UserDatabase.get().feedDao();
        getPostCount.1 var4_4 = getPostCount.1.INSTANCE;
        Flowable flowable = feedDao.getCommunityFeed(targetId, feedType.getApiKey()).map(new Function((Function1)var4_4){
            private final /* synthetic */ Function1 function;
            {
                Intrinsics.checkNotNullParameter((Object)function, (String)"function");
                this.function = function;
            }

            public final /* synthetic */ Object apply(Object t) {
                return this.function.invoke(t);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"map(...)");
        return flowable;
    }

    public final boolean hasInLocal(@NotNull String communityId) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        EkoCommunityDao communityDao = UserDatabase.get().communityDao();
        return communityDao.getByIdNow(communityId) != null;
    }

    @NotNull
    public final PagingSource<Integer, CommunityEntity> getCommunityPagingSource(@NotNull String keyword, @NotNull String categoryId, @NotNull AmityCommunityFilter filter, @NotNull AmityCommunitySortOption sortOption, @Nullable Boolean isDeleted, boolean includeDiscoverablePrivateCommunity) {
        Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
        Intrinsics.checkNotNullParameter((Object)categoryId, (String)"categoryId");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOption), (String)"sortOption");
        return UserDatabase.get().communityQueryPagingDao().getCommunityPagingSource(keyword, categoryId, filter, sortOption, isDeleted, includeDiscoverablePrivateCommunity);
    }

    @NotNull
    public final PagingSource<Integer, CommunityEntity> searchCommunityPagingSource(@NotNull String keyword, @NotNull String categoryId, @NotNull AmityCommunityFilter filter, @NotNull AmityCommunitySortOption sortOption, @Nullable Boolean isDeleted, boolean includeDiscoverablePrivateCommunity) {
        Intrinsics.checkNotNullParameter((Object)keyword, (String)"keyword");
        Intrinsics.checkNotNullParameter((Object)categoryId, (String)"categoryId");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOption), (String)"sortOption");
        return UserDatabase.get().communitySearchPagingDao().getCommunityPagingSource(keyword, categoryId, filter, sortOption, isDeleted, includeDiscoverablePrivateCommunity);
    }

    @NotNull
    public final Flowable<CommunityEntity> getLatestCommunity(@NotNull String categoryId, @NotNull AmityCommunityFilter filter, @Nullable Boolean isDeleted, @NotNull DynamicQueryStreamKeyCreator dynamicQueryStreamKeyCreator, int nonce) {
        Intrinsics.checkNotNullParameter((Object)categoryId, (String)"categoryId");
        Intrinsics.checkNotNullParameter((Object)((Object)filter), (String)"filter");
        Intrinsics.checkNotNullParameter((Object)dynamicQueryStreamKeyCreator, (String)"dynamicQueryStreamKeyCreator");
        Flowable<CommunityEntity> flowable = UserDatabase.get().communityDao().getLatestCommunity(categoryId, filter, isDeleted, ((Object)dynamicQueryStreamKeyCreator.toMap()).hashCode(), nonce, DateTime.now());
        Intrinsics.checkNotNullExpressionValue(flowable, (String)"getLatestCommunity(...)");
        return flowable;
    }

    @NotNull
    public final PagingSource<Integer, CommunityEntity> getSearchCommunitiesPagingSource(@NotNull String query, @Nullable AmityCommunityMembershipStatusFilter filter, @Nullable AmityTags tags, @Nullable List<String> categoryIds) {
        Intrinsics.checkNotNullParameter((Object)query, (String)"query");
        return AmitySearchCommunitiesPagingDao.getSearchCommunitiesPagingSource$default(UserDatabase.get().searchCommunitiesPagingDao(), query, filter, tags, categoryIds, null, 16, null);
    }

    public final void notifyChanges(@NotNull String communityId) {
        Intrinsics.checkNotNullParameter((Object)communityId, (String)"communityId");
        UserDatabase.get().communityDao().notifyChanges(communityId);
    }

    private static final Unit getCommunityById$lambda$0(String $communityId, Ref.ObjectRef $community) {
        EkoCommunityDao communityDao = UserDatabase.get().communityDao();
        CommunityEntity entity = communityDao.getByIdNow($communityId);
        if (entity != null) {
            $community.element = entity;
        }
        return Unit.INSTANCE;
    }

    private static final void saveCommunities$lambda$1(List $communities) {
        UserDatabase.get().communityDao().save($communities);
    }

    private static final void updateJoinCommunity$lambda$2(String $communityId) {
        UserDatabase.get().communityDao().updateIsJoinedByCommunityId($communityId, true);
    }
}

