/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core;

import com.amity.socialcloud.sdk.chat.domain.marker.message.SyncMarkedMessageUseCase;
import com.amity.socialcloud.sdk.chat.domain.marker.reader.ReadSubChannelUseCase;
import com.amity.socialcloud.sdk.chat.domain.marker.reader.StartSubChannelReadingUseCase;
import com.amity.socialcloud.sdk.chat.domain.marker.reader.StopSubChannelReadingUseCase;
import com.amity.socialcloud.sdk.chat.domain.marker.reader.SubscribeToSubChannelMarkerTopicUseCase;
import com.amity.socialcloud.sdk.chat.domain.marker.reader.UnsubscribeToSubChannelMarkerTopicUseCase;
import com.amity.socialcloud.sdk.core.MarkerEvent;
import com.amity.socialcloud.sdk.core.session.component.SessionComponent;
import com.amity.socialcloud.sdk.core.session.eventbus.MarkerEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionLifeCycleEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionStateEventBus;
import com.amity.socialcloud.sdk.core.session.model.SessionState;
import com.ekoapp.ekosdk.internal.api.dto.MarkedMessageDto;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Predicate;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 *2\u00020\u0001:\u0001*B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0013\u001a\u00020\u0010H\u0002J\u001a\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\n2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\nJ\b\u0010\u0017\u001a\u00020\u0010H\u0002J\u001a\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\n2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\nJ\u000e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\u001aH\u0002J\b\u0010\u001b\u001a\u00020\u0010H\u0002J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\b\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020 H\u0002J\u0010\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020 2\u0006\u0010&\u001a\u00020'H\u0016J\b\u0010(\u001a\u00020 H\u0016J\b\u0010)\u001a\u00020 H\u0016R*\u0010\b\u001a\u001e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tj\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000f\u001a\u00070\u0010\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/amity/socialcloud/sdk/core/MarkReadEngine;", "Lcom/amity/socialcloud/sdk/core/session/component/SessionComponent;", "sessionLifeCycleEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;", "sessionStateEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;", "<init>", "(Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;)V", "isReadingMap", "Ljava/util/HashMap;", "", "", "Lkotlin/collections/HashMap;", "disposable", "Lio/reactivex/rxjava3/disposables/CompositeDisposable;", "timer", "Lio/reactivex/rxjava3/core/Completable;", "Lio/reactivex/rxjava3/annotations/NonNull;", "isReadyToRead", "timerDidTrigger", "startReading", "subChannelId", "channelId", "readSubChannels", "stopReading", "getReadingSubChannelId", "", "resumeReading", "syncReadAndDeliveredCount", "dto", "Lcom/ekoapp/ekosdk/internal/api/dto/MarkedMessageDto;", "startTimer", "", "stopTimer", "onSessionStateChange", "sessionState", "Lcom/amity/socialcloud/sdk/core/session/model/SessionState;", "establish", "account", "Lcom/ekoapp/ekosdk/internal/data/model/EkoAccount;", "destroy", "handleTokenExpire", "Companion", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nMarkReadEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkReadEngine.kt\ncom/amity/socialcloud/sdk/core/MarkReadEngine\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,154:1\n536#2:155\n521#2,6:156\n1#3:162\n*S KotlinDebug\n*F\n+ 1 MarkReadEngine.kt\ncom/amity/socialcloud/sdk/core/MarkReadEngine\n*L\n100#1:155\n100#1:156,6\n*E\n"})
public final class MarkReadEngine
extends SessionComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final HashMap<String, Boolean> isReadingMap;
    @NotNull
    private final CompositeDisposable disposable;
    @NotNull
    private final Completable timer;
    private boolean isReadyToRead;
    private static final long SYNC_INTERVAL = 30L;

    public MarkReadEngine(@NotNull SessionLifeCycleEventBus sessionLifeCycleEventBus, @NotNull SessionStateEventBus sessionStateEventBus) {
        Intrinsics.checkNotNullParameter((Object)sessionLifeCycleEventBus, (String)"sessionLifeCycleEventBus");
        Intrinsics.checkNotNullParameter((Object)sessionStateEventBus, (String)"sessionStateEventBus");
        super(sessionLifeCycleEventBus, sessionStateEventBus);
        this.isReadingMap = new HashMap();
        this.disposable = new CompositeDisposable();
        Completable completable = Flowable.interval((long)30L, (TimeUnit)TimeUnit.SECONDS).flatMapCompletable(new Function(this){
            final /* synthetic */ MarkReadEngine this$0;
            {
                this.this$0 = $receiver;
            }

            public final CompletableSource apply(Long it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (CompletableSource)MarkReadEngine.access$timerDidTrigger(this.this$0);
            }
        }).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"subscribeOn(...)");
        this.timer = completable;
        MarkerEventBus.INSTANCE.observe().filter((Predicate)1.INSTANCE).flatMapCompletable(new Function(){

            public final CompletableSource apply(MarkerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                MarkerEvent markerEvent = event;
                return markerEvent instanceof MarkerEvent.MarkedMessage ? (CompletableSource)this.syncReadAndDeliveredCount(((MarkerEvent.MarkedMessage)event).getDto()) : (markerEvent instanceof MarkerEvent.NetworkConnection.Connected ? (CompletableSource)this.resumeReading().onErrorComplete() : (CompletableSource)Completable.complete());
            }
        }).subscribeOn(Schedulers.io()).subscribe();
    }

    private final Completable timerDidTrigger() {
        Completable completable = this.readSubChannels().onErrorComplete();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"onErrorComplete(...)");
        return completable;
    }

    @NotNull
    public final Completable startReading(@NotNull String subChannelId, @Nullable String channelId) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Completable completable = Single.just((Object)subChannelId).flatMapCompletable(new Function(this, subChannelId){
            final /* synthetic */ MarkReadEngine this$0;
            final /* synthetic */ String $subChannelId;
            {
                this.this$0 = $receiver;
                this.$subChannelId = $subChannelId;
            }

            public final CompletableSource apply(String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ((Map)MarkReadEngine.access$isReadingMap$p(this.this$0)).put(this.$subChannelId, true);
                return (CompletableSource)new StartSubChannelReadingUseCase().execute(this.$subChannelId).doOnError(new Consumer(this.this$0, this.$subChannelId){
                    final /* synthetic */ MarkReadEngine this$0;
                    final /* synthetic */ String $subChannelId;
                    {
                        this.this$0 = $receiver;
                        this.$subChannelId = $subChannelId;
                    }

                    public final void accept(Throwable it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        ((Map)MarkReadEngine.access$isReadingMap$p(this.this$0)).put(this.$subChannelId, false);
                    }
                });
            }
        }).andThen((CompletableSource)new SubscribeToSubChannelMarkerTopicUseCase().execute(subChannelId, channelId));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"andThen(...)");
        return completable;
    }

    public static /* synthetic */ Completable startReading$default(MarkReadEngine markReadEngine, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return markReadEngine.startReading(string, string2);
    }

    private final Completable readSubChannels() {
        Completable completable;
        List<String> readingSubChannelIds = this.getReadingSubChannelId();
        if (readingSubChannelIds.isEmpty()) {
            Completable completable2 = Completable.complete();
            completable = completable2;
            Intrinsics.checkNotNullExpressionValue((Object)completable2, (String)"complete(...)");
        } else if (this.isReadyToRead) {
            completable = new ReadSubChannelUseCase().execute(readingSubChannelIds);
        } else {
            Completable completable3 = Completable.complete();
            Intrinsics.checkNotNull((Object)completable3);
            completable = completable3;
        }
        return completable;
    }

    @NotNull
    public final Completable stopReading(@NotNull String subChannelId, @Nullable String channelId) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        ((Map)this.isReadingMap).put(subChannelId, false);
        Completable completable = new StopSubChannelReadingUseCase().execute(subChannelId).andThen((CompletableSource)new UnsubscribeToSubChannelMarkerTopicUseCase().execute(subChannelId, channelId));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"andThen(...)");
        return completable;
    }

    public static /* synthetic */ Completable stopReading$default(MarkReadEngine markReadEngine, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        return markReadEngine.stopReading(string, string2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> getReadingSubChannelId() {
        void $this$filterTo$iv$iv;
        Map $this$filter$iv = this.isReadingMap;
        boolean $i$f$filter = false;
        Map map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            if (!((Boolean)it.getValue()).booleanValue()) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return CollectionsKt.toList((Iterable)destination$iv$iv.keySet());
    }

    private final Completable resumeReading() {
        return this.readSubChannels();
    }

    private final Completable syncReadAndDeliveredCount(MarkedMessageDto dto) {
        Completable completable = new SyncMarkedMessageUseCase().execute(dto).onErrorComplete();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"onErrorComplete(...)");
        return completable;
    }

    private final void startTimer() {
        if (this.disposable.size() == 0 || this.disposable.isDisposed()) {
            this.disposable.clear();
            Disposable disposable = this.timer.subscribe();
            CompositeDisposable compositeDisposable = this.disposable;
            Disposable p0 = disposable;
            boolean bl = false;
            compositeDisposable.add(p0);
        }
    }

    private final void stopTimer() {
        if (this.disposable.size() > 0) {
            this.disposable.clear();
        }
    }

    @Override
    public void onSessionStateChange(@NotNull SessionState sessionState) {
        Intrinsics.checkNotNullParameter((Object)sessionState, (String)"sessionState");
        this.isReadyToRead = Intrinsics.areEqual((Object)sessionState, (Object)SessionState.Established.INSTANCE);
    }

    @Override
    public void establish(@NotNull EkoAccount account) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        this.isReadyToRead = true;
        this.startTimer();
    }

    @Override
    public void destroy() {
        this.isReadyToRead = false;
        this.stopTimer();
        this.isReadingMap.clear();
    }

    @Override
    public void handleTokenExpire() {
        this.isReadyToRead = false;
        this.stopTimer();
    }

    public static final /* synthetic */ HashMap access$isReadingMap$p(MarkReadEngine $this) {
        return $this.isReadingMap;
    }

    public static final /* synthetic */ Completable access$timerDidTrigger(MarkReadEngine $this) {
        return $this.timerDidTrigger();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/amity/socialcloud/sdk/core/MarkReadEngine$Companion;", "", "<init>", "()V", "SYNC_INTERVAL", "", "amity-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

