/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.chat.data.message;

import android.net.Uri;
import androidx.paging.PagingConfig;
import androidx.paging.PagingData;
import androidx.paging.PagingSource;
import co.amity.rxbridge.FlowableKt;
import com.amity.socialcloud.sdk.api.chat.message.query.AmityMessageQuerySortOption;
import com.amity.socialcloud.sdk.chat.data.marker.message.MessageMarkerRepository;
import com.amity.socialcloud.sdk.chat.data.message.MessageLocalDataStore;
import com.amity.socialcloud.sdk.chat.data.message.MessageModelMapper;
import com.amity.socialcloud.sdk.chat.data.message.MessageQueryPersister;
import com.amity.socialcloud.sdk.chat.data.message.MessageRemoteDataStore;
import com.amity.socialcloud.sdk.chat.data.message.MessageRepository;
import com.amity.socialcloud.sdk.chat.data.message.flag.MessageFlagLocalDataStore;
import com.amity.socialcloud.sdk.chat.data.message.flag.MessageFlagRemoteDataStore;
import com.amity.socialcloud.sdk.chat.data.message.paging.MessageMediator;
import com.amity.socialcloud.sdk.chat.domain.marker.message.OptimisticCreateMessageMarkerUseCase;
import com.amity.socialcloud.sdk.common.AmityObjectRepository;
import com.amity.socialcloud.sdk.common.ModelMapper;
import com.amity.socialcloud.sdk.core.CoreClient;
import com.amity.socialcloud.sdk.core.MarkerSyncEngine;
import com.amity.socialcloud.sdk.core.MessagePreviewEvent;
import com.amity.socialcloud.sdk.core.MessageSyncEngine;
import com.amity.socialcloud.sdk.core.data.file.FileLocalDataStore;
import com.amity.socialcloud.sdk.core.session.eventbus.MessagePreviewEventBus;
import com.amity.socialcloud.sdk.model.chat.message.AmityMessage;
import com.amity.socialcloud.sdk.model.chat.message.AmityMessageAttachment;
import com.amity.socialcloud.sdk.model.core.error.AmityError;
import com.amity.socialcloud.sdk.model.core.error.AmityException;
import com.amity.socialcloud.sdk.model.core.file.AmityFileInfo;
import com.amity.socialcloud.sdk.model.core.file.upload.AmityUploadResult;
import com.amity.socialcloud.sdk.model.core.flag.AmityContentFlagReason;
import com.amity.socialcloud.sdk.model.core.mention.AmityMentioneeTarget;
import com.amity.socialcloud.sdk.model.core.tag.AmityTags;
import com.ekoapp.ekosdk.internal.EkoMessageEntity;
import com.ekoapp.ekosdk.internal.api.dto.EkoMessageDto;
import com.ekoapp.ekosdk.internal.api.dto.MessageQueryDto;
import com.ekoapp.ekosdk.internal.api.dto.SubChannelDto;
import com.ekoapp.ekosdk.internal.api.socket.request.FlagContentRequest;
import com.ekoapp.ekosdk.internal.keycreator.DynamicQueryStreamKeyCreator;
import com.ekoapp.ekosdk.internal.paging.DynamicQueryStreamPagerCreator;
import com.ekoapp.ekosdk.internal.repository.comment.CommentLoadResult;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableEmitter;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.functions.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00b6\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 V2\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001VB\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u0014\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\fH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0002J^\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\t2\b\u0010\u0013\u001a\u0004\u0018\u00010\t2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00192\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eJj\u0010 \u001a\u00020\u0007\"\b\b\u0000\u0010!*\u00020\"2\u0006\u0010#\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t2\b\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00192\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\f\u0010$\u001a\b\u0012\u0004\u0012\u0002H!0%H\u0002J\\\u0010&\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\t2\b\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\t2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00192\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eJ\\\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00020(2\u0006\u0010\u0012\u001a\u00020\t2\b\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0006\u0010\u0017\u001a\u00020\t2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010\u001c\u001a\u0004\u0018\u00010\u00192\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eH\u0002J#\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e2\u0006\u0010\u0012\u001a\u00020\t2\b\u0010*\u001a\u0004\u0018\u00010+\u00a2\u0006\u0002\u0010,J<\u0010-\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\t2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00192\u000e\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\u001f\u0018\u00010\u001eJ\u000e\u0010.\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\tJ\u0016\u0010/\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\t2\u0006\u00100\u001a\u000201J\u000e\u00102\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\tJ]\u00103\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u001e0\u000e2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u00104\u001a\u00020+2\b\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0006\u00105\u001a\u00020\u001b2\u0006\u00106\u001a\u00020\u001b2\b\u0010*\u001a\u0004\u0018\u00010+2\b\u0010\u0017\u001a\u0004\u0018\u00010\t2\u0006\u00107\u001a\u000208\u00a2\u0006\u0002\u00109J_\u0010:\u001a\b\u0012\u0004\u0012\u00020;0(2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u00107\u001a\u0002082\b\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0006\u00104\u001a\u00020+2\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u00105\u001a\u00020\u001b2\u0006\u00106\u001a\u00020\u001b2\b\u0010\u0017\u001a\u0004\u0018\u00010\t2\u0006\u0010<\u001a\u00020\u0010\u00a2\u0006\u0002\u0010=J_\u0010>\u001a\b\u0012\u0004\u0012\u00020;0(2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u00107\u001a\u0002082\b\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0006\u00104\u001a\u00020+2\b\u0010*\u001a\u0004\u0018\u00010+2\u0006\u00105\u001a\u00020\u001b2\u0006\u00106\u001a\u00020\u001b2\b\u0010\u0017\u001a\u0004\u0018\u00010\t2\u0006\u0010?\u001a\u00020\t\u00a2\u0006\u0002\u0010@Jg\u0010A\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030B0\u000e2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u00104\u001a\u00020+2\b\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0006\u00105\u001a\u00020\u001b2\u0006\u00106\u001a\u00020\u001b2\b\u0010*\u001a\u0004\u0018\u00010+2\b\u0010C\u001a\u0004\u0018\u00010\t2\u0006\u00107\u001a\u0002082\b\u0010\u0017\u001a\u0004\u0018\u00010D\u00a2\u0006\u0002\u0010EJi\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e2\u0006\u0010\u0012\u001a\u00020\t2\u0006\u00104\u001a\u00020+2\b\u0010\u0013\u001a\u0004\u0018\u00010\t2\u0006\u00105\u001a\u00020\u001b2\u0006\u00106\u001a\u00020\u001b2\b\u0010*\u001a\u0004\u0018\u00010+2\b\u0010\u0017\u001a\u0004\u0018\u00010\t2\u0006\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020\u00102\b\b\u0002\u0010J\u001a\u00020+\u00a2\u0006\u0002\u0010KJ\u0014\u0010L\u001a\b\u0012\u0004\u0012\u00020+0(2\u0006\u0010#\u001a\u00020\tJ\u001d\u0010M\u001a\u00020N2\u0006\u0010#\u001a\u00020\t2\u0006\u0010O\u001a\u00020\u0010H\u0000\u00a2\u0006\u0002\bPJ\u0010\u0010Q\u001a\u00020\u00072\u0006\u0010R\u001a\u00020SH\u0002J\u0006\u0010T\u001a\u00020\u0007J\u001a\u0010U\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u001e0(2\u0006\u0010#\u001a\u00020\t\u00a8\u0006W"}, d2={"Lcom/amity/socialcloud/sdk/chat/data/message/MessageRepository;", "Lcom/amity/socialcloud/sdk/common/AmityObjectRepository;", "Lcom/ekoapp/ekosdk/internal/EkoMessageEntity;", "Lcom/amity/socialcloud/sdk/model/chat/message/AmityMessage;", "<init>", "()V", "fetchAndSave", "Lio/reactivex/rxjava3/core/Completable;", "objectId", "", "queryFromCache", "mapper", "Lcom/amity/socialcloud/sdk/common/ModelMapper;", "observeFromCache", "Lio/reactivex/rxjava3/core/Flowable;", "getDefaultPageSize", "", "createMessage", "subChannelId", "parentId", "fileUri", "Landroid/net/Uri;", "fileId", "type", "data", "Lcom/google/gson/JsonObject;", "tags", "Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;", "metadata", "mentionees", "", "Lcom/amity/socialcloud/sdk/model/core/mention/AmityMentioneeTarget;", "handleUploadResult", "T", "Lcom/amity/socialcloud/sdk/model/core/file/AmityFileInfo;", "messageId", "uploadResult", "Lcom/amity/socialcloud/sdk/model/core/file/upload/AmityUploadResult;", "syncMessage", "createPreviewMessage", "Lio/reactivex/rxjava3/core/Single;", "observeLatestMessage", "isDeleted", "", "(Ljava/lang/String;Ljava/lang/Boolean;)Lio/reactivex/rxjava3/core/Flowable;", "updateMessage", "deleteMessage", "flagMessage", "reason", "Lcom/amity/socialcloud/sdk/model/core/flag/AmityContentFlagReason;", "unflagMessage", "observeMessages", "isFilterByParentId", "includingTags", "excludingTags", "sortOption", "Lcom/amity/socialcloud/sdk/api/chat/message/query/AmityMessageQuerySortOption;", "(Ljava/lang/String;ZLjava/lang/String;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Ljava/lang/Boolean;Ljava/lang/String;Lcom/amity/socialcloud/sdk/api/chat/message/query/AmityMessageQuerySortOption;)Lio/reactivex/rxjava3/core/Flowable;", "loadFirstPageMessages", "Lcom/ekoapp/ekosdk/internal/repository/comment/CommentLoadResult;", "limit", "(Ljava/lang/String;Lcom/amity/socialcloud/sdk/api/chat/message/query/AmityMessageQuerySortOption;Ljava/lang/String;ZLjava/lang/Boolean;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Ljava/lang/String;I)Lio/reactivex/rxjava3/core/Single;", "loadMessages", "token", "(Ljava/lang/String;Lcom/amity/socialcloud/sdk/api/chat/message/query/AmityMessageQuerySortOption;Ljava/lang/String;ZLjava/lang/Boolean;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Ljava/lang/String;Ljava/lang/String;)Lio/reactivex/rxjava3/core/Single;", "getMessagePagingData", "Landroidx/paging/PagingData;", "aroundMessageId", "Lcom/amity/socialcloud/sdk/model/chat/message/AmityMessage$DataType;", "(Ljava/lang/String;ZLjava/lang/String;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Ljava/lang/Boolean;Ljava/lang/String;Lcom/amity/socialcloud/sdk/api/chat/message/query/AmityMessageQuerySortOption;Lcom/amity/socialcloud/sdk/model/chat/message/AmityMessage$DataType;)Lio/reactivex/rxjava3/core/Flowable;", "getLatestMessage", "dynamicQueryStreamKeyCreator", "Lcom/ekoapp/ekosdk/internal/keycreator/DynamicQueryStreamKeyCreator;", "nonce", "isUnsyncedOnly", "(Ljava/lang/String;ZLjava/lang/String;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Lcom/amity/socialcloud/sdk/model/core/tag/AmityTags;Ljava/lang/Boolean;Ljava/lang/String;Lcom/ekoapp/ekosdk/internal/keycreator/DynamicQueryStreamKeyCreator;IZ)Lio/reactivex/rxjava3/core/Flowable;", "isFlaggedByMe", "updateMarkerHash", "", "hash", "updateMarkerHash$amity_sdk_release", "fetchMessageMarker", "dto", "Lcom/ekoapp/ekosdk/internal/api/dto/MessageQueryDto;", "deleteFailedMessages", "findCacheAroundMessageId", "Companion", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nMessageRepository.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MessageRepository.kt\ncom/amity/socialcloud/sdk/chat/data/message/MessageRepository\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,570:1\n774#2:571\n865#2,2:572\n1563#2:574\n1634#2,3:575\n*S KotlinDebug\n*F\n+ 1 MessageRepository.kt\ncom/amity/socialcloud/sdk/chat/data/message/MessageRepository\n*L\n539#1:571\n539#1:572,2\n540#1:574\n540#1:575,3\n*E\n"})
public final class MessageRepository
extends AmityObjectRepository<EkoMessageEntity, AmityMessage> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<AmityMessage.DataType> fileUploadingTypes;

    @Override
    @NotNull
    public Completable fetchAndSave(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        Completable completable = new MessageRemoteDataStore().getMessage(objectId).flatMapCompletable(new Function(this){
            final /* synthetic */ MessageRepository this$0;
            {
                this.this$0 = $receiver;
            }

            public final CompletableSource apply(MessageQueryDto dto) {
                Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
                return (CompletableSource)MessageRepository.access$fetchMessageMarker(this.this$0, dto).andThen((CompletableSource)new MessageQueryPersister().persist(dto));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"flatMapCompletable(...)");
        return completable;
    }

    @Override
    @Nullable
    public EkoMessageEntity queryFromCache(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        EkoMessageEntity message = new MessageLocalDataStore().getMessage(objectId);
        if (message != null && AmityMessage.State.Companion.enumOf(message.getSyncState()) != AmityMessage.State.SYNCED) {
            throw AmityException.Companion.create$default(AmityException.Companion, "Observing unsynced object is not supported by Live Object.", null, AmityError.UNSUPPORTED, null, 8, null);
        }
        return message;
    }

    @Override
    @NotNull
    public ModelMapper<EkoMessageEntity, AmityMessage> mapper() {
        return new MessageModelMapper();
    }

    @Override
    @NotNull
    public Flowable<EkoMessageEntity> observeFromCache(@NotNull String objectId) {
        Intrinsics.checkNotNullParameter((Object)objectId, (String)"objectId");
        return new MessageLocalDataStore().observeMessage(objectId);
    }

    private final int getDefaultPageSize() {
        return 40;
    }

    @NotNull
    public final Completable createMessage(@NotNull String subChannelId, @Nullable String parentId, @Nullable Uri fileUri, @Nullable String fileId, @NotNull String type2, @NotNull JsonObject data, @NotNull AmityTags tags, @Nullable JsonObject metadata, @NotNull List<AmityMentioneeTarget> mentionees) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)tags, (String)"tags");
        Intrinsics.checkNotNullParameter(mentionees, (String)"mentionees");
        Completable completable = this.createPreviewMessage(subChannelId, parentId, type2, data, tags, fileUri, metadata, mentionees).flatMapCompletable(new Function(fileId, fileUri){
            final /* synthetic */ String $fileId;
            final /* synthetic */ Uri $fileUri;
            {
                this.$fileId = $fileId;
                this.$fileUri = $fileUri;
            }

            public final CompletableSource apply(EkoMessageEntity message) {
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                return (CompletableSource)Completable.create(arg_0 -> createMessage.1.apply$lambda$0(this.$fileId, message, this.$fileUri, arg_0));
            }

            private static final void apply$lambda$0(String $fileId, EkoMessageEntity $message, Uri $fileUri, CompletableEmitter emitter) {
                Intrinsics.checkNotNullParameter((Object)emitter, (String)"emitter");
                if ($fileId != null) {
                    Intrinsics.checkNotNull((Object)$message);
                    CoreClient.INSTANCE.createAttachmentMessage($message, emitter, new AmityMessageAttachment.FILE_ID($fileId));
                } else if ($fileUri != null) {
                    MessageSyncEngine.Companion.grantPersistableUriPermissionIfNeeded($fileUri);
                    Intrinsics.checkNotNull((Object)$message);
                    CoreClient.INSTANCE.createAttachmentMessage($message, emitter, new AmityMessageAttachment.URL($fileUri));
                } else {
                    Intrinsics.checkNotNull((Object)$message);
                    CoreClient.INSTANCE.createTextMessage($message, emitter);
                }
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"flatMapCompletable(...)");
        return completable;
    }

    public static /* synthetic */ Completable createMessage$default(MessageRepository messageRepository, String string, String string2, Uri uri, String string3, String string4, JsonObject jsonObject, AmityTags amityTags, JsonObject jsonObject2, List list, int n, Object object) {
        if ((n & 8) != 0) {
            string3 = null;
        }
        return messageRepository.createMessage(string, string2, uri, string3, string4, jsonObject, amityTags, jsonObject2, list);
    }

    private final <T extends AmityFileInfo> Completable handleUploadResult(String messageId, String subChannelId, String parentId, String type2, JsonObject data, AmityTags tags, JsonObject metadata, List<AmityMentioneeTarget> mentionees, AmityUploadResult<? extends T> uploadResult) {
        Completable completable;
        AmityUploadResult<? extends T> amityUploadResult = uploadResult;
        if (amityUploadResult instanceof AmityUploadResult.COMPLETE) {
            String fileId = ((AmityFileInfo)((AmityUploadResult.COMPLETE)uploadResult).getFile()).getFileId();
            completable = this.syncMessage(messageId, subChannelId, parentId, type2, data, tags, fileId, metadata, mentionees);
        } else if (amityUploadResult instanceof AmityUploadResult.ERROR) {
            Completable completable2 = new MessageLocalDataStore().updateMessageState(messageId, AmityMessage.State.FAILED).andThen((CompletableSource)Completable.error((Throwable)((AmityUploadResult.ERROR)uploadResult).getError()));
            Intrinsics.checkNotNull((Object)completable2);
            completable = completable2;
        } else if (amityUploadResult instanceof AmityUploadResult.CANCELLED) {
            Completable completable3 = new MessageLocalDataStore().updateMessageState(messageId, AmityMessage.State.FAILED).andThen((CompletableSource)Completable.error((Throwable)AmityException.Companion.create$default(AmityException.Companion, StringsKt.capitalize((String)type2) + " upload cancelled", null, AmityError.UNKNOWN, null, 8, null)));
            Intrinsics.checkNotNull((Object)completable3);
            completable = completable3;
        } else {
            Completable completable4 = Completable.complete();
            Intrinsics.checkNotNull((Object)completable4);
            completable = completable4;
        }
        return completable;
    }

    @NotNull
    public final Completable syncMessage(@NotNull String messageId, @NotNull String subChannelId, @Nullable String parentId, @NotNull String type2, @NotNull JsonObject data, @NotNull AmityTags tags, @Nullable String fileId, @Nullable JsonObject metadata, @NotNull List<AmityMentioneeTarget> mentionees) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)tags, (String)"tags");
        Intrinsics.checkNotNullParameter(mentionees, (String)"mentionees");
        if (data.has("fileId")) {
            data.remove("fileId");
        }
        Completable completable = new MessageLocalDataStore().updateMessageState(messageId, AmityMessage.State.SYNCING).andThen((CompletableSource)new MessageRemoteDataStore().createMessage(messageId, parentId, subChannelId, fileId, type2, data, tags, metadata, mentionees).flatMapCompletable(new Function(messageId){
            final /* synthetic */ String $messageId;
            {
                this.$messageId = $messageId;
            }

            public final CompletableSource apply(MessageQueryDto dto) {
                Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
                return (CompletableSource)new OptimisticCreateMessageMarkerUseCase().execute(dto).onErrorComplete().andThen((CompletableSource)new MessageQueryPersister().persist(dto)).andThen((CompletableSource)new MessageLocalDataStore().updateMessageState(this.$messageId, AmityMessage.State.SYNCED)).andThen((CompletableSource)Completable.fromCallable(() -> syncMessage.1.apply$lambda$3(dto)).onErrorComplete());
            }

            /*
             * WARNING - void declaration
             */
            private static final Object apply$lambda$3(MessageQueryDto $dto) {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = $dto.getMessages();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    Unit unit;
                    Object v0;
                    void message;
                    Collection collection;
                    block4: {
                        EkoMessageDto ekoMessageDto = (EkoMessageDto)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        Iterable iterable2 = $dto.getSubChannels();
                        for (T t : iterable2) {
                            SubChannelDto it = (SubChannelDto)t;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)it.getSubChannelId(), (Object)message.getSubChannelId())) continue;
                            v0 = t;
                            break block4;
                        }
                        v0 = null;
                    }
                    if ((SubChannelDto)v0 != null) {
                        SubChannelDto subChannel;
                        boolean bl = false;
                        MessagePreviewEventBus.INSTANCE.publish(new MessagePreviewEvent.MessageCreated((EkoMessageDto)message, subChannel));
                        unit = Unit.INSTANCE;
                    } else {
                        unit = null;
                    }
                    collection.add(unit);
                }
                return (List)destination$iv$iv;
            }
        }));
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"andThen(...)");
        return completable;
    }

    public static /* synthetic */ Completable syncMessage$default(MessageRepository messageRepository, String string, String string2, String string3, String string4, JsonObject jsonObject, AmityTags amityTags, String string5, JsonObject jsonObject2, List list, int n, Object object) {
        if ((n & 0x40) != 0) {
            string5 = null;
        }
        return messageRepository.syncMessage(string, string2, string3, string4, jsonObject, amityTags, string5, jsonObject2, list);
    }

    private final Single<EkoMessageEntity> createPreviewMessage(String subChannelId, String parentId, String type2, JsonObject data, AmityTags tags, Uri fileUri, JsonObject metadata, List<AmityMentioneeTarget> mentionees) {
        Single single = new MessageLocalDataStore().createMessage(subChannelId, parentId, type2, data, metadata, tags, fileUri, mentionees).flatMap(new Function(fileUri){
            final /* synthetic */ Uri $fileUri;
            {
                this.$fileUri = $fileUri;
            }

            public final SingleSource<? extends EkoMessageEntity> apply(EkoMessageEntity message) {
                Completable completable;
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Completable completable2 = new MessageFlagLocalDataStore().createFlag(message.getMessageId());
                if (!MessageRepository.access$getFileUploadingTypes$cp().contains((Object)((Object)message.getDataType()))) {
                    completable = Completable.complete();
                } else {
                    Object object;
                    String fileType;
                    switch (createPreviewMessage.WhenMappings.$EnumSwitchMapping$0[message.getDataType().ordinal()]) {
                        case 1: {
                            String string = AmityMessage.DataType.IMAGE.getApiKey();
                            break;
                        }
                        case 2: {
                            String string = AmityMessage.DataType.VIDEO.getApiKey();
                            break;
                        }
                        case 3: {
                            String string = AmityMessage.DataType.AUDIO.getApiKey();
                            break;
                        }
                        default: {
                            String string = fileType = AmityMessage.DataType.FILE.getApiKey();
                        }
                    }
                    if ((object = this.$fileUri) == null || (object = object.toString()) == null) {
                        object = "";
                    }
                    Object path = object;
                    completable = new FileLocalDataStore().createLocalFile(message.getMessageId(), fileType, (String)path);
                }
                return (SingleSource)completable2.andThen((CompletableSource)completable).andThen((SingleSource)Single.just((Object)message));
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"flatMap(...)");
        return single;
    }

    @NotNull
    public final Flowable<AmityMessage> observeLatestMessage(@NotNull String subChannelId, @Nullable Boolean isDeleted) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Flowable flowable = new MessageLocalDataStore().observeLatestMessage(subChannelId, isDeleted).map((Function)observeLatestMessage.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"map(...)");
        return flowable;
    }

    @NotNull
    public final Completable updateMessage(@NotNull String messageId, @Nullable JsonObject data, @Nullable AmityTags tags, @Nullable JsonObject metadata, @Nullable List<AmityMentioneeTarget> mentionees) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Completable completable = new MessageRemoteDataStore().updateMessage(messageId, data, tags, metadata, mentionees).flatMapCompletable((Function)updateMessage.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"flatMapCompletable(...)");
        return completable;
    }

    @NotNull
    public final Completable deleteMessage(@NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Completable completable = Single.fromCallable(() -> MessageRepository.deleteMessage$lambda$0(messageId)).flatMapCompletable(new Function(messageId){
            final /* synthetic */ String $messageId;
            {
                this.$messageId = $messageId;
            }

            public final CompletableSource apply(String deletingId) {
                Intrinsics.checkNotNull((Object)deletingId);
                return ((CharSequence)deletingId).length() > 0 ? (CompletableSource)new MessageRemoteDataStore().deleteMessage(this.$messageId).flatMapCompletable((Function)deleteMessage.1.INSTANCE) : (CompletableSource)new MessageLocalDataStore().hardDeleteMessage(this.$messageId);
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"flatMapCompletable(...)");
        return completable;
    }

    @NotNull
    public final Completable flagMessage(@NotNull String messageId, @NotNull AmityContentFlagReason reason) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        FlagContentRequest request = reason instanceof AmityContentFlagReason.Others ? new FlagContentRequest(reason.getReason(), ((AmityContentFlagReason.Others)reason).getDetails()) : new FlagContentRequest(reason.getReason(), null, 2, null);
        Completable completable = new MessageFlagRemoteDataStore().flagMessage(messageId, request).map((Function)flagMessage.1.INSTANCE).ignoreElement();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"ignoreElement(...)");
        return completable;
    }

    @NotNull
    public final Completable unflagMessage(@NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Completable completable = new MessageFlagRemoteDataStore().unflagMessage(messageId).map((Function)unflagMessage.1.INSTANCE).ignoreElement();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"ignoreElement(...)");
        return completable;
    }

    @NotNull
    public final Flowable<List<AmityMessage>> observeMessages(@NotNull String subChannelId, boolean isFilterByParentId, @Nullable String parentId, @NotNull AmityTags includingTags, @NotNull AmityTags excludingTags, @Nullable Boolean isDeleted, @Nullable String type2, @NotNull AmityMessageQuerySortOption sortOption) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Intrinsics.checkNotNullParameter((Object)includingTags, (String)"includingTags");
        Intrinsics.checkNotNullParameter((Object)excludingTags, (String)"excludingTags");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOption), (String)"sortOption");
        Flowable flowable = new MessageLocalDataStore().observeMessages(subChannelId, isFilterByParentId, parentId, includingTags, excludingTags, isDeleted, type2, sortOption).map((Function)observeMessages.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"map(...)");
        return flowable;
    }

    @NotNull
    public final Single<CommentLoadResult> loadFirstPageMessages(@NotNull String subChannelId, @NotNull AmityMessageQuerySortOption sortOption, @Nullable String parentId, boolean isFilterByParentId, @Nullable Boolean isDeleted, @NotNull AmityTags includingTags, @NotNull AmityTags excludingTags, @Nullable String type2, int limit) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOption), (String)"sortOption");
        Intrinsics.checkNotNullParameter((Object)includingTags, (String)"includingTags");
        Intrinsics.checkNotNullParameter((Object)excludingTags, (String)"excludingTags");
        MessageRemoteDataStore messageRemoteDataStore = new MessageRemoteDataStore();
        String string = sortOption.getApiKey();
        Single single = MessageRemoteDataStore.queryMessages$default(messageRemoteDataStore, subChannelId, isFilterByParentId, parentId, isDeleted, includingTags, excludingTags, type2, null, limit, string, null, 1152, null).flatMap(new Function(subChannelId, this){
            final /* synthetic */ String $subChannelId;
            final /* synthetic */ MessageRepository this$0;
            {
                this.$subChannelId = $subChannelId;
                this.this$0 = $receiver;
            }

            public final SingleSource<? extends MessageQueryDto> apply(MessageQueryDto it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (SingleSource)new MessageLocalDataStore().hardDeleteAllFromSubChannel(this.$subChannelId).andThen((CompletableSource)MessageRepository.access$fetchMessageMarker(this.this$0, it)).andThen((CompletableSource)new MessageQueryPersister().persist(it)).andThen((SingleSource)Single.just((Object)it));
            }
        }).map((Function)loadFirstPageMessages.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"map(...)");
        return single;
    }

    @NotNull
    public final Single<CommentLoadResult> loadMessages(@NotNull String subChannelId, @NotNull AmityMessageQuerySortOption sortOption, @Nullable String parentId, boolean isFilterByParentId, @Nullable Boolean isDeleted, @NotNull AmityTags includingTags, @NotNull AmityTags excludingTags, @Nullable String type2, @NotNull String token) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOption), (String)"sortOption");
        Intrinsics.checkNotNullParameter((Object)includingTags, (String)"includingTags");
        Intrinsics.checkNotNullParameter((Object)excludingTags, (String)"excludingTags");
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Single single = MessageRemoteDataStore.queryMessages$default(new MessageRemoteDataStore(), subChannelId, isFilterByParentId, parentId, isDeleted, includingTags, excludingTags, type2, null, null, sortOption.getApiKey(), token, 384, null).flatMap(new Function(this){
            final /* synthetic */ MessageRepository this$0;
            {
                this.this$0 = $receiver;
            }

            public final SingleSource<? extends MessageQueryDto> apply(MessageQueryDto dto) {
                Intrinsics.checkNotNullParameter((Object)dto, (String)"dto");
                return (SingleSource)MessageRepository.access$fetchMessageMarker(this.this$0, dto).andThen((CompletableSource)new MessageQueryPersister().persist(dto)).andThen((SingleSource)Single.just((Object)dto));
            }
        }).map((Function)loadMessages.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"map(...)");
        return single;
    }

    @NotNull
    public final Flowable<PagingData<AmityMessage>> getMessagePagingData(@NotNull String subChannelId, boolean isFilterByParentId, @Nullable String parentId, @NotNull AmityTags includingTags, @NotNull AmityTags excludingTags, @Nullable Boolean isDeleted, @Nullable String aroundMessageId, @NotNull AmityMessageQuerySortOption sortOption, @Nullable AmityMessage.DataType type2) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Intrinsics.checkNotNullParameter((Object)includingTags, (String)"includingTags");
        Intrinsics.checkNotNullParameter((Object)excludingTags, (String)"excludingTags");
        Intrinsics.checkNotNullParameter((Object)((Object)sortOption), (String)"sortOption");
        String uniqueId = aroundMessageId != null ? UUID.randomUUID().toString() : null;
        AmityMessage.DataType dataType = type2;
        DynamicQueryStreamPagerCreator pagerCreator = new DynamicQueryStreamPagerCreator(new PagingConfig(this.getDefaultPageSize(), 0, true, 0, 0, 0, 58, null), null, new MessageMediator(subChannelId, isFilterByParentId, parentId, includingTags, excludingTags, isDeleted, sortOption, dataType != null ? dataType.getApiKey() : null, aroundMessageId, uniqueId), () -> MessageRepository.getMessagePagingData$lambda$1(subChannelId, isFilterByParentId, parentId, includingTags, excludingTags, isDeleted, sortOption, type2, aroundMessageId, uniqueId), (ModelMapper)new MessageModelMapper(), 2, null);
        return FlowableKt.toRx3(pagerCreator.create());
    }

    @NotNull
    public final Flowable<AmityMessage> getLatestMessage(@NotNull String subChannelId, boolean isFilterByParentId, @Nullable String parentId, @NotNull AmityTags includingTags, @NotNull AmityTags excludingTags, @Nullable Boolean isDeleted, @Nullable String type2, @NotNull DynamicQueryStreamKeyCreator dynamicQueryStreamKeyCreator, int nonce, boolean isUnsyncedOnly) {
        Intrinsics.checkNotNullParameter((Object)subChannelId, (String)"subChannelId");
        Intrinsics.checkNotNullParameter((Object)includingTags, (String)"includingTags");
        Intrinsics.checkNotNullParameter((Object)excludingTags, (String)"excludingTags");
        Intrinsics.checkNotNullParameter((Object)dynamicQueryStreamKeyCreator, (String)"dynamicQueryStreamKeyCreator");
        Flowable flowable = new MessageLocalDataStore().getLatestMessage(subChannelId, isFilterByParentId, parentId, includingTags, excludingTags, isDeleted, type2, dynamicQueryStreamKeyCreator, nonce, isUnsyncedOnly).map((Function)getLatestMessage.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"map(...)");
        return flowable;
    }

    public static /* synthetic */ Flowable getLatestMessage$default(MessageRepository messageRepository, String string, boolean bl, String string2, AmityTags amityTags, AmityTags amityTags2, Boolean bl2, String string3, DynamicQueryStreamKeyCreator dynamicQueryStreamKeyCreator, int n, boolean bl3, int n2, Object object) {
        if ((n2 & 0x200) != 0) {
            bl3 = false;
        }
        return messageRepository.getLatestMessage(string, bl, string2, amityTags, amityTags2, bl2, string3, dynamicQueryStreamKeyCreator, n, bl3);
    }

    @NotNull
    public final Single<Boolean> isFlaggedByMe(@NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        Single single = new MessageFlagRemoteDataStore().isFlaggedByMe(messageId).map((Function)isFlaggedByMe.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)single, (String)"map(...)");
        return single;
    }

    public final void updateMarkerHash$amity_sdk_release(@NotNull String messageId, int hash) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        new MessageLocalDataStore().updateMarkerHash(messageId, hash);
    }

    /*
     * WARNING - void declaration
     */
    private final Completable fetchMessageMarker(MessageQueryDto dto) {
        void $this$mapTo$iv$iv;
        EkoMessageDto it;
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv = dto.getMessages();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (EkoMessageDto)element$iv$iv;
            boolean bl = false;
            if (!MarkerSyncEngine.Companion.isMarkerSyncSupport(it.getChannelType())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (EkoMessageDto)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getMessageId());
        }
        List messageIds = (List)destination$iv$iv;
        boolean bl = false;
        Completable completable = (messageIds.isEmpty() ? Completable.complete() : new MessageMarkerRepository().fetchMessageMarker(messageIds)).onErrorComplete();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"onErrorComplete(...)");
        return completable;
    }

    @NotNull
    public final Completable deleteFailedMessages() {
        Completable completable = Completable.fromCallable(MessageRepository::deleteFailedMessages$lambda$5);
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"fromCallable(...)");
        return completable;
    }

    @NotNull
    public final Single<List<String>> findCacheAroundMessageId(@NotNull String messageId) {
        Intrinsics.checkNotNullParameter((Object)messageId, (String)"messageId");
        return new MessageLocalDataStore().findCacheAroundMessage(messageId);
    }

    private static final String deleteMessage$lambda$0(String $messageId) {
        String deletingId = "";
        EkoMessageEntity message = new MessageLocalDataStore().getMessage($messageId);
        if (message == null || Intrinsics.areEqual((Object)message.getSyncState(), (Object)AmityMessage.State.SYNCED.getStateName())) {
            deletingId = $messageId;
        }
        return deletingId;
    }

    private static final PagingSource getMessagePagingData$lambda$1(String $subChannelId, boolean $isFilterByParentId, String $parentId, AmityTags $includingTags, AmityTags $excludingTags, Boolean $isDeleted, AmityMessageQuerySortOption $sortOption, AmityMessage.DataType $type, String $aroundMessageId, String $uniqueId) {
        AmityMessage.DataType dataType = $type;
        return new MessageLocalDataStore().getMessagePagingSource($subChannelId, $isFilterByParentId, $parentId, $includingTags, $excludingTags, $isDeleted, $sortOption, dataType != null ? dataType.getApiKey() : null, $aroundMessageId, $uniqueId);
    }

    private static final Unit deleteFailedMessages$lambda$5() {
        new MessageLocalDataStore().cleanUpFailedMessages();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Completable access$fetchMessageMarker(MessageRepository $this, MessageQueryDto dto) {
        return $this.fetchMessageMarker(dto);
    }

    public static final /* synthetic */ List access$getFileUploadingTypes$cp() {
        return fileUploadingTypes;
    }

    static {
        AmityMessage.DataType[] dataTypeArray = new AmityMessage.DataType[]{AmityMessage.DataType.IMAGE, AmityMessage.DataType.FILE, AmityMessage.DataType.AUDIO, AmityMessage.DataType.VIDEO};
        fileUploadingTypes = CollectionsKt.listOf((Object[])dataTypeArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/amity/socialcloud/sdk/chat/data/message/MessageRepository$Companion;", "", "<init>", "()V", "fileUploadingTypes", "", "Lcom/amity/socialcloud/sdk/model/chat/message/AmityMessage$DataType;", "amity-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

