/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.api.video.room.analytics;

import com.amity.socialcloud.sdk.model.video.room.AmityRoom;
import com.amity.socialcloud.sdk.video.domain.watch.CreateWatchSessionUseCase;
import com.amity.socialcloud.sdk.video.domain.watch.SyncPendingWatchSessionsUseCase;
import com.amity.socialcloud.sdk.video.domain.watch.UpdateWatchSessionUseCase;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Single;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.joda.time.DateTime;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\nJ\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/amity/socialcloud/sdk/api/video/room/analytics/AmityRoomAnalytics;", "", "room", "Lcom/amity/socialcloud/sdk/model/video/room/AmityRoom;", "<init>", "(Lcom/amity/socialcloud/sdk/model/video/room/AmityRoom;)V", "createWatchSession", "Lio/reactivex/rxjava3/core/Single;", "", "startedAt", "Lorg/joda/time/DateTime;", "updateWatchSession", "Lio/reactivex/rxjava3/core/Completable;", "sessionId", "duration", "", "endedAt", "syncPendingWatchSessions", "", "amity-sdk_release"})
public final class AmityRoomAnalytics {
    @NotNull
    private final AmityRoom room;

    public AmityRoomAnalytics(@NotNull AmityRoom room) {
        Intrinsics.checkNotNullParameter((Object)room, (String)"room");
        this.room = room;
    }

    @NotNull
    public final Single<String> createWatchSession(@NotNull DateTime startedAt) {
        Intrinsics.checkNotNullParameter((Object)startedAt, (String)"startedAt");
        return new CreateWatchSessionUseCase().execute(this.room, startedAt);
    }

    @NotNull
    public final Completable updateWatchSession(@NotNull String sessionId, long duration, @NotNull DateTime endedAt) {
        Intrinsics.checkNotNullParameter((Object)sessionId, (String)"sessionId");
        Intrinsics.checkNotNullParameter((Object)endedAt, (String)"endedAt");
        return new UpdateWatchSessionUseCase().execute(sessionId, duration, endedAt);
    }

    public final void syncPendingWatchSessions() {
        new SyncPendingWatchSessionsUseCase().execute();
    }
}

