package com.amity.socialcloud.sdk.core.data.room

import androidx.paging.ExperimentalPagingApi
import co.amity.rxbridge.toRx2
import com.amity.socialcloud.sdk.dto.video.RoomListDto
import com.amity.socialcloud.sdk.entity.video.room.RoomEntity
import com.amity.socialcloud.sdk.model.video.room.AmityRoom
//import com.amity.socialcloud.sdk.video.domain.room.RoomReactorUseCase
import com.ekoapp.ekosdk.internal.data.AmityNonce
import com.ekoapp.ekosdk.internal.keycreator.RoomKeyCreator
import com.ekoapp.ekosdk.internal.mediator.DynamicQueryStreamMediator
import com.ekoapp.ekosdk.internal.token.DynamicQueryStreamQueryToken
import com.ekoapp.ekosdk.internal.token.QueryStreamQueryToken
import io.reactivex.Completable
import io.reactivex.Flowable
import io.reactivex.Single

@ExperimentalPagingApi
internal class RoomMediator(
    private val statuses: List<String>,
    private val types: List<String>?,
    private val isDeleted: Boolean?,
    private val sortBy: String?
) : DynamicQueryStreamMediator<RoomEntity, RoomListDto, AmityRoom>(
    nonce = AmityNonce.ROOM_LIST,
    dynamicQueryStreamKeyCreator = RoomKeyCreator(statuses, types, isDeleted, sortBy)
) {

    override fun provideReactorPublisher(): Flowable<AmityRoom> {
        return Flowable.never()
//        return RoomReactorUseCase().execute(statuses).toRx2()
    }

    override fun forceRefresh(): Boolean = true

    override fun getFirstPageRequest(pageSize: Int): Single<RoomListDto> = getRequest(limit = pageSize)

    override fun getFetchByTokenRequest(token: String): Single<RoomListDto> = getRequest(token = token)

    override fun persistResponse(dto: RoomListDto): Completable {
        return RoomListQueryPersister().persist(dto).toRx2()
    }

    override fun convertResponseToQueryToken(dto: RoomListDto): QueryStreamQueryToken {
        return DynamicQueryStreamQueryToken(
            dynamicQueryStreamKeyCreator = RoomKeyCreator(statuses, types, isDeleted, sortBy),
            next = dto.paging?.next,
            previous = dto.paging?.previous,
            primaryKeys = dto.rooms?.map { it.roomId ?: "" } ?: emptyList()
        )
    }

    private fun getRequest(limit: Int? = null, token: String? = null): Single<RoomListDto> {
        return RoomRemoteDataStore().queryRooms(
            statuses = statuses,
            types = types,
            isDeleted = isDeleted,
            sortBy = sortBy,
            limit = limit,
            token = token
        ).toRx2()
    }
}

