package com.amity.socialcloud.sdk.core.data.ad

import androidx.room.Dao
import androidx.room.Query
import com.amity.socialcloud.sdk.entity.core.ad.AdvertiserEntity
import com.ekoapp.ekosdk.internal.data.dao.EkoObjectDao
import io.reactivex.rxjava3.core.Single


@Dao
abstract class AdvertiserDao : EkoObjectDao<AdvertiserEntity>() {
    @Query("DELETE from advertiser")
    abstract override fun deleteAll()

    @Query("SELECT *" +
            " from advertiser" +
            " where advertiser.advertiserId = :advertiserId" +
            " LIMIT 1")
    abstract fun getByIdImpl(advertiserId: String): Single<List<AdvertiserEntity>>
    fun getById(advertiserId: String): Single<List<AdvertiserEntity>> {
        return getByIdImpl(advertiserId)
    }

    @Query("SELECT *" +
            " from advertiser" +
            " where advertiser.advertiserId = :advertiserId" +
            " LIMIT 1")
    abstract fun getByIdNowImpl(advertiserId: String): AdvertiserEntity?
    override fun getByIdNow(advertiserId: String): AdvertiserEntity? {
        return getByIdNowImpl(advertiserId)
    }

    @Query("SELECT *" +
            " from advertiser" +
            " where advertiser.advertiserId IN (:ids)")
    abstract fun getByIdsNowImpl(ids: List<String>): List<AdvertiserEntity>
    override fun getByIdsNow(ids: List<String>): List<AdvertiserEntity> {
        return getByIdsNowImpl(ids)
    }
}