package com.amity.socialcloud.sdk.api.core.session

import com.amity.socialcloud.sdk.core.domain.session.LoginUseCase
import com.amity.socialcloud.sdk.core.session.eventbus.AppEventBus
import com.amity.socialcloud.sdk.core.session.eventbus.SessionLifeCycleEventBus
import io.reactivex.rxjava3.core.Completable
import org.joda.time.DateTime

class AmityVisitorEstablisher private constructor(
    private val appEventBus: AppEventBus?,
    private val sessionLifeCycleEventBus: SessionLifeCycleEventBus?,
    private val displayName: String?,
    private val authSignature: String?,
    private val authSignatureExpiresAt: DateTime?,
) {

    fun submit(): Completable {
        return LoginUseCase().execute(
            appEventBus = appEventBus,
            sessionLifeCycleEventBus = sessionLifeCycleEventBus,
            userId = null,
            displayName = displayName,
            authToken = null,
            authSignature = authSignature,
            authSignatureExpiresAt = authSignatureExpiresAt,
            isLegacyVersion = false,
        )
            .ignoreElement()
    }

    class Builder internal constructor(
        private val appEventBus: AppEventBus?,
        private val sessionLifeCycleEventBus: SessionLifeCycleEventBus?,
    ) {
        private var displayName: String? = null
        private var authToken: String? = null
        private var authSignature: String? = null
        private var authSignatureExpiresAt: DateTime? = null

        fun displayName(displayName: String): Builder {
            this.displayName = displayName
            return this
        }

        fun authToken(authToken: String): Builder {
            this.authToken = authToken
            return this
        }

        fun authSignature(authSignature: String): Builder {
            this.authSignature = authSignature
            return this
        }

        fun authSignatureExpiresAt(authSignatureExpiresAt: DateTime): Builder {
            this.authSignatureExpiresAt = authSignatureExpiresAt
            return this
        }

        fun build(): AmityVisitorEstablisher {
            return AmityVisitorEstablisher(
                appEventBus = appEventBus,
                sessionLifeCycleEventBus = sessionLifeCycleEventBus,
                displayName = displayName,
                authSignature = authSignature,
                authSignatureExpiresAt = authSignatureExpiresAt,
            )
        }
    }

}