/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.SQLiteStatement;
import com.amity.socialcloud.sdk.model.core.permission.AmityPermissions;
import com.amity.socialcloud.sdk.model.core.role.AmityRoles;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.EkoPermissionsTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.EkoRolesTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.JsonObjectTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommunityMembershipDao;
import com.ekoapp.ekosdk.internal.entity.CommunityMembershipEntity;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class EkoCommunityMembershipDao_Impl
extends EkoCommunityMembershipDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<CommunityMembershipEntity> __insertAdapterOfCommunityMembershipEntity;
    private final JsonObjectTypeConverter __jsonObjectTypeConverter = new JsonObjectTypeConverter();
    private final EkoRolesTypeConverter __ekoRolesTypeConverter = new EkoRolesTypeConverter();
    private final EkoPermissionsTypeConverter __ekoPermissionsTypeConverter = new EkoPermissionsTypeConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeleteOrUpdateAdapter<CommunityMembershipEntity> __deleteAdapterOfCommunityMembershipEntity;
    private final EntityDeleteOrUpdateAdapter<CommunityMembershipEntity> __updateAdapterOfCommunityMembershipEntity;

    public EkoCommunityMembershipDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfCommunityMembershipEntity = new EntityInsertAdapter<CommunityMembershipEntity>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `community_membership` (`id`,`userId`,`communityId`,`channelId`,`metadata`,`communityMembership`,`isBanned`,`roles`,`permissions`,`lastJoin`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull CommunityMembershipEntity entity) {
                Integer _tmp_1;
                if (entity.getId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getId());
                }
                if (entity.getUserId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getUserId());
                }
                if (entity.getCommunityId() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getCommunityId());
                }
                if (entity.getChannelId() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getChannelId());
                }
                String _tmp = EkoCommunityMembershipDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(entity.getMetadata());
                if (_tmp == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp);
                }
                if (entity.getCommunityMembership() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, entity.getCommunityMembership());
                }
                Integer n = entity.isBanned() == null ? null : (_tmp_1 = Integer.valueOf(entity.isBanned() != false ? 1 : 0));
                if (_tmp_1 == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindLong(7, (long)_tmp_1.intValue());
                }
                String _tmp_2 = EkoCommunityMembershipDao_Impl.this.__ekoRolesTypeConverter.ekoRolesToString(entity.getRoles());
                if (_tmp_2 == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, _tmp_2);
                }
                String _tmp_3 = EkoCommunityMembershipDao_Impl.this.__ekoPermissionsTypeConverter.ekoPermissionsToString(entity.getPermissions());
                if (_tmp_3 == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, _tmp_3);
                }
                String _tmp_4 = EkoCommunityMembershipDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getLastJoin());
                if (_tmp_4 == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindText(10, _tmp_4);
                }
                String _tmp_5 = EkoCommunityMembershipDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_5 == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindText(11, _tmp_5);
                }
                String _tmp_6 = EkoCommunityMembershipDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_6 == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindText(12, _tmp_6);
                }
                String _tmp_7 = EkoCommunityMembershipDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_7 == null) {
                    statement.bindNull(13);
                } else {
                    statement.bindText(13, _tmp_7);
                }
            }
        };
        this.__deleteAdapterOfCommunityMembershipEntity = new EntityDeleteOrUpdateAdapter<CommunityMembershipEntity>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `community_membership` WHERE `communityId` = ? AND `userId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull CommunityMembershipEntity entity) {
                if (entity.getCommunityId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getCommunityId());
                }
                if (entity.getUserId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getUserId());
                }
            }
        };
        this.__updateAdapterOfCommunityMembershipEntity = new EntityDeleteOrUpdateAdapter<CommunityMembershipEntity>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `community_membership` SET `id` = ?,`userId` = ?,`communityId` = ?,`channelId` = ?,`metadata` = ?,`communityMembership` = ?,`isBanned` = ?,`roles` = ?,`permissions` = ?,`lastJoin` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `communityId` = ? AND `userId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull CommunityMembershipEntity entity) {
                Integer _tmp_1;
                if (entity.getId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getId());
                }
                if (entity.getUserId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getUserId());
                }
                if (entity.getCommunityId() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getCommunityId());
                }
                if (entity.getChannelId() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getChannelId());
                }
                String _tmp = EkoCommunityMembershipDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(entity.getMetadata());
                if (_tmp == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, _tmp);
                }
                if (entity.getCommunityMembership() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, entity.getCommunityMembership());
                }
                Integer n = entity.isBanned() == null ? null : (_tmp_1 = Integer.valueOf(entity.isBanned() != false ? 1 : 0));
                if (_tmp_1 == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindLong(7, (long)_tmp_1.intValue());
                }
                String _tmp_2 = EkoCommunityMembershipDao_Impl.this.__ekoRolesTypeConverter.ekoRolesToString(entity.getRoles());
                if (_tmp_2 == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, _tmp_2);
                }
                String _tmp_3 = EkoCommunityMembershipDao_Impl.this.__ekoPermissionsTypeConverter.ekoPermissionsToString(entity.getPermissions());
                if (_tmp_3 == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, _tmp_3);
                }
                String _tmp_4 = EkoCommunityMembershipDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getLastJoin());
                if (_tmp_4 == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindText(10, _tmp_4);
                }
                String _tmp_5 = EkoCommunityMembershipDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_5 == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindText(11, _tmp_5);
                }
                String _tmp_6 = EkoCommunityMembershipDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_6 == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindText(12, _tmp_6);
                }
                String _tmp_7 = EkoCommunityMembershipDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_7 == null) {
                    statement.bindNull(13);
                } else {
                    statement.bindText(13, _tmp_7);
                }
                if (entity.getCommunityId() == null) {
                    statement.bindNull(14);
                } else {
                    statement.bindText(14, entity.getCommunityId());
                }
                if (entity.getUserId() == null) {
                    statement.bindNull(15);
                } else {
                    statement.bindText(15, entity.getUserId());
                }
            }
        };
    }

    @Override
    public void insertImpl(CommunityMembershipEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfCommunityMembershipEntity.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends CommunityMembershipEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfCommunityMembershipEntity.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(List<? extends CommunityMembershipEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfCommunityMembershipEntity.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(CommunityMembershipEntity communityMembership) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfCommunityMembershipEntity.handle(_connection, (Object)communityMembership);
            return null;
        });
    }

    @Override
    public void updateImpl(CommunityMembershipEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfCommunityMembershipEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(CommunityMembershipEntity membership) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoCommunityMembershipDao_Impl.super.insert(membership);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends CommunityMembershipEntity> memberships) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoCommunityMembershipDao_Impl.super.insert(memberships);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void deleteByCommunityId(String communityId) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoCommunityMembershipDao_Impl.super.deleteByCommunityId(communityId);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void updateUser(String userId) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoCommunityMembershipDao_Impl.super.updateUser(userId);
            return Unit.INSTANCE;
        });
    }

    @Override
    CommunityMembershipEntity getByCommunityIdAndUserIdNowImpl(String communityId, String userId) {
        String _sql = "SELECT * from community_membership where communityId = ? and userId = ? LIMIT 1";
        return (CommunityMembershipEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from community_membership where communityId = ? and userId = ? LIMIT 1");){
                CommunityMembershipEntity _result;
                int _argIndex = 1;
                if (communityId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, communityId);
                }
                _argIndex = 2;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                int _columnIndexOfId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"id");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfCommunityId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"communityId");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfCommunityMembership = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"communityMembership");
                int _columnIndexOfIsBanned = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isBanned");
                int _columnIndexOfRoles = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"roles");
                int _columnIndexOfPermissions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"permissions");
                int _columnIndexOfLastJoin = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastJoin");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new CommunityMembershipEntity();
                    String _tmpId = _stmt.isNull(_columnIndexOfId) ? null : _stmt.getText(_columnIndexOfId);
                    _result.setId(_tmpId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _result.setUserId(_tmpUserId);
                    String _tmpCommunityId = _stmt.isNull(_columnIndexOfCommunityId) ? null : _stmt.getText(_columnIndexOfCommunityId);
                    _result.setCommunityId(_tmpCommunityId);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _result.setChannelId(_tmpChannelId);
                    String _tmp = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                    _result.setMetadata(_tmpMetadata);
                    String _tmpCommunityMembership = _stmt.isNull(_columnIndexOfCommunityMembership) ? null : _stmt.getText(_columnIndexOfCommunityMembership);
                    _result.setCommunityMembership(_tmpCommunityMembership);
                    Integer _tmp_1 = _stmt.isNull(_columnIndexOfIsBanned) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfIsBanned));
                    Boolean _tmpIsBanned = _tmp_1 == null ? null : Boolean.valueOf(_tmp_1 != 0);
                    _result.setBanned(_tmpIsBanned);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfRoles) ? null : _stmt.getText(_columnIndexOfRoles);
                    AmityRoles _tmpRoles = this.__ekoRolesTypeConverter.stringToEkoRoles(_tmp_2);
                    _result.setRoles(_tmpRoles);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfPermissions) ? null : _stmt.getText(_columnIndexOfPermissions);
                    AmityPermissions _tmpPermissions = this.__ekoPermissionsTypeConverter.stringToEkoPermissions(_tmp_3);
                    _result.setPermissions(_tmpPermissions);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfLastJoin) ? null : _stmt.getText(_columnIndexOfLastJoin);
                    DateTime _tmpLastJoin = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setLastJoin(_tmpLastJoin);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                CommunityMembershipEntity communityMembershipEntity = _result;
                return communityMembershipEntity;
            }
        });
    }

    @Override
    CommunityMembershipEntity getByIdNowImpl(String id) {
        String _sql = "SELECT * from community_membership where id = ? LIMIT 1";
        return (CommunityMembershipEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from community_membership where id = ? LIMIT 1");){
                CommunityMembershipEntity _result;
                int _argIndex = 1;
                if (id == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, id);
                }
                int _columnIndexOfId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"id");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfCommunityId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"communityId");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfCommunityMembership = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"communityMembership");
                int _columnIndexOfIsBanned = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isBanned");
                int _columnIndexOfRoles = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"roles");
                int _columnIndexOfPermissions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"permissions");
                int _columnIndexOfLastJoin = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastJoin");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new CommunityMembershipEntity();
                    String _tmpId = _stmt.isNull(_columnIndexOfId) ? null : _stmt.getText(_columnIndexOfId);
                    _result.setId(_tmpId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _result.setUserId(_tmpUserId);
                    String _tmpCommunityId = _stmt.isNull(_columnIndexOfCommunityId) ? null : _stmt.getText(_columnIndexOfCommunityId);
                    _result.setCommunityId(_tmpCommunityId);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _result.setChannelId(_tmpChannelId);
                    String _tmp = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                    _result.setMetadata(_tmpMetadata);
                    String _tmpCommunityMembership = _stmt.isNull(_columnIndexOfCommunityMembership) ? null : _stmt.getText(_columnIndexOfCommunityMembership);
                    _result.setCommunityMembership(_tmpCommunityMembership);
                    Integer _tmp_1 = _stmt.isNull(_columnIndexOfIsBanned) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfIsBanned));
                    Boolean _tmpIsBanned = _tmp_1 == null ? null : Boolean.valueOf(_tmp_1 != 0);
                    _result.setBanned(_tmpIsBanned);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfRoles) ? null : _stmt.getText(_columnIndexOfRoles);
                    AmityRoles _tmpRoles = this.__ekoRolesTypeConverter.stringToEkoRoles(_tmp_2);
                    _result.setRoles(_tmpRoles);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfPermissions) ? null : _stmt.getText(_columnIndexOfPermissions);
                    AmityPermissions _tmpPermissions = this.__ekoPermissionsTypeConverter.stringToEkoPermissions(_tmp_3);
                    _result.setPermissions(_tmpPermissions);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfLastJoin) ? null : _stmt.getText(_columnIndexOfLastJoin);
                    DateTime _tmpLastJoin = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setLastJoin(_tmpLastJoin);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                CommunityMembershipEntity communityMembershipEntity = _result;
                return communityMembershipEntity;
            }
        });
    }

    @Override
    Flowable<CommunityMembershipEntity> getByIdImpl(String communityId, String userId) {
        String _sql = "SELECT * from community_membership where communityId = ? and userId = ? LIMIT 1";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"community_membership"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from community_membership where communityId = ? and userId = ? LIMIT 1");){
                CommunityMembershipEntity _result;
                int _argIndex = 1;
                if (communityId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, communityId);
                }
                _argIndex = 2;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                int _columnIndexOfId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"id");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfCommunityId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"communityId");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfCommunityMembership = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"communityMembership");
                int _columnIndexOfIsBanned = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isBanned");
                int _columnIndexOfRoles = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"roles");
                int _columnIndexOfPermissions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"permissions");
                int _columnIndexOfLastJoin = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastJoin");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new CommunityMembershipEntity();
                    String _tmpId = _stmt.isNull(_columnIndexOfId) ? null : _stmt.getText(_columnIndexOfId);
                    _result.setId(_tmpId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _result.setUserId(_tmpUserId);
                    String _tmpCommunityId = _stmt.isNull(_columnIndexOfCommunityId) ? null : _stmt.getText(_columnIndexOfCommunityId);
                    _result.setCommunityId(_tmpCommunityId);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _result.setChannelId(_tmpChannelId);
                    String _tmp = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                    _result.setMetadata(_tmpMetadata);
                    String _tmpCommunityMembership = _stmt.isNull(_columnIndexOfCommunityMembership) ? null : _stmt.getText(_columnIndexOfCommunityMembership);
                    _result.setCommunityMembership(_tmpCommunityMembership);
                    Integer _tmp_1 = _stmt.isNull(_columnIndexOfIsBanned) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfIsBanned));
                    Boolean _tmpIsBanned = _tmp_1 == null ? null : Boolean.valueOf(_tmp_1 != 0);
                    _result.setBanned(_tmpIsBanned);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfRoles) ? null : _stmt.getText(_columnIndexOfRoles);
                    AmityRoles _tmpRoles = this.__ekoRolesTypeConverter.stringToEkoRoles(_tmp_2);
                    _result.setRoles(_tmpRoles);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfPermissions) ? null : _stmt.getText(_columnIndexOfPermissions);
                    AmityPermissions _tmpPermissions = this.__ekoPermissionsTypeConverter.stringToEkoPermissions(_tmp_3);
                    _result.setPermissions(_tmpPermissions);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfLastJoin) ? null : _stmt.getText(_columnIndexOfLastJoin);
                    DateTime _tmpLastJoin = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setLastJoin(_tmpLastJoin);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                CommunityMembershipEntity communityMembershipEntity = _result;
                return communityMembershipEntity;
            }
        });
    }

    @Override
    List<CommunityMembershipEntity> getByIdsNowImpl(List<String> ids) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("SELECT * from community_membership where userId in (");
        int _inputSize = ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        return (List)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare(_sql);){
                int _argIndex = 1;
                for (String _item : ids) {
                    if (_item == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindText(_argIndex, _item);
                    }
                    ++_argIndex;
                }
                int _columnIndexOfId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"id");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfCommunityId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"communityId");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfCommunityMembership = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"communityMembership");
                int _columnIndexOfIsBanned = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isBanned");
                int _columnIndexOfRoles = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"roles");
                int _columnIndexOfPermissions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"permissions");
                int _columnIndexOfLastJoin = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastJoin");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<CommunityMembershipEntity> _result = new ArrayList<CommunityMembershipEntity>();
                while (_stmt.step()) {
                    CommunityMembershipEntity _item_1 = new CommunityMembershipEntity();
                    String _tmpId = _stmt.isNull(_columnIndexOfId) ? null : _stmt.getText(_columnIndexOfId);
                    _item_1.setId(_tmpId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _item_1.setUserId(_tmpUserId);
                    String _tmpCommunityId = _stmt.isNull(_columnIndexOfCommunityId) ? null : _stmt.getText(_columnIndexOfCommunityId);
                    _item_1.setCommunityId(_tmpCommunityId);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _item_1.setChannelId(_tmpChannelId);
                    String _tmp = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp);
                    _item_1.setMetadata(_tmpMetadata);
                    String _tmpCommunityMembership = _stmt.isNull(_columnIndexOfCommunityMembership) ? null : _stmt.getText(_columnIndexOfCommunityMembership);
                    _item_1.setCommunityMembership(_tmpCommunityMembership);
                    Integer _tmp_1 = _stmt.isNull(_columnIndexOfIsBanned) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfIsBanned));
                    Boolean _tmpIsBanned = _tmp_1 == null ? null : Boolean.valueOf(_tmp_1 != 0);
                    _item_1.setBanned(_tmpIsBanned);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfRoles) ? null : _stmt.getText(_columnIndexOfRoles);
                    AmityRoles _tmpRoles = this.__ekoRolesTypeConverter.stringToEkoRoles(_tmp_2);
                    _item_1.setRoles(_tmpRoles);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfPermissions) ? null : _stmt.getText(_columnIndexOfPermissions);
                    AmityPermissions _tmpPermissions = this.__ekoPermissionsTypeConverter.stringToEkoPermissions(_tmp_3);
                    _item_1.setPermissions(_tmpPermissions);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfLastJoin) ? null : _stmt.getText(_columnIndexOfLastJoin);
                    DateTime _tmpLastJoin = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _item_1.setLastJoin(_tmpLastJoin);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                    _item_1.setCreatedAt(_tmpCreatedAt);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                    _item_1.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                    _item_1.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item_1);
                }
                ArrayList<CommunityMembershipEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    Flowable<CommunityMembershipEntity> getLatestCommunityMembershipImpl(String communityId, String[] memberships, Boolean isFilterByRoles, String[] roles, int hash, int nonce, DateTime now) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("SELECT * from community_membership where community_membership.communityId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and community_membership.communityMembership in (");
        int _inputSize = memberships == null ? 1 : memberships.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(") and case when ");
        _stringBuilder.append("?");
        _stringBuilder.append(" then community_membership.userId in (SELECT userId from community_role where communityId = ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and roleName in (");
        int _inputSize_1 = roles == null ? 1 : roles.length;
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize_1);
        _stringBuilder.append(")) else userId is not null end and community_membership.updatedAt > ");
        _stringBuilder.append("?");
        _stringBuilder.append(" and community_membership.userId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (");
        _stringBuilder.append("?");
        _stringBuilder.append(") and amity_paging_id.nonce = (");
        _stringBuilder.append("?");
        _stringBuilder.append(") ) order by community_membership.updatedAt  desc limit 1");
        String _sql = _stringBuilder.toString();
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"community_membership", "community_role", "amity_paging_id"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare(_sql);){
                CommunityMembershipEntity _result;
                Integer _tmp;
                int _argIndex = 1;
                if (communityId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, communityId);
                }
                _argIndex = 2;
                if (memberships == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    for (String _item : memberships) {
                        if (_item == null) {
                            _stmt.bindNull(_argIndex);
                        } else {
                            _stmt.bindText(_argIndex, _item);
                        }
                        ++_argIndex;
                    }
                }
                _argIndex = 2 + _inputSize;
                Integer n = isFilterByRoles == null ? null : (_tmp = Integer.valueOf(isFilterByRoles != false ? 1 : 0));
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp.intValue());
                }
                _argIndex = 3 + _inputSize;
                if (communityId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, communityId);
                }
                _argIndex = 4 + _inputSize;
                if (roles == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    for (String _item_1 : roles) {
                        if (_item_1 == null) {
                            _stmt.bindNull(_argIndex);
                        } else {
                            _stmt.bindText(_argIndex, _item_1);
                        }
                        ++_argIndex;
                    }
                }
                _argIndex = 4 + _inputSize + _inputSize_1;
                String _tmp_1 = this.__dateTimeTypeConverter.dateTimeToString(now);
                if (_tmp_1 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, _tmp_1);
                }
                _argIndex = 5 + _inputSize + _inputSize_1;
                _stmt.bindLong(_argIndex, (long)hash);
                _argIndex = 6 + _inputSize + _inputSize_1;
                _stmt.bindLong(_argIndex, (long)nonce);
                int _columnIndexOfId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"id");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfCommunityId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"communityId");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfCommunityMembership = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"communityMembership");
                int _columnIndexOfIsBanned = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isBanned");
                int _columnIndexOfRoles = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"roles");
                int _columnIndexOfPermissions = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"permissions");
                int _columnIndexOfLastJoin = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastJoin");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new CommunityMembershipEntity();
                    String _tmpId = _stmt.isNull(_columnIndexOfId) ? null : _stmt.getText(_columnIndexOfId);
                    _result.setId(_tmpId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _result.setUserId(_tmpUserId);
                    String _tmpCommunityId = _stmt.isNull(_columnIndexOfCommunityId) ? null : _stmt.getText(_columnIndexOfCommunityId);
                    _result.setCommunityId(_tmpCommunityId);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _result.setChannelId(_tmpChannelId);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_2);
                    _result.setMetadata(_tmpMetadata);
                    String _tmpCommunityMembership = _stmt.isNull(_columnIndexOfCommunityMembership) ? null : _stmt.getText(_columnIndexOfCommunityMembership);
                    _result.setCommunityMembership(_tmpCommunityMembership);
                    Integer _tmp_3 = _stmt.isNull(_columnIndexOfIsBanned) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfIsBanned));
                    Boolean _tmpIsBanned = _tmp_3 == null ? null : Boolean.valueOf(_tmp_3 != 0);
                    _result.setBanned(_tmpIsBanned);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfRoles) ? null : _stmt.getText(_columnIndexOfRoles);
                    AmityRoles _tmpRoles = this.__ekoRolesTypeConverter.stringToEkoRoles(_tmp_4);
                    _result.setRoles(_tmpRoles);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfPermissions) ? null : _stmt.getText(_columnIndexOfPermissions);
                    AmityPermissions _tmpPermissions = this.__ekoPermissionsTypeConverter.stringToEkoPermissions(_tmp_5);
                    _result.setPermissions(_tmpPermissions);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfLastJoin) ? null : _stmt.getText(_columnIndexOfLastJoin);
                    DateTime _tmpLastJoin = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                    _result.setLastJoin(_tmpLastJoin);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_8 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_8);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                CommunityMembershipEntity communityMembershipEntity = _result;
                return communityMembershipEntity;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "DELETE from community_membership";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from community_membership");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @Override
    void deleteByCommunityIdImpl(String communityId) {
        String _sql = "DELETE from community_membership where community_membership.communityId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from community_membership where community_membership.communityId = ?");){
                int _argIndex = 1;
                if (communityId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, communityId);
                }
                _stmt.step();
                Object var4_4 = null;
                return var4_4;
            }
        });
    }

    @Override
    void updateUserImpl(String userId) {
        String _sql = "UPDATE community_membership set userId = ? where userId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE community_membership set userId = ? where userId = ?");){
                int _argIndex = 1;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                _argIndex = 2;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                _stmt.step();
                Object var4_4 = null;
                return var4_4;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

