package com.ekoapp.ekosdk.internal.api.dto

import com.amity.socialcloud.sdk.model.core.reaction.AmityReactionMap
import com.ekoapp.ekosdk.EkoFlag
import com.google.gson.JsonElement
import com.google.gson.JsonObject
import com.google.gson.annotations.SerializedName
import org.joda.time.DateTime

data class EkoPostDto constructor(
	@SerializedName("postId")
	val postId: String,

	@SerializedName("_id")
	val mid: String,

	@SerializedName("path")
	private val path: String? = null,

	@SerializedName("feedId")
	val feedId: String? = null,

	@SerializedName("structureType")
	val structureType: String? = null,

	@SerializedName("parentPostId")
	val parentPostId: String? = null,

	@SerializedName("postedUserId")
	var postedUserId: String,

	@SerializedName("sharedUserId")
	val sharedUserId: String? = null,

	@SerializedName("dataType")
	val dataType: String,

	@SerializedName("data")
	private val data: JsonElement? = null,

	@SerializedName("metadata")
	private val metadata: JsonElement? = null,

	@SerializedName("sharedCount")
	val sharedCount: Int = 0,

	@SerializedName("targetType")
	var targetType: String,

	@SerializedName("targetId")
	var targetId: String,

	@SerializedName("reactions")
	val reactions: AmityReactionMap? = null,

	@SerializedName("reactionsCount")
	val reactionCount: Int = 0,

	@SerializedName("myReactions")
	val myReactions: List<String>? = null,

	@SerializedName("latestReaction")
	val latestReaction: EkoReactorDto? = null,

	@SerializedName("commentsCount")
	val commentsCount: Int = 0,

	@SerializedName("flagCount")
	val flagCount: Int = 0,

	@SerializedName("hashFlag")
	val flag: EkoFlag? = null,

	@SerializedName("children")
	val children: List<String>,

	@SerializedName("isDeleted")
	val deleted: Boolean,

	@SerializedName("editedAt")
	val editedAt: DateTime? = null,

	@SerializedName("feedType")
	var feedType: String,

	@SerializedName("mentionees")
	var mentionees: List<EkoMentioneesDto>? = null,

	@SerializedName("impression")
	val impression: Int = 0,

	@SerializedName("reach")
	val reach: Int = 0,

	@SerializedName("hashtags")
	val hashtags: List<String>? = null,

	@SerializedName("pii")
	val pii: List<EkoPiiDto>? = null,

	@SerializedName("links")
	val links: List<EkoLinkDto>? = null,

) : EkoObjectDto() {

	fun getPath(): String {
		return path ?: ""
	}

	fun getData(): JsonObject? {
		return if (data != null && data.isJsonObject) {
			data.asJsonObject
		} else null
	}

	fun getMetadata(): JsonObject? {
		return if (metadata != null && metadata.isJsonObject) {
			metadata.asJsonObject
		} else null
	}
}