package com.amity.socialcloud.sdk.core.data.analytics

import com.ekoapp.ekosdk.internal.api.dto.EkoUserListDto
import com.ekoapp.ekosdk.internal.api.socket.request.SendAnalyticsEventsRequest
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single
import retrofit2.http.Body
import retrofit2.http.GET
import retrofit2.http.Headers
import retrofit2.http.POST
import retrofit2.http.Path
import retrofit2.http.Query

interface AnalyticsApi {

    @POST("api/v1/analytics/activities")
    @Headers("Custom-Timeout: 30")
    fun sendAnalytics(
        @Body request: SendAnalyticsEventsRequest
    ): Single<JsonObject>

    @GET("api/v1/analytics/views/posts/{postId}/users")
    fun queryPostReachUsers(
        @Path("postId") postId: String? = null,
        @Query("limit") limit: Int? = null,
        @Query("token") token: String? = null
    ): Single<EkoUserListDto>

    @GET("api/v1/analytics/views/stories/{storyId}/users")
    fun queryStorySeenUsers(
        @Path("storyId") storyId: String? = null,
        @Query("limit") limit: Int? = null,
        @Query("token") token: String? = null
    ): Single<EkoUserListDto>
}