package com.amity.socialcloud.sdk.api.core.presence

import com.amity.socialcloud.sdk.api.core.AmityCoreClient
import com.amity.socialcloud.sdk.model.core.presence.AmityOnlineUsersSnapshot
import com.ekoapp.ekosdk.internal.usecase.presence.GetRoomOnlineUsersCountUseCase
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Flowable
import io.reactivex.rxjava3.core.Single
import java.util.concurrent.TimeUnit

class AmityRoomPresenceRepository internal constructor(val roomId: String) {

    fun startHeartbeat(): Completable {
        return AmityCoreClient.presence().startRoomHeartbeat(roomId = roomId)
    }

    fun stopHeartbeat() {
        return AmityCoreClient.presence().stopRoomHeartbeat()
    }

    fun observeOnlineUsersCount(interval: Long = 15): Flowable<Int> {
        return Flowable
                .interval(0L, interval,TimeUnit.SECONDS)
                .flatMapSingle {
                    GetRoomOnlineUsersCountUseCase().execute(roomId = roomId)
                }
    }

    fun getOnlineUsersCount(): Single<Int> {
        return GetRoomOnlineUsersCountUseCase().execute(roomId = roomId)
    }

    fun getOnlineUsersSnapshot(): Single<AmityOnlineUsersSnapshot> {
        return AmityOnlineUsersSnapshot.createByRoomId(roomId = roomId)
    }

    class Builder {
        fun roomId(roomId: String): AmityRoomPresenceRepository {
            return AmityRoomPresenceRepository(roomId = roomId)
        }
    }
}