/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.SQLiteStatement;
import com.amity.socialcloud.sdk.model.core.tag.AmityTags;
import com.ekoapp.ekosdk.EkoCategoryIds;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.EkoCategoriesTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.EkoTagsTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.JsonObjectTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.EkoCommunityDao;
import com.ekoapp.ekosdk.internal.entity.CommunityEntity;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class EkoCommunityDao_Impl
extends EkoCommunityDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<CommunityEntity> __insertAdapterOfCommunityEntity;
    private final EkoTagsTypeConverter __ekoTagsTypeConverter = new EkoTagsTypeConverter();
    private final JsonObjectTypeConverter __jsonObjectTypeConverter = new JsonObjectTypeConverter();
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EkoCategoriesTypeConverter __ekoCategoriesTypeConverter = new EkoCategoriesTypeConverter();
    private final EntityDeleteOrUpdateAdapter<CommunityEntity> __deleteAdapterOfCommunityEntity;
    private final EntityDeleteOrUpdateAdapter<CommunityEntity> __updateAdapterOfCommunityEntity;

    public EkoCommunityDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfCommunityEntity = new EntityInsertAdapter<CommunityEntity>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `community` (`communityId`,`mid`,`path`,`channelId`,`userId`,`displayName`,`description`,`avatarFileId`,`isOfficial`,`isPublic`,`onlyAdminCanPost`,`tags`,`metadata`,`postsCount`,`membersCount`,`isJoined`,`isDeleted`,`needApprovalOnPostCreation`,`allowCommentInStory`,`editedAt`,`isDiscoverable`,`requiresJoinApproval`,`communityType`,`categoryIds`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull CommunityEntity entity) {
                Integer _tmp_11;
                Integer _tmp_10;
                Integer _tmp_8;
                Integer _tmp_7;
                Integer _tmp_6;
                Integer _tmp_5;
                Integer _tmp_2;
                Integer _tmp_1;
                Integer _tmp;
                if (entity.getCommunityId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getCommunityId());
                }
                if (entity.getMid() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getMid());
                }
                if (entity.getPath() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getPath());
                }
                if (entity.getChannelId() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getChannelId());
                }
                if (entity.getUserId() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, entity.getUserId());
                }
                if (entity.getDisplayName() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, entity.getDisplayName());
                }
                if (entity.getDescription() == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, entity.getDescription());
                }
                if (entity.getAvatarFileId() == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, entity.getAvatarFileId());
                }
                Integer n = entity.isOfficial() == null ? null : (_tmp = Integer.valueOf(entity.isOfficial() != false ? 1 : 0));
                if (_tmp == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindLong(9, (long)_tmp.intValue());
                }
                Integer n2 = entity.isPublic() == null ? null : (_tmp_1 = Integer.valueOf(entity.isPublic() != false ? 1 : 0));
                if (_tmp_1 == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindLong(10, (long)_tmp_1.intValue());
                }
                Integer n3 = entity.getOnlyAdminCanPost() == null ? null : (_tmp_2 = Integer.valueOf(entity.getOnlyAdminCanPost() != false ? 1 : 0));
                if (_tmp_2 == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindLong(11, (long)_tmp_2.intValue());
                }
                String _tmp_3 = EkoCommunityDao_Impl.this.__ekoTagsTypeConverter.ekoTagsToString(entity.getTags());
                if (_tmp_3 == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindText(12, _tmp_3);
                }
                String _tmp_4 = EkoCommunityDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(entity.getMetadata());
                if (_tmp_4 == null) {
                    statement.bindNull(13);
                } else {
                    statement.bindText(13, _tmp_4);
                }
                if (entity.getPostsCount() == null) {
                    statement.bindNull(14);
                } else {
                    statement.bindLong(14, (long)entity.getPostsCount().intValue());
                }
                if (entity.getMembersCount() == null) {
                    statement.bindNull(15);
                } else {
                    statement.bindLong(15, (long)entity.getMembersCount().intValue());
                }
                Integer n4 = entity.isJoined() == null ? null : (_tmp_5 = Integer.valueOf(entity.isJoined() != false ? 1 : 0));
                if (_tmp_5 == null) {
                    statement.bindNull(16);
                } else {
                    statement.bindLong(16, (long)_tmp_5.intValue());
                }
                Integer n5 = entity.isDeleted() == null ? null : (_tmp_6 = Integer.valueOf(entity.isDeleted() != false ? 1 : 0));
                if (_tmp_6 == null) {
                    statement.bindNull(17);
                } else {
                    statement.bindLong(17, (long)_tmp_6.intValue());
                }
                Integer n6 = entity.getNeedApprovalOnPostCreation() == null ? null : (_tmp_7 = Integer.valueOf(entity.getNeedApprovalOnPostCreation() != false ? 1 : 0));
                if (_tmp_7 == null) {
                    statement.bindNull(18);
                } else {
                    statement.bindLong(18, (long)_tmp_7.intValue());
                }
                Integer n7 = entity.getAllowCommentInStory() == null ? null : (_tmp_8 = Integer.valueOf(entity.getAllowCommentInStory() != false ? 1 : 0));
                if (_tmp_8 == null) {
                    statement.bindNull(19);
                } else {
                    statement.bindLong(19, (long)_tmp_8.intValue());
                }
                String _tmp_9 = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getEditedAt());
                if (_tmp_9 == null) {
                    statement.bindNull(20);
                } else {
                    statement.bindText(20, _tmp_9);
                }
                Integer n8 = entity.isDiscoverable() == null ? null : (_tmp_10 = Integer.valueOf(entity.isDiscoverable() != false ? 1 : 0));
                if (_tmp_10 == null) {
                    statement.bindNull(21);
                } else {
                    statement.bindLong(21, (long)_tmp_10.intValue());
                }
                Integer n9 = entity.getRequiresJoinApproval() == null ? null : (_tmp_11 = Integer.valueOf(entity.getRequiresJoinApproval() != false ? 1 : 0));
                if (_tmp_11 == null) {
                    statement.bindNull(22);
                } else {
                    statement.bindLong(22, (long)_tmp_11.intValue());
                }
                if (entity.getCommunityType() == null) {
                    statement.bindNull(23);
                } else {
                    statement.bindText(23, entity.getCommunityType());
                }
                String _tmp_12 = EkoCommunityDao_Impl.this.__ekoCategoriesTypeConverter.ekoCategoriesToString(entity.getCategoryIds());
                if (_tmp_12 == null) {
                    statement.bindNull(24);
                } else {
                    statement.bindText(24, _tmp_12);
                }
                String _tmp_13 = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_13 == null) {
                    statement.bindNull(25);
                } else {
                    statement.bindText(25, _tmp_13);
                }
                String _tmp_14 = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_14 == null) {
                    statement.bindNull(26);
                } else {
                    statement.bindText(26, _tmp_14);
                }
                String _tmp_15 = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_15 == null) {
                    statement.bindNull(27);
                } else {
                    statement.bindText(27, _tmp_15);
                }
            }
        };
        this.__deleteAdapterOfCommunityEntity = new EntityDeleteOrUpdateAdapter<CommunityEntity>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `community` WHERE `communityId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull CommunityEntity entity) {
                if (entity.getCommunityId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getCommunityId());
                }
            }
        };
        this.__updateAdapterOfCommunityEntity = new EntityDeleteOrUpdateAdapter<CommunityEntity>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `community` SET `communityId` = ?,`mid` = ?,`path` = ?,`channelId` = ?,`userId` = ?,`displayName` = ?,`description` = ?,`avatarFileId` = ?,`isOfficial` = ?,`isPublic` = ?,`onlyAdminCanPost` = ?,`tags` = ?,`metadata` = ?,`postsCount` = ?,`membersCount` = ?,`isJoined` = ?,`isDeleted` = ?,`needApprovalOnPostCreation` = ?,`allowCommentInStory` = ?,`editedAt` = ?,`isDiscoverable` = ?,`requiresJoinApproval` = ?,`communityType` = ?,`categoryIds` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `communityId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull CommunityEntity entity) {
                Integer _tmp_11;
                Integer _tmp_10;
                Integer _tmp_8;
                Integer _tmp_7;
                Integer _tmp_6;
                Integer _tmp_5;
                Integer _tmp_2;
                Integer _tmp_1;
                Integer _tmp;
                if (entity.getCommunityId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getCommunityId());
                }
                if (entity.getMid() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getMid());
                }
                if (entity.getPath() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getPath());
                }
                if (entity.getChannelId() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getChannelId());
                }
                if (entity.getUserId() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, entity.getUserId());
                }
                if (entity.getDisplayName() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, entity.getDisplayName());
                }
                if (entity.getDescription() == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, entity.getDescription());
                }
                if (entity.getAvatarFileId() == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, entity.getAvatarFileId());
                }
                Integer n = entity.isOfficial() == null ? null : (_tmp = Integer.valueOf(entity.isOfficial() != false ? 1 : 0));
                if (_tmp == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindLong(9, (long)_tmp.intValue());
                }
                Integer n2 = entity.isPublic() == null ? null : (_tmp_1 = Integer.valueOf(entity.isPublic() != false ? 1 : 0));
                if (_tmp_1 == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindLong(10, (long)_tmp_1.intValue());
                }
                Integer n3 = entity.getOnlyAdminCanPost() == null ? null : (_tmp_2 = Integer.valueOf(entity.getOnlyAdminCanPost() != false ? 1 : 0));
                if (_tmp_2 == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindLong(11, (long)_tmp_2.intValue());
                }
                String _tmp_3 = EkoCommunityDao_Impl.this.__ekoTagsTypeConverter.ekoTagsToString(entity.getTags());
                if (_tmp_3 == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindText(12, _tmp_3);
                }
                String _tmp_4 = EkoCommunityDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(entity.getMetadata());
                if (_tmp_4 == null) {
                    statement.bindNull(13);
                } else {
                    statement.bindText(13, _tmp_4);
                }
                if (entity.getPostsCount() == null) {
                    statement.bindNull(14);
                } else {
                    statement.bindLong(14, (long)entity.getPostsCount().intValue());
                }
                if (entity.getMembersCount() == null) {
                    statement.bindNull(15);
                } else {
                    statement.bindLong(15, (long)entity.getMembersCount().intValue());
                }
                Integer n4 = entity.isJoined() == null ? null : (_tmp_5 = Integer.valueOf(entity.isJoined() != false ? 1 : 0));
                if (_tmp_5 == null) {
                    statement.bindNull(16);
                } else {
                    statement.bindLong(16, (long)_tmp_5.intValue());
                }
                Integer n5 = entity.isDeleted() == null ? null : (_tmp_6 = Integer.valueOf(entity.isDeleted() != false ? 1 : 0));
                if (_tmp_6 == null) {
                    statement.bindNull(17);
                } else {
                    statement.bindLong(17, (long)_tmp_6.intValue());
                }
                Integer n6 = entity.getNeedApprovalOnPostCreation() == null ? null : (_tmp_7 = Integer.valueOf(entity.getNeedApprovalOnPostCreation() != false ? 1 : 0));
                if (_tmp_7 == null) {
                    statement.bindNull(18);
                } else {
                    statement.bindLong(18, (long)_tmp_7.intValue());
                }
                Integer n7 = entity.getAllowCommentInStory() == null ? null : (_tmp_8 = Integer.valueOf(entity.getAllowCommentInStory() != false ? 1 : 0));
                if (_tmp_8 == null) {
                    statement.bindNull(19);
                } else {
                    statement.bindLong(19, (long)_tmp_8.intValue());
                }
                String _tmp_9 = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getEditedAt());
                if (_tmp_9 == null) {
                    statement.bindNull(20);
                } else {
                    statement.bindText(20, _tmp_9);
                }
                Integer n8 = entity.isDiscoverable() == null ? null : (_tmp_10 = Integer.valueOf(entity.isDiscoverable() != false ? 1 : 0));
                if (_tmp_10 == null) {
                    statement.bindNull(21);
                } else {
                    statement.bindLong(21, (long)_tmp_10.intValue());
                }
                Integer n9 = entity.getRequiresJoinApproval() == null ? null : (_tmp_11 = Integer.valueOf(entity.getRequiresJoinApproval() != false ? 1 : 0));
                if (_tmp_11 == null) {
                    statement.bindNull(22);
                } else {
                    statement.bindLong(22, (long)_tmp_11.intValue());
                }
                if (entity.getCommunityType() == null) {
                    statement.bindNull(23);
                } else {
                    statement.bindText(23, entity.getCommunityType());
                }
                String _tmp_12 = EkoCommunityDao_Impl.this.__ekoCategoriesTypeConverter.ekoCategoriesToString(entity.getCategoryIds());
                if (_tmp_12 == null) {
                    statement.bindNull(24);
                } else {
                    statement.bindText(24, _tmp_12);
                }
                String _tmp_13 = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_13 == null) {
                    statement.bindNull(25);
                } else {
                    statement.bindText(25, _tmp_13);
                }
                String _tmp_14 = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_14 == null) {
                    statement.bindNull(26);
                } else {
                    statement.bindText(26, _tmp_14);
                }
                String _tmp_15 = EkoCommunityDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_15 == null) {
                    statement.bindNull(27);
                } else {
                    statement.bindText(27, _tmp_15);
                }
                if (entity.getCommunityId() == null) {
                    statement.bindNull(28);
                } else {
                    statement.bindText(28, entity.getCommunityId());
                }
            }
        };
    }

    @Override
    public void insertImpl(CommunityEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfCommunityEntity.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends CommunityEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfCommunityEntity.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(CommunityEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfCommunityEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void delete(List<? extends CommunityEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfCommunityEntity.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void updateImpl(CommunityEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfCommunityEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(CommunityEntity community) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoCommunityDao_Impl.super.insert(community);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends CommunityEntity> communities) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoCommunityDao_Impl.super.insert(communities);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(CommunityEntity community) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoCommunityDao_Impl.super.update(community);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(List<? extends CommunityEntity> communities) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoCommunityDao_Impl.super.update(communities);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void updateIsJoined(String communityId) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EkoCommunityDao_Impl.super.updateIsJoined(communityId);
            return Unit.INSTANCE;
        });
    }

    @Override
    Flowable<CommunityEntity> getByCommunityIdImpl(String communityId) {
        String _sql = "SELECT * from community where community.communityId = ? LIMIT 1";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"community"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from community where community.communityId = ? LIMIT 1");){
                CommunityEntity _result;
                int _argIndex = 1;
                if (communityId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, communityId);
                }
                int _columnIndexOfCommunityId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"communityId");
                int _columnIndexOfMid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mid");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfDisplayName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"displayName");
                int _columnIndexOfDescription = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"description");
                int _columnIndexOfAvatarFileId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"avatarFileId");
                int _columnIndexOfIsOfficial = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isOfficial");
                int _columnIndexOfIsPublic = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isPublic");
                int _columnIndexOfOnlyAdminCanPost = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"onlyAdminCanPost");
                int _columnIndexOfTags = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"tags");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfPostsCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"postsCount");
                int _columnIndexOfMembersCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"membersCount");
                int _columnIndexOfIsJoined = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isJoined");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfNeedApprovalOnPostCreation = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"needApprovalOnPostCreation");
                int _columnIndexOfAllowCommentInStory = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"allowCommentInStory");
                int _columnIndexOfEditedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"editedAt");
                int _columnIndexOfIsDiscoverable = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDiscoverable");
                int _columnIndexOfRequiresJoinApproval = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"requiresJoinApproval");
                int _columnIndexOfCommunityType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"communityType");
                int _columnIndexOfCategoryIds = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"categoryIds");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new CommunityEntity();
                    String _tmpCommunityId = _stmt.isNull(_columnIndexOfCommunityId) ? null : _stmt.getText(_columnIndexOfCommunityId);
                    _result.setCommunityId(_tmpCommunityId);
                    String _tmpMid = _stmt.isNull(_columnIndexOfMid) ? null : _stmt.getText(_columnIndexOfMid);
                    _result.setMid(_tmpMid);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _result.setPath(_tmpPath);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _result.setChannelId(_tmpChannelId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _result.setUserId(_tmpUserId);
                    String _tmpDisplayName = _stmt.isNull(_columnIndexOfDisplayName) ? null : _stmt.getText(_columnIndexOfDisplayName);
                    _result.setDisplayName(_tmpDisplayName);
                    String _tmpDescription = _stmt.isNull(_columnIndexOfDescription) ? null : _stmt.getText(_columnIndexOfDescription);
                    _result.setDescription(_tmpDescription);
                    String _tmpAvatarFileId = _stmt.isNull(_columnIndexOfAvatarFileId) ? null : _stmt.getText(_columnIndexOfAvatarFileId);
                    _result.setAvatarFileId(_tmpAvatarFileId);
                    Integer _tmp = _stmt.isNull(_columnIndexOfIsOfficial) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfIsOfficial));
                    Boolean _tmpIsOfficial = _tmp == null ? null : Boolean.valueOf(_tmp != 0);
                    _result.setOfficial(_tmpIsOfficial);
                    Integer _tmp_1 = _stmt.isNull(_columnIndexOfIsPublic) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfIsPublic));
                    Boolean _tmpIsPublic = _tmp_1 == null ? null : Boolean.valueOf(_tmp_1 != 0);
                    _result.setPublic(_tmpIsPublic);
                    Integer _tmp_2 = _stmt.isNull(_columnIndexOfOnlyAdminCanPost) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfOnlyAdminCanPost));
                    Boolean _tmpOnlyAdminCanPost = _tmp_2 == null ? null : Boolean.valueOf(_tmp_2 != 0);
                    _result.setOnlyAdminCanPost(_tmpOnlyAdminCanPost);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfTags) ? null : _stmt.getText(_columnIndexOfTags);
                    AmityTags _tmpTags = this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_3);
                    _result.setTags(_tmpTags);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                    _result.setMetadata(_tmpMetadata);
                    Integer _tmpPostsCount = _stmt.isNull(_columnIndexOfPostsCount) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfPostsCount));
                    _result.setPostsCount(_tmpPostsCount);
                    Integer _tmpMembersCount = _stmt.isNull(_columnIndexOfMembersCount) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfMembersCount));
                    _result.setMembersCount(_tmpMembersCount);
                    Integer _tmp_5 = _stmt.isNull(_columnIndexOfIsJoined) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfIsJoined));
                    Boolean _tmpIsJoined = _tmp_5 == null ? null : Boolean.valueOf(_tmp_5 != 0);
                    _result.setJoined(_tmpIsJoined);
                    Integer _tmp_6 = _stmt.isNull(_columnIndexOfIsDeleted) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfIsDeleted));
                    Boolean _tmpIsDeleted = _tmp_6 == null ? null : Boolean.valueOf(_tmp_6 != 0);
                    _result.setDeleted(_tmpIsDeleted);
                    Integer _tmp_7 = _stmt.isNull(_columnIndexOfNeedApprovalOnPostCreation) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfNeedApprovalOnPostCreation));
                    Boolean _tmpNeedApprovalOnPostCreation = _tmp_7 == null ? null : Boolean.valueOf(_tmp_7 != 0);
                    _result.setNeedApprovalOnPostCreation(_tmpNeedApprovalOnPostCreation);
                    Integer _tmp_8 = _stmt.isNull(_columnIndexOfAllowCommentInStory) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfAllowCommentInStory));
                    Boolean _tmpAllowCommentInStory = _tmp_8 == null ? null : Boolean.valueOf(_tmp_8 != 0);
                    _result.setAllowCommentInStory(_tmpAllowCommentInStory);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfEditedAt) ? null : _stmt.getText(_columnIndexOfEditedAt);
                    DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                    _result.setEditedAt(_tmpEditedAt);
                    Integer _tmp_10 = _stmt.isNull(_columnIndexOfIsDiscoverable) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfIsDiscoverable));
                    Boolean _tmpIsDiscoverable = _tmp_10 == null ? null : Boolean.valueOf(_tmp_10 != 0);
                    _result.setDiscoverable(_tmpIsDiscoverable);
                    Integer _tmp_11 = _stmt.isNull(_columnIndexOfRequiresJoinApproval) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfRequiresJoinApproval));
                    Boolean _tmpRequiresJoinApproval = _tmp_11 == null ? null : Boolean.valueOf(_tmp_11 != 0);
                    _result.setRequiresJoinApproval(_tmpRequiresJoinApproval);
                    String _tmpCommunityType = _stmt.isNull(_columnIndexOfCommunityType) ? null : _stmt.getText(_columnIndexOfCommunityType);
                    _result.setCommunityType(_tmpCommunityType);
                    String _tmp_12 = _stmt.isNull(_columnIndexOfCategoryIds) ? null : _stmt.getText(_columnIndexOfCategoryIds);
                    EkoCategoryIds _tmpCategoryIds = this.__ekoCategoriesTypeConverter.stringToEkoCategories(_tmp_12);
                    _result.setCategoryIds(_tmpCategoryIds);
                    String _tmp_13 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_13);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_14 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_14);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_15 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_15);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                CommunityEntity communityEntity = _result;
                return communityEntity;
            }
        });
    }

    @Override
    Flowable<List<CommunityEntity>> observeByCommunityIdsImpl(List<String> communityIds) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("SELECT * from community where community.communityId in (");
        int _inputSize = communityIds == null ? 1 : communityIds.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"community"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare(_sql);){
                int _argIndex = 1;
                if (communityIds == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    for (String _item : communityIds) {
                        if (_item == null) {
                            _stmt.bindNull(_argIndex);
                        } else {
                            _stmt.bindText(_argIndex, _item);
                        }
                        ++_argIndex;
                    }
                }
                int _columnIndexOfCommunityId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"communityId");
                int _columnIndexOfMid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mid");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfDisplayName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"displayName");
                int _columnIndexOfDescription = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"description");
                int _columnIndexOfAvatarFileId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"avatarFileId");
                int _columnIndexOfIsOfficial = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isOfficial");
                int _columnIndexOfIsPublic = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isPublic");
                int _columnIndexOfOnlyAdminCanPost = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"onlyAdminCanPost");
                int _columnIndexOfTags = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"tags");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfPostsCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"postsCount");
                int _columnIndexOfMembersCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"membersCount");
                int _columnIndexOfIsJoined = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isJoined");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfNeedApprovalOnPostCreation = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"needApprovalOnPostCreation");
                int _columnIndexOfAllowCommentInStory = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"allowCommentInStory");
                int _columnIndexOfEditedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"editedAt");
                int _columnIndexOfIsDiscoverable = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDiscoverable");
                int _columnIndexOfRequiresJoinApproval = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"requiresJoinApproval");
                int _columnIndexOfCommunityType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"communityType");
                int _columnIndexOfCategoryIds = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"categoryIds");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<CommunityEntity> _result = new ArrayList<CommunityEntity>();
                while (_stmt.step()) {
                    CommunityEntity _item_1 = new CommunityEntity();
                    String _tmpCommunityId = _stmt.isNull(_columnIndexOfCommunityId) ? null : _stmt.getText(_columnIndexOfCommunityId);
                    _item_1.setCommunityId(_tmpCommunityId);
                    String _tmpMid = _stmt.isNull(_columnIndexOfMid) ? null : _stmt.getText(_columnIndexOfMid);
                    _item_1.setMid(_tmpMid);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _item_1.setPath(_tmpPath);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _item_1.setChannelId(_tmpChannelId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _item_1.setUserId(_tmpUserId);
                    String _tmpDisplayName = _stmt.isNull(_columnIndexOfDisplayName) ? null : _stmt.getText(_columnIndexOfDisplayName);
                    _item_1.setDisplayName(_tmpDisplayName);
                    String _tmpDescription = _stmt.isNull(_columnIndexOfDescription) ? null : _stmt.getText(_columnIndexOfDescription);
                    _item_1.setDescription(_tmpDescription);
                    String _tmpAvatarFileId = _stmt.isNull(_columnIndexOfAvatarFileId) ? null : _stmt.getText(_columnIndexOfAvatarFileId);
                    _item_1.setAvatarFileId(_tmpAvatarFileId);
                    Integer _tmp = _stmt.isNull(_columnIndexOfIsOfficial) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfIsOfficial));
                    Boolean _tmpIsOfficial = _tmp == null ? null : Boolean.valueOf(_tmp != 0);
                    _item_1.setOfficial(_tmpIsOfficial);
                    Integer _tmp_1 = _stmt.isNull(_columnIndexOfIsPublic) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfIsPublic));
                    Boolean _tmpIsPublic = _tmp_1 == null ? null : Boolean.valueOf(_tmp_1 != 0);
                    _item_1.setPublic(_tmpIsPublic);
                    Integer _tmp_2 = _stmt.isNull(_columnIndexOfOnlyAdminCanPost) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfOnlyAdminCanPost));
                    Boolean _tmpOnlyAdminCanPost = _tmp_2 == null ? null : Boolean.valueOf(_tmp_2 != 0);
                    _item_1.setOnlyAdminCanPost(_tmpOnlyAdminCanPost);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfTags) ? null : _stmt.getText(_columnIndexOfTags);
                    AmityTags _tmpTags = this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_3);
                    _item_1.setTags(_tmpTags);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                    _item_1.setMetadata(_tmpMetadata);
                    Integer _tmpPostsCount = _stmt.isNull(_columnIndexOfPostsCount) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfPostsCount));
                    _item_1.setPostsCount(_tmpPostsCount);
                    Integer _tmpMembersCount = _stmt.isNull(_columnIndexOfMembersCount) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfMembersCount));
                    _item_1.setMembersCount(_tmpMembersCount);
                    Integer _tmp_5 = _stmt.isNull(_columnIndexOfIsJoined) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfIsJoined));
                    Boolean _tmpIsJoined = _tmp_5 == null ? null : Boolean.valueOf(_tmp_5 != 0);
                    _item_1.setJoined(_tmpIsJoined);
                    Integer _tmp_6 = _stmt.isNull(_columnIndexOfIsDeleted) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfIsDeleted));
                    Boolean _tmpIsDeleted = _tmp_6 == null ? null : Boolean.valueOf(_tmp_6 != 0);
                    _item_1.setDeleted(_tmpIsDeleted);
                    Integer _tmp_7 = _stmt.isNull(_columnIndexOfNeedApprovalOnPostCreation) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfNeedApprovalOnPostCreation));
                    Boolean _tmpNeedApprovalOnPostCreation = _tmp_7 == null ? null : Boolean.valueOf(_tmp_7 != 0);
                    _item_1.setNeedApprovalOnPostCreation(_tmpNeedApprovalOnPostCreation);
                    Integer _tmp_8 = _stmt.isNull(_columnIndexOfAllowCommentInStory) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfAllowCommentInStory));
                    Boolean _tmpAllowCommentInStory = _tmp_8 == null ? null : Boolean.valueOf(_tmp_8 != 0);
                    _item_1.setAllowCommentInStory(_tmpAllowCommentInStory);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfEditedAt) ? null : _stmt.getText(_columnIndexOfEditedAt);
                    DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                    _item_1.setEditedAt(_tmpEditedAt);
                    Integer _tmp_10 = _stmt.isNull(_columnIndexOfIsDiscoverable) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfIsDiscoverable));
                    Boolean _tmpIsDiscoverable = _tmp_10 == null ? null : Boolean.valueOf(_tmp_10 != 0);
                    _item_1.setDiscoverable(_tmpIsDiscoverable);
                    Integer _tmp_11 = _stmt.isNull(_columnIndexOfRequiresJoinApproval) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfRequiresJoinApproval));
                    Boolean _tmpRequiresJoinApproval = _tmp_11 == null ? null : Boolean.valueOf(_tmp_11 != 0);
                    _item_1.setRequiresJoinApproval(_tmpRequiresJoinApproval);
                    String _tmpCommunityType = _stmt.isNull(_columnIndexOfCommunityType) ? null : _stmt.getText(_columnIndexOfCommunityType);
                    _item_1.setCommunityType(_tmpCommunityType);
                    String _tmp_12 = _stmt.isNull(_columnIndexOfCategoryIds) ? null : _stmt.getText(_columnIndexOfCategoryIds);
                    EkoCategoryIds _tmpCategoryIds = this.__ekoCategoriesTypeConverter.stringToEkoCategories(_tmp_12);
                    _item_1.setCategoryIds(_tmpCategoryIds);
                    String _tmp_13 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_13);
                    _item_1.setCreatedAt(_tmpCreatedAt);
                    String _tmp_14 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_14);
                    _item_1.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_15 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_15);
                    _item_1.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item_1);
                }
                ArrayList<CommunityEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    CommunityEntity getByIdNowImpl(String communityId) {
        String _sql = "SELECT * from community where communityId = ? LIMIT 1";
        return (CommunityEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from community where communityId = ? LIMIT 1");){
                CommunityEntity _result;
                int _argIndex = 1;
                if (communityId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, communityId);
                }
                int _columnIndexOfCommunityId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"communityId");
                int _columnIndexOfMid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mid");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfDisplayName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"displayName");
                int _columnIndexOfDescription = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"description");
                int _columnIndexOfAvatarFileId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"avatarFileId");
                int _columnIndexOfIsOfficial = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isOfficial");
                int _columnIndexOfIsPublic = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isPublic");
                int _columnIndexOfOnlyAdminCanPost = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"onlyAdminCanPost");
                int _columnIndexOfTags = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"tags");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfPostsCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"postsCount");
                int _columnIndexOfMembersCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"membersCount");
                int _columnIndexOfIsJoined = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isJoined");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfNeedApprovalOnPostCreation = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"needApprovalOnPostCreation");
                int _columnIndexOfAllowCommentInStory = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"allowCommentInStory");
                int _columnIndexOfEditedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"editedAt");
                int _columnIndexOfIsDiscoverable = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDiscoverable");
                int _columnIndexOfRequiresJoinApproval = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"requiresJoinApproval");
                int _columnIndexOfCommunityType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"communityType");
                int _columnIndexOfCategoryIds = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"categoryIds");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new CommunityEntity();
                    String _tmpCommunityId = _stmt.isNull(_columnIndexOfCommunityId) ? null : _stmt.getText(_columnIndexOfCommunityId);
                    _result.setCommunityId(_tmpCommunityId);
                    String _tmpMid = _stmt.isNull(_columnIndexOfMid) ? null : _stmt.getText(_columnIndexOfMid);
                    _result.setMid(_tmpMid);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _result.setPath(_tmpPath);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _result.setChannelId(_tmpChannelId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _result.setUserId(_tmpUserId);
                    String _tmpDisplayName = _stmt.isNull(_columnIndexOfDisplayName) ? null : _stmt.getText(_columnIndexOfDisplayName);
                    _result.setDisplayName(_tmpDisplayName);
                    String _tmpDescription = _stmt.isNull(_columnIndexOfDescription) ? null : _stmt.getText(_columnIndexOfDescription);
                    _result.setDescription(_tmpDescription);
                    String _tmpAvatarFileId = _stmt.isNull(_columnIndexOfAvatarFileId) ? null : _stmt.getText(_columnIndexOfAvatarFileId);
                    _result.setAvatarFileId(_tmpAvatarFileId);
                    Integer _tmp = _stmt.isNull(_columnIndexOfIsOfficial) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfIsOfficial));
                    Boolean _tmpIsOfficial = _tmp == null ? null : Boolean.valueOf(_tmp != 0);
                    _result.setOfficial(_tmpIsOfficial);
                    Integer _tmp_1 = _stmt.isNull(_columnIndexOfIsPublic) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfIsPublic));
                    Boolean _tmpIsPublic = _tmp_1 == null ? null : Boolean.valueOf(_tmp_1 != 0);
                    _result.setPublic(_tmpIsPublic);
                    Integer _tmp_2 = _stmt.isNull(_columnIndexOfOnlyAdminCanPost) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfOnlyAdminCanPost));
                    Boolean _tmpOnlyAdminCanPost = _tmp_2 == null ? null : Boolean.valueOf(_tmp_2 != 0);
                    _result.setOnlyAdminCanPost(_tmpOnlyAdminCanPost);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfTags) ? null : _stmt.getText(_columnIndexOfTags);
                    AmityTags _tmpTags = this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_3);
                    _result.setTags(_tmpTags);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                    _result.setMetadata(_tmpMetadata);
                    Integer _tmpPostsCount = _stmt.isNull(_columnIndexOfPostsCount) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfPostsCount));
                    _result.setPostsCount(_tmpPostsCount);
                    Integer _tmpMembersCount = _stmt.isNull(_columnIndexOfMembersCount) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfMembersCount));
                    _result.setMembersCount(_tmpMembersCount);
                    Integer _tmp_5 = _stmt.isNull(_columnIndexOfIsJoined) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfIsJoined));
                    Boolean _tmpIsJoined = _tmp_5 == null ? null : Boolean.valueOf(_tmp_5 != 0);
                    _result.setJoined(_tmpIsJoined);
                    Integer _tmp_6 = _stmt.isNull(_columnIndexOfIsDeleted) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfIsDeleted));
                    Boolean _tmpIsDeleted = _tmp_6 == null ? null : Boolean.valueOf(_tmp_6 != 0);
                    _result.setDeleted(_tmpIsDeleted);
                    Integer _tmp_7 = _stmt.isNull(_columnIndexOfNeedApprovalOnPostCreation) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfNeedApprovalOnPostCreation));
                    Boolean _tmpNeedApprovalOnPostCreation = _tmp_7 == null ? null : Boolean.valueOf(_tmp_7 != 0);
                    _result.setNeedApprovalOnPostCreation(_tmpNeedApprovalOnPostCreation);
                    Integer _tmp_8 = _stmt.isNull(_columnIndexOfAllowCommentInStory) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfAllowCommentInStory));
                    Boolean _tmpAllowCommentInStory = _tmp_8 == null ? null : Boolean.valueOf(_tmp_8 != 0);
                    _result.setAllowCommentInStory(_tmpAllowCommentInStory);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfEditedAt) ? null : _stmt.getText(_columnIndexOfEditedAt);
                    DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                    _result.setEditedAt(_tmpEditedAt);
                    Integer _tmp_10 = _stmt.isNull(_columnIndexOfIsDiscoverable) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfIsDiscoverable));
                    Boolean _tmpIsDiscoverable = _tmp_10 == null ? null : Boolean.valueOf(_tmp_10 != 0);
                    _result.setDiscoverable(_tmpIsDiscoverable);
                    Integer _tmp_11 = _stmt.isNull(_columnIndexOfRequiresJoinApproval) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfRequiresJoinApproval));
                    Boolean _tmpRequiresJoinApproval = _tmp_11 == null ? null : Boolean.valueOf(_tmp_11 != 0);
                    _result.setRequiresJoinApproval(_tmpRequiresJoinApproval);
                    String _tmpCommunityType = _stmt.isNull(_columnIndexOfCommunityType) ? null : _stmt.getText(_columnIndexOfCommunityType);
                    _result.setCommunityType(_tmpCommunityType);
                    String _tmp_12 = _stmt.isNull(_columnIndexOfCategoryIds) ? null : _stmt.getText(_columnIndexOfCategoryIds);
                    EkoCategoryIds _tmpCategoryIds = this.__ekoCategoriesTypeConverter.stringToEkoCategories(_tmp_12);
                    _result.setCategoryIds(_tmpCategoryIds);
                    String _tmp_13 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_13);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_14 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_14);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_15 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_15);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                CommunityEntity communityEntity = _result;
                return communityEntity;
            }
        });
    }

    @Override
    List<CommunityEntity> getByIdsNowImpl(List<String> ids) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("SELECT * from community where community.communityId IN (");
        int _inputSize = ids == null ? 1 : ids.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        return (List)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare(_sql);){
                int _argIndex = 1;
                if (ids == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    for (String _item : ids) {
                        if (_item == null) {
                            _stmt.bindNull(_argIndex);
                        } else {
                            _stmt.bindText(_argIndex, _item);
                        }
                        ++_argIndex;
                    }
                }
                int _columnIndexOfCommunityId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"communityId");
                int _columnIndexOfMid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mid");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfDisplayName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"displayName");
                int _columnIndexOfDescription = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"description");
                int _columnIndexOfAvatarFileId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"avatarFileId");
                int _columnIndexOfIsOfficial = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isOfficial");
                int _columnIndexOfIsPublic = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isPublic");
                int _columnIndexOfOnlyAdminCanPost = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"onlyAdminCanPost");
                int _columnIndexOfTags = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"tags");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfPostsCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"postsCount");
                int _columnIndexOfMembersCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"membersCount");
                int _columnIndexOfIsJoined = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isJoined");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfNeedApprovalOnPostCreation = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"needApprovalOnPostCreation");
                int _columnIndexOfAllowCommentInStory = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"allowCommentInStory");
                int _columnIndexOfEditedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"editedAt");
                int _columnIndexOfIsDiscoverable = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDiscoverable");
                int _columnIndexOfRequiresJoinApproval = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"requiresJoinApproval");
                int _columnIndexOfCommunityType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"communityType");
                int _columnIndexOfCategoryIds = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"categoryIds");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<CommunityEntity> _result = new ArrayList<CommunityEntity>();
                while (_stmt.step()) {
                    CommunityEntity _item_1 = new CommunityEntity();
                    String _tmpCommunityId = _stmt.isNull(_columnIndexOfCommunityId) ? null : _stmt.getText(_columnIndexOfCommunityId);
                    _item_1.setCommunityId(_tmpCommunityId);
                    String _tmpMid = _stmt.isNull(_columnIndexOfMid) ? null : _stmt.getText(_columnIndexOfMid);
                    _item_1.setMid(_tmpMid);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _item_1.setPath(_tmpPath);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _item_1.setChannelId(_tmpChannelId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _item_1.setUserId(_tmpUserId);
                    String _tmpDisplayName = _stmt.isNull(_columnIndexOfDisplayName) ? null : _stmt.getText(_columnIndexOfDisplayName);
                    _item_1.setDisplayName(_tmpDisplayName);
                    String _tmpDescription = _stmt.isNull(_columnIndexOfDescription) ? null : _stmt.getText(_columnIndexOfDescription);
                    _item_1.setDescription(_tmpDescription);
                    String _tmpAvatarFileId = _stmt.isNull(_columnIndexOfAvatarFileId) ? null : _stmt.getText(_columnIndexOfAvatarFileId);
                    _item_1.setAvatarFileId(_tmpAvatarFileId);
                    Integer _tmp = _stmt.isNull(_columnIndexOfIsOfficial) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfIsOfficial));
                    Boolean _tmpIsOfficial = _tmp == null ? null : Boolean.valueOf(_tmp != 0);
                    _item_1.setOfficial(_tmpIsOfficial);
                    Integer _tmp_1 = _stmt.isNull(_columnIndexOfIsPublic) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfIsPublic));
                    Boolean _tmpIsPublic = _tmp_1 == null ? null : Boolean.valueOf(_tmp_1 != 0);
                    _item_1.setPublic(_tmpIsPublic);
                    Integer _tmp_2 = _stmt.isNull(_columnIndexOfOnlyAdminCanPost) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfOnlyAdminCanPost));
                    Boolean _tmpOnlyAdminCanPost = _tmp_2 == null ? null : Boolean.valueOf(_tmp_2 != 0);
                    _item_1.setOnlyAdminCanPost(_tmpOnlyAdminCanPost);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfTags) ? null : _stmt.getText(_columnIndexOfTags);
                    AmityTags _tmpTags = this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_3);
                    _item_1.setTags(_tmpTags);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_4);
                    _item_1.setMetadata(_tmpMetadata);
                    Integer _tmpPostsCount = _stmt.isNull(_columnIndexOfPostsCount) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfPostsCount));
                    _item_1.setPostsCount(_tmpPostsCount);
                    Integer _tmpMembersCount = _stmt.isNull(_columnIndexOfMembersCount) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfMembersCount));
                    _item_1.setMembersCount(_tmpMembersCount);
                    Integer _tmp_5 = _stmt.isNull(_columnIndexOfIsJoined) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfIsJoined));
                    Boolean _tmpIsJoined = _tmp_5 == null ? null : Boolean.valueOf(_tmp_5 != 0);
                    _item_1.setJoined(_tmpIsJoined);
                    Integer _tmp_6 = _stmt.isNull(_columnIndexOfIsDeleted) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfIsDeleted));
                    Boolean _tmpIsDeleted = _tmp_6 == null ? null : Boolean.valueOf(_tmp_6 != 0);
                    _item_1.setDeleted(_tmpIsDeleted);
                    Integer _tmp_7 = _stmt.isNull(_columnIndexOfNeedApprovalOnPostCreation) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfNeedApprovalOnPostCreation));
                    Boolean _tmpNeedApprovalOnPostCreation = _tmp_7 == null ? null : Boolean.valueOf(_tmp_7 != 0);
                    _item_1.setNeedApprovalOnPostCreation(_tmpNeedApprovalOnPostCreation);
                    Integer _tmp_8 = _stmt.isNull(_columnIndexOfAllowCommentInStory) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfAllowCommentInStory));
                    Boolean _tmpAllowCommentInStory = _tmp_8 == null ? null : Boolean.valueOf(_tmp_8 != 0);
                    _item_1.setAllowCommentInStory(_tmpAllowCommentInStory);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfEditedAt) ? null : _stmt.getText(_columnIndexOfEditedAt);
                    DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_9);
                    _item_1.setEditedAt(_tmpEditedAt);
                    Integer _tmp_10 = _stmt.isNull(_columnIndexOfIsDiscoverable) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfIsDiscoverable));
                    Boolean _tmpIsDiscoverable = _tmp_10 == null ? null : Boolean.valueOf(_tmp_10 != 0);
                    _item_1.setDiscoverable(_tmpIsDiscoverable);
                    Integer _tmp_11 = _stmt.isNull(_columnIndexOfRequiresJoinApproval) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfRequiresJoinApproval));
                    Boolean _tmpRequiresJoinApproval = _tmp_11 == null ? null : Boolean.valueOf(_tmp_11 != 0);
                    _item_1.setRequiresJoinApproval(_tmpRequiresJoinApproval);
                    String _tmpCommunityType = _stmt.isNull(_columnIndexOfCommunityType) ? null : _stmt.getText(_columnIndexOfCommunityType);
                    _item_1.setCommunityType(_tmpCommunityType);
                    String _tmp_12 = _stmt.isNull(_columnIndexOfCategoryIds) ? null : _stmt.getText(_columnIndexOfCategoryIds);
                    EkoCategoryIds _tmpCategoryIds = this.__ekoCategoriesTypeConverter.stringToEkoCategories(_tmp_12);
                    _item_1.setCategoryIds(_tmpCategoryIds);
                    String _tmp_13 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_13);
                    _item_1.setCreatedAt(_tmpCreatedAt);
                    String _tmp_14 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_14);
                    _item_1.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_15 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_15);
                    _item_1.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item_1);
                }
                ArrayList<CommunityEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    Flowable<CommunityEntity> getLatestCommunityImpl(Boolean isFilterByCategoryId, String categoryId, Boolean isFilterByMembership, Boolean isJoined, Boolean isDeleted, int hash, int nonce, DateTime now) {
        String _sql = "SELECT * from community where community.isJoined = (case when ? then ? else isJoined end) and case when ? then community.communityId in (SELECT communityId from category where categoryId in (?)) else community.communityId is not null end and community.isDeleted = (case when ? is null then isDeleted else ? end) and community.updatedAt > ? and community.communityId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (?) and amity_paging_id.nonce = (?) ) order by community.updatedAt  desc limit 1";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"community", "category", "amity_paging_id"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * from community where community.isJoined = (case when ? then ? else isJoined end) and case when ? then community.communityId in (SELECT communityId from category where categoryId in (?)) else community.communityId is not null end and community.isDeleted = (case when ? is null then isDeleted else ? end) and community.updatedAt > ? and community.communityId not in (SELECT amity_paging_id.id from amity_paging_id where amity_paging_id.hash = (?) and amity_paging_id.nonce = (?) ) order by community.updatedAt  desc limit 1");){
                CommunityEntity _result;
                Integer _tmp_4;
                Integer _tmp_3;
                Integer _tmp_2;
                Integer _tmp_1;
                Integer _tmp;
                int _argIndex = 1;
                Integer n = isFilterByMembership == null ? null : (_tmp = Integer.valueOf(isFilterByMembership != false ? 1 : 0));
                if (_tmp == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp.intValue());
                }
                _argIndex = 2;
                Integer n2 = isJoined == null ? null : (_tmp_1 = Integer.valueOf(isJoined != false ? 1 : 0));
                if (_tmp_1 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp_1.intValue());
                }
                _argIndex = 3;
                Integer n3 = isFilterByCategoryId == null ? null : (_tmp_2 = Integer.valueOf(isFilterByCategoryId != false ? 1 : 0));
                if (_tmp_2 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp_2.intValue());
                }
                _argIndex = 4;
                if (categoryId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, categoryId);
                }
                _argIndex = 5;
                Integer n4 = isDeleted == null ? null : (_tmp_3 = Integer.valueOf(isDeleted != false ? 1 : 0));
                if (_tmp_3 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp_3.intValue());
                }
                _argIndex = 6;
                Integer n5 = isDeleted == null ? null : (_tmp_4 = Integer.valueOf(isDeleted != false ? 1 : 0));
                if (_tmp_4 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindLong(_argIndex, (long)_tmp_4.intValue());
                }
                _argIndex = 7;
                String _tmp_5 = this.__dateTimeTypeConverter.dateTimeToString(now);
                if (_tmp_5 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, _tmp_5);
                }
                _argIndex = 8;
                _stmt.bindLong(_argIndex, (long)hash);
                _argIndex = 9;
                _stmt.bindLong(_argIndex, (long)nonce);
                int _columnIndexOfCommunityId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"communityId");
                int _columnIndexOfMid = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"mid");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfChannelId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"channelId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfDisplayName = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"displayName");
                int _columnIndexOfDescription = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"description");
                int _columnIndexOfAvatarFileId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"avatarFileId");
                int _columnIndexOfIsOfficial = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isOfficial");
                int _columnIndexOfIsPublic = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isPublic");
                int _columnIndexOfOnlyAdminCanPost = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"onlyAdminCanPost");
                int _columnIndexOfTags = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"tags");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfPostsCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"postsCount");
                int _columnIndexOfMembersCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"membersCount");
                int _columnIndexOfIsJoined = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isJoined");
                int _columnIndexOfIsDeleted = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDeleted");
                int _columnIndexOfNeedApprovalOnPostCreation = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"needApprovalOnPostCreation");
                int _columnIndexOfAllowCommentInStory = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"allowCommentInStory");
                int _columnIndexOfEditedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"editedAt");
                int _columnIndexOfIsDiscoverable = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isDiscoverable");
                int _columnIndexOfRequiresJoinApproval = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"requiresJoinApproval");
                int _columnIndexOfCommunityType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"communityType");
                int _columnIndexOfCategoryIds = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"categoryIds");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new CommunityEntity();
                    String _tmpCommunityId = _stmt.isNull(_columnIndexOfCommunityId) ? null : _stmt.getText(_columnIndexOfCommunityId);
                    _result.setCommunityId(_tmpCommunityId);
                    String _tmpMid = _stmt.isNull(_columnIndexOfMid) ? null : _stmt.getText(_columnIndexOfMid);
                    _result.setMid(_tmpMid);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _result.setPath(_tmpPath);
                    String _tmpChannelId = _stmt.isNull(_columnIndexOfChannelId) ? null : _stmt.getText(_columnIndexOfChannelId);
                    _result.setChannelId(_tmpChannelId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _result.setUserId(_tmpUserId);
                    String _tmpDisplayName = _stmt.isNull(_columnIndexOfDisplayName) ? null : _stmt.getText(_columnIndexOfDisplayName);
                    _result.setDisplayName(_tmpDisplayName);
                    String _tmpDescription = _stmt.isNull(_columnIndexOfDescription) ? null : _stmt.getText(_columnIndexOfDescription);
                    _result.setDescription(_tmpDescription);
                    String _tmpAvatarFileId = _stmt.isNull(_columnIndexOfAvatarFileId) ? null : _stmt.getText(_columnIndexOfAvatarFileId);
                    _result.setAvatarFileId(_tmpAvatarFileId);
                    Integer _tmp_6 = _stmt.isNull(_columnIndexOfIsOfficial) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfIsOfficial));
                    Boolean _tmpIsOfficial = _tmp_6 == null ? null : Boolean.valueOf(_tmp_6 != 0);
                    _result.setOfficial(_tmpIsOfficial);
                    Integer _tmp_7 = _stmt.isNull(_columnIndexOfIsPublic) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfIsPublic));
                    Boolean _tmpIsPublic = _tmp_7 == null ? null : Boolean.valueOf(_tmp_7 != 0);
                    _result.setPublic(_tmpIsPublic);
                    Integer _tmp_8 = _stmt.isNull(_columnIndexOfOnlyAdminCanPost) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfOnlyAdminCanPost));
                    Boolean _tmpOnlyAdminCanPost = _tmp_8 == null ? null : Boolean.valueOf(_tmp_8 != 0);
                    _result.setOnlyAdminCanPost(_tmpOnlyAdminCanPost);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfTags) ? null : _stmt.getText(_columnIndexOfTags);
                    AmityTags _tmpTags = this.__ekoTagsTypeConverter.stringToEkoTags(_tmp_9);
                    _result.setTags(_tmpTags);
                    String _tmp_10 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_10);
                    _result.setMetadata(_tmpMetadata);
                    Integer _tmpPostsCount = _stmt.isNull(_columnIndexOfPostsCount) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfPostsCount));
                    _result.setPostsCount(_tmpPostsCount);
                    Integer _tmpMembersCount = _stmt.isNull(_columnIndexOfMembersCount) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfMembersCount));
                    _result.setMembersCount(_tmpMembersCount);
                    Integer _tmp_11 = _stmt.isNull(_columnIndexOfIsJoined) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfIsJoined));
                    Boolean _tmpIsJoined = _tmp_11 == null ? null : Boolean.valueOf(_tmp_11 != 0);
                    _result.setJoined(_tmpIsJoined);
                    Integer _tmp_12 = _stmt.isNull(_columnIndexOfIsDeleted) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfIsDeleted));
                    Boolean _tmpIsDeleted = _tmp_12 == null ? null : Boolean.valueOf(_tmp_12 != 0);
                    _result.setDeleted(_tmpIsDeleted);
                    Integer _tmp_13 = _stmt.isNull(_columnIndexOfNeedApprovalOnPostCreation) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfNeedApprovalOnPostCreation));
                    Boolean _tmpNeedApprovalOnPostCreation = _tmp_13 == null ? null : Boolean.valueOf(_tmp_13 != 0);
                    _result.setNeedApprovalOnPostCreation(_tmpNeedApprovalOnPostCreation);
                    Integer _tmp_14 = _stmt.isNull(_columnIndexOfAllowCommentInStory) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfAllowCommentInStory));
                    Boolean _tmpAllowCommentInStory = _tmp_14 == null ? null : Boolean.valueOf(_tmp_14 != 0);
                    _result.setAllowCommentInStory(_tmpAllowCommentInStory);
                    String _tmp_15 = _stmt.isNull(_columnIndexOfEditedAt) ? null : _stmt.getText(_columnIndexOfEditedAt);
                    DateTime _tmpEditedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_15);
                    _result.setEditedAt(_tmpEditedAt);
                    Integer _tmp_16 = _stmt.isNull(_columnIndexOfIsDiscoverable) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfIsDiscoverable));
                    Boolean _tmpIsDiscoverable = _tmp_16 == null ? null : Boolean.valueOf(_tmp_16 != 0);
                    _result.setDiscoverable(_tmpIsDiscoverable);
                    Integer _tmp_17 = _stmt.isNull(_columnIndexOfRequiresJoinApproval) ? null : Integer.valueOf((int)_stmt.getLong(_columnIndexOfRequiresJoinApproval));
                    Boolean _tmpRequiresJoinApproval = _tmp_17 == null ? null : Boolean.valueOf(_tmp_17 != 0);
                    _result.setRequiresJoinApproval(_tmpRequiresJoinApproval);
                    String _tmpCommunityType = _stmt.isNull(_columnIndexOfCommunityType) ? null : _stmt.getText(_columnIndexOfCommunityType);
                    _result.setCommunityType(_tmpCommunityType);
                    String _tmp_18 = _stmt.isNull(_columnIndexOfCategoryIds) ? null : _stmt.getText(_columnIndexOfCategoryIds);
                    EkoCategoryIds _tmpCategoryIds = this.__ekoCategoriesTypeConverter.stringToEkoCategories(_tmp_18);
                    _result.setCategoryIds(_tmpCategoryIds);
                    String _tmp_19 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_19);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_20 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_20);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_21 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_21);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                CommunityEntity communityEntity = _result;
                return communityEntity;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "DELETE from community";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE from community");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @Override
    Completable deleteByCommunityIdImpl(String communityId) {
        String _sql = "UPDATE community set isDeleted = 1 where communityId = ?";
        return RxRoom.createCompletable((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE community set isDeleted = 1 where communityId = ?");){
                int _argIndex = 1;
                if (communityId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, communityId);
                }
                _stmt.step();
                Unit unit = Unit.INSTANCE;
                return unit;
            }
        });
    }

    @Override
    void updateIsJoinedImpl(String communityId) {
        String _sql = "UPDATE community set communityId = ? where communityId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE community set communityId = ? where communityId = ?");){
                int _argIndex = 1;
                if (communityId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, communityId);
                }
                _argIndex = 2;
                if (communityId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, communityId);
                }
                _stmt.step();
                Object var4_4 = null;
                return var4_4;
            }
        });
    }

    @Override
    void updateIsJoinedByCommunityIdImpl(String communityId, boolean isJoined) {
        String _sql = "UPDATE community set isJoined = ? where communityId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE community set isJoined = ? where communityId = ?");){
                int _argIndex = 1;
                int _tmp = isJoined ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp);
                _argIndex = 2;
                if (communityId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, communityId);
                }
                _stmt.step();
                Object var6_6 = null;
                return var6_6;
            }
        });
    }

    @Override
    public void notifyChanges(String communityId) {
        String _sql = "UPDATE community set communityId = ? where communityId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE community set communityId = ? where communityId = ?");){
                int _argIndex = 1;
                if (communityId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, communityId);
                }
                _argIndex = 2;
                if (communityId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, communityId);
                }
                _stmt.step();
                Object var4_4 = null;
                return var4_4;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

