/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.core;

import com.amity.socialcloud.sdk.api.core.AmityCoreClient;
import com.amity.socialcloud.sdk.chat.data.channel.ChannelRepository;
import com.amity.socialcloud.sdk.chat.data.marker.subchannel.SubChannelMarkerRepository;
import com.amity.socialcloud.sdk.chat.data.subchannel.SubChannelRepository;
import com.amity.socialcloud.sdk.chat.domain.marker.channel.ReCalculateChannelUnreadInfoUseCase;
import com.amity.socialcloud.sdk.chat.domain.marker.subchannel.OptimisticCreateSubChannelUnreadInfoUseCase;
import com.amity.socialcloud.sdk.chat.domain.marker.sync.SyncMarkerUseCase;
import com.amity.socialcloud.sdk.chat.domain.marker.user.GetUserMarkerUseCase;
import com.amity.socialcloud.sdk.core.CoreClient;
import com.amity.socialcloud.sdk.core.MarkerEvent;
import com.amity.socialcloud.sdk.core.MarkerSyncEngine;
import com.amity.socialcloud.sdk.core.MarkerSyncEvent;
import com.amity.socialcloud.sdk.core.mention.AmityMentionType;
import com.amity.socialcloud.sdk.core.session.component.SessionComponent;
import com.amity.socialcloud.sdk.core.session.eventbus.MarkerEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionLifeCycleEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionStateEventBus;
import com.amity.socialcloud.sdk.core.session.model.SessionState;
import com.amity.socialcloud.sdk.model.chat.channel.AmityChannel;
import com.ekoapp.ekosdk.internal.SubChannelUnreadInfoEntity;
import com.ekoapp.ekosdk.internal.api.dto.ChannelEventDto;
import com.ekoapp.ekosdk.internal.api.dto.EkoChannelDto;
import com.ekoapp.ekosdk.internal.api.dto.MentioneeDto;
import com.ekoapp.ekosdk.internal.api.dto.SubChannelDto;
import com.ekoapp.ekosdk.internal.api.dto.UserMarkerDto;
import com.ekoapp.ekosdk.internal.api.dto.UserMarkersDto;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.core.SingleSource;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 ,2\u00020\u0001:\u0001,B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0013\u001a\u00020\fJ\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0017J\u0006\u0010\u0019\u001a\u00020\u0017J\b\u0010\u001a\u001a\u00020\tH\u0002J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u000fH\u0002J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\f0\u001eH\u0002J\n\u0010\u001f\u001a\u0004\u0018\u00010\u0011H\u0002J\u0010\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u0011H\u0002J\u0010\u0010\"\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020\u00172\u0006\u0010%\u001a\u00020&H\u0016J\u0010\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020)H\u0016J\b\u0010*\u001a\u00020\u0017H\u0016J\b\u0010+\u001a\u00020\u0017H\u0016R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006-"}, d2={"Lcom/amity/socialcloud/sdk/core/MarkerSyncEngine;", "Lcom/amity/socialcloud/sdk/core/session/component/SessionComponent;", "sessionLifeCycleEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;", "sessionStateEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;", "<init>", "(Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;)V", "timer", "Lio/reactivex/rxjava3/core/Completable;", "Lio/reactivex/rxjava3/annotations/NonNull;", "isWaitingForResponse", "", "events", "", "Lcom/amity/socialcloud/sdk/core/MarkerSyncEvent;", "deviceLastSyncAt", "Lorg/joda/time/DateTime;", "isReadyToSync", "isConsistentMode", "disposable", "Lio/reactivex/rxjava3/disposables/CompositeDisposable;", "startMarkerSync", "", "startUserTotalUnreadSync", "stopMarkerSync", "timerDidTrigger", "addNewEvent", "event", "fetchDeviceLastSyncAt", "Lio/reactivex/rxjava3/core/Single;", "getDeviceLastSyncAt", "saveDeviceLastSyncAt", "lastSyncAt", "handleConsistentEvent", "Lcom/amity/socialcloud/sdk/core/MarkerEvent;", "onSessionStateChange", "sessionState", "Lcom/amity/socialcloud/sdk/core/session/model/SessionState;", "establish", "account", "Lcom/ekoapp/ekosdk/internal/data/model/EkoAccount;", "destroy", "handleTokenExpire", "Companion", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nMarkerSyncEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkerSyncEngine.kt\ncom/amity/socialcloud/sdk/core/MarkerSyncEngine\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,265:1\n1#2:266\n1#2:277\n1#2:293\n1617#3,9:267\n1869#3:276\n1870#3:278\n1626#3:279\n1761#3,3:280\n1617#3,9:283\n1869#3:292\n1870#3:294\n1626#3:295\n*S KotlinDebug\n*F\n+ 1 MarkerSyncEngine.kt\ncom/amity/socialcloud/sdk/core/MarkerSyncEngine\n*L\n198#1:277\n204#1:293\n198#1:267,9\n198#1:276\n198#1:278\n198#1:279\n199#1:280,3\n204#1:283,9\n204#1:292\n204#1:294\n204#1:295\n*E\n"})
public final class MarkerSyncEngine
extends SessionComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Completable timer;
    private boolean isWaitingForResponse;
    @NotNull
    private final List<MarkerSyncEvent> events;
    @Nullable
    private DateTime deviceLastSyncAt;
    private boolean isReadyToSync;
    private boolean isConsistentMode;
    @NotNull
    private final CompositeDisposable disposable;
    private static final long SYNC_INTERVAL = 2L;
    @NotNull
    private static final List<AmityChannel.Type> SUPPORT_CHANNEL_TYPES;

    public MarkerSyncEngine(@NotNull SessionLifeCycleEventBus sessionLifeCycleEventBus, @NotNull SessionStateEventBus sessionStateEventBus) {
        Intrinsics.checkNotNullParameter((Object)sessionLifeCycleEventBus, (String)"sessionLifeCycleEventBus");
        Intrinsics.checkNotNullParameter((Object)sessionStateEventBus, (String)"sessionStateEventBus");
        super(sessionLifeCycleEventBus, sessionStateEventBus);
        Completable completable = Flowable.interval((long)2L, (TimeUnit)TimeUnit.SECONDS).flatMapCompletable(new Function(this){
            final /* synthetic */ MarkerSyncEngine this$0;
            {
                this.this$0 = $receiver;
            }

            public final CompletableSource apply(Long it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return (CompletableSource)MarkerSyncEngine.access$timerDidTrigger(this.this$0).onErrorComplete();
            }
        }).subscribeOn(Schedulers.io());
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"subscribeOn(...)");
        this.timer = completable;
        this.events = new ArrayList();
        this.isConsistentMode = true;
        this.disposable = new CompositeDisposable();
        MarkerEventBus.INSTANCE.observe().doOnNext(new Consumer(){

            public final void accept(MarkerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                MarkerEvent markerEvent = event;
                if (markerEvent instanceof MarkerEvent.NetworkConnection.Connected) {
                    this.addNewEvent(MarkerSyncEvent.RESUME);
                } else if (markerEvent instanceof MarkerEvent.NetworkConnection.Disconnected) {
                    isWaitingForResponse = false;
                } else if (markerEvent instanceof MarkerEvent.NewMessage) {
                    String string = ((MarkerEvent.NewMessage)event).getMessage().getChannelType();
                    Companion companion = Companion;
                    String p0 = string;
                    boolean bl = false;
                    if (companion.isMarkerSyncSupport(p0)) {
                        this.addNewEvent(MarkerSyncEvent.NEW_MESSAGE);
                        this.handleConsistentEvent(event);
                    }
                } else if (markerEvent instanceof MarkerEvent.MarkerUpdated) {
                    this.addNewEvent(MarkerSyncEvent.MARKER_UPDATED);
                    this.handleConsistentEvent(event);
                }
            }
        }).subscribeOn(Schedulers.io()).observeOn(Schedulers.io()).subscribe();
    }

    public final boolean isConsistentMode() {
        return this.isConsistentMode;
    }

    public final void startMarkerSync() {
        CoreClient.INSTANCE.enableUnreadCount();
        this.isConsistentMode = false;
        this.addNewEvent(MarkerSyncEvent.START_SYNCING);
        if (this.disposable.size() == 0 || this.disposable.isDisposed()) {
            this.disposable.clear();
            Disposable disposable = this.timer.subscribe();
            CompositeDisposable compositeDisposable = this.disposable;
            Disposable p0 = disposable;
            boolean bl = false;
            compositeDisposable.add(p0);
        }
    }

    public final void startUserTotalUnreadSync() {
        this.addNewEvent(MarkerSyncEvent.START_SYNCING);
        if (this.disposable.size() == 0 || this.disposable.isDisposed()) {
            this.disposable.clear();
            Disposable disposable = this.timer.subscribe();
            CompositeDisposable compositeDisposable = this.disposable;
            Disposable p0 = disposable;
            boolean bl = false;
            compositeDisposable.add(p0);
        }
    }

    public final void stopMarkerSync() {
        if (this.disposable.size() > 0) {
            this.disposable.clear();
            this.events.clear();
        }
        this.isWaitingForResponse = false;
    }

    private final Completable timerDidTrigger() {
        Completable completable;
        if (this.isWaitingForResponse) {
            Completable completable2 = Completable.complete();
            completable = completable2;
            Intrinsics.checkNotNullExpressionValue((Object)completable2, (String)"complete(...)");
        } else if (this.events.isEmpty()) {
            Completable completable3 = Completable.complete();
            completable = completable3;
            Intrinsics.checkNotNullExpressionValue((Object)completable3, (String)"complete(...)");
        } else if (!this.isReadyToSync) {
            Completable completable4 = Completable.complete();
            completable = completable4;
            Intrinsics.checkNotNullExpressionValue((Object)completable4, (String)"complete(...)");
        } else {
            this.events.clear();
            this.isWaitingForResponse = true;
            Completable completable5 = this.fetchDeviceLastSyncAt().flatMap(new Function(this){
                final /* synthetic */ MarkerSyncEngine this$0;
                {
                    this.this$0 = $receiver;
                }

                public final SingleSource<? extends Pair<List<UserMarkerDto>, Boolean>> apply(Boolean it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return (SingleSource)new SyncMarkerUseCase().execute(MarkerSyncEngine.access$getDeviceLastSyncAt(this.this$0));
                }
            }).doOnSuccess(new Consumer(this){
                final /* synthetic */ MarkerSyncEngine this$0;
                {
                    this.this$0 = $receiver;
                }

                public final void accept(Pair<? extends List<UserMarkerDto>, Boolean> pair) {
                    Intrinsics.checkNotNullParameter(pair, (String)"<destruct>");
                    List userMarkers = (List)pair.component1();
                    boolean hasMoreMarkers = (Boolean)pair.component2();
                    UserMarkerDto userMarkerDto = (UserMarkerDto)CollectionsKt.firstOrNull((List)userMarkers);
                    if (userMarkerDto != null && (userMarkerDto = userMarkerDto.getLastSyncAt()) != null) {
                        UserMarkerDto userMarkerDto2 = userMarkerDto;
                        MarkerSyncEngine markerSyncEngine = this.this$0;
                        UserMarkerDto p0 = userMarkerDto2;
                        boolean bl = false;
                        MarkerSyncEngine.access$saveDeviceLastSyncAt(markerSyncEngine, (DateTime)p0);
                    }
                    if (hasMoreMarkers) {
                        MarkerSyncEngine.access$addNewEvent(this.this$0, MarkerSyncEvent.HAS_MORE);
                    }
                }
            }).doFinally(() -> MarkerSyncEngine.timerDidTrigger$lambda$1(this)).ignoreElement().subscribeOn(Schedulers.io());
            Intrinsics.checkNotNull((Object)completable5);
            completable = completable5;
        }
        return completable;
    }

    private final void addNewEvent(MarkerSyncEvent event) {
        this.events.add(event);
    }

    private final Single<Boolean> fetchDeviceLastSyncAt() {
        Single single;
        if (this.deviceLastSyncAt == null) {
            Single single2 = new GetUserMarkerUseCase().execute().doOnSuccess(new Consumer(this){
                final /* synthetic */ MarkerSyncEngine this$0;
                {
                    this.this$0 = $receiver;
                }

                public final void accept(UserMarkersDto userMarkers) {
                    block0: {
                        Intrinsics.checkNotNullParameter((Object)userMarkers, (String)"userMarkers");
                        UserMarkerDto userMarkerDto = (UserMarkerDto)CollectionsKt.firstOrNull(userMarkers.getUserMarkers());
                        if (userMarkerDto == null) break block0;
                        UserMarkerDto userMarkerDto2 = userMarkerDto;
                        MarkerSyncEngine markerSyncEngine = this.this$0;
                        UserMarkerDto userMarker = userMarkerDto2;
                        boolean bl = false;
                        MarkerSyncEngine.access$saveDeviceLastSyncAt(markerSyncEngine, userMarker.getLastSyncAt());
                    }
                }
            }).map((Function)fetchDeviceLastSyncAt.2.INSTANCE).onErrorReturnItem((Object)true);
            Intrinsics.checkNotNull((Object)single2);
            single = single2;
        } else {
            Single single3 = Single.just((Object)true);
            Intrinsics.checkNotNull((Object)single3);
            single = single3;
        }
        return single;
    }

    private final DateTime getDeviceLastSyncAt() {
        return this.deviceLastSyncAt;
    }

    private final void saveDeviceLastSyncAt(DateTime lastSyncAt) {
        block4: {
            block3: {
                if (this.deviceLastSyncAt == null) break block3;
                DateTime dateTime = this.deviceLastSyncAt;
                boolean bl = dateTime != null ? dateTime.isBefore((ReadableInstant)lastSyncAt) : false;
                if (!bl) break block4;
            }
            this.deviceLastSyncAt = lastSyncAt;
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void handleConsistentEvent(MarkerEvent event) {
        MarkerEvent markerEvent = event;
        if (markerEvent instanceof MarkerEvent.SubChannelCreated) {
            String channelId;
            SubChannelDto subChannel;
            SubChannelDto subChannelDto = subChannel = (SubChannelDto)CollectionsKt.firstOrNull(((MarkerEvent.SubChannelCreated)event).getDto().getSubChannels());
            String subChannelId = subChannelDto != null ? subChannelDto.getSubChannelId() : null;
            SubChannelDto subChannelDto2 = subChannel;
            String string = channelId = subChannelDto2 != null ? subChannelDto2.getChannelId() : null;
            if (subChannelId != null && channelId != null) {
                new OptimisticCreateSubChannelUnreadInfoUseCase().execute(subChannelId, channelId);
            }
        } else if (markerEvent instanceof MarkerEvent.SubChannelDeleted) {
            SubChannelDto subChannelDto = (SubChannelDto)CollectionsKt.firstOrNull(((MarkerEvent.SubChannelDeleted)event).getDto().getSubChannels());
            if (subChannelDto != null) {
                String it;
                SubChannelDto subChannel = subChannelDto;
                boolean bl = false;
                String string = subChannel.getSubChannelId();
                if (string != null) {
                    it = string;
                    boolean bl2 = false;
                    new SubChannelMarkerRepository().deleteUnreadInfoBySubChannelId(it);
                }
                String string2 = subChannel.getChannelId();
                if (string2 != null) {
                    it = string2;
                    boolean bl3 = false;
                    new ReCalculateChannelUnreadInfoUseCase().execute(it);
                    new ChannelRepository().notifyChanges$amity_sdk_release(it);
                }
            }
        } else if (markerEvent instanceof MarkerEvent.ChannelLeft || markerEvent instanceof MarkerEvent.ChannelDeleted || markerEvent instanceof MarkerEvent.ChannelBan) {
            MarkerEvent subChannelId = event;
            Object object = subChannelId instanceof MarkerEvent.Channel ? (MarkerEvent.Channel)subChannelId : null;
            if (object != null && (object = ((MarkerEvent.Channel)object).getDto()) != null && (object = ((ChannelEventDto)object).getChannelDtoList()) != null && (object = (EkoChannelDto)CollectionsKt.firstOrNull(object)) != null && (object = ((EkoChannelDto)object).getChannelId()) != null) {
                Object it2 = object;
                boolean bl = false;
                new SubChannelMarkerRepository().deleteUnreadInfoByChannelId((String)it2);
                new ReCalculateChannelUnreadInfoUseCase().execute((String)it2);
            }
        } else if (markerEvent instanceof MarkerEvent.NewMessage) {
            String subChannelId = ((MarkerEvent.NewMessage)event).getMessage().getSubChannelId();
            String channelId = ((MarkerEvent.NewMessage)event).getMessage().getChannelId();
            SubChannelMarkerRepository subChannelMarkerRepository = new SubChannelMarkerRepository();
            Intrinsics.checkNotNull((Object)subChannelId);
            SubChannelUnreadInfoEntity subChannelUnreadInfo = subChannelMarkerRepository.getSubChannelUnreadInfo(subChannelId);
            if (subChannelUnreadInfo != null && ((MarkerEvent.NewMessage)event).getMessage().getSegment() > subChannelUnreadInfo.getLastSegment()) {
                boolean isMentioned;
                boolean isMentionedAll;
                block22: {
                    void $this$any$iv;
                    Iterator $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv;
                    subChannelUnreadInfo.setLastSegment(((MarkerEvent.NewMessage)event).getMessage().getSegment());
                    List<MentioneeDto> list = ((MarkerEvent.NewMessage)event).getMessage().getMentionees();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getMentionees(...)");
                    Iterable it = list;
                    boolean $i$f$mapNotNull = false;
                    void it2 = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        String it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        MentioneeDto it3 = (MentioneeDto)element$iv$iv;
                        boolean bl4 = false;
                        if (it3.getType() == null) continue;
                        boolean bl5 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    $this$mapNotNull$iv = (List)destination$iv$iv;
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        v9 = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            String it4 = (String)element$iv;
                            boolean bl = false;
                            if (!Intrinsics.areEqual((Object)it4, (Object)AmityMentionType.CHANNEL.getApiKey())) continue;
                            v9 = true;
                            break block22;
                        }
                        v9 = isMentionedAll = false;
                    }
                }
                if (isMentionedAll) {
                    v10 = true;
                } else {
                    void $this$mapNotNullTo$iv$iv;
                    void $this$mapNotNull$iv;
                    Object element$iv;
                    List<MentioneeDto> list = ((MarkerEvent.NewMessage)event).getMessage().getMentionees();
                    Intrinsics.checkNotNullExpressionValue(list, (String)"getMentionees(...)");
                    Iterable $i$f$any = list;
                    boolean $i$f$mapNotNull = false;
                    element$iv = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        List<String> it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        MentioneeDto it = (MentioneeDto)element$iv$iv;
                        boolean bl6 = false;
                        if (it.getUserPublicIds() == null) continue;
                        boolean bl7 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    v10 = isMentioned = CollectionsKt.flatten((Iterable)((List)destination$iv$iv)).contains(AmityCoreClient.INSTANCE.getUserId());
                }
                if (isMentioned) {
                    subChannelUnreadInfo.setLastMentionSegment(((MarkerEvent.NewMessage)event).getMessage().getSegment());
                }
                subChannelUnreadInfo.setUpdatedAt(DateTime.now());
                new SubChannelMarkerRepository().saveSubChannelUnreadInfo(CollectionsKt.listOf((Object)subChannelUnreadInfo));
                new SubChannelRepository().notifyChanges$amity_sdk_release(subChannelId);
                ChannelRepository channelRepository = new ChannelRepository();
                Intrinsics.checkNotNull((Object)channelId);
                channelRepository.notifyChanges$amity_sdk_release(channelId);
                if (Intrinsics.areEqual((Object)((MarkerEvent.NewMessage)event).getMessage().getUserId(), (Object)AmityCoreClient.INSTANCE.getUserId())) {
                    String string = ((MarkerEvent.NewMessage)event).getMessage().getSubChannelId();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSubChannelId(...)");
                    CoreClient.INSTANCE.markRead(string, ((MarkerEvent.NewMessage)event).getMessage().getSegment());
                }
            }
        }
    }

    @Override
    public void onSessionStateChange(@NotNull SessionState sessionState) {
        Intrinsics.checkNotNullParameter((Object)sessionState, (String)"sessionState");
        this.isReadyToSync = Intrinsics.areEqual((Object)sessionState, (Object)SessionState.Established.INSTANCE);
    }

    @Override
    public void establish(@NotNull EkoAccount account) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        this.isReadyToSync = true;
        if (CoreClient.INSTANCE.isUnreadCountEnable() && this.isConsistentMode) {
            this.startUserTotalUnreadSync();
        }
    }

    @Override
    public void destroy() {
        this.stopMarkerSync();
        this.isReadyToSync = false;
        this.deviceLastSyncAt = null;
    }

    @Override
    public void handleTokenExpire() {
        this.stopMarkerSync();
        this.isReadyToSync = false;
    }

    private static final void timerDidTrigger$lambda$1(MarkerSyncEngine this$0) {
        this$0.isWaitingForResponse = false;
    }

    public static final /* synthetic */ DateTime access$getDeviceLastSyncAt(MarkerSyncEngine $this) {
        return $this.getDeviceLastSyncAt();
    }

    public static final /* synthetic */ void access$saveDeviceLastSyncAt(MarkerSyncEngine $this, DateTime lastSyncAt) {
        $this.saveDeviceLastSyncAt(lastSyncAt);
    }

    public static final /* synthetic */ Completable access$timerDidTrigger(MarkerSyncEngine $this) {
        return $this.timerDidTrigger();
    }

    static {
        AmityChannel.Type[] typeArray = new AmityChannel.Type[]{AmityChannel.Type.COMMUNITY, AmityChannel.Type.CONVERSATION, AmityChannel.Type.BROADCAST};
        SUPPORT_CHANNEL_TYPES = CollectionsKt.listOf((Object[])typeArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\bJ\u0010\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/amity/socialcloud/sdk/core/MarkerSyncEngine$Companion;", "", "<init>", "()V", "SYNC_INTERVAL", "", "SUPPORT_CHANNEL_TYPES", "", "Lcom/amity/socialcloud/sdk/model/chat/channel/AmityChannel$Type;", "isMarkerSyncSupport", "", "type", "", "amity-sdk_release"})
    @SourceDebugExtension(value={"SMAP\nMarkerSyncEngine.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkerSyncEngine.kt\ncom/amity/socialcloud/sdk/core/MarkerSyncEngine$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,265:1\n1#2:266\n1563#3:267\n1634#3,3:268\n*S KotlinDebug\n*F\n+ 1 MarkerSyncEngine.kt\ncom/amity/socialcloud/sdk/core/MarkerSyncEngine$Companion\n*L\n234#1:267\n234#1:268,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean isMarkerSyncSupport(@Nullable AmityChannel.Type type2) {
            boolean bl;
            AmityChannel.Type type3 = type2;
            if (type3 != null) {
                AmityChannel.Type type4 = type3;
                List list = SUPPORT_CHANNEL_TYPES;
                AmityChannel.Type p0 = type4;
                boolean bl2 = false;
                bl = list.contains((Object)p0);
            } else {
                bl = false;
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean isMarkerSyncSupport(@Nullable String type2) {
            boolean bl;
            String string = type2;
            if (string != null) {
                void $this$mapTo$iv$iv;
                String string2 = string;
                Iterable $this$map$iv = SUPPORT_CHANNEL_TYPES;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    AmityChannel.Type type3 = (AmityChannel.Type)((Object)item$iv$iv);
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.getApiKey());
                }
                List list = (List)destination$iv$iv;
                String p0 = string2;
                boolean bl3 = false;
                bl = list.contains(p0);
            } else {
                bl = false;
            }
            return bl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

