package com.ekoapp.ekosdk.internal.usecase.post

import com.amity.socialcloud.sdk.model.social.post.AmityPost
import com.amity.socialcloud.sdk.social.data.post.PostRepository
import com.amity.socialcloud.sdk.social.domain.post.PostComposerUseCase
import com.amity.socialcloud.sdk.common.AmityObjectRepository
import com.ekoapp.ekosdk.internal.PostEntity
import com.ekoapp.ekosdk.internal.TombstoneModelType
import com.ekoapp.ekosdk.internal.usecase.LiveObjectUseCase

internal class PostLiveObjectUseCase : LiveObjectUseCase<PostEntity, AmityPost>() {

    override fun createRepository(): AmityObjectRepository<PostEntity, AmityPost> = PostRepository()

    override fun composeModel(model: AmityPost): AmityPost = PostComposerUseCase().execute(model)

    override fun tombstoneModelType(): TombstoneModelType = TombstoneModelType.POST
}