package com.ekoapp.ekosdk.internal.data.model

import androidx.room.Entity
import androidx.room.PrimaryKey

@Entity(tableName = "upload_url")
class AmityUploadUrl {

    @PrimaryKey
    var id: String = currentUploadUrlId()
    var uploadUrl: String = ""
    var updateAt: Long = System.currentTimeMillis()

    companion object {
        private const val SINGLETON_UPLOAD_URL_ID = "SINGLETON_UPLOAD_URL_ID"

        fun currentUploadUrlId(): String {
            return SINGLETON_UPLOAD_URL_ID
        }

        fun create(url: String): AmityUploadUrl {
            val amityUploadUrl = AmityUploadUrl()
            amityUploadUrl.uploadUrl = url
            return amityUploadUrl
        }
    }
}
