package com.amity.socialcloud.sdk.core.domain.link

import com.amity.socialcloud.sdk.core.data.settings.network.NetworkSettingsRepository
import com.amity.socialcloud.sdk.model.core.link.AmityLinkPreviewMetadata
import io.reactivex.rxjava3.core.Single

internal class GetLinkPreviewMetadataUseCase {

    fun execute(url: String): Single<AmityLinkPreviewMetadata> {
        return NetworkSettingsRepository().getLinkPreviewMetadata(url)
            .map { dto ->
                AmityLinkPreviewMetadata(
                    title = dto.title,
                    description = dto.description,
                    imageUrl = dto.imageUrl,
                    domain = dto.domain
                )
            }
    }
}
