package com.amity.socialcloud.sdk.core.data.file

import com.amity.socialcloud.sdk.common.EntityMapper
import com.ekoapp.ekosdk.internal.EkoFileEntity
import com.ekoapp.ekosdk.internal.api.dto.EkoFileDto
import com.ekoapp.ekosdk.internal.api.mapper.EkoFileMapper.AttributesComposer

internal class FileEntityMapper : EntityMapper<EkoFileDto, EkoFileEntity>() {

    override fun map(dtos: List<EkoFileDto>): List<EkoFileEntity> {
        return dtos.map { dto -> map(dto) }
    }

    private fun map(dto: EkoFileDto): EkoFileEntity {
        return EkoFileEntity().apply {
            fileId = dto.fileId
            fileUrl = dto.fileUrl
            type = dto.type
            accessType = dto.accessType
            createdAt = dto.createdAt
            updatedAt = dto.updatedAt
            attributes = AttributesComposer().compose(dto.attributes, dto.status, dto.videoUrl)
            altText = dto.altText
        }
    }

}