package com.amity.socialcloud.sdk.api.social.community.query

enum class AmityCommunitySortOption(val apiKey: String) {
    DISPLAY_NAME("displayName"),
    FIRST_CREATED("firstCreated"),
    LAST_CREATED("lastCreated");

    companion object {
        fun enumOf(apiKey: String?): AmityCommunitySortOption {
            return values().find { apiKey == it.apiKey } ?: LAST_CREATED
        }
    }

}