package com.amity.socialcloud.sdk.api.chat.message.create

import com.amity.socialcloud.sdk.model.chat.message.AmityMessage
import com.amity.socialcloud.sdk.model.chat.message.AmityMessageAttachment
import com.amity.socialcloud.sdk.model.core.tag.AmityTags
import com.google.gson.JsonObject


class AmityFileMessageCreator internal constructor(
    subChannelId: String,
    parentId: String?,
    tags: AmityTags,
    private val attachment: AmityMessageAttachment,
    private val caption: String?,
    private val metadata: JsonObject?,
) : AmityMessageCreator(
    subChannelId = subChannelId,
    parentId = parentId,
    tags = tags,
    attachment = attachment,
    metadata = metadata,
) {

    override fun getDataType(): AmityMessage.DataType {
        return AmityMessage.DataType.FILE
    }

    override fun getData(): JsonObject {
        val data = JsonObject()
        if (!caption.isNullOrEmpty()) {
            data.addProperty("caption", caption)
        }
        return data
    }

    class Builder internal constructor() {

        private lateinit var subChannelId: String
        private var parentId: String? = null
        private var metadata: JsonObject? = null
        private var tags: AmityTags = AmityTags()
        private lateinit var attachment: AmityMessageAttachment
        private var caption: String? = null

        internal fun subChannelId(subChannelId: String): Builder {
            return apply { this.subChannelId = subChannelId }
        }
    
        internal fun attachment(attachment: AmityMessageAttachment): Builder {
            return apply { this.attachment = attachment }
        }

        fun parentId(parentId: String?): Builder {
            return apply { this.parentId = parentId }
        }
    
        fun metadata(metadata: JsonObject): Builder {
            return apply { this.metadata = metadata }
        }

        fun tags(tags: AmityTags): Builder {
            return apply { this.tags = tags }
        }

        fun caption(caption: String): Builder {
            return apply { this.caption = caption }
        }

        fun build(): AmityFileMessageCreator {
            return AmityFileMessageCreator(subChannelId, parentId, tags, attachment, caption, metadata)
        }
    }

}