/*
 * Decompiled with CFR 0.152.
 */
package com.ekoapp.ekosdk.internal.data.dao;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.sqlite.SQLiteStatement;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.dao.PinDao;
import com.ekoapp.ekosdk.internal.data.model.PinEntity;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class PinDao_Impl
extends PinDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<PinEntity> __insertAdapterOfPinEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final EntityDeleteOrUpdateAdapter<PinEntity> __deleteAdapterOfPinEntity;
    private final EntityDeleteOrUpdateAdapter<PinEntity> __updateAdapterOfPinEntity;

    public PinDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfPinEntity = new EntityInsertAdapter<PinEntity>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `pin` (`pinId`,`referenceId`,`referenceType`,`placement`,`targetId`,`targetType`,`pinnedBy`,`pinnedAt`,`lastPinsUpdatedAt`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull PinEntity entity) {
                if (entity.getPinId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getPinId());
                }
                if (entity.getReferenceId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getReferenceId());
                }
                if (entity.getReferenceType() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getReferenceType());
                }
                if (entity.getPlacement() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getPlacement());
                }
                if (entity.getTargetId() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, entity.getTargetId());
                }
                if (entity.getTargetType() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, entity.getTargetType());
                }
                if (entity.getPinnedBy() == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, entity.getPinnedBy());
                }
                String _tmp = PinDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getPinnedAt());
                if (_tmp == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, _tmp);
                }
                String _tmp_1 = PinDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getLastPinsUpdatedAt());
                if (_tmp_1 == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, _tmp_1);
                }
                String _tmp_2 = PinDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindText(10, _tmp_2);
                }
                String _tmp_3 = PinDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_3 == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindText(11, _tmp_3);
                }
                String _tmp_4 = PinDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_4 == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindText(12, _tmp_4);
                }
            }
        };
        this.__deleteAdapterOfPinEntity = new EntityDeleteOrUpdateAdapter<PinEntity>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `pin` WHERE `pinId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull PinEntity entity) {
                if (entity.getPinId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getPinId());
                }
            }
        };
        this.__updateAdapterOfPinEntity = new EntityDeleteOrUpdateAdapter<PinEntity>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `pin` SET `pinId` = ?,`referenceId` = ?,`referenceType` = ?,`placement` = ?,`targetId` = ?,`targetType` = ?,`pinnedBy` = ?,`pinnedAt` = ?,`lastPinsUpdatedAt` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `pinId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull PinEntity entity) {
                if (entity.getPinId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getPinId());
                }
                if (entity.getReferenceId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getReferenceId());
                }
                if (entity.getReferenceType() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getReferenceType());
                }
                if (entity.getPlacement() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getPlacement());
                }
                if (entity.getTargetId() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, entity.getTargetId());
                }
                if (entity.getTargetType() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, entity.getTargetType());
                }
                if (entity.getPinnedBy() == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, entity.getPinnedBy());
                }
                String _tmp = PinDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getPinnedAt());
                if (_tmp == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, _tmp);
                }
                String _tmp_1 = PinDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getLastPinsUpdatedAt());
                if (_tmp_1 == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, _tmp_1);
                }
                String _tmp_2 = PinDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_2 == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindText(10, _tmp_2);
                }
                String _tmp_3 = PinDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_3 == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindText(11, _tmp_3);
                }
                String _tmp_4 = PinDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_4 == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindText(12, _tmp_4);
                }
                if (entity.getPinId() == null) {
                    statement.bindNull(13);
                } else {
                    statement.bindText(13, entity.getPinId());
                }
            }
        };
    }

    @Override
    public void insertImpl(PinEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfPinEntity.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends PinEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfPinEntity.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(PinEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfPinEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void delete(List<? extends PinEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfPinEntity.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void updateImpl(PinEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfPinEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(PinEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            PinDao_Impl.super.insert(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends PinEntity> objects) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            PinDao_Impl.super.insert(objects);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(PinEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            PinDao_Impl.super.update(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public PinEntity getByIdNowImpl(String id) {
        String _sql = "select * from pin where pinId = ? limit 1";
        return (PinEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("select * from pin where pinId = ? limit 1");){
                PinEntity _result;
                int _argIndex = 1;
                if (id == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, id);
                }
                int _columnIndexOfPinId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pinId");
                int _columnIndexOfReferenceId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceId");
                int _columnIndexOfReferenceType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"referenceType");
                int _columnIndexOfPlacement = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"placement");
                int _columnIndexOfTargetId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetId");
                int _columnIndexOfTargetType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetType");
                int _columnIndexOfPinnedBy = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pinnedBy");
                int _columnIndexOfPinnedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"pinnedAt");
                int _columnIndexOfLastPinsUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"lastPinsUpdatedAt");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    String _tmpPinId = _stmt.isNull(_columnIndexOfPinId) ? null : _stmt.getText(_columnIndexOfPinId);
                    String _tmpReferenceId = _stmt.isNull(_columnIndexOfReferenceId) ? null : _stmt.getText(_columnIndexOfReferenceId);
                    String _tmpReferenceType = _stmt.isNull(_columnIndexOfReferenceType) ? null : _stmt.getText(_columnIndexOfReferenceType);
                    String _tmpPlacement = _stmt.isNull(_columnIndexOfPlacement) ? null : _stmt.getText(_columnIndexOfPlacement);
                    String _tmpTargetId = _stmt.isNull(_columnIndexOfTargetId) ? null : _stmt.getText(_columnIndexOfTargetId);
                    String _tmpTargetType = _stmt.isNull(_columnIndexOfTargetType) ? null : _stmt.getText(_columnIndexOfTargetType);
                    String _tmpPinnedBy = _stmt.isNull(_columnIndexOfPinnedBy) ? null : _stmt.getText(_columnIndexOfPinnedBy);
                    String _tmp = _stmt.isNull(_columnIndexOfPinnedAt) ? null : _stmt.getText(_columnIndexOfPinnedAt);
                    DateTime _tmpPinnedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfLastPinsUpdatedAt) ? null : _stmt.getText(_columnIndexOfLastPinsUpdatedAt);
                    DateTime _tmpLastPinsUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result = new PinEntity(_tmpPinId, _tmpReferenceId, _tmpReferenceType, _tmpPlacement, _tmpTargetId, _tmpTargetType, _tmpPinnedBy, _tmpPinnedAt, _tmpLastPinsUpdatedAt);
                    String _tmp_2 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_2);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_3);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                PinEntity pinEntity = _result;
                return pinEntity;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "delete from pin";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("delete from pin");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @Override
    public void updatePin() {
        String _sql = "UPDATE pin set pinId = pinId";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE pin set pinId = pinId");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

