/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.infra.mqtt;

import co.amity.rxbridge.CompletableKt;
import co.amity.rxbridge.FlowableKt;
import com.amity.socialcloud.sdk.core.data.user.UserDao;
import com.amity.socialcloud.sdk.core.session.component.SessionComponent;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionLifeCycleEventBus;
import com.amity.socialcloud.sdk.core.session.eventbus.SessionStateEventBus;
import com.amity.socialcloud.sdk.core.session.model.SessionState;
import com.amity.socialcloud.sdk.entity.core.user.UserEntity;
import com.amity.socialcloud.sdk.infra.mqtt.AmityMqttClient;
import com.amity.socialcloud.sdk.infra.mqtt.listener.MqttEventListener;
import com.amity.socialcloud.sdk.infra.mqtt.listener.MqttEventListeners;
import com.amity.socialcloud.sdk.infra.mqtt.payload.MqttPayload;
import com.amity.socialcloud.sdk.log.AmityLog;
import com.amity.socialcloud.sdk.model.core.error.AmityError;
import com.amity.socialcloud.sdk.model.core.error.AmityException;
import com.amity.socialcloud.sdk.model.core.events.AmityTopic;
import com.ekoapp.ekosdk.internal.api.EkoEndpoint;
import com.ekoapp.ekosdk.internal.data.UserDatabase;
import com.ekoapp.ekosdk.internal.data.converter.EkoGson;
import com.ekoapp.ekosdk.internal.data.model.EkoAccount;
import com.google.gson.JsonObject;
import com.hivemq.client.mqtt.MqttClient;
import com.hivemq.client.mqtt.MqttGlobalPublishFilter;
import com.hivemq.client.mqtt.lifecycle.MqttClientConnectedContext;
import com.hivemq.client.mqtt.lifecycle.MqttClientDisconnectedContext;
import com.hivemq.client.mqtt.mqtt3.Mqtt3ClientBuilder;
import com.hivemq.client.mqtt.mqtt3.Mqtt3RxClient;
import com.hivemq.client.mqtt.mqtt3.exceptions.Mqtt3ConnAckException;
import com.hivemq.client.mqtt.mqtt3.message.auth.Mqtt3SimpleAuthBuilder;
import com.hivemq.client.mqtt.mqtt3.message.connect.Mqtt3ConnectBuilder;
import com.hivemq.client.mqtt.mqtt3.message.connect.connack.Mqtt3ConnAckReturnCode;
import com.hivemq.client.mqtt.mqtt3.message.publish.Mqtt3Publish;
import io.reactivex.Completable;
import io.reactivex.Flowable;
import io.reactivex.disposables.Disposable;
import io.reactivex.rxjava3.core.CompletableSource;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.disposables.CompositeDisposable;
import io.reactivex.rxjava3.functions.Consumer;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.processors.PublishProcessor;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 /2\u00020\u0001:\u0002./B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\nH\u0016J\b\u0010\u0019\u001a\u00020\u0014H\u0016J\b\u0010\u001a\u001a\u00020\u0014H\u0016J\u0006\u0010\u001b\u001a\u00020\u001cJ\u0010\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u0018\u001a\u00020\nH\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\nH\u0002J \u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u001f2\u0006\u0010%\u001a\u00020&H\u0002J\u0010\u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010(\u001a\u00020)H\u0002J\u0010\u0010,\u001a\u00020\u00142\u0006\u0010(\u001a\u00020)H\u0002J\b\u0010-\u001a\u00020\u0014H\u0002R+\u0010\b\u001a\u001f\u0012\u0016\u0012\u0014 \f*\t\u0018\u00010\n\u00a2\u0006\u0002\b\u000b0\n\u00a2\u0006\u0002\b\u000b0\t\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/amity/socialcloud/sdk/infra/mqtt/AmityMqttClient;", "Lcom/amity/socialcloud/sdk/core/session/component/SessionComponent;", "sessionLifeCycleEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;", "sessionStateEventBus", "Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;", "<init>", "(Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionLifeCycleEventBus;Lcom/amity/socialcloud/sdk/core/session/eventbus/SessionStateEventBus;)V", "connectRelay", "Lio/reactivex/rxjava3/processors/PublishProcessor;", "Lcom/ekoapp/ekosdk/internal/data/model/EkoAccount;", "Lkotlin/jvm/internal/EnhancedNullability;", "kotlin.jvm.PlatformType", "Lio/reactivex/rxjava3/annotations/NonNull;", "disposables", "Lio/reactivex/rxjava3/disposables/CompositeDisposable;", "autoSubscribeTopics", "", "Lcom/amity/socialcloud/sdk/model/core/events/AmityTopic;", "onSessionStateChange", "", "sessionState", "Lcom/amity/socialcloud/sdk/core/session/model/SessionState;", "establish", "account", "destroy", "handleTokenExpire", "disconnect", "Lio/reactivex/rxjava3/core/Completable;", "connect", "generateClientId", "", "newAccount", "initMqttClient", "Lcom/hivemq/client/mqtt/mqtt3/Mqtt3RxClient;", "clientId", "username", "password", "", "obsoleteClient", "authClient", "Lcom/amity/socialcloud/sdk/infra/mqtt/AmityMqttClient$AuthenticatedMqttClient;", "createEventSubscription", "Lio/reactivex/rxjava3/disposables/Disposable;", "addClientListeners", "autoSubscribe", "AuthenticatedMqttClient", "Companion", "amity-sdk_release"})
@SourceDebugExtension(value={"SMAP\nAmityMqttClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AmityMqttClient.kt\ncom/amity/socialcloud/sdk/infra/mqtt/AmityMqttClient\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,323:1\n1#2:324\n1869#3,2:325\n*S KotlinDebug\n*F\n+ 1 AmityMqttClient.kt\ncom/amity/socialcloud/sdk/infra/mqtt/AmityMqttClient\n*L\n251#1:325,2\n*E\n"})
public final class AmityMqttClient
extends SessionComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PublishProcessor<EkoAccount> connectRelay;
    @NotNull
    private final CompositeDisposable disposables;
    @NotNull
    private final List<AmityTopic> autoSubscribeTopics;
    @NotNull
    private static final CompositeDisposable subscriptions = new CompositeDisposable();
    @Nullable
    private static AuthenticatedMqttClient activeClient;
    @NotNull
    private static final String TAG;

    public AmityMqttClient(@NotNull SessionLifeCycleEventBus sessionLifeCycleEventBus, @NotNull SessionStateEventBus sessionStateEventBus) {
        Intrinsics.checkNotNullParameter((Object)sessionLifeCycleEventBus, (String)"sessionLifeCycleEventBus");
        Intrinsics.checkNotNullParameter((Object)sessionStateEventBus, (String)"sessionStateEventBus");
        super(sessionLifeCycleEventBus, sessionStateEventBus);
        PublishProcessor publishProcessor = PublishProcessor.create();
        Intrinsics.checkNotNullExpressionValue((Object)publishProcessor, (String)"create(...)");
        this.connectRelay = publishProcessor;
        this.disposables = new CompositeDisposable();
        Object[] objectArray = this.connectRelay.onBackpressureBuffer().concatMapCompletable(new Function(){

            /*
             * Enabled aggressive block sorting
             */
            public final CompletableSource apply(EkoAccount account) {
                CompletableSource completableSource;
                AuthenticatedMqttClient authenticatedMqttClient = activeClient;
                if (authenticatedMqttClient != null) {
                    AuthenticatedMqttClient authenticatedMqttClient2 = authenticatedMqttClient;
                    AmityMqttClient amityMqttClient = this;
                    AuthenticatedMqttClient client = authenticatedMqttClient2;
                    boolean bl = false;
                    io.reactivex.rxjava3.core.Completable completable = amityMqttClient.obsoleteClient(client).onErrorComplete();
                    Intrinsics.checkNotNull((Object)account);
                    io.reactivex.rxjava3.core.Completable completable2 = completable.andThen((CompletableSource)amityMqttClient.connect(account).onErrorComplete());
                    authenticatedMqttClient = completable2;
                    if (completable2 != null) {
                        completableSource = (CompletableSource)authenticatedMqttClient;
                        return completableSource;
                    }
                }
                Intrinsics.checkNotNull((Object)account);
                completableSource = (CompletableSource)this.connect(account).onErrorComplete();
                return completableSource;
            }
        }).subscribeOn(Schedulers.io()).subscribe(AmityMqttClient::_init_$lambda$0, (Consumer)3.INSTANCE);
        CompositeDisposable compositeDisposable = this.disposables;
        Object[] p0 = objectArray;
        boolean bl = false;
        compositeDisposable.add((io.reactivex.rxjava3.disposables.Disposable)p0);
        objectArray = new AmityTopic[]{new AmityTopic.NETWORK(), new AmityTopic.SMART_CHANNEL(), new AmityTopic.SMART_MESSAGE_FEED(), new AmityTopic.SMART_MESSAGE(), new AmityTopic.USER_MARKER(), new AmityTopic.LIVESTREAM()};
        this.autoSubscribeTopics = CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void onSessionStateChange(@NotNull SessionState sessionState) {
        Intrinsics.checkNotNullParameter((Object)sessionState, (String)"sessionState");
        AmityLog.INSTANCE.tag("SSM3").e("mqtt session change: " + sessionState, new Object[0]);
    }

    @Override
    public void establish(@NotNull EkoAccount account) {
        Intrinsics.checkNotNullParameter((Object)account, (String)"account");
        AmityLog.INSTANCE.tag("SSM3").e("mqtt session establish: " + this.hashCode(), new Object[0]);
        this.connectRelay.onNext((Object)account);
    }

    @Override
    public void destroy() {
        block0: {
            AuthenticatedMqttClient authenticatedMqttClient = activeClient;
            if (authenticatedMqttClient == null) break block0;
            AuthenticatedMqttClient it = authenticatedMqttClient;
            boolean bl = false;
            this.obsoleteClient(it).subscribeOn(Schedulers.io()).subscribe();
        }
    }

    @Override
    public void handleTokenExpire() {
        block0: {
            AuthenticatedMqttClient authenticatedMqttClient = activeClient;
            if (authenticatedMqttClient == null) break block0;
            AuthenticatedMqttClient it = authenticatedMqttClient;
            boolean bl = false;
            this.obsoleteClient(it).subscribeOn(Schedulers.io()).subscribe();
        }
    }

    @NotNull
    public final io.reactivex.rxjava3.core.Completable disconnect() {
        AuthenticatedMqttClient authenticatedMqttClient;
        block3: {
            block2: {
                authenticatedMqttClient = activeClient;
                if (authenticatedMqttClient == null) break block2;
                AuthenticatedMqttClient p0 = authenticatedMqttClient;
                boolean bl = false;
                io.reactivex.rxjava3.core.Completable completable = this.obsoleteClient(p0);
                authenticatedMqttClient = completable;
                if (completable != null) break block3;
            }
            io.reactivex.rxjava3.core.Completable completable = io.reactivex.rxjava3.core.Completable.complete();
            authenticatedMqttClient = completable;
            Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"complete(...)");
        }
        return authenticatedMqttClient;
    }

    private final io.reactivex.rxjava3.core.Completable connect(EkoAccount account) {
        Mqtt3RxClient mqtt3RxClient;
        block7: {
            block6: {
                Mqtt3RxClient mqttClient;
                Mqtt3RxClient mqtt3RxClient2;
                String clientId = this.generateClientId(account);
                UserDao userDao = UserDatabase.get().userDao();
                UserEntity user = userDao.getByIdNow(account.getUserId());
                Object object = user;
                if (object == null || (object = ((UserEntity)object).getMid()) == null) {
                    object = "";
                }
                Object username = object;
                String string = account.getAccessToken();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAccessToken(...)");
                String string2 = string;
                byte[] byArray = string2.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                byte[] password = byArray;
                try {
                    mqtt3RxClient2 = this.initMqttClient(clientId, (String)username, password);
                }
                catch (Exception e) {
                    mqtt3RxClient2 = null;
                }
                if ((mqtt3RxClient = (mqttClient = mqtt3RxClient2)) == null) break block6;
                Mqtt3RxClient it = mqtt3RxClient;
                boolean bl = false;
                Completable completable = ((io.reactivex.Single)((Mqtt3ConnectBuilder.Nested)((Mqtt3ConnectBuilder.Nested)mqttClient.connectWith().cleanSession(false)).keepAlive(60)).applyConnect()).ignoreElement().doOnSubscribe(arg_0 -> AmityMqttClient.connect$lambda$9$lambda$5(arg_0 -> AmityMqttClient.connect$lambda$9$lambda$4(clientId, account, arg_0), arg_0)).doOnComplete(() -> AmityMqttClient.connect$lambda$9$lambda$6(clientId, account, mqttClient, this)).doOnError(arg_0 -> AmityMqttClient.connect$lambda$9$lambda$8(AmityMqttClient::connect$lambda$9$lambda$7, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"doOnError(...)");
                io.reactivex.rxjava3.core.Completable completable2 = CompletableKt.toRx3((Completable)completable);
                mqtt3RxClient = completable2;
                if (completable2 != null) break block7;
            }
            io.reactivex.rxjava3.core.Completable completable = io.reactivex.rxjava3.core.Completable.complete();
            mqtt3RxClient = completable;
            Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"complete(...)");
        }
        return mqtt3RxClient;
    }

    private final String generateClientId(EkoAccount newAccount) {
        String string = newAccount.getDeviceId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getDeviceId(...)");
        return string;
    }

    private final Mqtt3RxClient initMqttClient(String clientId, String username, byte[] password) {
        Mqtt3RxClient mqtt3RxClient = ((Mqtt3ClientBuilder)((Mqtt3ClientBuilder)((Mqtt3ClientBuilder)((Mqtt3ClientBuilder)((Mqtt3SimpleAuthBuilder.Nested.Complete)((Mqtt3SimpleAuthBuilder.Nested.Complete)((Mqtt3ClientBuilder)((Mqtt3ClientBuilder)((Mqtt3ClientBuilder)((Mqtt3ClientBuilder)MqttClient.builder().useMqttVersion3().identifier(clientId)).serverHost(EkoEndpoint.INSTANCE.getMqttUrl())).serverPort(443)).sslWithDefaultConfig()).simpleAuth().username(username)).password(password)).applySimpleAuth()).automaticReconnectWithDefaultConfig()).addConnectedListener(AmityMqttClient::initMqttClient$lambda$10)).addDisconnectedListener(arg_0 -> AmityMqttClient.initMqttClient$lambda$11(clientId, arg_0))).buildRx();
        Intrinsics.checkNotNullExpressionValue((Object)mqtt3RxClient, (String)"buildRx(...)");
        return mqtt3RxClient;
    }

    private final io.reactivex.rxjava3.core.Completable obsoleteClient(AuthenticatedMqttClient authClient) {
        subscriptions.clear();
        activeClient = null;
        Completable completable = authClient.getMqttClient().disconnect();
        Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"disconnect(...)");
        io.reactivex.rxjava3.core.Completable completable2 = CompletableKt.toRx3((Completable)completable).subscribeOn(Schedulers.io()).doOnSubscribe(new Consumer(authClient){
            final /* synthetic */ AuthenticatedMqttClient $authClient;
            {
                this.$authClient = $authClient;
            }

            public final void accept(io.reactivex.rxjava3.disposables.Disposable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                AmityLog.INSTANCE.tag(AmityMqttClient.Companion.getTAG()).e("Disconnecting client: \" + " + this.$authClient.getClientId() + " + \" userId : \" + " + this.$authClient.getAccount().getUserId(), new Object[0]);
            }
        }).doOnComplete(() -> AmityMqttClient.obsoleteClient$lambda$12(authClient)).doOnError((Consumer)obsoleteClient.3.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)completable2, (String)"doOnError(...)");
        return completable2;
    }

    private final io.reactivex.rxjava3.disposables.Disposable createEventSubscription(AuthenticatedMqttClient authClient) {
        Mqtt3RxClient mqttClient = authClient.getMqttClient();
        Flowable flowable = mqttClient.publishes(MqttGlobalPublishFilter.ALL);
        Intrinsics.checkNotNullExpressionValue((Object)flowable, (String)"publishes(...)");
        io.reactivex.rxjava3.disposables.Disposable disposable = FlowableKt.toRx3((Flowable)flowable).subscribeOn(Schedulers.io()).doOnNext(new Consumer(authClient, this){
            final /* synthetic */ AuthenticatedMqttClient $authClient;
            final /* synthetic */ AmityMqttClient this$0;
            {
                this.$authClient = $authClient;
                this.this$0 = $receiver;
            }

            public final void accept(Mqtt3Publish it) {
                boolean isNotActiveClient;
                AuthenticatedMqttClient authenticatedMqttClient = AmityMqttClient.access$getActiveClient$cp();
                boolean bl = isNotActiveClient = !Intrinsics.areEqual((Object)this.$authClient.getClientId(), (Object)(authenticatedMqttClient != null ? authenticatedMqttClient.getClientId() : null));
                if (isNotActiveClient) {
                    AmityMqttClient.access$obsoleteClient(this.this$0, this.$authClient).subscribeOn(Schedulers.io()).subscribe();
                    return;
                }
                try {
                    byte[] byArray = it.getPayloadAsBytes();
                    Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getPayloadAsBytes(...)");
                    byte[] byArray2 = byArray;
                    String payload = new String(byArray2, Charsets.UTF_8);
                    AmityLog.INSTANCE.tag(AmityMqttClient.Companion.getTAG()).d("received event: " + payload, new Object[0]);
                    MqttPayload event = (MqttPayload)EkoGson.get().fromJson(payload, MqttPayload.class);
                    MqttEventListener<Object> listener = MqttEventListeners.INSTANCE.getMap().get(event.getEventType());
                    if (listener != null) {
                        JsonObject jsonObject = event.getData();
                        if (jsonObject != null) {
                            JsonObject data = jsonObject;
                            boolean bl2 = false;
                            listener.onEvent$amity_sdk_release(data);
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }).doOnError((Consumer)createEventSubscription.2.INSTANCE).subscribe();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"subscribe(...)");
        return disposable;
    }

    private final void addClientListeners(AuthenticatedMqttClient authClient) {
        io.reactivex.rxjava3.disposables.Disposable eventSubscription = this.createEventSubscription(authClient);
        subscriptions.add(eventSubscription);
    }

    private final void autoSubscribe() {
        Iterable $this$forEach$iv = this.autoSubscribeTopics;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            io.reactivex.rxjava3.disposables.Disposable topicSubscription2;
            AmityTopic topic = (AmityTopic)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)Companion.subscribe(topic).subscribeOn(Schedulers.io()).doOnError(new Consumer(topic){
                final /* synthetic */ AmityTopic $topic;
                {
                    this.$topic = $topic;
                }

                public final void accept(Throwable it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    AmityLog.INSTANCE.tag(AmityMqttClient.Companion.getTAG()).e("Failed to subscribe " + this.$topic.getNonce$amity_sdk_release(), new Object[0]);
                }
            }).subscribe(), (String)"subscribe(...)");
            subscriptions.add(topicSubscription2);
        }
    }

    private static final void _init_$lambda$0() {
    }

    private static final Unit connect$lambda$9$lambda$4(String $clientId, EkoAccount $account, Disposable it) {
        AmityLog.INSTANCE.tag(TAG).e("Connecting client: " + $clientId + " userId: " + $account.getUserId(), new Object[0]);
        return Unit.INSTANCE;
    }

    private static final void connect$lambda$9$lambda$5(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void connect$lambda$9$lambda$6(String $clientId, EkoAccount $account, Mqtt3RxClient $mqttClient, AmityMqttClient this$0) {
        AmityLog.INSTANCE.tag(TAG).e("Connected client: " + $clientId + " userId: " + $account.getUserId(), new Object[0]);
        AuthenticatedMqttClient authClient = new AuthenticatedMqttClient($clientId, $account, $mqttClient);
        activeClient = authClient;
        this$0.addClientListeners(authClient);
        this$0.autoSubscribe();
    }

    private static final Unit connect$lambda$9$lambda$7(Throwable it) {
        AmityLog.INSTANCE.tag(TAG).e("Connection exception: " + it.getMessage(), new Object[0]);
        return Unit.INSTANCE;
    }

    private static final void connect$lambda$9$lambda$8(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void initMqttClient$lambda$10(MqttClientConnectedContext it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        AmityLog.INSTANCE.tag(TAG).e("mqtt connected", new Object[0]);
    }

    /*
     * Unable to fully structure code
     */
    private static final void initMqttClient$lambda$11(String $clientId, MqttClientDisconnectedContext it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        v0 = it.getCause();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getCause(...)");
        exception = v0;
        if (AmityMqttClient.activeClient == null) ** GOTO lbl-1000
        v1 = AmityMqttClient.activeClient;
        if (!Intrinsics.areEqual((Object)(v1 != null ? v1.getClientId() : null), (Object)$clientId)) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            v2 = false;
        }
        isNotActive = v2;
        hasValidDisconnectReason = exception instanceof Mqtt3ConnAckException != false && (((Mqtt3ConnAckException)exception).getMqttMessage().getReturnCode() == Mqtt3ConnAckReturnCode.IDENTIFIER_REJECTED || ((Mqtt3ConnAckException)exception).getMqttMessage().getReturnCode() == Mqtt3ConnAckReturnCode.UNSUPPORTED_PROTOCOL_VERSION || ((Mqtt3ConnAckException)exception).getMqttMessage().getReturnCode() == Mqtt3ConnAckReturnCode.BAD_USER_NAME_OR_PASSWORD || ((Mqtt3ConnAckException)exception).getMqttMessage().getReturnCode() == Mqtt3ConnAckReturnCode.NOT_AUTHORIZED);
        v3 = shouldNotReconnect = isNotActive != false || hasValidDisconnectReason != false;
        if (shouldNotReconnect) {
            it.getReconnector().reconnect(false);
        }
        AmityLog.INSTANCE.tag(AmityMqttClient.TAG).e("mqtt disconnected || isNotActive: " + isNotActive + " || hasValidDisconnectReason: " + hasValidDisconnectReason + " ", new Object[0]);
        AmityLog.INSTANCE.tag(AmityMqttClient.TAG).e("mqtt disconnected || cause: " + exception, new Object[0]);
    }

    private static final void obsoleteClient$lambda$12(AuthenticatedMqttClient $authClient) {
        AmityLog.INSTANCE.tag(TAG).e("Disconnected client: \" + " + $authClient.getClientId() + " + \" userId : \" + " + $authClient.getAccount().getUserId(), new Object[0]);
    }

    static {
        TAG = "AmityMqtt";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0007H\u00c6\u0003J'\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\t\u0010\u0019\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/amity/socialcloud/sdk/infra/mqtt/AmityMqttClient$AuthenticatedMqttClient;", "", "clientId", "", "account", "Lcom/ekoapp/ekosdk/internal/data/model/EkoAccount;", "mqttClient", "Lcom/hivemq/client/mqtt/mqtt3/Mqtt3RxClient;", "<init>", "(Ljava/lang/String;Lcom/ekoapp/ekosdk/internal/data/model/EkoAccount;Lcom/hivemq/client/mqtt/mqtt3/Mqtt3RxClient;)V", "getClientId", "()Ljava/lang/String;", "getAccount", "()Lcom/ekoapp/ekosdk/internal/data/model/EkoAccount;", "getMqttClient", "()Lcom/hivemq/client/mqtt/mqtt3/Mqtt3RxClient;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "amity-sdk_release"})
    public static final class AuthenticatedMqttClient {
        @NotNull
        private final String clientId;
        @NotNull
        private final EkoAccount account;
        @NotNull
        private final Mqtt3RxClient mqttClient;

        public AuthenticatedMqttClient(@NotNull String clientId, @NotNull EkoAccount account, @NotNull Mqtt3RxClient mqttClient) {
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            Intrinsics.checkNotNullParameter((Object)account, (String)"account");
            Intrinsics.checkNotNullParameter((Object)mqttClient, (String)"mqttClient");
            this.clientId = clientId;
            this.account = account;
            this.mqttClient = mqttClient;
        }

        @NotNull
        public final String getClientId() {
            return this.clientId;
        }

        @NotNull
        public final EkoAccount getAccount() {
            return this.account;
        }

        @NotNull
        public final Mqtt3RxClient getMqttClient() {
            return this.mqttClient;
        }

        @NotNull
        public final String component1() {
            return this.clientId;
        }

        @NotNull
        public final EkoAccount component2() {
            return this.account;
        }

        @NotNull
        public final Mqtt3RxClient component3() {
            return this.mqttClient;
        }

        @NotNull
        public final AuthenticatedMqttClient copy(@NotNull String clientId, @NotNull EkoAccount account, @NotNull Mqtt3RxClient mqttClient) {
            Intrinsics.checkNotNullParameter((Object)clientId, (String)"clientId");
            Intrinsics.checkNotNullParameter((Object)account, (String)"account");
            Intrinsics.checkNotNullParameter((Object)mqttClient, (String)"mqttClient");
            return new AuthenticatedMqttClient(clientId, account, mqttClient);
        }

        public static /* synthetic */ AuthenticatedMqttClient copy$default(AuthenticatedMqttClient authenticatedMqttClient, String string, EkoAccount ekoAccount, Mqtt3RxClient mqtt3RxClient, int n, Object object) {
            if ((n & 1) != 0) {
                string = authenticatedMqttClient.clientId;
            }
            if ((n & 2) != 0) {
                ekoAccount = authenticatedMqttClient.account;
            }
            if ((n & 4) != 0) {
                mqtt3RxClient = authenticatedMqttClient.mqttClient;
            }
            return authenticatedMqttClient.copy(string, ekoAccount, mqtt3RxClient);
        }

        @NotNull
        public String toString() {
            return "AuthenticatedMqttClient(clientId=" + this.clientId + ", account=" + this.account + ", mqttClient=" + this.mqttClient + ")";
        }

        public int hashCode() {
            int result = this.clientId.hashCode();
            result = result * 31 + this.account.hashCode();
            result = result * 31 + this.mqttClient.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof AuthenticatedMqttClient)) {
                return false;
            }
            AuthenticatedMqttClient authenticatedMqttClient = (AuthenticatedMqttClient)other;
            if (!Intrinsics.areEqual((Object)this.clientId, (Object)authenticatedMqttClient.clientId)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.account, (Object)authenticatedMqttClient.account)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.mqttClient, (Object)authenticatedMqttClient.mqttClient);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0014"}, d2={"Lcom/amity/socialcloud/sdk/infra/mqtt/AmityMqttClient$Companion;", "", "<init>", "()V", "subscriptions", "Lio/reactivex/rxjava3/disposables/CompositeDisposable;", "activeClient", "Lcom/amity/socialcloud/sdk/infra/mqtt/AmityMqttClient$AuthenticatedMqttClient;", "TAG", "", "getTAG", "()Ljava/lang/String;", "subscribe", "Lio/reactivex/rxjava3/core/Completable;", "mqttTopic", "Lcom/amity/socialcloud/sdk/model/core/events/AmityTopic;", "unsubscribe", "getCurrentClient", "Lio/reactivex/rxjava3/core/Single;", "Lcom/hivemq/client/mqtt/mqtt3/Mqtt3RxClient;", "amity-sdk_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getTAG() {
            return TAG;
        }

        @NotNull
        public final io.reactivex.rxjava3.core.Completable subscribe(@NotNull AmityTopic mqttTopic) {
            Intrinsics.checkNotNullParameter((Object)mqttTopic, (String)"mqttTopic");
            io.reactivex.rxjava3.core.Completable completable = mqttTopic.generateTopic$amity_sdk_release().flatMapCompletable((Function)subscribe.1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"flatMapCompletable(...)");
            return completable;
        }

        @NotNull
        public final io.reactivex.rxjava3.core.Completable unsubscribe(@NotNull AmityTopic mqttTopic) {
            Intrinsics.checkNotNullParameter((Object)mqttTopic, (String)"mqttTopic");
            io.reactivex.rxjava3.core.Completable completable = mqttTopic.generateTopic$amity_sdk_release().flatMapCompletable((Function)unsubscribe.1.INSTANCE);
            Intrinsics.checkNotNullExpressionValue((Object)completable, (String)"flatMapCompletable(...)");
            return completable;
        }

        private final Single<Mqtt3RxClient> getCurrentClient() {
            Single single;
            Mqtt3RxClient client;
            AuthenticatedMqttClient authenticatedMqttClient = activeClient;
            Object object = client = authenticatedMqttClient != null ? authenticatedMqttClient.getMqttClient() : null;
            if (client == null) {
                AmityException exception = AmityException.Companion.create$default(AmityException.Companion, "Failed to subscribe", null, AmityError.UNKNOWN, null, 8, null);
                Single single2 = Single.error((Throwable)exception);
                Intrinsics.checkNotNull((Object)single2);
                single = single2;
            } else {
                Single single3 = Single.just((Object)client);
                Intrinsics.checkNotNull((Object)single3);
                single = single3;
            }
            return single;
        }

        public static final /* synthetic */ Single access$getCurrentClient(Companion $this) {
            return $this.getCurrentClient();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

