package com.ekoapp.ekosdk.internal.data.model

import androidx.room.Entity
import com.google.gson.annotations.SerializedName

internal const val USER_FEED_QUERY_TOKEN_TABLE_NAME = "user_feed_query_token"

@Entity(
        tableName = USER_FEED_QUERY_TOKEN_TABLE_NAME,
        primaryKeys = ["userId", "sortBy", "isDeleted", "postTypes", "pageNumber"]
)
data class UserFeedQueryTokenEntity(
    var userId: String = "",
    var sortBy: String = "",
    @get:JvmName("getIsDeleted")
    @set:JvmName("setIsDeleted")
    @SerializedName("isDeleted")
    var isDeleted: String = "",
    var postTypes: String = ""
) : EkoQueryToken() {

}