package com.ekoapp.ekosdk;

import com.google.common.base.MoreObjects;

import org.joda.time.DateTime;

public abstract class EkoObject {

    private DateTime createdAt;
    private DateTime updatedAt;
    private DateTime expiresAt;


    /**
     * Intrinsic identifier of this entity
     */
    public abstract String getId();

    public DateTime getCreatedAt() {
        return createdAt;
    }

    public void setCreatedAt(DateTime createdAt) {
        this.createdAt = createdAt;
    }

    public DateTime getUpdatedAt() {
        return updatedAt;
    }

    public void setUpdatedAt(DateTime updatedAt) {
        this.updatedAt = updatedAt;
    }

    protected String internalToString(MoreObjects.ToStringHelper toStringHelper) {
        toStringHelper.add("createdAt", createdAt)
                .add("updatedAt", updatedAt);

        return toStringHelper.toString();
    }

    public DateTime getExpiresAt() {
        return expiresAt;
    }

    public void setExpiresAt(DateTime expiresAt) {
        if (this.expiresAt == null || expiresAt.isAfter(this.expiresAt)) {
            this.expiresAt = expiresAt;
        }
    }

    @Override
    public String toString() {
        return internalToString(MoreObjects.toStringHelper(this));
    }
}
