package com.amity.socialcloud.sdk.video.domain.room

import com.amity.socialcloud.sdk.model.video.room.AmityRoom
import com.amity.socialcloud.sdk.core.data.room.RoomRepository
import com.google.gson.JsonObject
import io.reactivex.rxjava3.core.Single

internal class UpdateRoomUseCase {
    fun execute(
        roomId: String,
        title: String?,
        description: String?,
        thumbnailFileId: String?,
        metadata: JsonObject?,
        liveChatEnabled: Boolean?,
    ): Single<AmityRoom> {
        return RoomRepository().updateRoom(
            roomId = roomId,
            title = title,
            description = description,
            thumbnailFileId = thumbnailFileId,
            metadata = metadata,
            liveChatEnabled = liveChatEnabled
        ).flatMap { GetRoomUseCase().execute(it).firstOrError() }
    }
}

