package com.amity.socialcloud.sdk.social.data.event

import com.amity.socialcloud.sdk.core.data.file.FileEntityMapper
import com.amity.socialcloud.sdk.core.data.file.FileLocalDataStore
import com.amity.socialcloud.sdk.core.data.user.UserEntityMapper
import com.amity.socialcloud.sdk.core.data.user.UserLocalDataStore
import com.amity.socialcloud.sdk.core.data.user.flag.UserFlagEntityMapper
import com.amity.socialcloud.sdk.core.data.user.flag.UserFlagLocalDataStore
import com.ekoapp.ekosdk.internal.api.dto.EventRSVPListDto
import io.reactivex.rxjava3.core.Completable

internal class EventResponsePersister {

    fun persist(dto: EventRSVPListDto): Completable {
        return Completable.defer {
            val fileCompletable = if (dto.files.isNotEmpty()) {
                FileLocalDataStore().saveFiles(FileEntityMapper().map(dto.files))
            } else {
                Completable.complete()
            }
            
            val userCompletable = if (dto.users.isNotEmpty()) {
                UserLocalDataStore().saveUsers(UserEntityMapper().map(dto.users))
            } else {
                Completable.complete()
            }
            
            val userFlagCompletable = if (dto.users.isNotEmpty()) {
                UserFlagLocalDataStore().saveFlags(UserFlagEntityMapper().map(dto.users))
            } else {
                Completable.complete()
            }
            
            val eventCompletable = dto.events?.let { events ->
                val entities = EventEntityMapper().map(events)
                EventLocalDataStore().saveEvents(entities)
            } ?: Completable.complete()
            
            val responseCompletable = dto.eventResponses?.let { eventResponses ->
                val entities = EventResponseEntityMapper().map(eventResponses)
                EventResponseLocalDataStore().saveEventResponses(entities)
            } ?: Completable.complete()
            
            Completable.mergeArray(
                fileCompletable,
                userCompletable,
                userFlagCompletable,
                eventCompletable,
                responseCompletable
            )
        }
    }
}
