package com.amity.socialcloud.sdk.model.social.event

enum class AmityEventType(val apiKey: String) {
    VIRTUAL("virtual"),
    IN_PERSON("in_person"),
    UNKNOWN("unknown");

    companion object {
        fun enumOf(value: String?): AmityEventType {
            return values().find { it.apiKey == value } ?: UNKNOWN
        }
    }
}
