package com.amity.socialcloud.sdk.core.data.pin.paging

import co.amity.rxbridge.toRx2
import com.amity.socialcloud.sdk.core.data.pin.PinRemoteDataStore
import com.amity.socialcloud.sdk.core.data.pin.PinnedPostQueryPersister
import com.amity.socialcloud.sdk.model.core.pin.AmityPinnedPost
import com.ekoapp.ekosdk.internal.api.dto.PinnedPostQueryDto
import com.ekoapp.ekosdk.internal.data.AmityNonce
import com.ekoapp.ekosdk.internal.data.model.PinEntity
import com.amity.socialcloud.sdk.social.data.post.paging.PinKeyCreator
import com.ekoapp.ekosdk.internal.mediator.DynamicQueryStreamMediator
import com.ekoapp.ekosdk.internal.token.DynamicQueryStreamQueryToken
import com.ekoapp.ekosdk.internal.token.QueryStreamQueryToken
import io.reactivex.Completable
import io.reactivex.Flowable
import io.reactivex.Single

class PinnedPostMediator(
        val targetId: String,
        val targetType: String,
        val placement: String? = null,
        val includeMixedStructure: Boolean,
) :
    DynamicQueryStreamMediator<PinEntity, PinnedPostQueryDto, AmityPinnedPost>(
        dynamicQueryStreamKeyCreator = PinKeyCreator(
            targetId = targetId,
            targetType = targetType,
            placement = placement,
            includeMixedStructure = includeMixedStructure
        ),
        nonce = AmityNonce.PINNED_POST_LIST
    ) {

    override fun provideReactorPublisher(): Flowable<AmityPinnedPost> {
        return Flowable.never()
    }
    
    override fun getFirstPageRequest(pageSize: Int): Single<PinnedPostQueryDto> {
        return getRequest(
            communityId = targetId,
            placement = placement,
            includeMixedStructure = includeMixedStructure,
        )
    }

    override fun getFetchByTokenRequest(token: String): Single<PinnedPostQueryDto> {
        return getRequest(
            communityId = targetId,
            placement = placement,
            includeMixedStructure = includeMixedStructure,
        )
    }

    override fun persistResponse(dto: PinnedPostQueryDto): Completable {
        return PinnedPostQueryPersister().persist(dto).toRx2()
    }

    override fun convertResponseToQueryToken(dto: PinnedPostQueryDto): QueryStreamQueryToken {
        val pinIds = mutableListOf<String>()
        dto.pinTargets.firstOrNull()?.let { target ->
            dto.pins.forEach { pinDto ->
                pinIds.add(pinDto.getId(target))
            }
        }
        return DynamicQueryStreamQueryToken(
            dynamicQueryStreamKeyCreator = dynamicQueryStreamKeyCreator,
            next = null,
            previous = null,
            primaryKeys = pinIds
        )
    }

    private fun getRequest(
        communityId: String,
        placement: String? = null,
        includeMixedStructure: Boolean
    ): Single<PinnedPostQueryDto> {
        return PinRemoteDataStore().queryPinPost(
            communityId = communityId,
            placement = placement,
            includeMixedStructure = includeMixedStructure
        ).toRx2()
    }
}