package com.amity.socialcloud.sdk.api.chat.channel.create

import com.amity.socialcloud.sdk.model.chat.channel.ChannelCreateOption
import com.amity.socialcloud.sdk.model.core.file.AmityImage
import com.amity.socialcloud.sdk.model.core.tag.AmityTags
import com.google.gson.JsonObject

class AmityCommunityChannelCreator {

    class Builder(private val displayName: String) {
        private var avatarFileId: String? = null
        private var metadata: JsonObject? = null
        private var tags: AmityTags? = null
        private var userIds: List<String>? = null
        private var isPublic: Boolean? = null

        fun avatar(avatar: AmityImage): Builder {
            return apply { this.avatarFileId = avatar.getFileId() }
        }

        fun metadata(metadata: JsonObject): Builder {
            return apply { this.metadata = metadata }
        }

        fun tags(tags: AmityTags): Builder {
            return apply { this.tags = tags }
        }

        fun userIds(userIds: List<String>): Builder {
            return apply { this.userIds = userIds }
        }
        
        fun isPublic(isPublic: Boolean): Builder {
            return apply { this.isPublic = isPublic }
        }

        fun build(): AmityChannelCreator {
            val option = ChannelCreateOption(
                    displayName = displayName,
                    avatarFileId = avatarFileId,
                    metadata = metadata,
                    tags = tags,
                    isPublic = isPublic,
                    userIds = userIds)
            return AmityChannelCreator(channelType = AmityChannelCreator.CreationType.COMMUNITY, option = option)
        }
    }

}