/*
 * Decompiled with CFR 0.152.
 */
package com.amity.socialcloud.sdk.social.data.event;

import androidx.annotation.NonNull;
import androidx.room.EntityDeleteOrUpdateAdapter;
import androidx.room.EntityInsertAdapter;
import androidx.room.RoomDatabase;
import androidx.room.rxjava3.RxRoom;
import androidx.room.util.DBUtil;
import androidx.room.util.SQLiteConnectionUtil;
import androidx.room.util.SQLiteStatementUtil;
import androidx.room.util.StringUtil;
import androidx.sqlite.SQLiteConnection;
import androidx.sqlite.SQLiteStatement;
import com.amity.socialcloud.sdk.entity.social.event.EventEntity;
import com.amity.socialcloud.sdk.social.data.event.EventDao;
import com.ekoapp.ekosdk.internal.data.converter.DateTimeTypeConverter;
import com.ekoapp.ekosdk.internal.data.converter.JsonObjectTypeConverter;
import com.google.gson.JsonObject;
import io.reactivex.rxjava3.core.Flowable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import org.joda.time.DateTime;

public final class EventDao_Impl
extends EventDao {
    private final RoomDatabase __db;
    private final EntityInsertAdapter<EventEntity> __insertAdapterOfEventEntity;
    private final DateTimeTypeConverter __dateTimeTypeConverter = new DateTimeTypeConverter();
    private final JsonObjectTypeConverter __jsonObjectTypeConverter = new JsonObjectTypeConverter();
    private final EntityDeleteOrUpdateAdapter<EventEntity> __deleteAdapterOfEventEntity;
    private final EntityDeleteOrUpdateAdapter<EventEntity> __updateAdapterOfEventEntity;

    public EventDao_Impl(@NonNull RoomDatabase __db) {
        this.__db = __db;
        this.__insertAdapterOfEventEntity = new EntityInsertAdapter<EventEntity>(){

            @NonNull
            protected String createQuery() {
                return "INSERT OR REPLACE INTO `event` (`publicId`,`eventId`,`title`,`description`,`type`,`status`,`startTime`,`endTime`,`coverImageFileId`,`originType`,`originId`,`userId`,`discussionCommunityId`,`targetCommunityId`,`postId`,`rsvpCount`,`interestedCount`,`isLocationVisible`,`location`,`externalUrl`,`metadata`,`path`,`createdAt`,`updatedAt`,`expiresAt`) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull EventEntity entity) {
                if (entity.getPublicId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getPublicId());
                }
                if (entity.getEventId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getEventId());
                }
                if (entity.getTitle() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getTitle());
                }
                if (entity.getDescription() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getDescription());
                }
                if (entity.getType() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, entity.getType());
                }
                if (entity.getStatus() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, entity.getStatus());
                }
                String _tmp = EventDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getStartTime());
                if (_tmp == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, _tmp);
                }
                String _tmp_1 = EventDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getEndTime());
                if (_tmp_1 == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, _tmp_1);
                }
                if (entity.getCoverImageFileId() == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, entity.getCoverImageFileId());
                }
                if (entity.getOriginType() == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindText(10, entity.getOriginType());
                }
                if (entity.getOriginId() == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindText(11, entity.getOriginId());
                }
                if (entity.getUserId() == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindText(12, entity.getUserId());
                }
                if (entity.getDiscussionCommunityId() == null) {
                    statement.bindNull(13);
                } else {
                    statement.bindText(13, entity.getDiscussionCommunityId());
                }
                if (entity.getTargetCommunityId() == null) {
                    statement.bindNull(14);
                } else {
                    statement.bindText(14, entity.getTargetCommunityId());
                }
                if (entity.getPostId() == null) {
                    statement.bindNull(15);
                } else {
                    statement.bindText(15, entity.getPostId());
                }
                statement.bindLong(16, (long)entity.getRsvpCount());
                statement.bindLong(17, (long)entity.getInterestedCount());
                int _tmp_2 = entity.isLocationVisible() ? 1 : 0;
                statement.bindLong(18, (long)_tmp_2);
                if (entity.getLocation() == null) {
                    statement.bindNull(19);
                } else {
                    statement.bindText(19, entity.getLocation());
                }
                if (entity.getExternalUrl() == null) {
                    statement.bindNull(20);
                } else {
                    statement.bindText(20, entity.getExternalUrl());
                }
                String _tmp_3 = EventDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(entity.getMetadata());
                if (_tmp_3 == null) {
                    statement.bindNull(21);
                } else {
                    statement.bindText(21, _tmp_3);
                }
                if (entity.getPath() == null) {
                    statement.bindNull(22);
                } else {
                    statement.bindText(22, entity.getPath());
                }
                String _tmp_4 = EventDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_4 == null) {
                    statement.bindNull(23);
                } else {
                    statement.bindText(23, _tmp_4);
                }
                String _tmp_5 = EventDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_5 == null) {
                    statement.bindNull(24);
                } else {
                    statement.bindText(24, _tmp_5);
                }
                String _tmp_6 = EventDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_6 == null) {
                    statement.bindNull(25);
                } else {
                    statement.bindText(25, _tmp_6);
                }
            }
        };
        this.__deleteAdapterOfEventEntity = new EntityDeleteOrUpdateAdapter<EventEntity>(){

            @NonNull
            protected String createQuery() {
                return "DELETE FROM `event` WHERE `eventId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull EventEntity entity) {
                if (entity.getEventId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getEventId());
                }
            }
        };
        this.__updateAdapterOfEventEntity = new EntityDeleteOrUpdateAdapter<EventEntity>(){

            @NonNull
            protected String createQuery() {
                return "UPDATE OR ABORT `event` SET `publicId` = ?,`eventId` = ?,`title` = ?,`description` = ?,`type` = ?,`status` = ?,`startTime` = ?,`endTime` = ?,`coverImageFileId` = ?,`originType` = ?,`originId` = ?,`userId` = ?,`discussionCommunityId` = ?,`targetCommunityId` = ?,`postId` = ?,`rsvpCount` = ?,`interestedCount` = ?,`isLocationVisible` = ?,`location` = ?,`externalUrl` = ?,`metadata` = ?,`path` = ?,`createdAt` = ?,`updatedAt` = ?,`expiresAt` = ? WHERE `eventId` = ?";
            }

            protected void bind(@NonNull SQLiteStatement statement, @NonNull EventEntity entity) {
                if (entity.getPublicId() == null) {
                    statement.bindNull(1);
                } else {
                    statement.bindText(1, entity.getPublicId());
                }
                if (entity.getEventId() == null) {
                    statement.bindNull(2);
                } else {
                    statement.bindText(2, entity.getEventId());
                }
                if (entity.getTitle() == null) {
                    statement.bindNull(3);
                } else {
                    statement.bindText(3, entity.getTitle());
                }
                if (entity.getDescription() == null) {
                    statement.bindNull(4);
                } else {
                    statement.bindText(4, entity.getDescription());
                }
                if (entity.getType() == null) {
                    statement.bindNull(5);
                } else {
                    statement.bindText(5, entity.getType());
                }
                if (entity.getStatus() == null) {
                    statement.bindNull(6);
                } else {
                    statement.bindText(6, entity.getStatus());
                }
                String _tmp = EventDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getStartTime());
                if (_tmp == null) {
                    statement.bindNull(7);
                } else {
                    statement.bindText(7, _tmp);
                }
                String _tmp_1 = EventDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getEndTime());
                if (_tmp_1 == null) {
                    statement.bindNull(8);
                } else {
                    statement.bindText(8, _tmp_1);
                }
                if (entity.getCoverImageFileId() == null) {
                    statement.bindNull(9);
                } else {
                    statement.bindText(9, entity.getCoverImageFileId());
                }
                if (entity.getOriginType() == null) {
                    statement.bindNull(10);
                } else {
                    statement.bindText(10, entity.getOriginType());
                }
                if (entity.getOriginId() == null) {
                    statement.bindNull(11);
                } else {
                    statement.bindText(11, entity.getOriginId());
                }
                if (entity.getUserId() == null) {
                    statement.bindNull(12);
                } else {
                    statement.bindText(12, entity.getUserId());
                }
                if (entity.getDiscussionCommunityId() == null) {
                    statement.bindNull(13);
                } else {
                    statement.bindText(13, entity.getDiscussionCommunityId());
                }
                if (entity.getTargetCommunityId() == null) {
                    statement.bindNull(14);
                } else {
                    statement.bindText(14, entity.getTargetCommunityId());
                }
                if (entity.getPostId() == null) {
                    statement.bindNull(15);
                } else {
                    statement.bindText(15, entity.getPostId());
                }
                statement.bindLong(16, (long)entity.getRsvpCount());
                statement.bindLong(17, (long)entity.getInterestedCount());
                int _tmp_2 = entity.isLocationVisible() ? 1 : 0;
                statement.bindLong(18, (long)_tmp_2);
                if (entity.getLocation() == null) {
                    statement.bindNull(19);
                } else {
                    statement.bindText(19, entity.getLocation());
                }
                if (entity.getExternalUrl() == null) {
                    statement.bindNull(20);
                } else {
                    statement.bindText(20, entity.getExternalUrl());
                }
                String _tmp_3 = EventDao_Impl.this.__jsonObjectTypeConverter.jsonObjectToString(entity.getMetadata());
                if (_tmp_3 == null) {
                    statement.bindNull(21);
                } else {
                    statement.bindText(21, _tmp_3);
                }
                if (entity.getPath() == null) {
                    statement.bindNull(22);
                } else {
                    statement.bindText(22, entity.getPath());
                }
                String _tmp_4 = EventDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getCreatedAt());
                if (_tmp_4 == null) {
                    statement.bindNull(23);
                } else {
                    statement.bindText(23, _tmp_4);
                }
                String _tmp_5 = EventDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getUpdatedAt());
                if (_tmp_5 == null) {
                    statement.bindNull(24);
                } else {
                    statement.bindText(24, _tmp_5);
                }
                String _tmp_6 = EventDao_Impl.this.__dateTimeTypeConverter.dateTimeToString(entity.getExpiresAt());
                if (_tmp_6 == null) {
                    statement.bindNull(25);
                } else {
                    statement.bindText(25, _tmp_6);
                }
                if (entity.getEventId() == null) {
                    statement.bindNull(26);
                } else {
                    statement.bindText(26, entity.getEventId());
                }
            }
        };
    }

    @Override
    public void insertImpl(EventEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfEventEntity.insert(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insertImpl(List<? extends EventEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__insertAdapterOfEventEntity.insert(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void delete(EventEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfEventEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void delete(List<? extends EventEntity> objects) {
        if (objects == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__deleteAdapterOfEventEntity.handleMultiple(_connection, (Iterable)objects);
            return null;
        });
    }

    @Override
    public void updateImpl(EventEntity object) {
        if (object == null) {
            throw new NullPointerException();
        }
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            this.__updateAdapterOfEventEntity.handle(_connection, (Object)object);
            return null;
        });
    }

    @Override
    public void insert(EventEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EventDao_Impl.super.insert(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void insert(List<? extends EventEntity> objects) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EventDao_Impl.super.insert(objects);
            return Unit.INSTANCE;
        });
    }

    @Override
    public void update(EventEntity object) {
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            EventDao_Impl.super.update(object);
            return Unit.INSTANCE;
        });
    }

    @Override
    public Flowable<EventEntity> getEventImpl(String eventId) {
        String _sql = "SELECT * FROM event WHERE eventId = ? LIMIT 1";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"event"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * FROM event WHERE eventId = ? LIMIT 1");){
                EventEntity _result;
                int _argIndex = 1;
                if (eventId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, eventId);
                }
                int _columnIndexOfPublicId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"publicId");
                int _columnIndexOfEventId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eventId");
                int _columnIndexOfTitle = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"title");
                int _columnIndexOfDescription = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"description");
                int _columnIndexOfType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"type");
                int _columnIndexOfStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"status");
                int _columnIndexOfStartTime = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"startTime");
                int _columnIndexOfEndTime = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"endTime");
                int _columnIndexOfCoverImageFileId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"coverImageFileId");
                int _columnIndexOfOriginType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"originType");
                int _columnIndexOfOriginId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"originId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfDiscussionCommunityId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"discussionCommunityId");
                int _columnIndexOfTargetCommunityId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetCommunityId");
                int _columnIndexOfPostId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"postId");
                int _columnIndexOfRsvpCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"rsvpCount");
                int _columnIndexOfInterestedCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"interestedCount");
                int _columnIndexOfIsLocationVisible = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isLocationVisible");
                int _columnIndexOfLocation = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"location");
                int _columnIndexOfExternalUrl = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"externalUrl");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new EventEntity();
                    String _tmpPublicId = _stmt.isNull(_columnIndexOfPublicId) ? null : _stmt.getText(_columnIndexOfPublicId);
                    _result.setPublicId(_tmpPublicId);
                    String _tmpEventId = _stmt.isNull(_columnIndexOfEventId) ? null : _stmt.getText(_columnIndexOfEventId);
                    _result.setEventId(_tmpEventId);
                    String _tmpTitle = _stmt.isNull(_columnIndexOfTitle) ? null : _stmt.getText(_columnIndexOfTitle);
                    _result.setTitle(_tmpTitle);
                    String _tmpDescription = _stmt.isNull(_columnIndexOfDescription) ? null : _stmt.getText(_columnIndexOfDescription);
                    _result.setDescription(_tmpDescription);
                    String _tmpType = _stmt.isNull(_columnIndexOfType) ? null : _stmt.getText(_columnIndexOfType);
                    _result.setType(_tmpType);
                    String _tmpStatus = _stmt.isNull(_columnIndexOfStatus) ? null : _stmt.getText(_columnIndexOfStatus);
                    _result.setStatus(_tmpStatus);
                    String _tmp = _stmt.isNull(_columnIndexOfStartTime) ? null : _stmt.getText(_columnIndexOfStartTime);
                    DateTime _tmpStartTime = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _result.setStartTime(_tmpStartTime);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfEndTime) ? null : _stmt.getText(_columnIndexOfEndTime);
                    DateTime _tmpEndTime = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setEndTime(_tmpEndTime);
                    String _tmpCoverImageFileId = _stmt.isNull(_columnIndexOfCoverImageFileId) ? null : _stmt.getText(_columnIndexOfCoverImageFileId);
                    _result.setCoverImageFileId(_tmpCoverImageFileId);
                    String _tmpOriginType = _stmt.isNull(_columnIndexOfOriginType) ? null : _stmt.getText(_columnIndexOfOriginType);
                    _result.setOriginType(_tmpOriginType);
                    String _tmpOriginId = _stmt.isNull(_columnIndexOfOriginId) ? null : _stmt.getText(_columnIndexOfOriginId);
                    _result.setOriginId(_tmpOriginId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _result.setUserId(_tmpUserId);
                    String _tmpDiscussionCommunityId = _stmt.isNull(_columnIndexOfDiscussionCommunityId) ? null : _stmt.getText(_columnIndexOfDiscussionCommunityId);
                    _result.setDiscussionCommunityId(_tmpDiscussionCommunityId);
                    String _tmpTargetCommunityId = _stmt.isNull(_columnIndexOfTargetCommunityId) ? null : _stmt.getText(_columnIndexOfTargetCommunityId);
                    _result.setTargetCommunityId(_tmpTargetCommunityId);
                    String _tmpPostId = _stmt.isNull(_columnIndexOfPostId) ? null : _stmt.getText(_columnIndexOfPostId);
                    _result.setPostId(_tmpPostId);
                    int _tmpRsvpCount = (int)_stmt.getLong(_columnIndexOfRsvpCount);
                    _result.setRsvpCount(_tmpRsvpCount);
                    int _tmpInterestedCount = (int)_stmt.getLong(_columnIndexOfInterestedCount);
                    _result.setInterestedCount(_tmpInterestedCount);
                    int _tmp_2 = (int)_stmt.getLong(_columnIndexOfIsLocationVisible);
                    boolean _tmpIsLocationVisible = _tmp_2 != 0;
                    _result.setLocationVisible(_tmpIsLocationVisible);
                    String _tmpLocation = _stmt.isNull(_columnIndexOfLocation) ? null : _stmt.getText(_columnIndexOfLocation);
                    _result.setLocation(_tmpLocation);
                    String _tmpExternalUrl = _stmt.isNull(_columnIndexOfExternalUrl) ? null : _stmt.getText(_columnIndexOfExternalUrl);
                    _result.setExternalUrl(_tmpExternalUrl);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_3);
                    _result.setMetadata(_tmpMetadata);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _result.setPath(_tmpPath);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                EventEntity eventEntity = _result;
                return eventEntity;
            }
        });
    }

    @Override
    public Flowable<List<EventEntity>> observeEventImpl(String eventId) {
        String _sql = "SELECT * FROM event WHERE eventId = ?";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"event"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * FROM event WHERE eventId = ?");){
                int _argIndex = 1;
                if (eventId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, eventId);
                }
                int _columnIndexOfPublicId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"publicId");
                int _columnIndexOfEventId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eventId");
                int _columnIndexOfTitle = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"title");
                int _columnIndexOfDescription = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"description");
                int _columnIndexOfType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"type");
                int _columnIndexOfStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"status");
                int _columnIndexOfStartTime = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"startTime");
                int _columnIndexOfEndTime = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"endTime");
                int _columnIndexOfCoverImageFileId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"coverImageFileId");
                int _columnIndexOfOriginType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"originType");
                int _columnIndexOfOriginId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"originId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfDiscussionCommunityId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"discussionCommunityId");
                int _columnIndexOfTargetCommunityId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetCommunityId");
                int _columnIndexOfPostId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"postId");
                int _columnIndexOfRsvpCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"rsvpCount");
                int _columnIndexOfInterestedCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"interestedCount");
                int _columnIndexOfIsLocationVisible = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isLocationVisible");
                int _columnIndexOfLocation = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"location");
                int _columnIndexOfExternalUrl = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"externalUrl");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<EventEntity> _result = new ArrayList<EventEntity>();
                while (_stmt.step()) {
                    EventEntity _item = new EventEntity();
                    String _tmpPublicId = _stmt.isNull(_columnIndexOfPublicId) ? null : _stmt.getText(_columnIndexOfPublicId);
                    _item.setPublicId(_tmpPublicId);
                    String _tmpEventId = _stmt.isNull(_columnIndexOfEventId) ? null : _stmt.getText(_columnIndexOfEventId);
                    _item.setEventId(_tmpEventId);
                    String _tmpTitle = _stmt.isNull(_columnIndexOfTitle) ? null : _stmt.getText(_columnIndexOfTitle);
                    _item.setTitle(_tmpTitle);
                    String _tmpDescription = _stmt.isNull(_columnIndexOfDescription) ? null : _stmt.getText(_columnIndexOfDescription);
                    _item.setDescription(_tmpDescription);
                    String _tmpType = _stmt.isNull(_columnIndexOfType) ? null : _stmt.getText(_columnIndexOfType);
                    _item.setType(_tmpType);
                    String _tmpStatus = _stmt.isNull(_columnIndexOfStatus) ? null : _stmt.getText(_columnIndexOfStatus);
                    _item.setStatus(_tmpStatus);
                    String _tmp = _stmt.isNull(_columnIndexOfStartTime) ? null : _stmt.getText(_columnIndexOfStartTime);
                    DateTime _tmpStartTime = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _item.setStartTime(_tmpStartTime);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfEndTime) ? null : _stmt.getText(_columnIndexOfEndTime);
                    DateTime _tmpEndTime = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _item.setEndTime(_tmpEndTime);
                    String _tmpCoverImageFileId = _stmt.isNull(_columnIndexOfCoverImageFileId) ? null : _stmt.getText(_columnIndexOfCoverImageFileId);
                    _item.setCoverImageFileId(_tmpCoverImageFileId);
                    String _tmpOriginType = _stmt.isNull(_columnIndexOfOriginType) ? null : _stmt.getText(_columnIndexOfOriginType);
                    _item.setOriginType(_tmpOriginType);
                    String _tmpOriginId = _stmt.isNull(_columnIndexOfOriginId) ? null : _stmt.getText(_columnIndexOfOriginId);
                    _item.setOriginId(_tmpOriginId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _item.setUserId(_tmpUserId);
                    String _tmpDiscussionCommunityId = _stmt.isNull(_columnIndexOfDiscussionCommunityId) ? null : _stmt.getText(_columnIndexOfDiscussionCommunityId);
                    _item.setDiscussionCommunityId(_tmpDiscussionCommunityId);
                    String _tmpTargetCommunityId = _stmt.isNull(_columnIndexOfTargetCommunityId) ? null : _stmt.getText(_columnIndexOfTargetCommunityId);
                    _item.setTargetCommunityId(_tmpTargetCommunityId);
                    String _tmpPostId = _stmt.isNull(_columnIndexOfPostId) ? null : _stmt.getText(_columnIndexOfPostId);
                    _item.setPostId(_tmpPostId);
                    int _tmpRsvpCount = (int)_stmt.getLong(_columnIndexOfRsvpCount);
                    _item.setRsvpCount(_tmpRsvpCount);
                    int _tmpInterestedCount = (int)_stmt.getLong(_columnIndexOfInterestedCount);
                    _item.setInterestedCount(_tmpInterestedCount);
                    int _tmp_2 = (int)_stmt.getLong(_columnIndexOfIsLocationVisible);
                    boolean _tmpIsLocationVisible = _tmp_2 != 0;
                    _item.setLocationVisible(_tmpIsLocationVisible);
                    String _tmpLocation = _stmt.isNull(_columnIndexOfLocation) ? null : _stmt.getText(_columnIndexOfLocation);
                    _item.setLocation(_tmpLocation);
                    String _tmpExternalUrl = _stmt.isNull(_columnIndexOfExternalUrl) ? null : _stmt.getText(_columnIndexOfExternalUrl);
                    _item.setExternalUrl(_tmpExternalUrl);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_3);
                    _item.setMetadata(_tmpMetadata);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _item.setPath(_tmpPath);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _item.setCreatedAt(_tmpCreatedAt);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                    _item.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                    _item.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item);
                }
                ArrayList<EventEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public EventEntity getByIdNowImpl(String eventId) {
        String _sql = "SELECT * FROM event WHERE eventId = ? LIMIT 1";
        return (EventEntity)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * FROM event WHERE eventId = ? LIMIT 1");){
                EventEntity _result;
                int _argIndex = 1;
                if (eventId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, eventId);
                }
                int _columnIndexOfPublicId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"publicId");
                int _columnIndexOfEventId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eventId");
                int _columnIndexOfTitle = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"title");
                int _columnIndexOfDescription = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"description");
                int _columnIndexOfType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"type");
                int _columnIndexOfStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"status");
                int _columnIndexOfStartTime = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"startTime");
                int _columnIndexOfEndTime = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"endTime");
                int _columnIndexOfCoverImageFileId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"coverImageFileId");
                int _columnIndexOfOriginType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"originType");
                int _columnIndexOfOriginId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"originId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfDiscussionCommunityId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"discussionCommunityId");
                int _columnIndexOfTargetCommunityId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetCommunityId");
                int _columnIndexOfPostId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"postId");
                int _columnIndexOfRsvpCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"rsvpCount");
                int _columnIndexOfInterestedCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"interestedCount");
                int _columnIndexOfIsLocationVisible = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isLocationVisible");
                int _columnIndexOfLocation = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"location");
                int _columnIndexOfExternalUrl = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"externalUrl");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new EventEntity();
                    String _tmpPublicId = _stmt.isNull(_columnIndexOfPublicId) ? null : _stmt.getText(_columnIndexOfPublicId);
                    _result.setPublicId(_tmpPublicId);
                    String _tmpEventId = _stmt.isNull(_columnIndexOfEventId) ? null : _stmt.getText(_columnIndexOfEventId);
                    _result.setEventId(_tmpEventId);
                    String _tmpTitle = _stmt.isNull(_columnIndexOfTitle) ? null : _stmt.getText(_columnIndexOfTitle);
                    _result.setTitle(_tmpTitle);
                    String _tmpDescription = _stmt.isNull(_columnIndexOfDescription) ? null : _stmt.getText(_columnIndexOfDescription);
                    _result.setDescription(_tmpDescription);
                    String _tmpType = _stmt.isNull(_columnIndexOfType) ? null : _stmt.getText(_columnIndexOfType);
                    _result.setType(_tmpType);
                    String _tmpStatus = _stmt.isNull(_columnIndexOfStatus) ? null : _stmt.getText(_columnIndexOfStatus);
                    _result.setStatus(_tmpStatus);
                    String _tmp = _stmt.isNull(_columnIndexOfStartTime) ? null : _stmt.getText(_columnIndexOfStartTime);
                    DateTime _tmpStartTime = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _result.setStartTime(_tmpStartTime);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfEndTime) ? null : _stmt.getText(_columnIndexOfEndTime);
                    DateTime _tmpEndTime = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _result.setEndTime(_tmpEndTime);
                    String _tmpCoverImageFileId = _stmt.isNull(_columnIndexOfCoverImageFileId) ? null : _stmt.getText(_columnIndexOfCoverImageFileId);
                    _result.setCoverImageFileId(_tmpCoverImageFileId);
                    String _tmpOriginType = _stmt.isNull(_columnIndexOfOriginType) ? null : _stmt.getText(_columnIndexOfOriginType);
                    _result.setOriginType(_tmpOriginType);
                    String _tmpOriginId = _stmt.isNull(_columnIndexOfOriginId) ? null : _stmt.getText(_columnIndexOfOriginId);
                    _result.setOriginId(_tmpOriginId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _result.setUserId(_tmpUserId);
                    String _tmpDiscussionCommunityId = _stmt.isNull(_columnIndexOfDiscussionCommunityId) ? null : _stmt.getText(_columnIndexOfDiscussionCommunityId);
                    _result.setDiscussionCommunityId(_tmpDiscussionCommunityId);
                    String _tmpTargetCommunityId = _stmt.isNull(_columnIndexOfTargetCommunityId) ? null : _stmt.getText(_columnIndexOfTargetCommunityId);
                    _result.setTargetCommunityId(_tmpTargetCommunityId);
                    String _tmpPostId = _stmt.isNull(_columnIndexOfPostId) ? null : _stmt.getText(_columnIndexOfPostId);
                    _result.setPostId(_tmpPostId);
                    int _tmpRsvpCount = (int)_stmt.getLong(_columnIndexOfRsvpCount);
                    _result.setRsvpCount(_tmpRsvpCount);
                    int _tmpInterestedCount = (int)_stmt.getLong(_columnIndexOfInterestedCount);
                    _result.setInterestedCount(_tmpInterestedCount);
                    int _tmp_2 = (int)_stmt.getLong(_columnIndexOfIsLocationVisible);
                    boolean _tmpIsLocationVisible = _tmp_2 != 0;
                    _result.setLocationVisible(_tmpIsLocationVisible);
                    String _tmpLocation = _stmt.isNull(_columnIndexOfLocation) ? null : _stmt.getText(_columnIndexOfLocation);
                    _result.setLocation(_tmpLocation);
                    String _tmpExternalUrl = _stmt.isNull(_columnIndexOfExternalUrl) ? null : _stmt.getText(_columnIndexOfExternalUrl);
                    _result.setExternalUrl(_tmpExternalUrl);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_3);
                    _result.setMetadata(_tmpMetadata);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _result.setPath(_tmpPath);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                EventEntity eventEntity = _result;
                return eventEntity;
            }
        });
    }

    @Override
    public List<EventEntity> getByIdsNowImpl(List<String> eventIds) {
        StringBuilder _stringBuilder = new StringBuilder();
        _stringBuilder.append("SELECT * FROM event WHERE eventId IN (");
        int _inputSize = eventIds.size();
        StringUtil.appendPlaceholders((StringBuilder)_stringBuilder, (int)_inputSize);
        _stringBuilder.append(")");
        String _sql = _stringBuilder.toString();
        return (List)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)true, (boolean)false, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare(_sql);){
                int _argIndex = 1;
                for (String _item : eventIds) {
                    if (_item == null) {
                        _stmt.bindNull(_argIndex);
                    } else {
                        _stmt.bindText(_argIndex, _item);
                    }
                    ++_argIndex;
                }
                int _columnIndexOfPublicId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"publicId");
                int _columnIndexOfEventId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eventId");
                int _columnIndexOfTitle = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"title");
                int _columnIndexOfDescription = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"description");
                int _columnIndexOfType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"type");
                int _columnIndexOfStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"status");
                int _columnIndexOfStartTime = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"startTime");
                int _columnIndexOfEndTime = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"endTime");
                int _columnIndexOfCoverImageFileId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"coverImageFileId");
                int _columnIndexOfOriginType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"originType");
                int _columnIndexOfOriginId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"originId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfDiscussionCommunityId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"discussionCommunityId");
                int _columnIndexOfTargetCommunityId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetCommunityId");
                int _columnIndexOfPostId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"postId");
                int _columnIndexOfRsvpCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"rsvpCount");
                int _columnIndexOfInterestedCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"interestedCount");
                int _columnIndexOfIsLocationVisible = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isLocationVisible");
                int _columnIndexOfLocation = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"location");
                int _columnIndexOfExternalUrl = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"externalUrl");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                ArrayList<EventEntity> _result = new ArrayList<EventEntity>();
                while (_stmt.step()) {
                    EventEntity _item_1 = new EventEntity();
                    String _tmpPublicId = _stmt.isNull(_columnIndexOfPublicId) ? null : _stmt.getText(_columnIndexOfPublicId);
                    _item_1.setPublicId(_tmpPublicId);
                    String _tmpEventId = _stmt.isNull(_columnIndexOfEventId) ? null : _stmt.getText(_columnIndexOfEventId);
                    _item_1.setEventId(_tmpEventId);
                    String _tmpTitle = _stmt.isNull(_columnIndexOfTitle) ? null : _stmt.getText(_columnIndexOfTitle);
                    _item_1.setTitle(_tmpTitle);
                    String _tmpDescription = _stmt.isNull(_columnIndexOfDescription) ? null : _stmt.getText(_columnIndexOfDescription);
                    _item_1.setDescription(_tmpDescription);
                    String _tmpType = _stmt.isNull(_columnIndexOfType) ? null : _stmt.getText(_columnIndexOfType);
                    _item_1.setType(_tmpType);
                    String _tmpStatus = _stmt.isNull(_columnIndexOfStatus) ? null : _stmt.getText(_columnIndexOfStatus);
                    _item_1.setStatus(_tmpStatus);
                    String _tmp = _stmt.isNull(_columnIndexOfStartTime) ? null : _stmt.getText(_columnIndexOfStartTime);
                    DateTime _tmpStartTime = this.__dateTimeTypeConverter.stringToDateTime(_tmp);
                    _item_1.setStartTime(_tmpStartTime);
                    String _tmp_1 = _stmt.isNull(_columnIndexOfEndTime) ? null : _stmt.getText(_columnIndexOfEndTime);
                    DateTime _tmpEndTime = this.__dateTimeTypeConverter.stringToDateTime(_tmp_1);
                    _item_1.setEndTime(_tmpEndTime);
                    String _tmpCoverImageFileId = _stmt.isNull(_columnIndexOfCoverImageFileId) ? null : _stmt.getText(_columnIndexOfCoverImageFileId);
                    _item_1.setCoverImageFileId(_tmpCoverImageFileId);
                    String _tmpOriginType = _stmt.isNull(_columnIndexOfOriginType) ? null : _stmt.getText(_columnIndexOfOriginType);
                    _item_1.setOriginType(_tmpOriginType);
                    String _tmpOriginId = _stmt.isNull(_columnIndexOfOriginId) ? null : _stmt.getText(_columnIndexOfOriginId);
                    _item_1.setOriginId(_tmpOriginId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _item_1.setUserId(_tmpUserId);
                    String _tmpDiscussionCommunityId = _stmt.isNull(_columnIndexOfDiscussionCommunityId) ? null : _stmt.getText(_columnIndexOfDiscussionCommunityId);
                    _item_1.setDiscussionCommunityId(_tmpDiscussionCommunityId);
                    String _tmpTargetCommunityId = _stmt.isNull(_columnIndexOfTargetCommunityId) ? null : _stmt.getText(_columnIndexOfTargetCommunityId);
                    _item_1.setTargetCommunityId(_tmpTargetCommunityId);
                    String _tmpPostId = _stmt.isNull(_columnIndexOfPostId) ? null : _stmt.getText(_columnIndexOfPostId);
                    _item_1.setPostId(_tmpPostId);
                    int _tmpRsvpCount = (int)_stmt.getLong(_columnIndexOfRsvpCount);
                    _item_1.setRsvpCount(_tmpRsvpCount);
                    int _tmpInterestedCount = (int)_stmt.getLong(_columnIndexOfInterestedCount);
                    _item_1.setInterestedCount(_tmpInterestedCount);
                    int _tmp_2 = (int)_stmt.getLong(_columnIndexOfIsLocationVisible);
                    boolean _tmpIsLocationVisible = _tmp_2 != 0;
                    _item_1.setLocationVisible(_tmpIsLocationVisible);
                    String _tmpLocation = _stmt.isNull(_columnIndexOfLocation) ? null : _stmt.getText(_columnIndexOfLocation);
                    _item_1.setLocation(_tmpLocation);
                    String _tmpExternalUrl = _stmt.isNull(_columnIndexOfExternalUrl) ? null : _stmt.getText(_columnIndexOfExternalUrl);
                    _item_1.setExternalUrl(_tmpExternalUrl);
                    String _tmp_3 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_3);
                    _item_1.setMetadata(_tmpMetadata);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _item_1.setPath(_tmpPath);
                    String _tmp_4 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_4);
                    _item_1.setCreatedAt(_tmpCreatedAt);
                    String _tmp_5 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_5);
                    _item_1.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                    _item_1.setExpiresAt(_tmpExpiresAt);
                    _result.add(_item_1);
                }
                ArrayList<EventEntity> arrayList = _result;
                return arrayList;
            }
        });
    }

    @Override
    public Flowable<EventEntity> getLatestEventImpl(boolean isFilterByOriginType, String originType, boolean isFilterByOriginId, String originId, boolean isFilterByUserId, String userId, boolean isFilterByStatus, String status, boolean isFilterByType, String type2, int hash, int nonce, DateTime now, String sortBy, String orderBy) {
        String _sql = "SELECT * FROM event WHERE (? = 0 OR originType = ?) AND (? = 0 OR originId = ?) AND (? = 0 OR userId = ?) AND (? = 0 OR status = ?) AND (? = 0 OR type = ?) AND updatedAt > ? AND eventId NOT IN (SELECT id FROM amity_paging_id WHERE hash = ? AND nonce = ?) ORDER BY CASE WHEN ? = 'startTime' AND ? = 'asc' THEN startTime END ASC, CASE WHEN ? = 'startTime' AND ? = 'desc' THEN startTime END DESC, CASE WHEN ? = 'createdAt' AND ? = 'asc' THEN createdAt END ASC, CASE WHEN ? = 'createdAt' AND ? = 'desc' THEN createdAt END DESC LIMIT 1";
        return RxRoom.createFlowable((RoomDatabase)this.__db, (boolean)false, (String[])new String[]{"event", "amity_paging_id"}, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("SELECT * FROM event WHERE (? = 0 OR originType = ?) AND (? = 0 OR originId = ?) AND (? = 0 OR userId = ?) AND (? = 0 OR status = ?) AND (? = 0 OR type = ?) AND updatedAt > ? AND eventId NOT IN (SELECT id FROM amity_paging_id WHERE hash = ? AND nonce = ?) ORDER BY CASE WHEN ? = 'startTime' AND ? = 'asc' THEN startTime END ASC, CASE WHEN ? = 'startTime' AND ? = 'desc' THEN startTime END DESC, CASE WHEN ? = 'createdAt' AND ? = 'asc' THEN createdAt END ASC, CASE WHEN ? = 'createdAt' AND ? = 'desc' THEN createdAt END DESC LIMIT 1");){
                EventEntity _result;
                int _argIndex = 1;
                int _tmp = isFilterByOriginType ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp);
                _argIndex = 2;
                if (originType == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, originType);
                }
                _argIndex = 3;
                int _tmp_1 = isFilterByOriginId ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp_1);
                _argIndex = 4;
                if (originId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, originId);
                }
                _argIndex = 5;
                int _tmp_2 = isFilterByUserId ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp_2);
                _argIndex = 6;
                if (userId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, userId);
                }
                _argIndex = 7;
                int _tmp_3 = isFilterByStatus ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp_3);
                _argIndex = 8;
                if (status == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, status);
                }
                _argIndex = 9;
                int _tmp_4 = isFilterByType ? 1 : 0;
                _stmt.bindLong(_argIndex, (long)_tmp_4);
                _argIndex = 10;
                if (type2 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, type2);
                }
                _argIndex = 11;
                String _tmp_5 = this.__dateTimeTypeConverter.dateTimeToString(now);
                if (_tmp_5 == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, _tmp_5);
                }
                _argIndex = 12;
                _stmt.bindLong(_argIndex, (long)hash);
                _argIndex = 13;
                _stmt.bindLong(_argIndex, (long)nonce);
                _argIndex = 14;
                if (sortBy == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, sortBy);
                }
                _argIndex = 15;
                if (orderBy == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, orderBy);
                }
                _argIndex = 16;
                if (sortBy == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, sortBy);
                }
                _argIndex = 17;
                if (orderBy == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, orderBy);
                }
                _argIndex = 18;
                if (sortBy == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, sortBy);
                }
                _argIndex = 19;
                if (orderBy == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, orderBy);
                }
                _argIndex = 20;
                if (sortBy == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, sortBy);
                }
                _argIndex = 21;
                if (orderBy == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, orderBy);
                }
                int _columnIndexOfPublicId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"publicId");
                int _columnIndexOfEventId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"eventId");
                int _columnIndexOfTitle = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"title");
                int _columnIndexOfDescription = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"description");
                int _columnIndexOfType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"type");
                int _columnIndexOfStatus = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"status");
                int _columnIndexOfStartTime = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"startTime");
                int _columnIndexOfEndTime = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"endTime");
                int _columnIndexOfCoverImageFileId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"coverImageFileId");
                int _columnIndexOfOriginType = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"originType");
                int _columnIndexOfOriginId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"originId");
                int _columnIndexOfUserId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"userId");
                int _columnIndexOfDiscussionCommunityId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"discussionCommunityId");
                int _columnIndexOfTargetCommunityId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"targetCommunityId");
                int _columnIndexOfPostId = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"postId");
                int _columnIndexOfRsvpCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"rsvpCount");
                int _columnIndexOfInterestedCount = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"interestedCount");
                int _columnIndexOfIsLocationVisible = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"isLocationVisible");
                int _columnIndexOfLocation = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"location");
                int _columnIndexOfExternalUrl = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"externalUrl");
                int _columnIndexOfMetadata = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"metadata");
                int _columnIndexOfPath = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"path");
                int _columnIndexOfCreatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"createdAt");
                int _columnIndexOfUpdatedAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"updatedAt");
                int _columnIndexOfExpiresAt = SQLiteStatementUtil.getColumnIndexOrThrow((SQLiteStatement)_stmt, (String)"expiresAt");
                if (_stmt.step()) {
                    _result = new EventEntity();
                    String _tmpPublicId = _stmt.isNull(_columnIndexOfPublicId) ? null : _stmt.getText(_columnIndexOfPublicId);
                    _result.setPublicId(_tmpPublicId);
                    String _tmpEventId = _stmt.isNull(_columnIndexOfEventId) ? null : _stmt.getText(_columnIndexOfEventId);
                    _result.setEventId(_tmpEventId);
                    String _tmpTitle = _stmt.isNull(_columnIndexOfTitle) ? null : _stmt.getText(_columnIndexOfTitle);
                    _result.setTitle(_tmpTitle);
                    String _tmpDescription = _stmt.isNull(_columnIndexOfDescription) ? null : _stmt.getText(_columnIndexOfDescription);
                    _result.setDescription(_tmpDescription);
                    String _tmpType = _stmt.isNull(_columnIndexOfType) ? null : _stmt.getText(_columnIndexOfType);
                    _result.setType(_tmpType);
                    String _tmpStatus = _stmt.isNull(_columnIndexOfStatus) ? null : _stmt.getText(_columnIndexOfStatus);
                    _result.setStatus(_tmpStatus);
                    String _tmp_6 = _stmt.isNull(_columnIndexOfStartTime) ? null : _stmt.getText(_columnIndexOfStartTime);
                    DateTime _tmpStartTime = this.__dateTimeTypeConverter.stringToDateTime(_tmp_6);
                    _result.setStartTime(_tmpStartTime);
                    String _tmp_7 = _stmt.isNull(_columnIndexOfEndTime) ? null : _stmt.getText(_columnIndexOfEndTime);
                    DateTime _tmpEndTime = this.__dateTimeTypeConverter.stringToDateTime(_tmp_7);
                    _result.setEndTime(_tmpEndTime);
                    String _tmpCoverImageFileId = _stmt.isNull(_columnIndexOfCoverImageFileId) ? null : _stmt.getText(_columnIndexOfCoverImageFileId);
                    _result.setCoverImageFileId(_tmpCoverImageFileId);
                    String _tmpOriginType = _stmt.isNull(_columnIndexOfOriginType) ? null : _stmt.getText(_columnIndexOfOriginType);
                    _result.setOriginType(_tmpOriginType);
                    String _tmpOriginId = _stmt.isNull(_columnIndexOfOriginId) ? null : _stmt.getText(_columnIndexOfOriginId);
                    _result.setOriginId(_tmpOriginId);
                    String _tmpUserId = _stmt.isNull(_columnIndexOfUserId) ? null : _stmt.getText(_columnIndexOfUserId);
                    _result.setUserId(_tmpUserId);
                    String _tmpDiscussionCommunityId = _stmt.isNull(_columnIndexOfDiscussionCommunityId) ? null : _stmt.getText(_columnIndexOfDiscussionCommunityId);
                    _result.setDiscussionCommunityId(_tmpDiscussionCommunityId);
                    String _tmpTargetCommunityId = _stmt.isNull(_columnIndexOfTargetCommunityId) ? null : _stmt.getText(_columnIndexOfTargetCommunityId);
                    _result.setTargetCommunityId(_tmpTargetCommunityId);
                    String _tmpPostId = _stmt.isNull(_columnIndexOfPostId) ? null : _stmt.getText(_columnIndexOfPostId);
                    _result.setPostId(_tmpPostId);
                    int _tmpRsvpCount = (int)_stmt.getLong(_columnIndexOfRsvpCount);
                    _result.setRsvpCount(_tmpRsvpCount);
                    int _tmpInterestedCount = (int)_stmt.getLong(_columnIndexOfInterestedCount);
                    _result.setInterestedCount(_tmpInterestedCount);
                    int _tmp_8 = (int)_stmt.getLong(_columnIndexOfIsLocationVisible);
                    boolean _tmpIsLocationVisible = _tmp_8 != 0;
                    _result.setLocationVisible(_tmpIsLocationVisible);
                    String _tmpLocation = _stmt.isNull(_columnIndexOfLocation) ? null : _stmt.getText(_columnIndexOfLocation);
                    _result.setLocation(_tmpLocation);
                    String _tmpExternalUrl = _stmt.isNull(_columnIndexOfExternalUrl) ? null : _stmt.getText(_columnIndexOfExternalUrl);
                    _result.setExternalUrl(_tmpExternalUrl);
                    String _tmp_9 = _stmt.isNull(_columnIndexOfMetadata) ? null : _stmt.getText(_columnIndexOfMetadata);
                    JsonObject _tmpMetadata = this.__jsonObjectTypeConverter.stringToJsonObject(_tmp_9);
                    _result.setMetadata(_tmpMetadata);
                    String _tmpPath = _stmt.isNull(_columnIndexOfPath) ? null : _stmt.getText(_columnIndexOfPath);
                    _result.setPath(_tmpPath);
                    String _tmp_10 = _stmt.isNull(_columnIndexOfCreatedAt) ? null : _stmt.getText(_columnIndexOfCreatedAt);
                    DateTime _tmpCreatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_10);
                    _result.setCreatedAt(_tmpCreatedAt);
                    String _tmp_11 = _stmt.isNull(_columnIndexOfUpdatedAt) ? null : _stmt.getText(_columnIndexOfUpdatedAt);
                    DateTime _tmpUpdatedAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_11);
                    _result.setUpdatedAt(_tmpUpdatedAt);
                    String _tmp_12 = _stmt.isNull(_columnIndexOfExpiresAt) ? null : _stmt.getText(_columnIndexOfExpiresAt);
                    DateTime _tmpExpiresAt = this.__dateTimeTypeConverter.stringToDateTime(_tmp_12);
                    _result.setExpiresAt(_tmpExpiresAt);
                } else {
                    _result = null;
                }
                EventEntity eventEntity = _result;
                return eventEntity;
            }
        });
    }

    @Override
    public void deleteAll() {
        String _sql = "DELETE FROM event";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE FROM event");){
                _stmt.step();
                Object var2_2 = null;
                return var2_2;
            }
        });
    }

    @Override
    public int deleteByIdImpl(String eventId) {
        String _sql = "DELETE FROM event WHERE eventId = ?";
        return (Integer)DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("DELETE FROM event WHERE eventId = ?");){
                int _argIndex = 1;
                if (eventId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, eventId);
                }
                _stmt.step();
                Integer n = SQLiteConnectionUtil.getTotalChangedRows((SQLiteConnection)_connection);
                return n;
            }
        });
    }

    @Override
    public void notifyChanges(String eventId) {
        String _sql = "UPDATE event SET eventId = ? WHERE eventId = ?";
        DBUtil.performBlocking((RoomDatabase)this.__db, (boolean)false, (boolean)true, _connection -> {
            try (SQLiteStatement _stmt = _connection.prepare("UPDATE event SET eventId = ? WHERE eventId = ?");){
                int _argIndex = 1;
                if (eventId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, eventId);
                }
                _argIndex = 2;
                if (eventId == null) {
                    _stmt.bindNull(_argIndex);
                } else {
                    _stmt.bindText(_argIndex, eventId);
                }
                _stmt.step();
                Object var4_4 = null;
                return var4_4;
            }
        });
    }

    @NonNull
    public static List<Class<?>> getRequiredConverters() {
        return Collections.emptyList();
    }
}

