package com.amity.socialcloud.sdk.social.data.post.live

import com.amity.socialcloud.sdk.social.data.post.PostQueryPersister
import com.amity.socialcloud.sdk.social.data.post.PostRemoteDataStore
import com.ekoapp.ekosdk.internal.PostEntity
import com.ekoapp.ekosdk.internal.api.dto.EkoPostQueryDto
import com.ekoapp.ekosdk.internal.data.AmityNonce
import com.ekoapp.ekosdk.internal.mediator.SinglePageMediator
import com.ekoapp.ekosdk.internal.token.DynamicQueryStreamQueryToken
import com.ekoapp.ekosdk.internal.token.QueryStreamQueryToken
import io.reactivex.rxjava3.core.Completable
import io.reactivex.rxjava3.core.Single

internal class LiveRoomPostSinglePageMediator(
    private val targetType: String,
    private val targetIds: List<String>
) : SinglePageMediator<PostEntity, EkoPostQueryDto>(
    nonce = AmityNonce.LIVE_ROOM_POST_LIST,
    dynamicQueryStreamKeyCreator = LiveRoomPostKeyCreator(
        targetType = targetType,
        targetIds = targetIds
    )
) {

    override fun persistResponse(dto: EkoPostQueryDto): Completable {
        return PostQueryPersister().persist(dto)
    }

    override fun getRequest(): Single<EkoPostQueryDto> {
        return PostRemoteDataStore().getLiveRoomPosts(
            targetTypes = listOf(targetType),
            targetIds = targetIds.takeIf { it.isNotEmpty() },
            limit = LIVE_ROOM_POST_PAGE_SIZE,
            sortBy = LIVE_ROOM_SORT
        )
    }

    override fun convertResponseToQueryToken(dto: EkoPostQueryDto): QueryStreamQueryToken {
        val postIds = dto.posts.mapNotNull { it.postId }
        return DynamicQueryStreamQueryToken(
            dynamicQueryStreamKeyCreator = dynamicQueryStreamKeyCreator,
            next = null,
            previous = null,
            primaryKeys = postIds
        )
    }

    companion object {
        private const val LIVE_ROOM_POST_PAGE_SIZE = 100
        private const val LIVE_ROOM_SORT = "lastCreated"
    }
}
